/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.wmm.adapter;

import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wmm.adapter.MemberRepository;
import com.ibm.websphere.wmm.adapter.datatype.ExternalMember;
import com.ibm.websphere.wmm.adapter.datatype.ExternalMemberIdentifier;
import com.ibm.websphere.wmm.adapter.datatype.ExternalMemberIdentifierList;
import com.ibm.websphere.wmm.adapter.datatype.ExternalMemberIdentifierSet;
import com.ibm.websphere.wmm.adapter.datatype.ExternalMemberList;
import com.ibm.websphere.wmm.adapter.datatype.ExternalMemberSet;
import com.ibm.websphere.wmm.adapter.datatype.ExternalMemberSetFactory;
import com.ibm.websphere.wmm.adapter.datatype.ExternalSearchResponseControl;
import com.ibm.websphere.wmm.configuration.ProfileRepository;
import com.ibm.websphere.wmm.datatype.Attribute;
import com.ibm.websphere.wmm.datatype.AttributeDefinition;
import com.ibm.websphere.wmm.datatype.AttributeDefinitionSet;
import com.ibm.websphere.wmm.datatype.Attributes;
import com.ibm.websphere.wmm.datatype.GroupScope;
import com.ibm.websphere.wmm.datatype.MemberTypeAttributeMap;
import com.ibm.websphere.wmm.datatype.PageControl;
import com.ibm.websphere.wmm.datatype.SearchCriteria;
import com.ibm.websphere.wmm.datatype.SortControl;
import com.ibm.websphere.wmm.datatype.StringSet;
import com.ibm.websphere.wmm.datatype.StringSetFactory;
import com.ibm.websphere.wmm.exception.DuplicateLogonIdException;
import com.ibm.websphere.wmm.exception.EntryNotFoundException;
import com.ibm.websphere.wmm.exception.MemberAlreadyExistsException;
import com.ibm.websphere.wmm.exception.MemberNotFoundException;
import com.ibm.websphere.wmm.exception.MultipleEntriesFoundException;
import com.ibm.websphere.wmm.exception.NotImplementedException;
import com.ibm.websphere.wmm.exception.PasswordCheckFailedException;
import com.ibm.websphere.wmm.exception.WMMApplicationException;
import com.ibm.websphere.wmm.exception.WMMException;
import com.ibm.ws.wim.bridge.model.Group;
import com.ibm.ws.wim.bridge.model.Member;
import com.ibm.ws.wim.bridge.model.Model;
import com.ibm.ws.wim.bridge.model.Organization;
import com.ibm.ws.wim.bridge.model.Person;
import com.ibm.ws.wim.bridge.util.EntityTypeResolver;
import com.ibm.ws.wmm.adapter.datatype.impl.ExternalMemberFactory;
import com.ibm.ws.wmm.adapter.datatype.impl.ExternalMemberIdentifierFactory;
import com.ibm.ws.wmm.adapter.datatype.impl.ExternalMemberIdentifierSetFactory;
import com.ibm.ws.wmm.adapter.datatype.impl.ExternalMemberListFactory;
import com.ibm.ws.wmm.adapter.datatype.impl.ExternalSearchResponseControlFactory;
import com.ibm.ws.wmm.datatype.impl.AttributeDefinitionFactory;
import com.ibm.ws.wmm.datatype.impl.AttributeFactory;
import com.ibm.ws.wmm.datatype.impl.AttributesFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CMRAdapter
implements MemberRepository {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = CMRAdapter.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private Model model = null;
    private StringSet definedAttribute = StringSetFactory.getInstance();
    private Map definedUsers = new HashMap();

    public void assignMembersToGroup(ExternalMemberIdentifier externalMemberIdentifier, ExternalMemberIdentifierSet externalMemberIdentifierSet, short s) throws WMMException {
    }

    public void assignMemberToGroup(ExternalMemberIdentifier externalMemberIdentifier, ExternalMemberIdentifier externalMemberIdentifier2) throws WMMException {
        this.entering(CLASSNAME, "assignMemberToGroup(groupId,memberId)");
        if (externalMemberIdentifier != null && externalMemberIdentifier2 != null) {
            Set<Member> set;
            Member member = this.retrieveMember(externalMemberIdentifier);
            if (member == null) {
                throw new MemberNotFoundException(CLASSNAME, "assignMemberToGroup(groupId,memberId)", "specified groupId [" + externalMemberIdentifier + "] is not exists. ");
            }
            if (!(member instanceof Group)) {
                throw new WMMApplicationException(CLASSNAME, "assignMemberToGroup(groupId,memberId)", "specified groupId [" + externalMemberIdentifier + "] is not group. ");
            }
            Member member2 = this.retrieveMember(externalMemberIdentifier2);
            if (member2 == null) {
                throw new MemberNotFoundException(CLASSNAME, "assignMemberToGroup(groupId,memberId)", "specified memberId [" + externalMemberIdentifier2 + "] is not exists. ");
            }
            Set set2 = member.getGroupChildren();
            if (set2 == null) {
                set = new HashSet<Member>();
                set.add(member2);
                member.setGroupChildren(set);
            } else {
                set2.add(member2);
                member.setGroupChildren(set2);
            }
            set = member2.getParentGroups();
            if (set == null) {
                HashSet<Member> hashSet = new HashSet<Member>();
                hashSet.add(member);
                member2.setParentGroups(hashSet);
            } else {
                set.add(member);
                member2.setParentGroups(set);
            }
        } else {
            throw new WMMApplicationException(CLASSNAME, "assignMemberToGroup(groupId,memberId)", "either groupId [" + externalMemberIdentifier + "] or memberId [" + externalMemberIdentifier2 + "] is null.");
        }
        this.model.print();
        this.existing(CLASSNAME, "assignMemberToGroup(groupId,memberId)");
    }

    public void createAttributeDefinition(AttributeDefinition attributeDefinition) throws WMMException {
    }

    public boolean createExtId(String string, String string2) throws WMMException {
        return false;
    }

    public void createExtIds(Map map) throws WMMException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExternalMemberIdentifier createMember(ExternalMember externalMember) throws WMMException {
        this.entering(CLASSNAME, "createMember");
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createMember", WIMTraceHelper.printObjectArray(new Object[]{externalMember}));
        }
        ExternalMemberIdentifier externalMemberIdentifier = null;
        if (externalMember != null) {
            HashSet<Object> hashSet;
            Object object;
            Object object2;
            Object object3;
            this.model.print();
            ExternalMemberIdentifier externalMemberIdentifier2 = externalMember.getExternalMemberIdentifier();
            if (externalMemberIdentifier2 != null) {
                object3 = externalMemberIdentifier2.getMemberDN();
                if (this.model.getMember(this.model.getRoot(), "dn", (String)object3) != null) {
                    throw new MemberAlreadyExistsException(CLASSNAME, "createMember", "dn = " + (String)object3);
                }
            }
            object3 = null;
            short s = externalMember.getMemberType();
            String string = EntityTypeResolver.getWimEntityType(s);
            if (string == null) throw new WMMApplicationException(CLASSNAME, "createMember", "entity type is null [" + string + "]");
            if (string.equals("Person")) {
                object3 = new Person();
            } else if (string.equals("PersonAccount")) {
                object3 = new Person();
            } else if (string.equals("Group")) {
                object3 = new Group();
            } else {
                if (!string.equals("OrgContainer")) throw new WMMApplicationException(CLASSNAME, "createMember", "entity type is not supported [" + string + "]");
                object3 = new Organization();
            }
            if (externalMemberIdentifier2 == null) {
                throw new WMMApplicationException(CLASSNAME, "createMember", "extId is null");
            }
            ((Member)object3).setId(externalMemberIdentifier2.getMemberExtId());
            ((Member)object3).setDn(externalMemberIdentifier2.getMemberDN());
            ExternalMemberIdentifier externalMemberIdentifier3 = externalMember.getParentExternalMemberIdentifier();
            if (externalMemberIdentifier3 != null) {
                object2 = externalMemberIdentifier3.getMemberDN();
                object = this.model.getMember(this.model.getRoot(), "dn", (String)object2);
                if (object == null) {
                    throw new WMMApplicationException(CLASSNAME, "createMember", "the parent is not exists [" + externalMemberIdentifier3 + "]");
                }
                if (!(object instanceof Organization)) {
                    throw new WMMApplicationException(CLASSNAME, "createMember", "the specified parent is not organization [" + object.getClass().getName() + "].");
                }
                ((Member)object3).setParent((Member)object);
                hashSet = ((Member)object).getChildren();
                if (hashSet == null) {
                    hashSet = new HashSet<Object>();
                }
                hashSet.add(object3);
                ((Member)object).setChildren(hashSet);
            }
            if ((object2 = externalMember.getAttributes()) != null) {
                object = new HashMap();
                hashSet = object2.getAttributeNames().iterator();
                while (hashSet.hasNext()) {
                    String string2 = hashSet.next();
                    Attribute attribute = object2.getAttribute(string2);
                    Object object4 = attribute.getValue();
                    List list = attribute.getValues();
                    if (object4 != null) {
                        if (object4.toString().length() == 0) continue;
                        object.put(string2, object4);
                        continue;
                    }
                    if (list == null || list.size() == 0) continue;
                    object.put(string2, list);
                }
                ((Member)object3).setProperties((Map)object);
            }
            externalMemberIdentifier = externalMember.getExternalMemberIdentifier();
            this.model.print();
        }
        this.existing(CLASSNAME, "createMember");
        return externalMemberIdentifier;
    }

    public ExternalMemberIdentifierList getAncestorIdentifiers(ExternalMemberIdentifier externalMemberIdentifier, short s, short s2) throws WMMException {
        return null;
    }

    public StringSet getAttributeDatatypes() throws WMMException {
        return this.definedAttribute;
    }

    public AttributeDefinition getAttributeDefinition(String string) throws WMMException {
        this.entering(CLASSNAME, "getAttributeDefinition(attributeName)");
        AttributeDefinition attributeDefinition = AttributeDefinitionFactory.getInstance();
        attributeDefinition.setName(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("READONLY", "TRUE");
        hashMap.put("key1", "value2");
        attributeDefinition.setMetaData(hashMap);
        this.existing(CLASSNAME, "getAttributeDefinition(attributeName)");
        return attributeDefinition;
    }

    public AttributeDefinitionSet getAttributeDefinitions(short s) throws WMMException {
        return null;
    }

    public ExternalMemberIdentifierSet getDescendantIdentifiers(ExternalMemberIdentifier externalMemberIdentifier, short s, short s2, short[] sArray) throws WMMException {
        return null;
    }

    public String getExtId(String string) throws WMMException {
        return null;
    }

    public ExternalMemberIdentifierSet getGroupIdentifiersForMember(ExternalMemberIdentifier externalMemberIdentifier, ExternalMemberIdentifier externalMemberIdentifier2, GroupScope groupScope, short s) throws WMMException {
        this.entering(CLASSNAME, "getGroupIdentifiersForMember(memberId,baseMbrId,scope,returnIdType)");
        ExternalMemberIdentifierSet externalMemberIdentifierSet = null;
        if (externalMemberIdentifier != null) {
            String string = externalMemberIdentifier.getMemberDN();
            Member member = this.model.getMember(this.model.getRoot(), "dn", string);
            if (member == null) {
                throw new MemberNotFoundException(CLASSNAME, "getGroupIdentifiersForMember(memberId,baseMbrId,scope,returnIdType)", "specified memberId [dn = " + string + "] not exists. ");
            }
            Set set = member.getParentGroups();
            externalMemberIdentifierSet = ExternalMemberIdentifierSetFactory.getInstance();
            if (set != null) {
                for (Member member2 : set) {
                    String string2 = member2.getId();
                    String string3 = member2.getDn();
                    ExternalMemberIdentifier externalMemberIdentifier3 = ExternalMemberIdentifierFactory.getInstance();
                    externalMemberIdentifier3.setMemberDN(string3);
                    externalMemberIdentifier3.setMemberExtId(string2);
                    externalMemberIdentifierSet.add(externalMemberIdentifier3);
                }
            }
        }
        this.existing(CLASSNAME, "getGroupIdentifiersForMember(memberId,baseMbrId,scope,returnIdType)");
        return externalMemberIdentifierSet;
    }

    public ExternalMemberIdentifierSet getGroupMemberIdentifiers(ExternalMemberIdentifier externalMemberIdentifier, GroupScope groupScope, short s, short[] sArray) throws WMMException {
        this.entering(CLASSNAME, "getGroupMemberIdentifiers(groupId,scope,returnIdType,memberTypes)");
        ExternalMemberIdentifierSet externalMemberIdentifierSet = null;
        if (externalMemberIdentifier != null) {
            String string = externalMemberIdentifier.getMemberDN();
            Member member = this.model.getMember(this.model.getRoot(), "dn", string);
            if (member == null) {
                throw new MemberNotFoundException(CLASSNAME, "getGroupMemberIdentifiers(groupId,scope,returnIdType,memberTypes)", "specified groupId [dn = " + string + "] not exists. ");
            }
            if (!(member instanceof Group)) {
                throw new WMMApplicationException(CLASSNAME, "getGroupMemberIdentifiers(groupId,scope,returnIdType,memberTypes)", "specified groupId [dn = " + string + "] is not group type. ");
            }
            Set set = member.getGroupChildren();
            externalMemberIdentifierSet = ExternalMemberIdentifierSetFactory.getInstance();
            if (set != null) {
                for (Member member2 : set) {
                    String string2 = member2.getId();
                    String string3 = member2.getDn();
                    ExternalMemberIdentifier externalMemberIdentifier2 = ExternalMemberIdentifierFactory.getInstance();
                    externalMemberIdentifier2.setMemberDN(string3);
                    externalMemberIdentifier2.setMemberExtId(string2);
                    externalMemberIdentifierSet.add(externalMemberIdentifier2);
                }
            }
        }
        this.existing(CLASSNAME, "getGroupMemberIdentifiers(groupId,scope,returnIdType,memberTypes)");
        return externalMemberIdentifierSet;
    }

    public ExternalMemberSet getGroupMembers(ExternalMemberIdentifier externalMemberIdentifier, GroupScope groupScope, MemberTypeAttributeMap memberTypeAttributeMap) throws WMMException {
        return null;
    }

    public ExternalMemberSet getGroupsForMember(ExternalMemberIdentifier externalMemberIdentifier, ExternalMemberIdentifier externalMemberIdentifier2, GroupScope groupScope, StringSet stringSet) throws WMMException {
        return null;
    }

    public StringSet getMandatoryAttributes(short s) throws WMMException {
        return null;
    }

    private Member retrieveMember(ExternalMemberIdentifier externalMemberIdentifier) throws WMMException {
        this.entering(CLASSNAME, "retrieveMember(extMbrId)", "" + externalMemberIdentifier);
        String string = externalMemberIdentifier.getMemberDN();
        String string2 = externalMemberIdentifier.getMemberExtId();
        Member member = null;
        member = string2 != null && string2.length() > 0 ? this.model.getMember(this.model.getRoot(), "id", string2) : this.model.getMember(this.model.getRoot(), "dn", string);
        this.existing(CLASSNAME, "retrieveMember(extMbrId)", "" + member);
        return member;
    }

    public ExternalMember getMember(ExternalMemberIdentifier externalMemberIdentifier, StringSet stringSet, String string) throws WMMException {
        this.entering(CLASSNAME, "getMember(memberId,attributeNames,context)");
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getMember(memberId,attributeNames,context)", WIMTraceHelper.printObjectArray(new Object[]{externalMemberIdentifier, stringSet, string}));
        }
        ExternalMember externalMember = null;
        if (externalMemberIdentifier != null) {
            Object object;
            Member member = this.retrieveMember(externalMemberIdentifier);
            if (member == null) {
                throw new MemberNotFoundException(CLASSNAME, "getMember(memberId,attributeNames,context)", "" + externalMemberIdentifier);
            }
            externalMember = ExternalMemberFactory.getInstance();
            if (member instanceof Person) {
                externalMember.setMemberType((short)0);
            } else if (member instanceof Group) {
                externalMember.setMemberType((short)1);
            } else {
                externalMember.setMemberType((short)2);
            }
            externalMemberIdentifier.setMemberExtId(member.getId());
            externalMemberIdentifier.setMemberDN(member.getDn());
            externalMember.setExternalMemberIdentifier(externalMemberIdentifier);
            Member member2 = member.getParent();
            if (member2 != null) {
                object = ExternalMemberIdentifierFactory.getInstance();
                object.setMemberDN(member2.getDn());
                object.setMemberExtId(member2.getId());
                externalMember.setParentExternalMemberIdentifier((ExternalMemberIdentifier)object);
            }
            if ((object = member.getProperties()) != null) {
                Attributes attributes2 = AttributesFactory.getInstance();
                for (String string2 : object.keySet()) {
                    Attribute attribute = AttributeFactory.getInstance(string2);
                    attribute.setValue(object.get(string2));
                    externalMember.addAttribute(attribute);
                }
                externalMember.setAttributes(attributes2);
            }
        }
        this.existing(CLASSNAME, "getMember(memberId,attributeNames,context)");
        return externalMember;
    }

    public String getMemberDN(String string) throws WMMException {
        return null;
    }

    public StringSet getMemberReferenceAttributes() throws WMMException {
        return null;
    }

    public ExternalMemberSet getMembers(short s, ExternalMemberIdentifierSet externalMemberIdentifierSet, StringSet stringSet, String string) throws WMMException {
        return null;
    }

    public StringSet getSupportedAttributes(short s) throws WMMException {
        return null;
    }

    public boolean initialize(ProfileRepository profileRepository, List list) throws WMMException {
        this.entering(CLASSNAME, "initialize");
        this.model = Model.singleton();
        this.definedAttribute.add("STRING");
        this.definedAttribute.add("IDENTIFIER");
        this.definedAttribute.add("REFERENCE");
        this.definedAttribute.add("LONG");
        this.definedAttribute.add("SHORT");
        this.definedAttribute.add("BYTEARRAY");
        this.definedUsers.put("ray", "password1");
        this.definedUsers.put("andy", "andypassword");
        this.definedUsers.put("vivian", "vpwd");
        this.definedUsers.put("xiaolin", "xlpwd");
        this.existing(CLASSNAME, "initialize");
        return true;
    }

    public boolean isMemberInGroup(ExternalMemberIdentifier externalMemberIdentifier, ExternalMemberIdentifier externalMemberIdentifier2, GroupScope groupScope) throws WMMException {
        this.entering(CLASSNAME, "isMemberInGroup(groupId,memberId,scope)");
        boolean bl = false;
        if (externalMemberIdentifier != null && externalMemberIdentifier2 != null) {
            Member member = this.retrieveMember(externalMemberIdentifier);
            if (member == null) {
                throw new MemberNotFoundException(CLASSNAME, "isMemberInGroup(groupId,memberId,scope)", "specified groupId [" + externalMemberIdentifier + "] is not exists. ");
            }
            if (!(member instanceof Group)) {
                throw new WMMApplicationException(CLASSNAME, "isMemberInGroup(groupId,memberId,scope)", "specified groupId [" + externalMemberIdentifier + "] is not group. ");
            }
            Member member2 = this.retrieveMember(externalMemberIdentifier2);
            if (member2 == null) {
                throw new MemberNotFoundException(CLASSNAME, "isMemberInGroup(groupId,memberId,scope)", "specified memberId [" + externalMemberIdentifier2 + "] is not exists. ");
            }
            Set set = member.getGroupChildren();
            if (set == null) {
                bl = false;
            } else {
                for (Member member3 : set) {
                    if (!member2.equals(member3)) continue;
                    bl = true;
                    break;
                }
            }
        } else {
            throw new WMMApplicationException(CLASSNAME, "isMemberInGroup(groupId,memberId,scope)", "either groupId [" + externalMemberIdentifier + "] or memberId [" + externalMemberIdentifier2 + "] is null.");
        }
        this.existing(CLASSNAME, "isMemberInGroup(groupId,memberId,scope)");
        return bl;
    }

    public ExternalMemberIdentifier moveMember(ExternalMemberIdentifier externalMemberIdentifier, ExternalMemberIdentifier externalMemberIdentifier2) throws WMMException {
        return null;
    }

    public ExternalMemberIdentifierSet removeMember(ExternalMemberIdentifier externalMemberIdentifier, boolean bl) throws WMMException {
        this.entering(CLASSNAME, "removeMember(memberId,removeDescendants)");
        ExternalMemberIdentifierSet externalMemberIdentifierSet = null;
        if (externalMemberIdentifier != null) {
            String string = externalMemberIdentifier.getMemberDN();
            Member member = this.model.getMember(this.model.getRoot(), "dn", string);
            if (member == null) {
                throw new MemberNotFoundException(CLASSNAME, "removeMember(memberId,removeDescendants)", "specified groupId [" + externalMemberIdentifier + "] is not exists. ");
            }
            if (member.getChildren() != null && member.getChildren().size() > 0) {
                throw new WMMApplicationException(CLASSNAME, "removeMember(memberId,removeDescendants)", "contain children and can not be deleted. ");
            }
            this.model.removeMember(this.model.getRoot(), member);
            externalMemberIdentifierSet = ExternalMemberIdentifierSetFactory.getInstance();
            externalMemberIdentifierSet.add(externalMemberIdentifier);
        }
        this.model.print();
        this.existing(CLASSNAME, "removeMember(memberId,removeDescendants)");
        return externalMemberIdentifierSet;
    }

    public ExternalMemberIdentifier renameMember(ExternalMemberIdentifier externalMemberIdentifier, String string) throws WMMException {
        return null;
    }

    public ExternalMemberSet search(short s, SearchCriteria searchCriteria, StringSet stringSet, int n, int n2) throws WMMException {
        this.entering(CLASSNAME, "search(type,sc,ra,so,mr)");
        this.logp(CLASSNAME, "search(type,sc,ra,so,mr)", "memberType->" + s);
        this.logp(CLASSNAME, "search(type,sc,ra,so,mr)", "searchCriteria->" + searchCriteria);
        this.logp(CLASSNAME, "search(type,sc,ra,so,mr)", "resultAttributes->" + stringSet);
        this.logp(CLASSNAME, "search(type,sc,ra,so,mr)", "searchTimeOut->" + n);
        this.logp(CLASSNAME, "search(type,sc,ra,so,mr)", "maxSearchResults->" + n2);
        ExternalMemberSet externalMemberSet = ExternalMemberSetFactory.getInstance();
        ExternalMember externalMember = ExternalMemberFactory.getInstance((short)2);
        externalMember.setExternalMemberIdentifier(ExternalMemberIdentifierFactory.getInstance((String)"o=orgA,o=default organization", (String)"9f9624c0-de99-11d9-97d7-834842b1cd81", (String)"CMR1"));
        externalMember.setParentExternalMemberIdentifier(ExternalMemberIdentifierFactory.getInstance((String)"o=default organization", (String)"9f9624c0-de99-11d9-97d7-834842b1cd88", (String)"CMR1"));
        externalMemberSet.add(externalMember);
        externalMember = ExternalMemberFactory.getInstance((short)2);
        externalMember.setExternalMemberIdentifier(ExternalMemberIdentifierFactory.getInstance((String)"o=orgB,o=default organization", (String)"9f9624c1-de99-11d9-97d7-834842b1cd81", (String)"CMR1"));
        externalMember.setParentExternalMemberIdentifier(ExternalMemberIdentifierFactory.getInstance((String)"o=default organization", (String)"9f9624c0-de99-11d9-97d7-834842b1cd88", (String)"CMR1"));
        externalMemberSet.add(externalMember);
        this.existing(CLASSNAME, "search(type,sc,ra,so,mr)");
        return externalMemberSet;
    }

    public ExternalSearchResponseControl searchAgain(PageControl pageControl) throws WMMException {
        this.entering(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)");
        this.logp(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)", "pageControl->" + pageControl);
        ExternalSearchResponseControl externalSearchResponseControl = this.getExternalSearchResponseControl(pageControl);
        this.existing(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)");
        return externalSearchResponseControl;
    }

    private ExternalSearchResponseControl getExternalSearchResponseControl(PageControl pageControl) {
        ExternalSearchResponseControl externalSearchResponseControl = null;
        if (pageControl != null) {
            externalSearchResponseControl = ExternalSearchResponseControlFactory.getInstance();
            byte[] byArray = pageControl.getCookie();
            externalSearchResponseControl.setCookie(byArray);
            ExternalMemberList externalMemberList = ExternalMemberListFactory.getInstance();
            ExternalMember externalMember = ExternalMemberFactory.getInstance((short)2);
            externalMember.setExternalMemberIdentifier(ExternalMemberIdentifierFactory.getInstance((String)"o=orgA,o=default organization", (String)"9f9624c0-de99-11d9-97d7-834842b1cd81", (String)"CMR1"));
            externalMember.setParentExternalMemberIdentifier(ExternalMemberIdentifierFactory.getInstance((String)"o=default organization", (String)"9f9624c0-de99-11d9-97d7-834842b1cd88", (String)"CMR1"));
            externalMemberList.add(externalMember);
            externalMember = ExternalMemberFactory.getInstance((short)2);
            externalMember.setExternalMemberIdentifier(ExternalMemberIdentifierFactory.getInstance((String)"o=orgB,o=default organization", (String)"9f9624c1-de99-11d9-97d7-834842b1cd81", (String)"CMR1"));
            externalMember.setParentExternalMemberIdentifier(ExternalMemberIdentifierFactory.getInstance((String)"o=default organization", (String)"9f9624c0-de99-11d9-97d7-834842b1cd88", (String)"CMR1"));
            externalMemberList.add(externalMember);
            externalSearchResponseControl.setExternalMemberList(externalMemberList);
            externalSearchResponseControl.setTotalNumberOfResults(pageControl.getPageSize());
            externalSearchResponseControl.setSorted(false);
        }
        return externalSearchResponseControl;
    }

    public ExternalSearchResponseControl search(short s, SearchCriteria searchCriteria, SortControl sortControl, PageControl pageControl, StringSet stringSet, int n, int n2) throws WMMException {
        this.entering(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)");
        this.logp(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)", "memberType->" + s);
        this.logp(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)", "searchCriteria->" + searchCriteria);
        this.logp(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)", "sortControl->" + sortControl);
        this.logp(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)", "pageControl->" + pageControl);
        this.logp(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)", "resultAttributes->" + stringSet);
        this.logp(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)", "searchTimeOut->" + n);
        this.logp(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)", "maxSearchResults->" + n2);
        ExternalSearchResponseControl externalSearchResponseControl = this.getExternalSearchResponseControl(searchCriteria, sortControl);
        this.existing(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)");
        return externalSearchResponseControl;
    }

    private ExternalSearchResponseControl getExternalSearchResponseControl(SearchCriteria searchCriteria, SortControl sortControl) {
        Object object;
        Object object2;
        ExternalSearchResponseControl externalSearchResponseControl = ExternalSearchResponseControlFactory.getInstance();
        if (searchCriteria != null) {
            object2 = searchCriteria.toString() + "time:" + String.valueOf(System.currentTimeMillis());
            object = ((String)object2).getBytes();
            externalSearchResponseControl.setCookie((byte[])object);
        }
        object2 = ExternalMemberListFactory.getInstance();
        object = ExternalMemberFactory.getInstance((short)2);
        object.setExternalMemberIdentifier(ExternalMemberIdentifierFactory.getInstance((String)"o=orgA,o=default organization", (String)"9f9624c0-de99-11d9-97d7-834842b1cd81", (String)"CMR1"));
        object.setParentExternalMemberIdentifier(ExternalMemberIdentifierFactory.getInstance((String)"o=default organization", (String)"9f9624c0-de99-11d9-97d7-834842b1cd88", (String)"CMR1"));
        object2.add(object);
        object = ExternalMemberFactory.getInstance((short)2);
        object.setExternalMemberIdentifier(ExternalMemberIdentifierFactory.getInstance((String)"o=orgB,o=default organization", (String)"9f9624c1-de99-11d9-97d7-834842b1cd81", (String)"CMR1"));
        object.setParentExternalMemberIdentifier(ExternalMemberIdentifierFactory.getInstance((String)"o=default organization", (String)"9f9624c0-de99-11d9-97d7-834842b1cd88", (String)"CMR1"));
        object2.add(object);
        externalSearchResponseControl.setExternalMemberList((ExternalMemberList)object2);
        if (sortControl != null) {
            externalSearchResponseControl.setSorted(true);
        } else {
            externalSearchResponseControl.setSorted(false);
        }
        externalSearchResponseControl.setTotalNumberOfResults(2);
        return externalSearchResponseControl;
    }

    public void unassignMemberFromGroup(ExternalMemberIdentifier externalMemberIdentifier, ExternalMemberIdentifier externalMemberIdentifier2) throws WMMException {
        this.entering(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)");
        if (externalMemberIdentifier != null && externalMemberIdentifier2 != null) {
            Set set;
            String string = externalMemberIdentifier.getMemberDN();
            Member member = this.model.getMember(this.model.getRoot(), "dn", string);
            if (member == null) {
                throw new MemberNotFoundException(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)", "specified groupId [" + externalMemberIdentifier + "] is not exists. ");
            }
            if (!(member instanceof Group)) {
                throw new WMMApplicationException(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)", "specified groupId [" + externalMemberIdentifier + "] is not group. ");
            }
            string = externalMemberIdentifier2.getMemberDN();
            Member member2 = this.model.getMember(this.model.getRoot(), "dn", string);
            if (member2 == null) {
                throw new MemberNotFoundException(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)", "specified memberId [" + externalMemberIdentifier2 + "] is not exists. ");
            }
            Set set2 = member.getGroupChildren();
            if (set2 != null) {
                set2.remove(member2);
                member.setGroupChildren(set2);
            }
            if ((set = member2.getParentGroups()) != null) {
                set.remove(member);
                member2.setParentGroups(set);
            }
        } else {
            throw new WMMApplicationException(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)", "either groupId [" + externalMemberIdentifier + "] or memberId [" + externalMemberIdentifier2 + "] is null.");
        }
        this.model.print();
        this.existing(CLASSNAME, "unassignMemberFromGroup(groupId,memberId)");
    }

    public void unassignMembersFromGroup(ExternalMemberIdentifier externalMemberIdentifier, ExternalMemberIdentifierSet externalMemberIdentifierSet) throws WMMException {
    }

    public boolean undo() throws WMMException {
        return false;
    }

    public ExternalMemberIdentifier updateMember(ExternalMember externalMember) throws WMMException {
        this.entering(CLASSNAME, "update(member)");
        ExternalMemberIdentifier externalMemberIdentifier = null;
        if (externalMember != null) {
            ExternalMemberIdentifier externalMemberIdentifier2 = externalMember.getExternalMemberIdentifier();
            String string = externalMemberIdentifier2.getMemberDN();
            Member member = this.model.getMember(this.model.getRoot(), "dn", string);
            if (member == null) {
                throw new MemberNotFoundException(CLASSNAME, "update(member)", "specified member [" + externalMemberIdentifier2 + "] is not exists. ");
            }
            externalMemberIdentifier = externalMemberIdentifier2;
        }
        this.existing(CLASSNAME, "update(member)");
        return externalMemberIdentifier;
    }

    public boolean validate(short s, ExternalMember externalMember) throws WMMException {
        return false;
    }

    public ExternalMember getPersonByAccountName(String string, String string2, StringSet stringSet) throws WMMException {
        return null;
    }

    public ExternalMember getPersonByAccountName(String string, String string2, StringSet stringSet, String string3) throws WMMException {
        return null;
    }

    public void unassignMemberFromGroups(ExternalMemberIdentifierSet externalMemberIdentifierSet, ExternalMemberIdentifier externalMemberIdentifier) throws WMMException {
    }

    public ExternalMember checkPassword(String string, String string2, StringSet stringSet, StringSet stringSet2, String string3) throws EntryNotFoundException, PasswordCheckFailedException, MultipleEntriesFoundException, NotImplementedException, WMMException {
        this.entering(CLASSNAME, "checkPassword");
        this.logp(CLASSNAME, "checkPassword", "defined users: " + this.definedUsers);
        if (!this.definedUsers.containsKey(string)) {
            throw new MemberNotFoundException(CLASSNAME, "checkPassword", "specified userSecurityName [" + string + "] not exists. ");
        }
        ExternalMember externalMember = null;
        if (string != null) {
            String string4 = (String)this.definedUsers.get(string);
            if (string.equals("vivian")) {
                throw new DuplicateLogonIdException(CLASSNAME, "checkPassword", "userSecurityName=" + string);
            }
            if (string4.equals(string2)) {
                externalMember = ExternalMemberFactory.getInstance();
                ExternalMemberIdentifier externalMemberIdentifier = ExternalMemberIdentifierFactory.getInstance();
                externalMemberIdentifier.setMemberDN(string);
                externalMemberIdentifier.setMemberExtId(string);
                externalMember.setExternalMemberIdentifier(externalMemberIdentifier);
            } else {
                throw new PasswordCheckFailedException(CLASSNAME, "checkPassword", "password check failed [" + string2 + "] expected [" + string4 + "]");
            }
        }
        this.existing(CLASSNAME, "checkPassword");
        return externalMember;
    }

    private void logp(String string, String string2, String string3) {
        trcLogger.log(Level.FINER, string + " " + string2 + " " + string3);
    }

    private void entering(String string, String string2) {
        this.entering(string, string2, "");
    }

    private void entering(String string, String string2, String string3) {
        trcLogger.log(Level.FINER, string + ">" + string2 + " ENTRY " + string3);
    }

    private void existing(String string, String string2) {
        this.existing(string, string2, "");
    }

    private void existing(String string, String string2, String string3) {
        trcLogger.log(Level.FINER, string + "<" + string2 + " RETURN " + string3);
    }
}

