/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.xpath.ldap.util;

import com.ibm.websphere.wim.exception.PropertyNotDefinedException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.ldap.LdapConfigManager;
import com.ibm.ws.wim.adapter.ldap.LdapEntity;
import com.ibm.ws.wim.xpath.mapping.datatype.LogicalNode;
import com.ibm.ws.wim.xpath.mapping.datatype.ParenthesisNode;
import com.ibm.ws.wim.xpath.mapping.datatype.PropertyNode;
import com.ibm.ws.wim.xpath.mapping.datatype.XPathNode;
import com.ibm.ws.wim.xpath.util.XPathTranslateHelper;
import commonj.sdo.Property;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LdapXPathTranslateHelper
implements XPathTranslateHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String CLASSNAME = LdapXPathTranslateHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private LdapConfigManager ldapConfigMgr = null;
    private Set entityTypes = null;
    private Stack logOps = new Stack();

    public LdapXPathTranslateHelper(Set set, LdapConfigManager ldapConfigManager) {
        this.entityTypes = set;
        this.ldapConfigMgr = ldapConfigManager;
    }

    public void genSearchString(StringBuffer stringBuffer, XPathNode xPathNode) throws WIMException {
        switch (xPathNode.getNodeType()) {
            case 0: {
                this.genSearchString(stringBuffer, (PropertyNode)xPathNode);
                break;
            }
            case 2: {
                this.genSearchString(stringBuffer, (ParenthesisNode)xPathNode);
                break;
            }
            case 1: {
                this.genSearchString(stringBuffer, (LogicalNode)xPathNode);
            }
        }
    }

    private void genSearchString(StringBuffer stringBuffer, PropertyNode propertyNode) throws WIMException {
        SchemaManager schemaManager = SchemaManager.singleton();
        String string = propertyNode.getName();
        String string2 = null;
        String string3 = null;
        Set set = this.ldapConfigMgr.getAttributeNames(this.entityTypes, string);
        if (set == null) {
            throw new PropertyNotDefinedException("PROPERTY_NOT_DEFINED_FOR_ENTITY", WIMMessageHelper.generateMsgParms(string, this.entityTypes), CLASSNAME, "genSearchString(StringBuffer searchExpBuffer,PropertyNode propNode)");
        }
        if (set.size() == 1) {
            Object[] objectArray;
            string2 = (String)set.toArray()[0];
            Object object = null;
            Property property = null;
            Iterator iterator = this.entityTypes.iterator();
            while (iterator.hasNext() && property == null) {
                objectArray = (Object[])iterator.next();
                property = schemaManager.getProperty((String)objectArray, string);
            }
            if (property == null) {
                throw new PropertyNotDefinedException("PROPERTY_NOT_DEFINED_FOR_ENTITY", WIMMessageHelper.generateMsgParms(string, this.entityTypes), CLASSNAME, "genSearchString(StringBuffer searchExpBuffer,PropertyNode propNode)");
            }
            string3 = property.getType().getName();
            object = this.ldapConfigMgr.getLdapValue(propertyNode.getValue(), string3, string2);
            short s = this.ldapConfigMgr.getOperator(propertyNode.getOperator());
            if (string3 != null && "String".equalsIgnoreCase(string3)) {
                object = this.ldapConfigMgr.escapeSpecialCharacters((String)object);
            }
            objectArray = new Object[]{string2, object};
            String string4 = this.ldapConfigMgr.CONDITION_FORMATS[s].format(objectArray);
            stringBuffer.append(string4);
        } else if (set.size() > 1) {
            stringBuffer.append("|");
            for (String string5 : this.entityTypes) {
                LdapEntity ldapEntity = this.ldapConfigMgr.getLdapEntity(string5);
                string2 = this.ldapConfigMgr.getAttributeName(ldapEntity, string);
                if (string2 == null) {
                    throw new PropertyNotDefinedException("PROPERTY_NOT_DEFINED_FOR_ENTITY", WIMMessageHelper.generateMsgParms(string, string5), CLASSNAME, "genSearchString(StringBuffer searchExpBuffer,PropertyNode propNode)");
                }
                Object object = null;
                Property property = schemaManager.getProperty(string5, string);
                string3 = property.getType().getName();
                object = this.ldapConfigMgr.getLdapValue(propertyNode.getValue(), string3, this.ldapConfigMgr.getSyntax(string2));
                short s = this.ldapConfigMgr.getOperator(propertyNode.getOperator());
                if (string3 != null && "String".equalsIgnoreCase(string3)) {
                    object = this.ldapConfigMgr.escapeSpecialCharacters((String)object);
                }
                Object[] objectArray = new Object[]{string2, object};
                String string6 = this.ldapConfigMgr.CONDITION_FORMATS[s].format(objectArray);
                stringBuffer.append("(");
                stringBuffer.append(string6);
                stringBuffer.append(")");
            }
        }
    }

    private void genSearchString(StringBuffer stringBuffer, LogicalNode logicalNode) throws WIMException {
        boolean bl = false;
        if (this.logOps.isEmpty()) {
            bl = true;
            this.logOps.push(logicalNode.getOperator());
        } else if ((String)this.logOps.peek() != logicalNode.getOperator()) {
            bl = true;
            this.logOps.push(logicalNode.getOperator());
        }
        if (bl) {
            if (logicalNode.getOperator().equals("and")) {
                stringBuffer.append("(&");
            } else {
                stringBuffer.append("(|");
            }
        }
        this.genStringChild(stringBuffer, (XPathNode)logicalNode.getLeftChild());
        this.genStringChild(stringBuffer, (XPathNode)logicalNode.getRightChild());
        if (bl) {
            stringBuffer.append(')');
            this.logOps.pop();
        }
    }

    private void genSearchString(StringBuffer stringBuffer, ParenthesisNode parenthesisNode) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "genSearchString(StringBuffer, ParenthesisNode)", WIMTraceHelper.printObjectArray(new Object[]{stringBuffer, parenthesisNode}));
        }
        XPathNode xPathNode = (XPathNode)parenthesisNode.getChild();
        this.genStringChild(stringBuffer, xPathNode);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "genSearchString(StringBuffer, ParenthesisNode)");
        }
    }

    private void genStringChild(StringBuffer stringBuffer, XPathNode xPathNode) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "genStringChild(StringBuffer, XPathNode)", WIMTraceHelper.printObjectArray(new Object[]{stringBuffer, xPathNode}));
        }
        switch (xPathNode.getNodeType()) {
            case 0: {
                stringBuffer.append('(');
                this.genSearchString(stringBuffer, (PropertyNode)xPathNode);
                stringBuffer.append(')');
                break;
            }
            case 2: {
                this.genSearchString(stringBuffer, (ParenthesisNode)xPathNode);
                break;
            }
            case 1: {
                this.genSearchString(stringBuffer, (LogicalNode)xPathNode);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "genStringChild(StringBuffer, XPathNode)");
        }
    }
}

