/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.xpath.lookaside.util;

import com.ibm.websphere.wim.exception.InvalidPropertyValueException;
import com.ibm.websphere.wim.exception.PropertyNotDefinedException;
import com.ibm.websphere.wim.exception.SearchControlException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.dao.DAOHelper;
import com.ibm.ws.wim.dao.DataAccessObject;
import com.ibm.ws.wim.dao.schema.DBRepositoryProperty;
import com.ibm.ws.wim.lookaside.LAPropertyCache;
import com.ibm.ws.wim.util.SearchParameter;
import com.ibm.ws.wim.xpath.mapping.datatype.LogicalNode;
import com.ibm.ws.wim.xpath.mapping.datatype.ParenthesisNode;
import com.ibm.ws.wim.xpath.mapping.datatype.PropertyNode;
import com.ibm.ws.wim.xpath.mapping.datatype.XPathNode;
import com.ibm.ws.wim.xpath.util.XPathTranslateHelper;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LAXPathTranslateHelper
implements XPathTranslateHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String CLASSNAME = LAXPathTranslateHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    public int numSearchProperties = 0;
    private LAPropertyCache propertyMgr = null;
    private DataAccessObject dao = null;
    public StringBuffer whereClause = null;
    public StringBuffer fromClause = null;
    HashSet incrementTypes = new HashSet();
    HashSet incrementExcludeTypes = new HashSet();
    Stack logOps = new Stack();
    short stringCount = 1;
    short integerCount = 1;
    short longCount = 1;
    short doubleCount = 1;
    short timestampCount = 1;
    short entityRefCount = 1;
    boolean needTopRightParenthesis = false;
    List parameters = null;

    public LAXPathTranslateHelper(List list, XPathNode xPathNode, List list2, LAPropertyCache lAPropertyCache, DataAccessObject dataAccessObject) {
        HashMap hashMap = new HashMap();
        this.numSearchProperties = hashMap.size();
        this.propertyMgr = lAPropertyCache;
        this.dao = dataAccessObject;
        this.parameters = list2;
        this.whereClause = new StringBuffer(this.numSearchProperties * 128);
        this.fromClause = new StringBuffer((this.numSearchProperties + 1) * 16);
        this.fromClause.append(dataAccessObject.getQuerySet().searchFromLAEntity);
        this.whereClause.append(dataAccessObject.getQuerySet().searchWhere1Equals1);
        if (xPathNode != null) {
            this.whereClause.append(dataAccessObject.getQuerySet().AND);
        }
    }

    public void genSearchString(StringBuffer stringBuffer, XPathNode xPathNode) throws WIMApplicationException {
        if (xPathNode == null) {
            return;
        }
        switch (xPathNode.getNodeType()) {
            case 0: {
                this.whereClause.append('(');
                this.needTopRightParenthesis = true;
                this.genSearchString(stringBuffer, (PropertyNode)xPathNode);
                break;
            }
            case 2: {
                this.genSearchString(stringBuffer, (ParenthesisNode)xPathNode);
                break;
            }
            case 1: {
                this.whereClause.append('(');
                this.needTopRightParenthesis = true;
                this.genSearchString(stringBuffer, (LogicalNode)xPathNode);
            }
        }
        if (this.needTopRightParenthesis) {
            this.whereClause.append(')');
        }
    }

    public StringBuffer getFromClause() {
        return this.fromClause;
    }

    public StringBuffer getWhereClause() {
        return this.whereClause;
    }

    private void genSearchString(StringBuffer stringBuffer, PropertyNode propertyNode) throws WIMApplicationException {
        String string = propertyNode.getName();
        DBRepositoryProperty dBRepositoryProperty = this.propertyMgr.getPropertyDefinition(string);
        if (dBRepositoryProperty == null) {
            throw new PropertyNotDefinedException("PROPERTY_NOT_DEFINED", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "genSearchString(StringBuffer searchExpBuffer,PropertyNode propNode)");
        }
        if (dBRepositoryProperty.isComposite()) {
            throw new SearchControlException("SEARCH_BY_COMPOSITE_PROPERTY_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "genSearchString(StringBuffer searchExpBuffer,PropertyNode propNode)");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        this.appendFromClause(dBRepositoryProperty, stringBuffer2, stringBuffer3);
        this.appendWhereClause(propertyNode, dBRepositoryProperty, stringBuffer2, stringBuffer3);
        if (!this.logOps.isEmpty() && this.logOps.contains("and")) {
            this.incrementTypes.add(dBRepositoryProperty.getDataType());
            if (this.logOps.contains("or")) {
                this.incrementExcludeTypes.add(dBRepositoryProperty.getDataType());
            }
        }
    }

    private void genSearchString(StringBuffer stringBuffer, ParenthesisNode parenthesisNode) throws WIMApplicationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "genSearchString(StringBuffer, ParenthesisNode)", WIMTraceHelper.printObjectArray(new Object[]{stringBuffer, parenthesisNode}));
        }
        XPathNode xPathNode = (XPathNode)parenthesisNode.getChild();
        this.whereClause.append(this.dao.getQuerySet().LEFT_BRACKET);
        this.genStringChild(stringBuffer, xPathNode);
        this.whereClause.append(this.dao.getQuerySet().RIGHT_BRACKET);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "genSearchString(StringBuffer, ParenthesisNode)");
        }
    }

    private void genSearchString(StringBuffer stringBuffer, LogicalNode logicalNode) throws WIMApplicationException {
        boolean bl = false;
        boolean bl2 = false;
        HashSet hashSet = null;
        this.logOps.push(logicalNode.getOperator());
        this.genStringChild(stringBuffer, (XPathNode)logicalNode.getLeftChild());
        if (logicalNode.getOperator().equals("and")) {
            bl2 = true;
            this.whereClause.append(this.dao.getQuerySet().AND);
        } else {
            this.whereClause.append(this.dao.getQuerySet().OR);
            if (!this.incrementExcludeTypes.isEmpty()) {
                hashSet = (HashSet)this.incrementTypes.clone();
                this.incrementTypes.removeAll(this.incrementExcludeTypes);
            }
        }
        this.genStringChild(stringBuffer, (XPathNode)logicalNode.getRightChild());
        this.logOps.pop();
        if (bl2) {
            if (!this.logOps.isEmpty() && !this.logOps.contains("and")) {
                this.incrementTypes.clear();
                this.incrementExcludeTypes.clear();
                this.resetTypeCounts();
            }
        } else {
            if (!this.logOps.isEmpty() && ((String)this.logOps.peek()).equals("and")) {
                this.incrementExcludeTypes.clear();
            }
            if (hashSet != null) {
                this.incrementTypes = hashSet;
                hashSet = null;
            }
        }
    }

    private void genStringChild(StringBuffer stringBuffer, XPathNode xPathNode) throws WIMApplicationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "genStringChild(StringBuffer, XPathNode)", WIMTraceHelper.printObjectArray(new Object[]{stringBuffer, xPathNode}));
        }
        switch (xPathNode.getNodeType()) {
            case 0: {
                this.genSearchString(stringBuffer, (PropertyNode)xPathNode);
                break;
            }
            case 2: {
                this.genSearchString(stringBuffer, (ParenthesisNode)xPathNode);
                break;
            }
            case 1: {
                this.genSearchString(stringBuffer, (LogicalNode)xPathNode);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "genStringChild(StringBuffer, XPathNode)");
        }
    }

    private void appendFromClause(DBRepositoryProperty dBRepositoryProperty, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws WIMApplicationException {
        boolean bl = false;
        if (!this.incrementTypes.isEmpty() && this.incrementTypes.contains(dBRepositoryProperty.getDataType())) {
            bl = true;
        }
        String string = dBRepositoryProperty.getDataType();
        short s = DAOHelper.getDataTypeId(string);
        switch (s) {
            case 0: {
                if (bl) {
                    this.stringCount = (short)(this.stringCount + 1);
                }
                stringBuffer.append("S" + this.stringCount);
                if (dBRepositoryProperty.isCaseSensitive()) {
                    stringBuffer2.append(stringBuffer + this.dao.getQuerySet().dotColumnValue);
                } else {
                    stringBuffer2.append(stringBuffer + this.dao.getQuerySet().dotColumnValueKey);
                }
                if (this.fromClause.toString().indexOf(" " + stringBuffer) != -1) break;
                this.fromClause.append(this.dao.getQuerySet().COMMA);
                this.fromClause.append(this.dao.getQuerySet().laTableStringValue);
                this.fromClause.append(stringBuffer);
                break;
            }
            case 3: {
                if (bl) {
                    this.integerCount = (short)(this.integerCount + 1);
                }
                stringBuffer.append("I" + this.integerCount);
                stringBuffer2.append(stringBuffer + this.dao.getQuerySet().dotColumnValue);
                if (this.fromClause.toString().indexOf(" " + stringBuffer) != -1) break;
                this.fromClause.append(this.dao.getQuerySet().COMMA);
                this.fromClause.append(this.dao.getQuerySet().laTableIntegerValue);
                this.fromClause.append(stringBuffer);
                break;
            }
            case 1: {
                if (bl) {
                    this.longCount = (short)(this.longCount + 1);
                }
                stringBuffer.append("L" + this.longCount);
                stringBuffer2.append(stringBuffer + this.dao.getQuerySet().dotColumnValue);
                if (this.fromClause.toString().indexOf(" " + stringBuffer) != -1) break;
                this.fromClause.append(this.dao.getQuerySet().COMMA);
                this.fromClause.append(this.dao.getQuerySet().laTableLongValue);
                this.fromClause.append(stringBuffer);
                break;
            }
            case 2: {
                if (bl) {
                    this.doubleCount = (short)(this.doubleCount + 1);
                }
                stringBuffer.append("D" + this.doubleCount);
                stringBuffer2.append(stringBuffer + this.dao.getQuerySet().dotColumnValue);
                if (this.fromClause.toString().indexOf(" " + stringBuffer) != -1) break;
                this.fromClause.append(this.dao.getQuerySet().COMMA);
                this.fromClause.append(this.dao.getQuerySet().laTableDoubleValue);
                this.fromClause.append(stringBuffer);
                break;
            }
            case 4: {
                if (bl) {
                    this.timestampCount = (short)(this.timestampCount + 1);
                }
                stringBuffer.append("T" + this.timestampCount);
                stringBuffer2.append(stringBuffer + this.dao.getQuerySet().dotColumnValue);
                if (this.fromClause.toString().indexOf(" " + stringBuffer) != -1) break;
                this.fromClause.append(this.dao.getQuerySet().COMMA);
                this.fromClause.append(this.dao.getQuerySet().laTableTimeStampValue);
                this.fromClause.append(stringBuffer);
                break;
            }
            case 5: {
                if (bl) {
                    this.entityRefCount = (short)(this.entityRefCount + 1);
                }
                stringBuffer.append("R" + this.entityRefCount);
                stringBuffer2.append(stringBuffer + this.dao.getQuerySet().dotColumnRefUnameKey);
                if (this.fromClause.toString().indexOf(" " + stringBuffer) != -1) break;
                this.fromClause.append(this.dao.getQuerySet().COMMA);
                this.fromClause.append(this.dao.getQuerySet().laTableReferenceValue);
                this.fromClause.append(stringBuffer);
                break;
            }
            case 6: {
                throw new SearchControlException("SEARCH_BY_LOB_PROPERTY_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(dBRepositoryProperty.getName()), CLASSNAME, "appendFromClause(DBRepositoryProperty, StringBuffer, StringBuffer)");
            }
            default: {
                throw new SearchControlException("PROPERTY_INVALID_DATA_TYPE", WIMMessageHelper.generateMsgParms(dBRepositoryProperty.getName()), CLASSNAME, "appendFromClause(DBRepositoryProperty, StringBuffer, StringBuffer)");
            }
        }
    }

    private void appendWhereClause(PropertyNode propertyNode, DBRepositoryProperty dBRepositoryProperty, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws WIMApplicationException {
        String string;
        Serializable serializable;
        String string2 = dBRepositoryProperty.getDataType();
        short s = DAOHelper.getDataTypeId(string2);
        Integer n = dBRepositoryProperty.getPropId();
        String string3 = propertyNode.getOperator();
        this.whereClause.append(stringBuffer);
        this.whereClause.append(this.dao.getQuerySet().searchLAEntityJoinCondition);
        this.whereClause.append(stringBuffer);
        this.whereClause.append(this.dao.getQuerySet().searchPropertyIdCondition);
        SearchParameter searchParameter = new SearchParameter(3, n);
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(searchParameter);
        this.whereClause.append(this.dao.getQuerySet().LEFT_BRACKET);
        this.whereClause.append(stringBuffer2 + " ");
        Object object = propertyNode.getValue();
        Object object2 = null;
        if (string3.equals("=") && object instanceof String) {
            int n2 = ((String)object).indexOf("\\*");
            if (n2 < 0) {
                if (((String)object).indexOf(42) >= 0) {
                    string3 = "LIKE";
                    object = ((String)object).replace('*', '%');
                }
            } else {
                serializable = new StringBuffer((String)object);
                n2 = 0;
                boolean bl = true;
                int n3 = 0;
                while (n3 < ((StringBuffer)serializable).length()) {
                    int n4 = ((StringBuffer)serializable).indexOf("*", n2);
                    if ((n2 = ((StringBuffer)serializable).indexOf("\\*", n2)) < 0 && bl) {
                        n3 = ((StringBuffer)serializable).length();
                        continue;
                    }
                    if (n4 != n2 + 1 && n4 > 0) {
                        string3 = "LIKE";
                        if (n2 < 0) {
                            n2 = ((StringBuffer)serializable).length();
                        }
                        String string4 = ((StringBuffer)serializable).substring(n4, n2);
                        string4 = string4.replace('*', '%');
                        ((StringBuffer)serializable).replace(n4, n2, string4);
                    }
                    if (n2 >= 0 && n2 < ((StringBuffer)serializable).length()) {
                        ((StringBuffer)serializable).deleteCharAt(n2);
                    }
                    n3 = ++n2;
                    bl = false;
                }
                object = ((StringBuffer)serializable).toString();
            }
        }
        if (object != null) {
            try {
                switch (s) {
                    case 0: {
                        object2 = object;
                        break;
                    }
                    case 3: {
                        object2 = new Integer(object.toString());
                        break;
                    }
                    case 1: {
                        object2 = new Long(object.toString());
                        break;
                    }
                    case 2: {
                        object2 = new Double(object.toString());
                        break;
                    }
                    case 4: {
                        String string5 = object.toString();
                        serializable = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                        ((DateFormat)serializable).setTimeZone(TimeZone.getTimeZone("GMT"));
                        Date date = ((DateFormat)serializable).parse(string5);
                        object2 = new Timestamp(date.getTime());
                        break;
                    }
                    case 5: {
                        object2 = DAOHelper.getTruncatedUniqueName(object.toString().trim());
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidPropertyValueException("INVALID_PROPERTY_VALUE_FORMAT", WIMMessageHelper.generateMsgParms(dBRepositoryProperty.getName()), CLASSNAME, "appendWhereClause(PropertyNode propNode, DBRepositoryProperty propDef, StringBuffer tableName, StringBuffer columnName)", (Throwable)numberFormatException);
            }
            catch (ParseException parseException) {
                throw new InvalidPropertyValueException("INVALID_PROPERTY_VALUE_FORMAT", WIMMessageHelper.generateMsgParms(dBRepositoryProperty.getName()), CLASSNAME, "appendWhereClause(PropertyNode propNode, DBRepositoryProperty propDef, StringBuffer tableName, StringBuffer columnName)", (Throwable)parseException);
            }
        }
        string3 = this.dao.getOperator(string3, s);
        this.whereClause.append(string3 + " ");
        this.whereClause.append("?");
        this.whereClause.append(this.dao.getQuerySet().RIGHT_BRACKET);
        searchParameter = new SearchParameter(s, n, object2);
        if (!dBRepositoryProperty.isCaseSensitive() && (string = (String)searchParameter.paramValue) != null) {
            searchParameter.paramValue = string.toLowerCase();
        }
        this.parameters.add(searchParameter);
    }

    private void resetTypeCounts() {
        this.stringCount = 1;
        this.integerCount = 1;
        this.longCount = 1;
        this.doubleCount = 1;
        this.timestampCount = 1;
        this.entityRefCount = 1;
    }
}

