/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.WLMPerf;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.pmi.server.PmiFactory;

public class PMIManager {
    private static final TraceComponent tc = Tr.register(PMIManager.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static int clientId;
    public static WLMPerf clientModule;
    public static WLMPerf serverModule;
    private static ThreadLocal pmiContext;

    private PMIManager() {
    }

    public static void initializePMI(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializePMI: moduleName=" + string);
        }
        try {
            if (string.equals("wlmModule.client")) {
                clientModule = PmiFactory.createWLMPerf("wlmModule.client");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "initializePMI: PmiFactory.createWLMPerf() clientModule=" + clientModule);
                }
            } else {
                serverModule = PmiFactory.createWLMPerf("wlmModule.server");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "initializePMI: PmiFactory.createWLMPerf() serverModule=" + serverModule);
                }
            }
        }
        catch (Throwable throwable) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initializePMI: PmiFactory.createWLMPerf() failed t=" + throwable);
            }
            if (string.equals("wlmModule.client")) {
                clientModule = null;
            }
            serverModule = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializePMI");
        }
    }

    public static void setClientId(int n) {
        clientId = n;
    }

    public static int getClientId() {
        if (clientId == -1) {
            clientId = GlobalORBFactory.globalORB().getServerId();
        }
        return clientId;
    }

    public static void putAffinityType(byte by) {
        pmiContext.set(new Byte(by));
    }

    public static byte getAffinityType() {
        Byte by = (Byte)pmiContext.get();
        if (by == null) {
            return 0;
        }
        return by;
    }

    public static void removeEntry() {
        pmiContext.set(null);
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.9 : none");
        }
        clientId = -1;
        pmiContext = new ThreadLocal();
    }
}

