/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.wlm.configuration.LSDAddress;
import com.ibm.ws.wlm.configuration.MemberAddress;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class WLMProperties {
    private static final TraceComponent tc = Tr.register(WLMProperties.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static WLMProperties instance;
    public static final String unusableIntervalKeyDeprecated = "com.ibm.ejs.wlm.UnusableInterval";
    public static final String unusableIntervalKey = "com.ibm.websphere.wlm.unusable.interval";
    public static final String altAddressModeKey = "com.ibm.websphere.wlm.alternate.address.mode";
    public static final String ALT_ADDRESS_MODE_NONE = "none";
    public static final String ALT_ADDRESS_MODE_NOENDIAN = "noendian";
    public static final String ALT_ADDRESS_MODE_ENDIAN = "endian";
    public static final int DEFAULT_UNUSABLE_INTERVAL = 300000;
    private static String adminDomainName;
    private static String serverGroupName;
    private static Set localPorts;
    private static String localHost;
    private static String templateIOR;
    private static int unusableInterval;
    private static String altAddressMode;
    private static LSDAddress[] lsdAddresses;
    private static MemberAddress[] memberAddresses;

    private WLMProperties() {
    }

    public static void initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if (instance != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", new Object[]{"Already initialized", instance});
            }
            return;
        }
        instance = new WLMProperties();
        try {
            String string;
            String string2 = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty(WLMProperties.unusableIntervalKey);
                    if (string == null) {
                        string = System.getProperty(WLMProperties.unusableIntervalKeyDeprecated);
                    }
                    return string;
                }
            });
            if (string2 != null) {
                unusableInterval = Integer.parseInt(string2) * 1000;
            }
            if ((string = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty(WLMProperties.altAddressModeKey);
                    return string;
                }
            })) != null) {
                altAddressMode = string;
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "WLM Properties set:");
                Tr.event(tc, "unusableInterval", new Integer(unusableInterval));
                Tr.event(tc, "altAddressMode", altAddressMode);
                Tr.event(tc, "adminDomainName", adminDomainName);
                Tr.event(tc, "containingSGName", serverGroupName);
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException(numberFormatException, "com.ibm.ws.wlm.WLMProperties.initialize", "206");
            Tr.warning(tc, "NLSKEY_UNABLE_TO_SET_PROPERTIES", numberFormatException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", instance);
        }
    }

    public static int getUnusableInterval() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getUnusableInterval", new Integer(unusableInterval));
        }
        return unusableInterval;
    }

    public static String getServerGroupName() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getServerGroupName", serverGroupName);
        }
        return serverGroupName;
    }

    public static void setServerGroupName(String string) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setServerGroupName", string);
        }
        serverGroupName = string;
    }

    public static void setAdminDomainName(String string) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setAdminDomainName", string);
        }
        adminDomainName = string;
    }

    public static void setLocalPort(int n) {
        localPorts.add(new Integer(n));
    }

    public static Set getLocalPorts() {
        return localPorts;
    }

    public static void setLocalHost(String string) {
        localHost = string;
    }

    public static String getLocalHost() {
        return localHost;
    }

    public static String getAdminDomainName() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAdminDomainName", adminDomainName);
        }
        return adminDomainName;
    }

    public static void setLocalTemplateIOR(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLocalTemplateIOR", string);
        }
        templateIOR = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLocalTemplateIOR", templateIOR);
        }
    }

    public static String getLocalTemplateIOR() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLocalTemplateIOR", templateIOR);
        }
        return templateIOR;
    }

    public static String getAltAddressMode() {
        if (instance == null) {
            WLMProperties.initialize();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAltAddressMode", altAddressMode);
        }
        return altAddressMode;
    }

    public String toString() {
        return adminDomainName + ":" + serverGroupName + ":" + String.valueOf(unusableInterval) + ":" + altAddressMode;
    }

    public static LSDAddress[] getLSDAddresses() {
        return lsdAddresses;
    }

    public static void setLSDAddresses(LSDAddress[] lSDAddressArray) {
        lsdAddresses = lSDAddressArray;
    }

    public static MemberAddress[] getMemberAddresses() {
        return memberAddresses;
    }

    public static void setMemberAddresses(MemberAddress[] memberAddressArray) {
        memberAddresses = memberAddressArray;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.7.1.6 : PQ83990");
        }
        instance = null;
        adminDomainName = null;
        serverGroupName = null;
        localPorts = Collections.synchronizedSet(new HashSet());
        localHost = "localhost";
        templateIOR = null;
        unusableInterval = 300000;
        altAddressMode = ALT_ADDRESS_MODE_ENDIAN;
        lsdAddresses = null;
        memberAddresses = null;
    }
}

