/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm.configuration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wlm.WLMProperties;
import com.ibm.ws.wlm.configuration.LSDAddress;

public class LSDDescription {
    private static final TraceComponent tc = Tr.register(LSDDescription.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private boolean usable = true;
    private long retry_time = 0L;
    private byte forward_failures = 0;
    private long forward_retry = 0L;
    private static final byte MAX_FORWARD_FAILURES = 3;
    private LSDAddress iiopAddress;

    public LSDDescription(LSDAddress lSDAddress) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CTOR", new Object[]{lSDAddress.getHost(), String.valueOf(lSDAddress.getPort())});
        }
        this.iiopAddress = lSDAddress;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CTOR");
        }
    }

    public String getHost() {
        return this.iiopAddress.getHost();
    }

    public int getPort() {
        return this.iiopAddress.getPort();
    }

    public int getSSLPort() {
        return this.iiopAddress.getSSLPort();
    }

    public int getSSLCCPort() {
        return this.iiopAddress.getSSLCCPort();
    }

    public boolean isUsable() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isUsable", new Object[]{new Boolean(this.usable), new Long(this.retry_time)});
        }
        if (!this.usable && this.retry_time < System.currentTimeMillis()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isUsable marking LSD usable at " + System.currentTimeMillis());
            }
            this.usable = true;
            this.retry_time = 0L;
            this.forward_failures = 0;
        }
        return this.usable;
    }

    public void handleLSDRemoteException() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleRemoteException", new Object[]{new Boolean(this.usable), new Long(this.retry_time)});
        }
        this.usable = false;
        Tr.service(tc, "WLMKEY_LSD_MARKED_UNUSABLE", new Object[]{this.getHost(), this.iiopAddress.toString()});
        this.retry_time = System.currentTimeMillis() + (long)WLMProperties.getUnusableInterval();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleRemoteException", new Object[]{new Boolean(this.usable), new Long(this.retry_time)});
        }
    }

    public void handleForwardFailure() {
        long l = System.currentTimeMillis();
        if (this.forward_retry < l) {
            this.forward_failures = 0;
        }
        this.forward_retry = l + (long)WLMProperties.getUnusableInterval();
        this.forward_failures = (byte)(this.forward_failures + 1);
        if (this.forward_failures >= 3) {
            this.usable = false;
            this.retry_time = this.forward_retry;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleForwardFailure", new Object[]{new Boolean(this.usable), new Long(this.forward_retry), String.valueOf(this.forward_failures)});
        }
    }

    public String toString() {
        String string = this.iiopAddress.toString();
        String string2 = this.getClass().getName() + "@" + string + ":" + this.usable;
        return string2;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.15 : none");
        }
    }
}

