/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm.configuration;

import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.KeyConverter;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.wlm.AlternateIIOPAddressHelper;
import com.ibm.ws.wlm.WLMProperties;
import com.ibm.ws.wlm.configuration.LSDAddress;
import com.ibm.ws.wlm.configuration.MemberAddress;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.omg.CORBA.portable.OutputStream;

public class WLMTaggedComponent {
    private static final TraceComponent tc = Tr.register(WLMTaggedComponent.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static final int WLM_COMPONENT_TAG = 1229081867;
    public static LSDAddress[] list = null;
    public static MemberAddress[] memberList = null;
    public static final int VERSION0 = 0;
    public static final int VERSION1 = 1;
    public static final int VERSION2 = 2;
    public static final int VERSION3 = 3;
    public static final int VERSION4 = 4;
    public static final int CURRENTVERSION = 4;
    private int version;
    private Identity clusterIdentity;
    private String adminDomainName;
    private String serverClusterName;
    private short[] lsdSSLPorts;
    private int[] memberSSLPorts;
    private short[] lsdSSLCCPorts;
    private int[] memberSSLCCPorts;
    private short[] lsdPorts;
    private int[] memberPorts;
    private String[] lsdHosts;
    private String[] memberHosts;
    private static boolean WBISupport;
    private static final KeyRepository keyRepository;
    private static final ClusterService ivClusterService;

    public WLMTaggedComponent(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WLMTaggedComponent", byArray);
        }
        this.determineWBISupport();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.version = dataInputStream.readInt();
            if (this.version == 0) {
                this.createVERSION0(dataInputStream);
            } else if (this.version == 1) {
                this.createVERSION1(dataInputStream);
            } else if (this.version == 2) {
                this.createVERSION2(dataInputStream);
            } else if (this.version == 3) {
                this.createVERSION3(dataInputStream);
            } else {
                this.createVERSION4(dataInputStream);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.wlm.configuration.WLMTaggedComponent.WLMTaggedComponent", "204", this);
            Tr.warning(tc, "NLSKEY_UNEXPECTED_EXCEPTION", new Object[]{"WLMTaggedComponent", iOException});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WLMTaggedComponent", new Object[]{new Integer(this.version), this.adminDomainName, this.serverClusterName});
        }
    }

    private void determineWBISupport() {
        ProcessProperties processProperties = ProcessProperties.getInstance();
        String string = (String)processProperties.get("IBM_CLUSTER_WBI_SUPPORT");
        WBISupport = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WBISupportProperty is currently set to " + string);
        }
        if (string != null && string.compareToIgnoreCase("true") == 0) {
            WBISupport = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WBISupport is currently set to " + WBISupport);
        }
    }

    private void createVERSION0(DataInputStream dataInputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createVERSION0");
        }
        try {
            this.adminDomainName = dataInputStream.readUTF();
            this.serverClusterName = dataInputStream.readUTF();
            this.clusterIdentity = KeyConverter.convertKey(this.adminDomainName, this.serverClusterName);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.wlm.configuration.WLMTaggedComponent.createVERSION0", "236", this);
            Tr.warning(tc, "NLSKEY_UNEXPECTED_EXCEPTION", new Object[]{"createVERSION0", iOException});
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVERSION0");
        }
    }

    private int createVERSION1(DataInputStream dataInputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createVERSION1");
        }
        this.createVERSION0(dataInputStream);
        int n = 0;
        try {
            n = dataInputStream.readInt();
            this.lsdSSLPorts = new short[n];
            this.lsdSSLCCPorts = new short[n];
            for (int i = 0; i < n; ++i) {
                this.lsdSSLPorts[i] = dataInputStream.readShort();
                this.lsdSSLCCPorts[i] = dataInputStream.readShort();
            }
        }
        catch (IOException iOException) {
            for (int i = 0; i < n; ++i) {
                this.lsdSSLPorts[i] = 0;
                this.lsdSSLCCPorts[i] = 0;
            }
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.wlm.configuration.WLMTaggedComponent.createVERSION1", "273", this);
            Tr.warning(tc, "NLSKEY_UNEXPECTED_EXCEPTION", new Object[]{"createVERSION1", iOException});
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVERSION1");
        }
        return n;
    }

    private void createVERSION2(DataInputStream dataInputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createVERSION2");
        }
        int n = this.createVERSION1(dataInputStream);
        try {
            this.lsdHosts = new String[n];
            this.lsdPorts = new short[n];
            for (int i = 0; i < n; ++i) {
                this.lsdHosts[i] = dataInputStream.readUTF();
                this.lsdPorts[i] = dataInputStream.readShort();
            }
        }
        catch (IOException iOException) {
            for (int i = 0; i < n; ++i) {
                this.lsdHosts[i] = null;
                this.lsdPorts[i] = 0;
            }
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.wlm.configuration.WLMTaggedComponent.createVERSION2", "328", this);
            Tr.warning(tc, "WLMKEY_UNEXPECTED_EXCEPTION", new Object[]{"createVERSION2", iOException});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVERSION2");
        }
    }

    private void createVERSION3(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createVERSION3", dataInputStream);
        }
        try {
            this.createVERSION2(dataInputStream);
            int n = dataInputStream.readInt();
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray, 0, n);
            this.clusterIdentity = WLMTaggedComponent.bytesToidentity(byArray);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.wlm.configuration.WLMTaggedComponent.createVERSION3", "380", this);
            Tr.warning(tc, "WLMKEY_UNEXPECTED_EXCEPTION", new Object[]{"createVERSION3", iOException});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVERSION3");
        }
    }

    private void createVERSION4(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createVERSION4");
        }
        int n = 0;
        try {
            this.createVERSION3(dataInputStream);
            n = dataInputStream.readInt();
            this.memberSSLPorts = new int[n];
            this.memberSSLCCPorts = new int[n];
            this.memberHosts = new String[n];
            this.memberPorts = new int[n];
            for (int i = 0; i < n; ++i) {
                this.memberSSLPorts[i] = dataInputStream.readInt();
                this.memberSSLCCPorts[i] = dataInputStream.readInt();
                this.memberHosts[i] = dataInputStream.readUTF();
                this.memberPorts[i] = dataInputStream.readInt();
            }
        }
        catch (IOException iOException) {
            for (int i = 0; i < n; ++i) {
                this.memberSSLPorts[i] = 0;
                this.memberSSLCCPorts[i] = 0;
                this.memberHosts[i] = null;
                this.memberPorts[i] = 0;
            }
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.wlm.configuration.WLMTaggedComponent.createVERSION4", "477", this);
            Tr.warning(tc, "WLMKEY_UNEXPECTED_EXCEPTION", new Object[]{"createVERSION4", iOException});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVERSION4");
        }
    }

    public int getVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVersion");
            Tr.exit(tc, "getVersion", new Integer(this.version));
        }
        return this.version;
    }

    public Identity getClusterIdentity() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterIdentity()");
            Tr.exit(tc, "getClusterIdentity()", this.clusterIdentity);
        }
        return this.clusterIdentity;
    }

    public String getAdminDomainName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminDomainName");
            Tr.exit(tc, "getAdminDomainName", this.adminDomainName);
        }
        return this.adminDomainName;
    }

    public short[] getLSDSSLPortList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLPortList");
            Tr.exit(tc, "getSSLPortList", this.lsdSSLPorts);
        }
        return this.lsdSSLPorts;
    }

    public int[] getMemberSSLPortList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberSSLPortList");
            Tr.exit(tc, "getMemberSSLPortList", this.memberSSLPorts);
        }
        return this.memberSSLPorts;
    }

    public short[] getLSDSSLCCPortList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLSDSSLCCPortList");
            Tr.exit(tc, "getLSDSSLCCPortList", this.lsdSSLCCPorts);
        }
        return this.lsdSSLCCPorts;
    }

    public int[] getMemberSSLCCPortList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberSSLCCPortList");
            Tr.exit(tc, "getMemberSSLCCPortList", this.memberSSLCCPorts);
        }
        return this.memberSSLCCPorts;
    }

    public short[] getLSDPortList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLSDPortList");
            Tr.exit(tc, "getLSDPortList", this.lsdPorts);
        }
        return this.lsdPorts;
    }

    public int[] getMemberPortList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberPortList");
            Tr.exit(tc, "getMemberPortList", this.memberPorts);
        }
        return this.memberPorts;
    }

    public String[] getLSDHostList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHostList");
            Tr.exit(tc, "getHostList", this.lsdHosts);
        }
        return this.lsdHosts;
    }

    public String[] getMemberHostList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberHostList");
            Tr.exit(tc, "getMemberHostList", this.memberHosts);
        }
        return this.memberHosts;
    }

    public static byte[] getTaggedComponentData(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTaggedComponentData", identity);
        }
        byte[] byArray = null;
        if (identity != null) {
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(4);
                String string = WLMProperties.getAdminDomainName();
                if (string == null) {
                    string = "";
                }
                dataOutputStream.writeUTF(string);
                if (WBISupport) {
                    dataOutputStream.writeUTF(ivClusterService.identityToString(identity));
                } else {
                    Map map = identity.getProperties();
                    String string2 = (String)map.get("CLUSTERNAME");
                    if (string2 != null) {
                        dataOutputStream.writeUTF(string2);
                    } else {
                        dataOutputStream.writeUTF(ivClusterService.identityToString(identity));
                    }
                }
                list = WLMProperties.getLSDAddresses();
                dataOutputStream.writeInt(list.length);
                for (n = 0; n < list.length; ++n) {
                    dataOutputStream.writeShort((short)list[n].getSSLPort());
                    dataOutputStream.writeShort((short)list[n].getSSLCCPort());
                }
                for (n = 0; n < list.length; ++n) {
                    dataOutputStream.writeUTF(list[n].getHost());
                    dataOutputStream.writeShort((short)list[n].getPort());
                }
                byte[] byArray2 = WLMTaggedComponent.identityToBytes((DescriptionKey)identity);
                dataOutputStream.writeInt(byArray2.length);
                dataOutputStream.write(byArray2);
                memberList = WLMProperties.getMemberAddresses();
                dataOutputStream.writeInt(memberList.length);
                for (int i = 0; i < memberList.length; ++i) {
                    dataOutputStream.writeInt(memberList[i].getSSLPort());
                    dataOutputStream.writeInt(memberList[i].getSSLCCPort());
                    dataOutputStream.writeUTF(memberList[i].getHost());
                    dataOutputStream.writeInt(memberList[i].getPort());
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.wlm.configuration.WLMIOR.createTaggedComponentData", "386");
                Tr.warning(tc, "NLSKEY_UNEXPECTED_EXCEPTION", new Object[]{"initializeTaggedComponentData", iOException});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTaggedComponentData", byArray);
        }
        return byArray;
    }

    public static void addAlternateIIOPAddressComponent(Profile profile) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addAlternateIIOPAddressComponent", profile);
        }
        byte[] byArray = null;
        ORB oRB = GlobalORBFactory.globalORB();
        boolean bl = WLMProperties.getAltAddressMode().equals("endian");
        for (int i = 0; i < list.length; ++i) {
            CDROutputStream cDROutputStream = ORB.createCDROutputStream((ORB)oRB);
            if (bl) {
                cDROutputStream.putEndian();
            }
            AlternateIIOPAddressHelper.write((OutputStream)cDROutputStream, list[i].getAlternateIIOPAddress());
            byArray = cDROutputStream.toByteArray();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "adding alternateIIOPaddress to taggedComponent", new Object[]{list[i], String.valueOf(byArray)});
            }
            profile.putTaggedComponent(3, byArray, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addAlternateIIOPAddressComponent");
        }
    }

    public static byte[] getZTaggedComponentData(Identity identity) {
        byte[] byArray;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getZTaggedComponentData", identity);
            }
            byArray = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                byte[] byArray2 = identity.toString().getBytes();
                dataOutputStream.writeInt(identity.hashCode());
                dataOutputStream.write(byArray2, 0, byArray2.length);
                dataOutputStream.flush();
                byteArrayOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.wlm.configuration.WLMTaggedComponent.getZTaggedComponentData", "645");
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "IOException attempting to marshal cluster identity", iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getZTaggedComponentData", byArray);
        }
        return byArray;
    }

    private static byte[] identityToBytes(DescriptionKey descriptionKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "identityToBytes", descriptionKey);
        }
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            keyRepository.exportToStream(dataOutputStream, descriptionKey);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "identityToBytes", byArray);
        }
        return byArray;
    }

    private static Identity bytesToidentity(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bytesToidentity", byArray);
        }
        DescriptionKey descriptionKey = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            descriptionKey = keyRepository.importFromStream(dataInputStream);
            dataInputStream.close();
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bytesToidentity", descriptionKey);
        }
        return descriptionKey;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n" + WLMTaggedComponent.class.getName() + " ");
        stringBuffer.append("[version: " + this.version + "] ");
        stringBuffer.append("[clusterIdentity: " + this.clusterIdentity + "] ");
        if (this.lsdHosts != null && this.lsdHosts.length > 0) {
            stringBuffer.append("[lsdHosts: ");
            for (n = 0; n < this.lsdHosts.length; ++n) {
                if (n == this.lsdHosts.length - 1) {
                    stringBuffer.append("[" + n + "]" + " " + this.lsdHosts[n]);
                    continue;
                }
                stringBuffer.append("[" + n + "]" + " " + this.lsdHosts[n] + ", ");
            }
            stringBuffer.append("] ");
        }
        if (this.lsdPorts != null && this.lsdPorts.length > 0) {
            stringBuffer.append("[lsdPorts: ");
            for (n = 0; n < this.lsdPorts.length; ++n) {
                if (n == this.lsdPorts.length - 1) {
                    stringBuffer.append("[" + n + "]" + " " + this.lsdPorts[n]);
                    continue;
                }
                stringBuffer.append("[" + n + "]" + " " + this.lsdPorts[n] + ", ");
            }
            stringBuffer.append("] ");
        }
        if (this.lsdSSLPorts != null && this.lsdSSLPorts.length > 0) {
            stringBuffer.append("[lsdSSLPorts: ");
            for (n = 0; n < this.lsdSSLPorts.length; ++n) {
                if (n == this.lsdSSLPorts.length - 1) {
                    stringBuffer.append("[" + n + "]" + " " + this.lsdSSLPorts[n]);
                    continue;
                }
                stringBuffer.append("[" + n + "]" + " " + this.lsdSSLPorts[n] + ", ");
            }
            stringBuffer.append("] ");
        }
        if (this.lsdSSLCCPorts != null && this.lsdSSLCCPorts.length > 0) {
            stringBuffer.append("[lsdSSLCCPorts: ");
            for (n = 0; n < this.lsdSSLCCPorts.length; ++n) {
                if (n == this.lsdSSLCCPorts.length - 1) {
                    stringBuffer.append("[" + n + "]" + " " + this.lsdSSLCCPorts[n]);
                    continue;
                }
                stringBuffer.append("[" + n + "]" + " " + this.lsdSSLCCPorts[n] + ", ");
            }
            stringBuffer.append("] ");
        }
        if (this.memberHosts != null && this.memberHosts.length > 0) {
            stringBuffer.append("[memberHosts: ");
            for (n = 0; n < this.memberHosts.length; ++n) {
                if (n == this.memberHosts.length - 1) {
                    stringBuffer.append("[" + n + "]" + " " + this.memberHosts[n]);
                    continue;
                }
                stringBuffer.append("[" + n + "]" + " " + this.memberHosts[n] + ", ");
            }
            stringBuffer.append("] ");
        }
        if (this.memberPorts != null && this.memberPorts.length > 0) {
            stringBuffer.append("[memberPorts: ");
            for (n = 0; n < this.memberPorts.length; ++n) {
                if (n == this.memberPorts.length - 1) {
                    stringBuffer.append("[" + n + "]" + " " + this.memberPorts[n]);
                    continue;
                }
                stringBuffer.append("[" + n + "]" + " " + this.memberPorts[n] + ", ");
            }
            stringBuffer.append("] ");
        }
        if (this.memberSSLPorts != null && this.memberSSLPorts.length > 0) {
            stringBuffer.append("[memberSSLPorts: ");
            for (n = 0; n < this.memberSSLPorts.length; ++n) {
                if (n == this.memberSSLPorts.length - 1) {
                    stringBuffer.append("[" + n + "]" + " " + this.memberSSLPorts[n]);
                    continue;
                }
                stringBuffer.append("[" + n + "]" + " " + this.memberSSLPorts[n] + ", ");
            }
            stringBuffer.append("] ");
        }
        if (this.memberSSLCCPorts != null && this.memberSSLCCPorts.length > 0) {
            stringBuffer.append("[memberSSLCCPorts: ");
            for (n = 0; n < this.memberSSLCCPorts.length; ++n) {
                if (n == this.memberSSLCCPorts.length - 1) {
                    stringBuffer.append("[" + n + "]" + " " + this.memberSSLCCPorts[n]);
                    continue;
                }
                stringBuffer.append("[" + n + "]" + " " + this.memberSSLCCPorts[n] + ", ");
            }
            stringBuffer.append("] ");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.26.1.3 : none");
        }
        keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
        ivClusterService = ClusterServiceFactory.getClusterService();
    }
}

