/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm.server;

import com.ibm.CORBA.iiop.ExtendedORBInitInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wlm.PMIManager;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public final class PMIServerRequestInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static final TraceComponent tc = Tr.register(PMIServerRequestInterceptor.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final String name = "PMIServerRequestInterceptor";

    public void pre_init(ORBInitInfo oRBInitInfo) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "pre_init", oRBInitInfo);
            }
            try {
                oRBInitInfo.register_initial_reference(name, (Object)this);
                ((ExtendedORBInitInfo)oRBInitInfo).add_server_request_interceptor((ServerRequestInterceptor)this, false);
            }
            catch (DuplicateName duplicateName) {
                FFDCFilter.processException((Throwable)duplicateName, "com.ibm.ws.wlm.server.PMIServerRequestInterceptor.pre_init", "115", (java.lang.Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "pre_init:Interceptor already registered:", (java.lang.Object)duplicateName);
                }
            }
            catch (InvalidName invalidName) {
                FFDCFilter.processException((Throwable)invalidName, "com.ibm.ws.wlm.server.WLMServerRequestInterceptor.pre_init", "120", (java.lang.Object)this);
                if (!tc.isEventEnabled()) break block6;
                Tr.event(tc, "pre_init:Unable to register server request interceptor", (java.lang.Object)invalidName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pre_init");
        }
    }

    public void post_init(ORBInitInfo oRBInitInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "post_init");
            Tr.exit(tc, "post_init");
        }
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive_request", serverRequestInfo);
        }
        if (PMIManager.serverModule != null) {
            int n;
            int n2;
            block8: {
                n2 = -1;
                n = 0;
                try {
                    ServiceContext serviceContext = ((ExtendedServerRequestInfo)serverRequestInfo).getRequestServiceContext(1229081865);
                    if (serviceContext != null && serviceContext.context_data.length > 4 && PMIServerRequestInterceptor.bytesToInt(serviceContext.context_data, 0) >= 1) {
                        n2 = PMIServerRequestInterceptor.bytesToInt(serviceContext.context_data, 12);
                        n = serviceContext.context_data[16];
                    }
                }
                catch (BAD_PARAM bAD_PARAM) {
                    FFDCFilter.processException((Throwable)bAD_PARAM, "com.ibm.ws.wlm.server.PMIServerRequestInterceptor.receive_request", "204", (java.lang.Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Unexpected exception", (java.lang.Object)bAD_PARAM);
                    }
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException((Throwable)classCastException, "com.ibm.ws.wlm.server.PMIServerRequestInterceptor.receive_request", "209", (java.lang.Object)this);
                    if (!tc.isEventEnabled()) break block8;
                    Tr.event(tc, "ClassCastException thrown casting to ExtendedServerRequestInfo", classCastException);
                }
            }
            PMIManager.serverModule.onIncomingWLMRequest(serverRequestInfo, n2, n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_request");
        }
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send_reply");
        }
        if (PMIManager.serverModule != null) {
            PMIManager.serverModule.onOutgoingWLMReply(serverRequestInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send_reply");
        }
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send_exception", serverRequestInfo.operation());
        }
        if (PMIManager.serverModule != null) {
            PMIManager.serverModule.onOutgoingWLMReply(serverRequestInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send_exception");
        }
    }

    public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send_other", serverRequestInfo.operation());
        }
        if (PMIManager.serverModule != null) {
            PMIManager.serverModule.onOutgoingWLMReply(serverRequestInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send_other");
        }
    }

    public String name() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "name");
            Tr.exit(tc, "name", name);
        }
        return name;
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
            Tr.exit(tc, "destroy");
        }
    }

    private static int bytesToInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = n; i < n + 4; ++i) {
            n2 <<= 8;
            n2 |= byArray[i] & 0xFF;
        }
        return n2;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.6 : none");
        }
    }
}

