/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm.server;

import com.ibm.CORBA.iiop.ExtendedORBInitInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wlm.server.WLMServiceServerContextListener;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public final class WLMServerRequestInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static final TraceComponent tc = Tr.register(WLMServerRequestInterceptor.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final String name = "WLMServerRequestInterceptor";
    private WLMServiceServerContextListener[] listeners = new WLMServiceServerContextListener[0];

    public void pre_init(ORBInitInfo oRBInitInfo) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "pre_init", oRBInitInfo);
            }
            try {
                oRBInitInfo.register_initial_reference(name, (Object)this);
                ((ExtendedORBInitInfo)oRBInitInfo).add_server_request_interceptor_first((ServerRequestInterceptor)this, false);
            }
            catch (DuplicateName duplicateName) {
                FFDCFilter.processException((Throwable)duplicateName, "com.ibm.ws.wlm.server.WLMServerRequestInterceptor.pre_init", "111", (java.lang.Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Interceptor already registered:", (java.lang.Object)duplicateName);
                }
            }
            catch (InvalidName invalidName) {
                FFDCFilter.processException((Throwable)invalidName, "com.ibm.ws.wlm.server.WLMServerRequestInterceptor.pre_init", "117", (java.lang.Object)this);
                if (!tc.isEventEnabled()) break block6;
                Tr.event(tc, "Unable to register server request interceptor", (java.lang.Object)invalidName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pre_init");
        }
    }

    public void post_init(ORBInitInfo oRBInitInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "post_init");
            Tr.exit(tc, "post_init");
        }
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send_reply");
            Tr.exit(tc, "send_reply");
        }
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive_request", serverRequestInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_request");
        }
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        ServiceContext serviceContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive_request_service_contexts", ((ExtendedServerRequestInfo)serverRequestInfo).getRequestMessage().getObjectKeyObject().getBytes());
        }
        if ((serviceContext = ((ExtendedServerRequestInfo)serverRequestInfo).getRequestServiceContext(1229081865)) != null) {
            this.notifyServiceContextListeners(serverRequestInfo);
            this.notifyValidationListeners(serverRequestInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_request_service_contexts");
        }
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send_exception", serverRequestInfo.operation());
            Tr.exit(tc, "send_exception");
        }
    }

    public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send_other", serverRequestInfo.operation());
            Tr.exit(tc, "send_other");
        }
    }

    private void notifyServiceContextListeners(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "notifyServiceContextListeners", serverRequestInfo);
            }
            try {
                ServiceContext serviceContext = ((ExtendedServerRequestInfo)serverRequestInfo).getRequestServiceContext(1229081865);
                if (serviceContext != null) {
                    byte[] byArray = null;
                    for (int i = 0; i < this.listeners.length && ((byArray = this.listeners[i].receiveServerContext(serviceContext.context_data)) == null || byArray.length <= 0); ++i) {
                    }
                    if (byArray != null && byArray.length > 0) {
                        serverRequestInfo.add_reply_service_context(new ServiceContext(1229081865, byArray), true);
                    }
                }
            }
            catch (BAD_PARAM bAD_PARAM) {
                FFDCFilter.processException((Throwable)bAD_PARAM, "com.ibm.ws.wlm.server.WLMServerRequestInterceptor.notifyServiceContextListeners", "297", (java.lang.Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected exception", (java.lang.Object)bAD_PARAM);
                }
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, "com.ibm.ws.wlm.server.WLMServerRequestInterceptor.notifyServiceContextListeners", "303", (java.lang.Object)this);
                if (!tc.isEventEnabled()) break block9;
                Tr.event(tc, "ClassCastException thrown casting to ExtendedServerRequestInfo", classCastException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyServiceContextListeners");
        }
    }

    private void notifyValidationListeners(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        ObjectKey objectKey = ((ExtendedServerRequestInfo)serverRequestInfo).getRequestMessage().getObjectKeyObject();
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].validateRequest(objectKey);
        }
    }

    public void registerServiceContextListener(ORB oRB, WLMServiceServerContextListener wLMServiceServerContextListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerServiceContextListener", wLMServiceServerContextListener);
        }
        int n = this.listeners.length;
        WLMServiceServerContextListener[] wLMServiceServerContextListenerArray = new WLMServiceServerContextListener[n + 1];
        System.arraycopy(this.listeners, 0, wLMServiceServerContextListenerArray, 1, n);
        wLMServiceServerContextListenerArray[0] = wLMServiceServerContextListener;
        this.listeners = wLMServiceServerContextListenerArray;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerServiceContextListener");
        }
    }

    public String name() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "name");
            Tr.exit(tc, "name", name);
        }
        return name;
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
            Tr.exit(tc, "destroy");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.16 : none");
        }
    }
}

