/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wmm.datatype.impl;

import com.ibm.websphere.wmm.datatype.AttributeDefinition;
import com.ibm.websphere.wmm.datatype.AttributeDefinitionIterator;
import com.ibm.websphere.wmm.datatype.AttributeDefinitionSet;
import com.ibm.ws.wmm.datatype.impl.AttributeDefinitionIteratorData;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class HashAttributeDefinitionSet
implements AttributeDefinitionSet {
    private HashMap map = null;
    private static final String PRESENT = "^";
    private int capacity = 11;
    private float loadFactor = 0.75f;

    public HashAttributeDefinitionSet() {
        this.map = new HashMap(this.capacity, this.loadFactor);
    }

    public HashAttributeDefinitionSet(int n) {
        this.capacity = (int)((float)n / this.loadFactor);
        this.map = new HashMap(this.capacity, this.loadFactor);
    }

    public HashAttributeDefinitionSet(int n, float f) {
        this.map = new HashMap(n, f);
        this.capacity = n;
        this.loadFactor = f;
    }

    public boolean add(AttributeDefinition attributeDefinition) {
        return this.map.put(attributeDefinition, PRESENT) == null;
    }

    public boolean addAll(AttributeDefinitionSet attributeDefinitionSet) {
        AttributeDefinitionIterator attributeDefinitionIterator = attributeDefinitionSet.iterator();
        while (attributeDefinitionIterator.hasNext()) {
            this.add(attributeDefinitionIterator.next());
        }
        return true;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean contains(AttributeDefinition attributeDefinition) {
        return this.map.containsKey(attributeDefinition);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public AttributeDefinitionIterator iterator() {
        return new AttributeDefinitionIteratorData(this.map.keySet().iterator());
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.capacity = objectInputStream.readInt();
        this.loadFactor = objectInputStream.readFloat();
        this.map = new HashMap(this.capacity, this.loadFactor);
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            this.map.put(object, PRESENT);
        }
    }

    public boolean remove(AttributeDefinition attributeDefinition) {
        return this.map.remove(attributeDefinition) == PRESENT;
    }

    public boolean removeAll(AttributeDefinitionSet attributeDefinitionSet) {
        AttributeDefinitionIterator attributeDefinitionIterator = attributeDefinitionSet.iterator();
        while (attributeDefinitionIterator.hasNext()) {
            this.remove(attributeDefinitionIterator.next());
        }
        return true;
    }

    public int size() {
        return this.map.size();
    }

    public AttributeDefinition[] toAttributeDefinitionArray() {
        return this.map.keySet().toArray(new AttributeDefinition[0]);
    }

    public String toString() {
        return this.map.keySet().toString();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.capacity);
        objectOutputStream.writeFloat(this.loadFactor);
        objectOutputStream.writeInt(this.map.size());
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }
}

