/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wmm.datatype.impl;

import com.ibm.websphere.wmm.datatype.MemberIdentifier;
import com.ibm.websphere.wmm.datatype.MemberIdentifierIterator;
import com.ibm.websphere.wmm.datatype.MemberIdentifierSet;
import com.ibm.ws.wmm.datatype.impl.MemberIdentifierIteratorData;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class HashMemberIdentifierSet
implements MemberIdentifierSet {
    private HashMap map = null;
    private static final String PRESENT = "^";
    private int capacity = 11;
    private float loadFactor = 0.75f;

    public HashMemberIdentifierSet() {
        this.map = new HashMap(this.capacity, this.loadFactor);
    }

    public HashMemberIdentifierSet(int n) {
        this.capacity = (int)((float)n / this.loadFactor);
        this.map = new HashMap(this.capacity, this.loadFactor);
    }

    public HashMemberIdentifierSet(int n, float f) {
        this.map = new HashMap(n, f);
        this.capacity = n;
        this.loadFactor = f;
    }

    public boolean add(MemberIdentifier memberIdentifier) {
        return this.map.put(memberIdentifier, PRESENT) == null;
    }

    public boolean addAll(MemberIdentifierSet memberIdentifierSet) {
        MemberIdentifierIterator memberIdentifierIterator = memberIdentifierSet.iterator();
        while (memberIdentifierIterator.hasNext()) {
            this.add(memberIdentifierIterator.next());
        }
        return true;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean contains(MemberIdentifier memberIdentifier) {
        return this.map.containsKey(memberIdentifier);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public MemberIdentifierIterator iterator() {
        return new MemberIdentifierIteratorData(this.map.keySet().iterator());
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.capacity = objectInputStream.readInt();
        this.loadFactor = objectInputStream.readFloat();
        this.map = new HashMap(this.capacity, this.loadFactor);
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            this.map.put(object, PRESENT);
        }
    }

    public boolean remove(MemberIdentifier memberIdentifier) {
        return this.map.remove(memberIdentifier) == PRESENT;
    }

    public boolean removeAll(MemberIdentifierSet memberIdentifierSet) {
        MemberIdentifierIterator memberIdentifierIterator = memberIdentifierSet.iterator();
        while (memberIdentifierIterator.hasNext()) {
            this.remove(memberIdentifierIterator.next());
        }
        return true;
    }

    public int size() {
        return this.map.size();
    }

    public MemberIdentifier[] toMemberIdentifierArray() {
        return this.map.keySet().toArray(new MemberIdentifier[0]);
    }

    public String toString() {
        return this.map.keySet().toString();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.capacity);
        objectOutputStream.writeFloat(this.loadFactor);
        objectOutputStream.writeInt(this.map.size());
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }
}

