/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wmm.datatype.impl;

import com.ibm.websphere.wmm.datatype.Member;
import com.ibm.websphere.wmm.datatype.MemberIterator;
import com.ibm.websphere.wmm.datatype.MemberSet;
import com.ibm.ws.wmm.datatype.impl.MemberIteratorData;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class HashMemberSet
implements MemberSet {
    private HashMap map = null;
    private static final String PRESENT = "^";
    private int capacity = 11;
    private float loadFactor = 0.75f;

    public HashMemberSet() {
        this.map = new HashMap(this.capacity, this.loadFactor);
    }

    public HashMemberSet(int n) {
        this.capacity = (int)((float)n / this.loadFactor);
        this.map = new HashMap(this.capacity, this.loadFactor);
    }

    public HashMemberSet(int n, float f) {
        this.map = new HashMap(n, f);
        this.capacity = n;
        this.loadFactor = f;
    }

    public boolean add(Member member) {
        return this.map.put(member, PRESENT) == null;
    }

    public boolean addAll(MemberSet memberSet) {
        MemberIterator memberIterator = memberSet.iterator();
        while (memberIterator.hasNext()) {
            this.add(memberIterator.next());
        }
        return true;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean contains(Member member) {
        return this.map.containsKey(member);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public MemberIterator iterator() {
        return new MemberIteratorData(this.map.keySet().iterator());
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.capacity = objectInputStream.readInt();
        this.loadFactor = objectInputStream.readFloat();
        this.map = new HashMap(this.capacity, this.loadFactor);
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            this.map.put(object, PRESENT);
        }
    }

    public boolean remove(Member member) {
        return this.map.remove(member) == PRESENT;
    }

    public boolean removeAll(MemberSet memberSet) {
        MemberIterator memberIterator = memberSet.iterator();
        while (memberIterator.hasNext()) {
            this.remove(memberIterator.next());
        }
        return true;
    }

    public int size() {
        return this.map.size();
    }

    public Member[] toMemberArray() {
        return this.map.keySet().toArray(new Member[0]);
    }

    public String toString() {
        return this.map.keySet().toString();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.capacity);
        objectOutputStream.writeFloat(this.loadFactor);
        objectOutputStream.writeInt(this.map.size());
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }
}

