/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wmm.datatype.impl;

import com.ibm.websphere.wmm.datatype.StringIterator;
import com.ibm.websphere.wmm.datatype.StringSet;
import com.ibm.ws.wmm.datatype.impl.StringIteratorData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class HashStringSet
implements StringSet {
    private HashMap map = null;
    private static transient String PRESENT = "d";
    private int capacity = 11;
    private float loadFactor = 0.75f;

    public HashStringSet() {
        this.map = new HashMap(this.capacity, this.loadFactor);
    }

    public HashStringSet(int n) {
        this.capacity = (int)((float)n / this.loadFactor);
        this.map = new HashMap(this.capacity, this.loadFactor);
    }

    public HashStringSet(int n, float f) {
        this.map = new HashMap(n, f);
        this.capacity = n;
        this.loadFactor = f;
    }

    public HashStringSet(Set set) {
        this.map = new HashMap(set.size(), this.loadFactor);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.map.put(iterator.next().toString(), PRESENT);
        }
    }

    public boolean add(String string) {
        return this.map.put(string, PRESENT) == null;
    }

    public boolean addAll(StringSet stringSet) {
        StringIterator stringIterator = stringSet.iterator();
        while (stringIterator.hasNext()) {
            this.add(stringIterator.next());
        }
        return true;
    }

    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            HashStringSet hashStringSet = (HashStringSet)super.clone();
            if (this.map != null) {
                hashStringSet.map = (HashMap)this.map.clone();
            }
            return hashStringSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean contains(String string) {
        return this.map.containsKey(string);
    }

    public boolean containsIgnoreCase(String string) {
        if (string == null) {
            return false;
        }
        Set set = this.map.keySet();
        for (String string2 : set) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StringSet)) {
            return false;
        }
        StringSet stringSet = (StringSet)object;
        if (stringSet.size() != this.size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        StringIterator stringIterator = stringSet.iterator();
        while (stringIterator.hasNext()) {
            if (this.contains(stringIterator.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        StringIterator stringIterator = this.iterator();
        while (stringIterator.hasNext()) {
            String string = stringIterator.next();
            if (string == null) continue;
            n += string.hashCode();
        }
        return n;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public StringIterator iterator() {
        return new StringIteratorData(this.map.keySet().iterator());
    }

    public boolean remove(String string) {
        return this.map.remove(string) == PRESENT;
    }

    public boolean removeAll(StringSet stringSet) {
        StringIterator stringIterator = stringSet.iterator();
        while (stringIterator.hasNext()) {
            this.remove(stringIterator.next());
        }
        return true;
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.keySet().toString();
    }

    public String[] toStringArray() {
        return this.map.keySet().toArray(new String[0]);
    }
}

