/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wmm.datatype.impl;

import com.ibm.websphere.wmm.datatype.Member;
import com.ibm.websphere.wmm.datatype.MemberIdentifier;
import com.ibm.ws.wim.util.UniqueNameHelper;
import com.ibm.ws.wmm.datatype.impl.BaseMemberData;
import com.ibm.ws.wmm.datatype.impl.MemberIdentifierFactory;

public class MemberData
extends BaseMemberData
implements Member {
    private String MEMBER_IDENTIFIER = "memberIdentifier";
    private String PARENT_MEMBER_IDENTIFIER = "parentMemberIdentifier";
    private MemberIdentifier iMemberIdentifier = null;
    private MemberIdentifier iParentMemberIdentifier = null;

    public MemberData() {
    }

    public MemberData(short s) {
        super(s);
    }

    public MemberData(short s, MemberIdentifier memberIdentifier) {
        this(s);
        this.iMemberIdentifier = memberIdentifier;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Member)) {
            return false;
        }
        Member member = (Member)object;
        return this.getMemberIdentifier() != null && this.getMemberIdentifier().equals(member.getMemberIdentifier());
    }

    public MemberIdentifier getMemberIdentifier() {
        return this.iMemberIdentifier;
    }

    public MemberIdentifier getParentMemberIdentifier() {
        if (this.iParentMemberIdentifier == null && this.iMemberIdentifier != null && this.iMemberIdentifier.getMemberDN() != null) {
            try {
                String string = UniqueNameHelper.getParentDN(this.iMemberIdentifier.getMemberDN());
                if (string != null) {
                    this.iParentMemberIdentifier = MemberIdentifierFactory.getInstance(string, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.iParentMemberIdentifier;
    }

    public int hashCode() {
        if (this.getMemberIdentifier() != null) {
            return this.getMemberIdentifier().hashCode();
        }
        return super.hashCode();
    }

    public void setMemberIdentifier(MemberIdentifier memberIdentifier) {
        this.iMemberIdentifier = memberIdentifier;
    }

    public void setParentMemberIdentifier(MemberIdentifier memberIdentifier) {
        this.iParentMemberIdentifier = memberIdentifier;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.MEMBER_TYPE).append(":").append(this.iMemberType).append(", ");
        stringBuffer.append(this.MEMBER_IDENTIFIER).append(":").append(this.iMemberIdentifier).append(", ");
        stringBuffer.append(this.PARENT_MEMBER_IDENTIFIER).append(":").append(this.iParentMemberIdentifier).append("\n");
        stringBuffer.append(this.getAttributes().toString());
        return stringBuffer.toString();
    }
}

