/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wmm.datatype.impl;

import com.ibm.websphere.wmm.datatype.Member;
import com.ibm.websphere.wmm.datatype.MemberIterator;
import com.ibm.websphere.wmm.datatype.MemberList;
import com.ibm.websphere.wmm.datatype.MemberSet;
import com.ibm.ws.wmm.datatype.impl.MemberIteratorData;
import com.ibm.ws.wmm.datatype.impl.MemberListFactory;
import java.util.Vector;

public class VectorMemberList
implements MemberList {
    private Vector list = null;
    private int capacity = 10;
    private int increment = 5;

    public VectorMemberList() {
        this.list = new Vector();
    }

    public VectorMemberList(int n) throws IllegalArgumentException {
        this.list = new Vector(n);
    }

    public VectorMemberList(int n, int n2) throws IllegalArgumentException {
        this.list = new Vector(n, n2);
    }

    public boolean add(Member member) {
        return this.list.add(member);
    }

    public void add(int n, Member member) {
        this.list.add(n, member);
    }

    public void addAll(int n, MemberSet memberSet) {
        int n2 = n;
        MemberIterator memberIterator = memberSet.iterator();
        while (memberIterator.hasNext()) {
            this.list.add(n2++, memberIterator.next());
        }
    }

    public boolean addAll(MemberSet memberSet) {
        boolean bl = true;
        MemberIterator memberIterator = memberSet.iterator();
        while (bl && memberIterator.hasNext()) {
            bl = this.list.add(memberIterator.next());
        }
        return bl;
    }

    public void clear() {
        this.list.clear();
    }

    public boolean contains(Member member) {
        return this.list.contains(member);
    }

    public Member elementAt(int n) {
        return (Member)this.list.elementAt(n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MemberList)) {
            return false;
        }
        MemberIterator memberIterator = this.iterator();
        MemberIterator memberIterator2 = ((MemberList)object).iterator();
        while (memberIterator.hasNext() && memberIterator2.hasNext()) {
            Member member = memberIterator.next();
            Member member2 = memberIterator2.next();
            if (!(member != null ? !member.equals(member2) : member2 != null)) continue;
            return false;
        }
        return !memberIterator.hasNext() && !memberIterator2.hasNext();
    }

    public Member get(int n) {
        return (Member)this.list.get(n);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public MemberIterator iterator() {
        return new MemberIteratorData(this.list.iterator());
    }

    public void removeRange(int n, int n2) {
        this.list.subList(n, n2).clear();
    }

    public void setElementAt(Member member, int n) {
        this.list.setElementAt(member, n);
    }

    public int size() {
        return this.list.size();
    }

    public MemberList subList(int n, int n2) {
        MemberList memberList = MemberListFactory.getInstance();
        for (int i = n; i < n2; ++i) {
            memberList.add((Member)this.list.get(i));
        }
        return memberList;
    }

    public String toString() {
        return this.list.toString();
    }

    public Member[] toArray() {
        return this.list.toArray(new Member[0]);
    }
}

