/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.workarea;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.asynchbeans.ServiceContext;
import com.ibm.ws.asynchbeans.ServiceContextInvalid;
import com.ibm.ws.asynchbeans.ServiceWithContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.workarea.UserWorkAreaServerImpl;
import com.ibm.ws.workarea.WorkAreaExportedToken;
import com.ibm.ws.workarea.WorkAreaMessages;
import java.util.Hashtable;

public class ServiceWithContextImpl
implements ServiceWithContext {
    private static final TraceComponent _tc = Tr.register(ServiceWithContextImpl.class, null, "com.ibm.ws.workarea.resources.acwa");
    private static ServiceWithContextImpl _swic = null;
    private static final int WA_REF_INCREMENT_COUNT = 5;
    private UserWorkAreaServerImpl[] waRefs = new UserWorkAreaServerImpl[5];
    int numberOfPartitions = 0;
    public static final String CONTEXT_SERVICE_NAME = "UserWorkArea";

    private ServiceWithContextImpl() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ServiceWithContextImpl");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ServiceWithContextImpl");
        }
    }

    public static ServiceWithContextImpl getInstance() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInstance");
        }
        if (_swic == null) {
            _swic = new ServiceWithContextImpl();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getInstance", _swic);
        }
        return _swic;
    }

    public void addPartition(UserWorkAreaServerImpl userWorkAreaServerImpl, int n) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addPartition", new Object[]{userWorkAreaServerImpl, new Integer(n)});
        }
        if (this.waRefs.length < n + 1) {
            UserWorkAreaServerImpl[] userWorkAreaServerImplArray = new UserWorkAreaServerImpl[this.waRefs.length + 5];
            System.arraycopy(this.waRefs, 0, userWorkAreaServerImplArray, 0, this.waRefs.length);
            this.waRefs = userWorkAreaServerImplArray;
        }
        ++this.numberOfPartitions;
        this.waRefs[n] = userWorkAreaServerImpl;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addPartition");
        }
    }

    public String getServiceName() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getServiceName");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getServiceName", CONTEXT_SERVICE_NAME);
        }
        return CONTEXT_SERVICE_NAME;
    }

    public String getServiceDescription() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getServiceDescription");
        }
        String string = WorkAreaMessages.getMsg("INF_WA_DESCRIPTION");
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getServiceDescription", string);
        }
        return string;
    }

    public ServiceContext peek() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "peek");
        }
        Hashtable hashtable = new Hashtable();
        WorkAreaExportedToken workAreaExportedToken = new WorkAreaExportedToken();
        WorkAreaExportedToken workAreaExportedToken2 = null;
        for (int i = 0; i < this.numberOfPartitions; ++i) {
            hashtable = this.waRefs[i].peek();
            workAreaExportedToken2 = new WorkAreaExportedToken(this.waRefs[i].getName(), hashtable);
            workAreaExportedToken.allPartitionTokens.put(this.waRefs[i].getPartitionName(), workAreaExportedToken2);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "peek", workAreaExportedToken);
        }
        return workAreaExportedToken;
    }

    public void push(ServiceContext serviceContext) throws ServiceContextInvalid {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "push", serviceContext);
        }
        WorkAreaExportedToken workAreaExportedToken = (WorkAreaExportedToken)serviceContext;
        WorkAreaExportedToken workAreaExportedToken2 = null;
        for (int i = 0; i < this.numberOfPartitions; ++i) {
            if (workAreaExportedToken == null) {
                workAreaExportedToken2 = new WorkAreaExportedToken(null, null);
            } else {
                workAreaExportedToken2 = (WorkAreaExportedToken)workAreaExportedToken.allPartitionTokens.get(this.waRefs[i].getPartitionName());
                if (workAreaExportedToken2 == null) {
                    workAreaExportedToken2 = new WorkAreaExportedToken(null, null);
                }
            }
            this.waRefs[i].push(workAreaExportedToken2);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "push");
        }
    }

    public void pop(ServiceContext serviceContext) throws ServiceContextInvalid {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "pop");
        }
        for (int i = 0; i < this.numberOfPartitions; ++i) {
            try {
                this.waRefs[i].pop();
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.workarea.ServiceWithContextImpl.pop", "381", this);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "pop", illegalStateException);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "pop", "Resuming context failed");
                }
                ServiceContextInvalid serviceContextInvalid = new ServiceContextInvalid(this.getServiceName());
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "pop", "Caught: " + illegalStateException);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "pop", "Throwing: " + serviceContextInvalid);
                }
                throw serviceContextInvalid;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "pop");
        }
    }
}

