/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.workarea;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.workareaservice.WorkAreaPartition;
import com.ibm.websphere.models.config.workareaservice.WorkAreaPartitionService;
import com.ibm.websphere.workarea.PartitionAlreadyExistsException;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.workarea.WorkAreaPartitionManagerImpl;
import com.ibm.ws.workarea.WorkAreaService;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;

public class WorkAreaPartitionServiceServer
extends ComponentImpl {
    private static final TraceComponent _tc = Tr.register(WorkAreaPartitionServiceServer.class, null, "com.ibm.ws.workarea.resources.acwa");
    private boolean _initialized = false;
    private boolean _enabled = true;
    List partitions = null;

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initialize", object);
        }
        try {
            if (!(object instanceof WorkAreaPartitionService)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "WorkAreaPartition parm is wrong type!  Going to use defaults!");
                }
                WorkAreaService.setEnabled(this._enabled);
                ConfigurationWarning configurationWarning = new ConfigurationWarning("");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "initialize", "Throwing: " + configurationWarning);
                }
                throw configurationWarning;
            }
            WorkAreaPartitionService workAreaPartitionService = (WorkAreaPartitionService)object;
            this.partitions = workAreaPartitionService.getPartitions();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.workarea.WorkAreaPartitionServiceServer.initialize", "72", this);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "initialize", exception);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "initialize", exception);
            }
            ConfigurationWarning configurationWarning = new ConfigurationWarning("");
            configurationWarning.initCause(exception);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "initialize", "Throwing: " + configurationWarning);
            }
            throw configurationWarning;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initialize");
        }
    }

    public void start() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "start");
        }
        if (this._initialized) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Already initialized; returning");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "start");
            }
            return;
        }
        this._initialized = true;
        boolean bl = true;
        WorkAreaPartitionManagerImpl workAreaPartitionManagerImpl = WorkAreaPartitionManagerImpl.getInstance();
        String string = null;
        Properties properties = new Properties();
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator iterator = null;
        EList eList = null;
        Property property = null;
        Iterator iterator2 = this.partitions.iterator();
        while (iterator2.hasNext()) {
            bl = true;
            WorkAreaPartition workAreaPartition = (WorkAreaPartition)iterator2.next();
            if (workAreaPartition.isEnable()) {
                properties.clear();
                properties.put("maxSendSize", new Integer(workAreaPartition.getMaxSendSize()).toString());
                properties.put("maxReceiveSize", new Integer(workAreaPartition.getMaxReceiveSize()).toString());
                string = workAreaPartition.getName();
                if (string == null) {
                    Tr.error(_tc, "ERR_INVALID_PARTITION_NAME", string);
                    continue;
                }
                bl2 = workAreaPartition.isBidirectional();
                if (bl2) {
                    properties.put("Bidirectional", "true");
                } else {
                    properties.put("Bidirectional", "false");
                }
                bl3 = workAreaPartition.isDeferredAttributeSerialization();
                if (bl3) {
                    properties.put("DeferredAttributeSerialization", "true");
                } else {
                    properties.put("DeferredAttributeSerialization", "false");
                }
                properties.put("EnableWebServicePropagation", Boolean.valueOf(workAreaPartition.isEnableWebServicePropagation()).toString());
                eList = workAreaPartition.getProperties();
                if (eList != null) {
                    iterator = eList.iterator();
                    while (iterator.hasNext()) {
                        property = (Property)iterator.next();
                        properties.put(property.getName(), property.getValue());
                    }
                }
                try {
                    workAreaPartitionManagerImpl.createWorkAreaPartition(string, properties);
                }
                catch (PartitionAlreadyExistsException partitionAlreadyExistsException) {
                    FFDCFilter.processException((Throwable)partitionAlreadyExistsException, "com.ibm.ws.workarea.WorkAreaPartitionServiceServer.start", "139", this);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "start", partitionAlreadyExistsException);
                    }
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "start", "The partition \"" + string + "\" has already been defined.");
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.workarea.WorkAreaPartitionServiceServer.start", "145", this);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "start", illegalAccessException);
                    }
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "start", "Initialization complete, can't create a new partition.");
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.workarea.WorkAreaPartitionServiceServer.start", "151", this);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "start", illegalArgumentException);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "start", "Invalid parameter(s) on createWorkAreaPartition: " + illegalArgumentException);
                    }
                    bl = false;
                }
                if (bl) {
                    Tr.audit(_tc, "INF_WAP_READY", new Object[]{string, WorkAreaService.getServerName()});
                }
                if (bl) continue;
                Tr.audit(_tc, "INF_WAP_NOT_ENABLED", new Object[]{string, WorkAreaService.getServerName()});
                continue;
            }
            Tr.audit(_tc, "INF_WAP_NOT_ENABLED", new Object[]{workAreaPartition.getName(), WorkAreaService.getServerName()});
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "start");
        }
    }
}

