/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.workarea;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.websphere.workarea.PartitionAlreadyExistsException;
import com.ibm.websphere.workarea.UserWorkArea;
import com.ibm.ws.client.applicationclient.ClientProcessService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.workarea.WorkAreaMessages;
import com.ibm.ws.workarea.WorkAreaPartitionManagerImpl;
import com.ibm.ws.workarea.WorkAreaService;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Context;

public class WorkAreaServiceClient
extends ComponentImpl {
    private static final TraceComponent _tc = Tr.register(WorkAreaServiceClient.class, null, "com.ibm.ws.workarea.resources.acwa");
    private static UserWorkArea _currentWorkArea = null;
    private boolean _isClientProcess = false;
    private int _maxSendSize = WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE;
    private int _maxReceiveSize = WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE;
    private boolean _enabled = true;
    private static boolean _initialized = false;
    private Hashtable userPartitionProps = new Hashtable();
    private Vector names = null;
    Properties userWorkAreaConfigurationProps = new Properties();

    public WorkAreaServiceClient() {
        this.userWorkAreaConfigurationProps.setProperty("cacheable", "false");
        this.userWorkAreaConfigurationProps.setProperty("maxSendSize", WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING);
        this.userWorkAreaConfigurationProps.setProperty("maxReceiveSize", WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING);
        this.userWorkAreaConfigurationProps.setProperty("Bidirectional", "true");
        this.userWorkAreaConfigurationProps.setProperty("isContextCORBAInteroperable", "true");
        this.userWorkAreaConfigurationProps.setProperty("DeferredAttributeSerialization", "false");
        this.userWorkAreaConfigurationProps.setProperty("EnableWebServicePropagation", "false");
    }

    public void initialize(Object object) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initialize");
        }
        WorkAreaService.setIsClientProcess(true);
        Properties properties = System.getProperties();
        String string = properties.getProperty("com.ibm.websphere.workarea.maxSendSize");
        if (string != null) {
            try {
                this._maxSendSize = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.workarea.WorkAreaServiceClient.initialize", "84", this);
                NumberFormatException numberFormatException2 = new NumberFormatException(WorkAreaMessages.getMsg("INF_INVALID_MAXSENDSIZE_FORMAT", new Object[]{WorkAreaService.getServiceName(), string, WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING}));
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "initialize", numberFormatException2);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "initialize", numberFormatException2);
                }
                throw numberFormatException2;
            }
            if (this._maxSendSize < -1) {
                this._maxSendSize = WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE;
                NumberFormatException numberFormatException = new NumberFormatException(WorkAreaMessages.getMsg("INF_INVALID_MAXSENDSIZE_FORMAT", new Object[]{WorkAreaService.getServiceName(), string, WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING}));
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "initialize", numberFormatException);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "initialize", numberFormatException);
                }
                throw numberFormatException;
            }
        }
        if ((string = properties.getProperty("com.ibm.websphere.workarea.maxReceiveSize")) != null) {
            try {
                this._maxReceiveSize = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.workarea.WorkAreaServiceClient.initialize", "108", this);
                NumberFormatException numberFormatException3 = new NumberFormatException(WorkAreaMessages.getMsg("INF_INVALID_MAXRECEIVESIZE_FORMAT", new Object[]{WorkAreaService.getServiceName(), string, WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING}));
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "initialize", numberFormatException3);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "initialize", numberFormatException3);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "initialize", "maxReceiveSize of " + string + " is invalid");
                }
                throw numberFormatException3;
            }
            if (this._maxReceiveSize < -1) {
                this._maxReceiveSize = WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE;
                NumberFormatException numberFormatException = new NumberFormatException(WorkAreaMessages.getMsg("INF_INVALID_MAXRECEIVESIZE_FORMAT", new Object[]{WorkAreaService.getServiceName(), string, WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING}));
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "initialize", numberFormatException);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "initialize", numberFormatException);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "initialize", "maxReceiveSize of " + string + " is invalid. A value less than -1 is not valid.");
                }
                throw numberFormatException;
            }
        }
        if ((string = properties.getProperty("com.ibm.websphere.workarea.lazySerialization")) != null && string.equals("true")) {
            this.userWorkAreaConfigurationProps.setProperty("DeferredAttributeSerialization", "true");
        }
        if ((string = properties.getProperty("com.ibm.websphere.workarea.DeferredAttributeSerialization")) != null && string.equals("true")) {
            this.userWorkAreaConfigurationProps.setProperty("DeferredAttributeSerialization", "true");
        }
        if ((string = properties.getProperty("com.ibm.websphere.workarea.isContextCORBAInteroperable")) != null && string.equals("false")) {
            this.userWorkAreaConfigurationProps.setProperty("isContextCORBAInteroperable", "false");
        }
        if ((string = properties.getProperty("com.ibm.websphere.workarea.enabled")) != null) {
            this._enabled = new Boolean(string);
        }
        if ((string = properties.getProperty("com.ibm.websphere.workarea.EnableWebServicePropagation")) != null && string.equals("true")) {
            this.userWorkAreaConfigurationProps.setProperty("EnableWebServicePropagation", "true");
        }
        WorkAreaService.setEnabled(this._enabled);
        this.processCommandLineProperties(properties);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initialize");
        }
    }

    public void start() {
        Context context;
        ClientProcessService clientProcessService;
        WorkAreaPartitionManagerImpl workAreaPartitionManagerImpl;
        boolean bl;
        block43: {
            block42: {
                block41: {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "start");
                    }
                    if (_initialized) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Already initialized; returning");
                        }
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "start");
                        }
                        return;
                    }
                    _initialized = true;
                    bl = true;
                    workAreaPartitionManagerImpl = WorkAreaPartitionManagerImpl.getInstance();
                    if (this._enabled) {
                        block40: {
                            try {
                                this.userWorkAreaConfigurationProps.setProperty("maxSendSize", new Integer(this._maxSendSize).toString());
                                this.userWorkAreaConfigurationProps.setProperty("maxReceiveSize", new Integer(this._maxReceiveSize).toString());
                                _currentWorkArea = workAreaPartitionManagerImpl.createWorkAreaPartition(WorkAreaService.getServiceName(), this.userWorkAreaConfigurationProps);
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "start", "Created partition " + WorkAreaService.getServiceName());
                                }
                            }
                            catch (PartitionAlreadyExistsException partitionAlreadyExistsException) {
                                FFDCFilter.processException((Throwable)partitionAlreadyExistsException, "com.ibm.ws.workarea.WorkAreaServiceClient.start", "129", this);
                                bl = false;
                                if (_tc.isEventEnabled()) {
                                    Tr.event(_tc, "start", partitionAlreadyExistsException);
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "start", "The partition \"" + WorkAreaService.getServiceName() + "\" already has been defined.");
                                }
                                Tr.error(_tc, "ERR_PARTITION_ALREADY_EXISTS", WorkAreaService.getServiceName());
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.workarea.WorkAreaServiceClient.start", "135", this);
                                bl = false;
                                if (_tc.isEventEnabled()) {
                                    Tr.event(_tc, "start", illegalAccessException);
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "start", "Initialization complete, can't create a new partition.");
                                }
                                Tr.error(_tc, WorkAreaMessages.getMsg("INF_INITIALIZATION_COMPLETE", new Object[]{WorkAreaService.getServerName(), WorkAreaService.getServiceName()}));
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.workarea.WorkAreaServiceClient.start", "200", this);
                                bl = false;
                                if (_tc.isEventEnabled()) {
                                    Tr.event(_tc, "start", illegalArgumentException);
                                }
                                if (!_tc.isDebugEnabled()) break block40;
                                Tr.debug(_tc, "start", illegalArgumentException);
                            }
                        }
                        if (_currentWorkArea == null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "start", "The WorkArea returned by the PartitionManager is null!");
                            }
                            bl = false;
                        } else {
                            WorkAreaService.setUserWorkArea(_currentWorkArea);
                        }
                    }
                    if (!this.userPartitionProps.isEmpty()) {
                        this.createUserSpecifiedPartitions();
                    }
                    clientProcessService = (ClientProcessService)this.getService(ClientProcessService.class);
                    context = clientProcessService.getServicesColonCtx();
                    try {
                        JndiHelper.recursiveRebind(context, "services:websphere/WorkAreaPartitionManager", (Object)workAreaPartitionManagerImpl);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "start", "Bound the WorkAreaPartitionManger into services:");
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.workarea.WorkAreaServiceClient.start", "248", this);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Could not bind the WorkAreaPartitionManager into services: on the client");
                        }
                        if (!_tc.isDebugEnabled()) break block41;
                        Tr.debug(_tc, "start", exception);
                    }
                }
                try {
                    context = clientProcessService.getJavaColonCtx();
                    JndiHelper.recursiveRebind(context, "comp/websphere/WorkAreaPartitionManager", (Object)workAreaPartitionManagerImpl);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "start", "Bound the WorkAreaPartitionManger into java:comp");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.workarea.WorkAreaServiceClient.start", "259", this);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Could not bind the WorkAreaPartitionManager into java:comp on the client");
                    }
                    if (!_tc.isDebugEnabled()) break block42;
                    Tr.debug(_tc, "start", exception);
                }
            }
            if (this._enabled) {
                context = clientProcessService.getJavaColonCtx();
                try {
                    JndiHelper.recursiveRebind(context, "comp/websphere/UserWorkArea", (Object)_currentWorkArea);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "start", "Bound partition " + WorkAreaService.getServiceName());
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.workarea.WorkAreaServiceClient.start", "171", this);
                    bl = false;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "start", exception);
                    }
                    if (!_tc.isDebugEnabled()) break block43;
                    Tr.debug(_tc, "Couldn't bind the UserWorkArea", exception);
                }
            }
        }
        if (this.names != null) {
            context = clientProcessService.getJavaColonCtx();
            String string = null;
            Enumeration enumeration = this.names.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    string = (String)enumeration.nextElement();
                    JndiHelper.recursiveRebind(context, "comp/websphere/workarea/" + string, (Object)workAreaPartitionManagerImpl.getWorkAreaPartition(string));
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "start", "Bound partition " + string);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.workarea.WorkAreaServiceClient.start", "171", this);
                    bl = false;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "start", exception);
                    }
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Couldn't bind the partition " + string);
                }
            }
        }
        this.releaseService(clientProcessService);
        if (bl && this._enabled) {
            Tr.audit(_tc, "INF_WA_READY", WorkAreaService.getServerName());
        }
        if (!bl && this._enabled) {
            Tr.audit(_tc, "INF_WA_DISABLED", WorkAreaService.getServerName());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "start");
        }
    }

    private void createUserSpecifiedPartitions() {
        Enumeration enumeration;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createUserSpecifiedPartitions");
        }
        if ((enumeration = this.userPartitionProps.keys()).hasMoreElements()) {
            this.names = new Vector();
            WorkAreaPartitionManagerImpl workAreaPartitionManagerImpl = WorkAreaPartitionManagerImpl.getInstance();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Properties properties = (Properties)this.userPartitionProps.get(string);
                if ((string = (String)properties.get("name")) == null) continue;
                try {
                    UserWorkArea userWorkArea = workAreaPartitionManagerImpl.createWorkAreaPartition(string, properties);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "createUserSpecifiedPartitions", "Created partition " + string);
                    }
                    this.names.add(string);
                }
                catch (PartitionAlreadyExistsException partitionAlreadyExistsException) {
                    FFDCFilter.processException((Throwable)partitionAlreadyExistsException, "com.ibm.ws.workarea.WorkAreaServiceServer.createUserSpecifiedPartitions", "413", this);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "createUserSpecifiedPartitions", partitionAlreadyExistsException);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "createUserSpecifiedPartitions", "The partition \"" + string + "\" already has been defined.");
                    }
                    Tr.error(_tc, "ERR_PARTITION_ALREADY_EXISTS", string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.workarea.WorkAreaServiceServer.createUserSpecifiedPartitions", "418", this);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "createUserSpecifiedPartitions", illegalAccessException);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "createUserSpecifiedPartitions", "Initialization complete, can't create a new partition.");
                    }
                    Tr.error(_tc, WorkAreaMessages.getMsg("INF_INITIALIZATION_COMPLETE", new Object[]{WorkAreaService.getServerName(), string}));
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.workarea.WorkAreaServiceServer.createUserSpecifiedPartitions", "443", this);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "createUserSpecifiedPartitions", exception);
                    }
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "createUserSpecifiedPartitions", exception);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createUserSpecifiedPartitions");
        }
    }

    private void processCommandLineProperties(Properties properties) {
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "-", false);
            string3 = stringTokenizer.nextToken();
            if (!string3.equals("partition") || stringTokenizer.countTokens() != 1) continue;
            string = stringTokenizer.nextToken();
            string3 = properties.getProperty(string2);
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ";", false);
            while (stringTokenizer2.hasMoreTokens()) {
                string2 = stringTokenizer2.nextToken();
                StringTokenizer stringTokenizer3 = new StringTokenizer(string2, "=", false);
                while (stringTokenizer3.hasMoreTokens()) {
                    if (stringTokenizer3.countTokens() != 2) continue;
                    Properties properties2 = (Properties)this.userPartitionProps.get(string);
                    if (properties2 == null) {
                        properties2 = new Properties();
                        properties2.put(stringTokenizer3.nextToken().trim(), stringTokenizer3.nextToken().trim());
                        this.userPartitionProps.put(string, properties2);
                        continue;
                    }
                    properties2.put(stringTokenizer3.nextToken().trim(), stringTokenizer3.nextToken().trim());
                    this.userPartitionProps.put(string, properties2);
                }
            }
        }
    }
}

