/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.workarea;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.websphere.workarea.PartitionAlreadyExistsException;
import com.ibm.websphere.workarea.UserWorkArea;
import com.ibm.ws.asynchbeans.AsynchBeansService;
import com.ibm.ws.asynchbeans.AsynchBeansServiceCollaborator;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.util.AsynchBeansInvocationService;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.webcontainer.WebContainerService;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppCollaborator;
import com.ibm.ws.workarea.ServiceWithContextImpl;
import com.ibm.ws.workarea.WorkAreaEJBCollaborator;
import com.ibm.ws.workarea.WorkAreaMessages;
import com.ibm.ws.workarea.WorkAreaPartitionManagerImpl;
import com.ibm.ws.workarea.WorkAreaService;
import com.ibm.ws.workarea.WorkAreaWebCollaborator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.eclipse.emf.common.util.EList;

public class WorkAreaServiceServer
extends ComponentImpl
implements PropertyChangeListener {
    private static final TraceComponent _tc = Tr.register(WorkAreaServiceServer.class, null, "com.ibm.ws.workarea.resources.acwa");
    private UserWorkArea _currentWorkArea = null;
    private int _maxSendSize = WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE;
    private int _maxReceiveSize = WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE;
    private boolean _enabled = true;
    private static Hashtable userPartitionProps;
    private static Vector names;
    private boolean _initialized = false;
    Properties userWorkAreaConfigurationProps = new Properties();

    public WorkAreaServiceServer() {
        this.userWorkAreaConfigurationProps.setProperty("cacheable", "false");
        this.userWorkAreaConfigurationProps.setProperty("maxSendSize", WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING);
        this.userWorkAreaConfigurationProps.setProperty("maxReceiveSize", WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING);
        this.userWorkAreaConfigurationProps.setProperty("Bidirectional", "false");
        this.userWorkAreaConfigurationProps.setProperty("isContextCORBAInteroperable", "true");
        this.userWorkAreaConfigurationProps.setProperty("DeferredAttributeSerialization", "false");
        this.userWorkAreaConfigurationProps.setProperty("EnableWebServicePropagation", "false");
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        block13: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "initialize", object);
            }
            WorkAreaService.setIsClientProcess(false);
            if (PlatformHelperFactory.getPlatformHelper().isCRAJvm()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "WorkAreaServiceServer disabled in z/OS CRA.");
                }
                throw new ComponentDisabledException();
            }
            try {
                if (object instanceof com.ibm.websphere.models.config.workareaservice.WorkAreaService) {
                    com.ibm.websphere.models.config.workareaservice.WorkAreaService workAreaService = (com.ibm.websphere.models.config.workareaservice.WorkAreaService)object;
                    this._maxReceiveSize = workAreaService.getMaxReceiveSize();
                    this._maxSendSize = workAreaService.getMaxSendSize();
                    this._enabled = workAreaService.isEnable();
                    this.userWorkAreaConfigurationProps.setProperty("maxSendSize", new Integer(this._maxSendSize).toString());
                    this.userWorkAreaConfigurationProps.setProperty("maxReceiveSize", new Integer(this._maxReceiveSize).toString());
                    WorkAreaService.setEnabled(this._enabled);
                    this.userWorkAreaConfigurationProps.setProperty("EnableWebServicePropagation", Boolean.valueOf(workAreaService.isEnableWebServicePropagation()).toString());
                    EList eList = workAreaService.getProperties();
                    if (eList != null) {
                        this.processAdminConsoleProperties((List)eList);
                    }
                    break block13;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "parm is wrong type!  Going to use defaults!");
                }
                WorkAreaService.setEnabled(this._enabled);
                ConfigurationWarning configurationWarning = new ConfigurationWarning("");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "initialize", "Throwing: " + configurationWarning);
                }
                throw configurationWarning;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.workarea.WorkAreaServiceServer.initialize", "98", this);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "initialize", exception);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "initialize", exception);
                }
                ConfigurationWarning configurationWarning = new ConfigurationWarning("");
                configurationWarning.initCause(exception);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "initialize", "Throwing: " + configurationWarning);
                }
                throw configurationWarning;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initialize");
        }
    }

    public void start() {
        Object object;
        Server server2;
        boolean bl;
        block39: {
            block37: {
                EJBContainer eJBContainer;
                block36: {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "start");
                    }
                    if (this._initialized) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Already initialized; returning");
                        }
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "start");
                        }
                        return;
                    }
                    this._initialized = true;
                    bl = true;
                    WorkAreaPartitionManagerImpl workAreaPartitionManagerImpl = WorkAreaPartitionManagerImpl.getInstance();
                    workAreaPartitionManagerImpl.setServiceImlpRef(this);
                    server2 = (Server)this.getService(Server.class);
                    if (server2 != null) {
                        WorkAreaService.setServerName(server2.getName());
                    }
                    eJBContainer = (EJBContainer)this.getService(EJBContainer.class);
                    if (this._enabled) {
                        try {
                            this._currentWorkArea = workAreaPartitionManagerImpl.createWorkAreaPartition(WorkAreaService.getServiceName(), this.userWorkAreaConfigurationProps);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "start", "Created partition " + WorkAreaService.getServiceName());
                            }
                        }
                        catch (PartitionAlreadyExistsException partitionAlreadyExistsException) {
                            FFDCFilter.processException((Throwable)partitionAlreadyExistsException, "com.ibm.ws.workarea.WorkAreaServiceServer.start", "143", this);
                            bl = false;
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, "start", partitionAlreadyExistsException);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "start", "The partition \"" + WorkAreaService.getServiceName() + "\" already has been defined.");
                            }
                            Tr.error(_tc, "ERR_PARTITION_ALREADY_EXISTS", WorkAreaService.getServiceName());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.workarea.WorkAreaServiceServer.start", "149", this);
                            bl = false;
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, "start", illegalAccessException);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "start", "Initialization complete, can't create a new partition.");
                            }
                            Tr.error(_tc, WorkAreaMessages.getMsg("INF_INITIALIZATION_COMPLETE", new Object[]{WorkAreaService.getServerName(), WorkAreaService.getServiceName()}));
                        }
                        if (this._currentWorkArea == null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "start", "The WorkArea returned by the PartitionManager is null!");
                            }
                            bl = false;
                        } else {
                            WorkAreaService.setUserWorkArea(this._currentWorkArea);
                        }
                    } else {
                        Tr.audit(_tc, "INF_WA_NOT_ENABLED", WorkAreaService.getServerName());
                    }
                    try {
                        object = new InitialContext();
                        JndiHelper.recursiveRebind((Context)object, "services:websphere/WorkAreaPartitionManager", (Object)workAreaPartitionManagerImpl);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "start", "Bound the WorkAreaPartitionManager");
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.workarea.WorkAreaServiceServer.start", "177", this);
                        bl = false;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Could not bind the WorkAreaPartitionManager on the server");
                        }
                        if (!_tc.isDebugEnabled()) break block36;
                        Tr.debug(_tc, "start", exception);
                    }
                }
                try {
                    eJBContainer.addCollaborator(WorkAreaEJBCollaborator.getInstance());
                    this.releaseService(eJBContainer);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "start", "BeforeActivationCollaborator added to ejb container");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.workarea.WorkAreaServiceServer.start", "194", this);
                    bl = false;
                    exception.printStackTrace();
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "start", exception);
                    }
                    if (!_tc.isDebugEnabled()) break block37;
                    Tr.debug(_tc, "start", exception);
                }
            }
            try {
                block38: {
                    object = (WebContainerService)this.getService(WebContainerService.class);
                    try {
                        object.addWebAppCollaborator((WebAppCollaborator)WorkAreaWebCollaborator.getInstance());
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "start", "WebAppInitializationCollaborator added to web container");
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.workarea.WorkAreaServiceServer.start", "215", this);
                        bl = false;
                        exception.printStackTrace();
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "start", exception);
                        }
                        if (!_tc.isDebugEnabled()) break block38;
                        Tr.debug(_tc, "start", exception);
                    }
                }
                this.releaseService(object);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.workarea.WorkAreaServiceServer.start", "238", this);
                bl = false;
                exception.printStackTrace();
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "start", exception);
                }
                if (!_tc.isDebugEnabled()) break block39;
                Tr.debug(_tc, "start", exception);
            }
        }
        object = (ApplicationMgr)this.getService(ApplicationMgr.class);
        object.addPropertyChangeListener("state", this);
        this.releaseService(object);
        this.releaseService(server2);
        this.createUserSpecifiedPartitions();
        if (bl && this._enabled) {
            Tr.audit(_tc, "INF_WA_READY", WorkAreaService.getServerName());
        }
        if (!bl && this._enabled) {
            Tr.audit(_tc, "INF_WA_DISABLED", WorkAreaService.getServerName());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "start");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "propertyChange: " + propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getNewValue().equals("STARTING")) {
            WorkAreaPartitionManagerImpl workAreaPartitionManagerImpl = WorkAreaPartitionManagerImpl.getInstance();
            workAreaPartitionManagerImpl.initializationComplete();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "propertyChange");
        }
    }

    public void doAsynchBeansRegistration() {
        AsynchBeansServiceCollaborator asynchBeansServiceCollaborator;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doAsynchBeansRegistration");
        }
        if ((asynchBeansServiceCollaborator = (AsynchBeansServiceCollaborator)this.getService(AsynchBeansService.class)) != null) {
            asynchBeansServiceCollaborator.register(ServiceWithContextImpl.getInstance());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Registered " + ServiceWithContextImpl.getInstance().getServiceName() + " with Asynch Beans");
            }
            AsynchBeansInvocationService.getInstance().registerWithAsynchBeans(asynchBeansServiceCollaborator);
            this.releaseService(asynchBeansServiceCollaborator);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "doAsynchBeansRegistration", "AsynchBeansService.getService returned null");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doAsynchBeansRegistration");
        }
    }

    private void processAdminConsoleProperties(List list) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processAdminConsoleProperties", list);
        }
        Properties properties = new Properties();
        String string = new String();
        userPartitionProps = new Hashtable();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                Property property = (Property)iterator.next();
                String string2 = property.getName();
                String string3 = property.getValue();
                if (string2 == null || string3 == null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "-", false);
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "=", false);
                if (stringTokenizer.countTokens() == 2 && stringTokenizer2.countTokens() == 2) {
                    string = stringTokenizer.nextToken().trim();
                    if (!string.equals("partition")) continue;
                    string = stringTokenizer.nextToken().trim();
                    properties = (Properties)userPartitionProps.get(string);
                    if (properties == null) {
                        properties = new Properties();
                        properties.put(stringTokenizer2.nextToken().trim(), stringTokenizer2.nextToken().trim());
                        userPartitionProps.put(string, properties);
                        continue;
                    }
                    properties.put(stringTokenizer2.nextToken().trim(), stringTokenizer2.nextToken().trim());
                    userPartitionProps.put(string, properties);
                    continue;
                }
                if (string2.equals("isContextBidirectional")) {
                    this.userWorkAreaConfigurationProps.setProperty("Bidirectional", string3);
                } else if (string2.equals("lazySerialization")) {
                    this.userWorkAreaConfigurationProps.setProperty("DeferredAttributeSerialization", string3);
                }
                if (string2.equals("Bidirectional")) {
                    this.userWorkAreaConfigurationProps.setProperty("Bidirectional", string3);
                    continue;
                }
                if (string2.equals("DeferredAttributeSerialization")) {
                    this.userWorkAreaConfigurationProps.setProperty("DeferredAttributeSerialization", string3);
                    continue;
                }
                if (!string2.equals("isContextCORBAInteroperable")) continue;
                this.userWorkAreaConfigurationProps.setProperty(string2, string3);
            }
            catch (Exception exception) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "processAdminConsoleProperties", "Invalid property entered, check the format of the property");
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "processAdminConsoleProperties", exception);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processAdminConsoleProperties");
        }
    }

    private void createUserSpecifiedPartitions() {
        Enumeration enumeration;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createUserSpecifiedPartitions");
        }
        if ((enumeration = userPartitionProps.keys()).hasMoreElements()) {
            names = new Vector();
            WorkAreaPartitionManagerImpl workAreaPartitionManagerImpl = WorkAreaPartitionManagerImpl.getInstance();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Properties properties = (Properties)userPartitionProps.get(string);
                if ((string = (String)properties.get("name")) == null) continue;
                try {
                    UserWorkArea userWorkArea = workAreaPartitionManagerImpl.createWorkAreaPartition(string, properties);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "createUserSpecifiedPartitions", "Created partition " + string);
                    }
                    names.add(string);
                }
                catch (PartitionAlreadyExistsException partitionAlreadyExistsException) {
                    FFDCFilter.processException((Throwable)partitionAlreadyExistsException, "com.ibm.ws.workarea.WorkAreaServiceServer.createUserSpecifiedPartitions", "413", this);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "createUserSpecifiedPartitions", partitionAlreadyExistsException);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "createUserSpecifiedPartitions", "The partition \"" + string + "\" already has been defined.");
                    }
                    Tr.error(_tc, "ERR_PARTITION_ALREADY_EXISTS", string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.workarea.WorkAreaServiceServer.createUserSpecifiedPartitions", "418", this);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "createUserSpecifiedPartitions", illegalAccessException);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "createUserSpecifiedPartitions", "Initialization complete, can't create a new partition.");
                    }
                    Tr.error(_tc, "INF_INITIALIZATION_COMPLETE", new Object[]{WorkAreaService.getServerName(), string});
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.workarea.WorkAreaServiceServer.createUserSpecifiedPartitions", "443", this);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "createUserSpecifiedPartitions", exception);
                    }
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "createUserSpecifiedPartitions", exception);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createUserSpecifiedPartitions");
        }
    }

    public static Vector getUserSpecifiedPartitionNames() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getUserSpecifiedPartitions");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getUserSpecifiedPartitions", names);
        }
        return names;
    }

    static {
        names = null;
    }
}

