/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.workspace.query.impl;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.j2c.J2CActivationSpec;
import com.ibm.ejs.models.base.resources.j2c.J2CAdminObject;
import com.ibm.ejs.models.base.resources.j2c.J2CConnectionFactory;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.models.base.resources.jdbc.CMPConnectorFactory;
import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jdbc.WAS40DataSource;
import com.ibm.ejs.models.base.resources.jms.JMSConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASQueue;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASQueueConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASTopic;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASTopicConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQQueue;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQQueueConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQTopic;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQTopicConnectionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.websphere.models.config.jaaslogin.JAASConfigurationEntry;
import com.ibm.websphere.models.config.libraries.Library;
import com.ibm.websphere.models.config.multibroker.DataReplicationDomain;
import com.ibm.websphere.models.config.multibroker.MultibrokerDomain;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.RefObjectHelper;
import com.ibm.ws.sm.workspace.template.RefObjectHelperFactory;
import com.ibm.ws.workspace.query.WorkSpaceQueryUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.XAQueueConnectionFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class WorkSpaceQueryUtilImpl
implements WorkSpaceQueryUtil {
    private static TraceComponent tc = Tr.register(WorkSpaceQueryUtilImpl.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");

    public boolean isStandAloneCell(RepositoryContext repositoryContext) throws WorkSpaceException {
        Cell cell = (Cell)this.getRefObjects(repositoryContext, "cell.xml", "Cell", false).iterator().next();
        return cell.getCellType().getValue() == 0;
    }

    public Collection getClusterNames(RepositoryContext repositoryContext) throws WorkSpaceException {
        RepositoryContextType repositoryContextType = this.getClusterContextType();
        return this.getNames(repositoryContext, repositoryContextType);
    }

    public Collection getCoreGroupNames(RepositoryContext repositoryContext) throws WorkSpaceException {
        RepositoryContextType repositoryContextType = this.getCoreGroupContextType();
        return this.getNames(repositoryContext, repositoryContextType);
    }

    private RepositoryContextType getCoreGroupContextType() {
        return RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("coregroups");
    }

    public Collection getNodeNames(RepositoryContext repositoryContext) throws WorkSpaceException {
        RepositoryContextType repositoryContextType = this.getNodeContextType();
        return this.getNames(repositoryContext, repositoryContextType);
    }

    public Collection getApplicationNames(RepositoryContext repositoryContext) throws WorkSpaceException {
        RepositoryContextType repositoryContextType = this.getApplicationContextType();
        return this.getNames(repositoryContext, repositoryContextType);
    }

    public Collection getServerTypes(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getServerEntries(repositoryContext).iterator();
        while (iterator.hasNext()) {
            String string = ((ServerEntry)iterator.next()).getServerType();
            if (string == null || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private Collection getServerEntries(RepositoryContext repositoryContext) throws WorkSpaceException {
        RepositoryContextType repositoryContextType = this.getNodeContextType();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = repositoryContext.findContext(repositoryContextType).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(this.getServerEntriesFromNode((RepositoryContext)iterator.next()));
        }
        return arrayList;
    }

    public Collection getServerEntriesFromNode(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getRefObjects(repositoryContext, "serverindex.xml", "ServerIndex", false).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((ServerIndex)iterator.next()).getServerEntries());
        }
        return arrayList;
    }

    private Resource load(RepositoryContext repositoryContext, String string) {
        return repositoryContext.getResourceSet().getResource(URI.createURI((String)string), true);
    }

    private Collection getServerNames(Collection collection, String string) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2;
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            if (string.equals("SERVER_TYPE_ALL") && !arrayList.contains(serverEntry.getServerName())) {
                arrayList.add(serverEntry.getServerName());
            }
            if ((string2 = serverEntry.getServerType()) == null || !string2.equals(string) || arrayList.contains(serverEntry.getServerName())) continue;
            arrayList.add(serverEntry.getServerName());
        }
        return arrayList;
    }

    public Collection getServerContexts(RepositoryContext repositoryContext, String string) throws WorkSpaceException {
        if (repositoryContext.getType().getName().equals("nodes")) {
            return this.getServerContextsFromNode(repositoryContext, string);
        }
        RepositoryContextType repositoryContextType = this.getNodeContextType();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = repositoryContext.findContext(repositoryContextType).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(this.getServerContextsFromNode((RepositoryContext)iterator.next(), string));
        }
        return arrayList;
    }

    private Collection getServerContextsFromNode(RepositoryContext repositoryContext, String string) throws WorkSpaceException {
        ArrayList<RepositoryContext> arrayList = new ArrayList<RepositoryContext>();
        Iterator iterator = this.getServerNames(this.getServerEntriesFromNode(repositoryContext), string).iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext2 = repositoryContext.findContext("servers/" + (String)iterator.next());
            if (repositoryContext2 == null) continue;
            arrayList.add(repositoryContext2);
        }
        return arrayList;
    }

    private RepositoryContextType getClusterContextType() {
        return RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("clusters");
    }

    private RepositoryContextType getServerContextType() {
        return RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("servers");
    }

    private RepositoryContextType getNodeContextType() {
        return RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("nodes");
    }

    private RepositoryContextType getApplicationContextType() {
        return RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("applications");
    }

    private Collection getNames(RepositoryContext repositoryContext, RepositoryContextType repositoryContextType) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = repositoryContext.findContext(repositoryContextType).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((RepositoryContext)iterator.next()).getName());
        }
        return arrayList;
    }

    public Collection getApplServerContexts(RepositoryContext repositoryContext, String string) throws WorkSpaceException {
        RepositoryContextType repositoryContextType = this.getClusterContextType();
        ArrayList<RepositoryContext> arrayList = new ArrayList<RepositoryContext>();
        RepositoryContext repositoryContext2 = null;
        RepositoryContext repositoryContext3 = null;
        ClusterMember clusterMember = null;
        Iterator iterator = repositoryContext.findContext(repositoryContextType).iterator();
        while (iterator.hasNext()) {
            repositoryContext2 = (RepositoryContext)iterator.next();
            if (!repositoryContext2.getName().equals(string)) continue;
            Iterator iterator2 = this.getRefObjects(repositoryContext2, "cluster.xml", "ServerCluster", false).iterator();
            while (iterator2.hasNext()) {
                Iterator iterator3 = ((ServerCluster)iterator2.next()).getMembers().iterator();
                while (iterator3.hasNext()) {
                    clusterMember = (ClusterMember)iterator3.next();
                    repositoryContext3 = this.getServerContext(repositoryContext, clusterMember.getNodeName(), clusterMember.getMemberName());
                    if (repositoryContext3 == null) continue;
                    arrayList.add(repositoryContext3);
                }
            }
            break block0;
        }
        return arrayList;
    }

    private RepositoryContext getServerContext(RepositoryContext repositoryContext, String string, String string2) throws WorkSpaceException {
        StringBuffer stringBuffer = new StringBuffer(this.getNodeContextType().getName());
        stringBuffer.append('/');
        stringBuffer.append(string);
        stringBuffer.append('/');
        stringBuffer.append(this.getServerContextType().getName());
        stringBuffer.append('/');
        stringBuffer.append(string2);
        return repositoryContext.findContext(stringBuffer.toString());
    }

    public Collection getNoneClusteredApplServerContexts(RepositoryContext repositoryContext) throws WorkSpaceException {
        Collection collection = this.getServerContexts(repositoryContext, "APPLICATION_SERVER");
        Iterator iterator = this.getClusterNames(repositoryContext).iterator();
        while (iterator.hasNext()) {
            collection.removeAll(this.getApplServerContexts(repositoryContext, (String)iterator.next()));
        }
        return collection;
    }

    public Collection getNonClusteredServerContexts(RepositoryContext repositoryContext) throws WorkSpaceException {
        Collection collection = this.getServerContexts(repositoryContext, "SERVER_TYPE_ALL");
        Iterator iterator = this.getClusterNames(repositoryContext).iterator();
        while (iterator.hasNext()) {
            collection.removeAll(this.getApplServerContexts(repositoryContext, (String)iterator.next()));
        }
        collection.removeAll(this.getServerContexts(repositoryContext, "DEPLOYMENT_MANAGER"));
        collection.removeAll(this.getServerContexts(repositoryContext, "NODE_AGENT"));
        return collection;
    }

    public Collection getJ2CAdminObjectsJNDINames(RepositoryContext repositoryContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJ2CAdminObjectsJNDINames");
        }
        String string = "J2CResourceAdapter";
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Iterator iterator = this.getRefObjects(repositoryContext, "resources.xml", string, true).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((J2CResourceAdapter)iterator.next()).getJ2cAdminObjects());
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            arrayList2.add(((J2CAdminObject)iterator.next()).getJndiName());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getJ2CAdminObjectsJNDINames ", new Object[]{arrayList2});
        }
        return arrayList2;
    }

    public Collection getJ2CActivationSpecJNDINames(RepositoryContext repositoryContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJ2CActivationSpecJNDINames");
        }
        String string = "J2CResourceAdapter";
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Iterator iterator = this.getRefObjects(repositoryContext, "resources.xml", string, true).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((J2CResourceAdapter)iterator.next()).getJ2cActivationSpec());
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            arrayList2.add(((J2CActivationSpec)iterator.next()).getJndiName());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getJ2CActivationSpecJNDINames ", new Object[]{arrayList2});
        }
        return arrayList2;
    }

    public Collection getJ2CConnectionFactoryJNDINames(RepositoryContext repositoryContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJ2CConnectionFactoryJNDINames");
        }
        String string = "J2CResourceAdapter";
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Iterator iterator = this.getRefObjects(repositoryContext, "resources.xml", string, true).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((J2EEResourceProvider)iterator.next()).getFactories());
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            J2EEResourceFactory j2EEResourceFactory = (J2EEResourceFactory)iterator.next();
            if (!(j2EEResourceFactory instanceof J2CConnectionFactory) || j2EEResourceFactory instanceof CMPConnectorFactory) continue;
            arrayList2.add(j2EEResourceFactory.getJndiName());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getJ2CConnectionFactoryJNDINames ", new Object[]{arrayList2});
        }
        return arrayList2;
    }

    public String getResourceNameFromJNDI(RepositoryContext repositoryContext, String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getResourceNameFromJNDI");
        }
        String string3 = "";
        if (string.equals("J2CAdminObject")) {
            string = "J2CResourceAdapter";
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.getRefObjects(repositoryContext, "resources.xml", string, true).iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(((J2CResourceAdapter)iterator.next()).getJ2cAdminObjects());
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                J2CAdminObject j2CAdminObject = (J2CAdminObject)iterator.next();
                String string4 = j2CAdminObject.getJndiName();
                if (string4 == null || !string4.equals(string2)) continue;
                string3 = j2CAdminObject.getName();
            }
        } else if (string.equals("J2CConnectionFactory")) {
            string = "J2CResourceAdapter";
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.getRefObjects(repositoryContext, "resources.xml", string, true).iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(((J2EEResourceProvider)iterator.next()).getFactories());
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string5;
                J2EEResourceFactory j2EEResourceFactory = (J2EEResourceFactory)iterator.next();
                if (!(j2EEResourceFactory instanceof J2CConnectionFactory) || (string5 = j2EEResourceFactory.getJndiName()) == null || !string5.equals(string2)) continue;
                string3 = j2EEResourceFactory.getName();
            }
        } else if (string.equals("J2CActivationSpec")) {
            string = "J2CResourceAdapter";
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.getRefObjects(repositoryContext, "resources.xml", string, true).iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(((J2CResourceAdapter)iterator.next()).getJ2cActivationSpec());
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                J2CActivationSpec j2CActivationSpec = (J2CActivationSpec)iterator.next();
                String string6 = j2CActivationSpec.getJndiName();
                if (string6 == null || !string6.equals(string2)) continue;
                string3 = j2CActivationSpec.getName();
            }
        } else {
            Collection collection = this.getResourceFactory(repositoryContext, string);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                J2EEResourceFactory j2EEResourceFactory = (J2EEResourceFactory)iterator.next();
                String string7 = j2EEResourceFactory.getJndiName();
                if (string7 == null || !string2.equals(string7)) continue;
                string3 = j2EEResourceFactory.getName();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getResourceNameFromJNDI ", new Object[]{string3});
        }
        return string3;
    }

    public String getResourceTypeFromJNDI(RepositoryContext repositoryContext, String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getResourceTypeFromJNDI");
        }
        String string3 = "";
        if (string.equals("J2CAdminObject")) {
            string = "J2CResourceAdapter";
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.getRefObjects(repositoryContext, "resources.xml", string, true).iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(((J2CResourceAdapter)iterator.next()).getJ2cAdminObjects());
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                J2CAdminObject j2CAdminObject = (J2CAdminObject)iterator.next();
                String string4 = j2CAdminObject.getJndiName();
                if (string4 == null || !string4.equals(string2) || j2CAdminObject.getAdminObject() == null) continue;
                String string5 = j2CAdminObject.getAdminObject().getAdminObjectInterface();
                if (string5.equals("javax.jms.Queue")) {
                    string3 = "Queue";
                    continue;
                }
                if (!string5.equals("javax.jms.Topic")) continue;
                string3 = "Topic";
            }
        } else if (string.equals("J2CConnectionFactory")) {
            string = "J2CResourceAdapter";
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.getRefObjects(repositoryContext, "resources.xml", string, true).iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(((J2EEResourceProvider)iterator.next()).getFactories());
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                J2EEResourceFactory j2EEResourceFactory = (J2EEResourceFactory)iterator.next();
                if (!(j2EEResourceFactory instanceof J2CConnectionFactory)) continue;
                J2CConnectionFactory j2CConnectionFactory = (J2CConnectionFactory)j2EEResourceFactory;
                String string6 = j2EEResourceFactory.getJndiName();
                if (string6 == null || !string6.equals(string2) || j2CConnectionFactory.getConnectionDefinition() == null) continue;
                String string7 = j2CConnectionFactory.getConnectionDefinition().getConnectionFactoryInterface();
                if (string7.equals("javax.jms.QueueConnectionFactory")) {
                    string3 = "QueueConnectionFactory";
                    continue;
                }
                if (string7.equals("javax.jms.TopicConnectionFactory")) {
                    string3 = "TopicConnectionFactory";
                    continue;
                }
                if (!string7.equals("javax.jms.ConnectionFactory")) continue;
                string3 = "ConnectionFactory";
            }
        } else {
            Collection collection = this.getResourceFactory(repositoryContext, string);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                J2EEResourceFactory j2EEResourceFactory = (J2EEResourceFactory)iterator.next();
                String string8 = j2EEResourceFactory.getJndiName();
                if (string8 == null || !string8.equals(string2)) continue;
                if (j2EEResourceFactory instanceof WASQueue || j2EEResourceFactory instanceof MQQueue) {
                    string3 = "Queue";
                    continue;
                }
                if (j2EEResourceFactory instanceof WASQueueConnectionFactory || j2EEResourceFactory instanceof MQQueueConnectionFactory) {
                    string3 = "QueueConnectionFactory";
                    continue;
                }
                if (j2EEResourceFactory instanceof WASTopic || j2EEResourceFactory instanceof MQTopic) {
                    string3 = "Topic";
                    continue;
                }
                if (j2EEResourceFactory instanceof WASTopicConnectionFactory || j2EEResourceFactory instanceof MQTopicConnectionFactory) {
                    string3 = "TopicConnectionFactory";
                    continue;
                }
                if (j2EEResourceFactory instanceof XAQueueConnectionFactory) {
                    string3 = "XAQueueConnectionFactory";
                    continue;
                }
                if (!(j2EEResourceFactory instanceof JMSConnectionFactory) && !(j2EEResourceFactory instanceof MQConnectionFactory)) continue;
                string3 = "ConnectionFactory";
            }
        }
        Tr.debug(tc, "resource subtype " + string3);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getResourceTypeFromJNDI ", new Object[]{string3});
        }
        return string3;
    }

    public Collection getResourceJNDINames(RepositoryContext repositoryContext, String string) {
        return this.getResourceJNDINames(this.getResourceFactory(repositoryContext, string));
    }

    private Collection getResourceFactory(RepositoryContext repositoryContext, String string) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getRefObjects(repositoryContext, "resources.xml", string, true).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((J2EEResourceProvider)iterator.next()).getFactories());
        }
        return arrayList;
    }

    private Collection getResourceJNDINames(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = ((J2EEResourceFactory)iterator.next()).getJndiName();
            Tr.debug(tc, "jndi name " + string);
            if (string == null || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private Collection get40ResourceJNDINames(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string;
            J2EEResourceFactory j2EEResourceFactory = (J2EEResourceFactory)iterator.next();
            if (!(j2EEResourceFactory instanceof WAS40DataSource) || arrayList.contains(string = j2EEResourceFactory.getJndiName())) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private Collection get50ResourceJNDINames(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string;
            J2EEResourceFactory j2EEResourceFactory = (J2EEResourceFactory)iterator.next();
            if (!(j2EEResourceFactory instanceof DataSource) || arrayList.contains(string = j2EEResourceFactory.getJndiName())) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Collection getResourceMofTypes(RepositoryContext repositoryContext) {
        return this.getRefObjectMofTypes(repositoryContext, "resources.xml", true);
    }

    public Collection getCMPResourceJNDINames(RepositoryContext repositoryContext) throws WorkSpaceException {
        return this.getResourceJNDINames(this.getCMPConnectorFactories(repositoryContext));
    }

    public Collection get40CMPResourceJNDINames(RepositoryContext repositoryContext) throws WorkSpaceException {
        return this.get40ResourceJNDINames(this.getResourceFactory(repositoryContext, "JDBCProvider"));
    }

    public Collection get50CMPResourceJNDINames(RepositoryContext repositoryContext) throws WorkSpaceException {
        return this.getResourceJNDINames(this.getCMPConnectorFactories(repositoryContext));
    }

    public Collection get50DataSourceResourceJNDINames(RepositoryContext repositoryContext) throws WorkSpaceException {
        return this.get50ResourceJNDINames(this.getResourceFactory(repositoryContext, "JDBCProvider"));
    }

    public Collection getCMPConnectorFactories(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getCMPResourceAdapters(repositoryContext).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((J2CResourceAdapter)iterator.next()).getFactories());
        }
        return arrayList;
    }

    public boolean cmpResourceAdapterExists(RepositoryContext repositoryContext) throws WorkSpaceException {
        return this.getCMPResourceAdapters(repositoryContext).size() > 0;
    }

    public Collection getMultiBrokerDomainNames(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getRefObjects(repositoryContext, "multibroker.xml", "MultibrokerDomain", false).iterator();
        while (iterator.hasNext()) {
            MultibrokerDomain multibrokerDomain = (MultibrokerDomain)iterator.next();
            arrayList.add(multibrokerDomain.getName());
        }
        return arrayList;
    }

    public Collection getDataReplicationDomainNames(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getRefObjects(repositoryContext, "multibroker.xml", "DataReplicationDomain", false).iterator();
        while (iterator.hasNext()) {
            DataReplicationDomain dataReplicationDomain = (DataReplicationDomain)iterator.next();
            arrayList.add(dataReplicationDomain.getName());
        }
        return arrayList;
    }

    public EList getMultiBrokerEntries(RepositoryContext repositoryContext, String string) throws WorkSpaceException {
        Iterator iterator = this.getRefObjects(repositoryContext, "multibroker.xml", "MultibrokerDomain", false).iterator();
        while (iterator.hasNext()) {
            MultibrokerDomain multibrokerDomain = (MultibrokerDomain)iterator.next();
            if (!multibrokerDomain.getName().equals(string)) continue;
            return multibrokerDomain.getEntries();
        }
        return null;
    }

    public Collection getWebContainers(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getServerRefObjects(repositoryContext, true).iterator();
        while (iterator.hasNext()) {
            Server server2 = (Server)iterator.next();
            Iterator iterator2 = server2.getComponents().iterator();
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                if (!(e2 instanceof ApplicationServer)) continue;
                Iterator iterator3 = ((ApplicationServer)e2).getComponents().iterator();
                while (iterator3.hasNext()) {
                    Object e3 = iterator3.next();
                    if (!(e3 instanceof WebContainer)) continue;
                    arrayList.add(e3);
                }
            }
        }
        return arrayList;
    }

    public boolean isFIPSEnabled(RepositoryContext repositoryContext) throws WorkSpaceException {
        String string = "";
        String string2 = "";
        Property property = null;
        Iterator iterator = this.getRefObjects(repositoryContext, "security.xml", "Security", true).iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((Security)iterator.next()).getProperties().iterator();
            while (iterator2.hasNext()) {
                property = (Property)iterator2.next();
                string = property.getName();
                if (!string.equals("com.ibm.security.useFIPS") || !(string2 = property.getValue()).equalsIgnoreCase("true")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSSLAliasFIPSApproved(RepositoryContext repositoryContext, String string) throws WorkSpaceException {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        SSLConfig sSLConfig = null;
        Property property = null;
        Iterator iterator = this.getRefObjects(repositoryContext, "security.xml", "Security", true).iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((Security)iterator.next()).getRepertoire().iterator();
            while (iterator2.hasNext()) {
                sSLConfig = (SSLConfig)iterator2.next();
                string2 = sSLConfig.getAlias();
                if (!string2.equals(string) || sSLConfig.getSetting() == null || sSLConfig.getSetting().getProperties() == null) continue;
                Iterator iterator3 = sSLConfig.getSetting().getProperties().iterator();
                while (iterator3.hasNext()) {
                    property = (Property)iterator3.next();
                    string3 = property.getName();
                    if (!string3.equals("com.ibm.ssl.contextProvider") || !(string4 = property.getValue()).equals("IBMJSSEFIPS")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getDefaultJCEProvider(RepositoryContext repositoryContext) throws WorkSpaceException {
        String string = "IBMJCE";
        if (this.isFIPSEnabled(repositoryContext)) {
            string = "IBMJCEFIPS";
        }
        return string;
    }

    public Collection getSSLAlias(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getRefObjects(repositoryContext, "security.xml", "Security", true).iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((Security)iterator.next()).getRepertoire().iterator();
            while (iterator2.hasNext()) {
                String string = ((SSLConfig)iterator2.next()).getAlias();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public Collection getJsseSSLAlias(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        SSLConfig sSLConfig = null;
        Collection collection = this.getRefObjects(repositoryContext, "security.xml", "Security", true);
        if (collection == null) {
            return arrayList;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            EList eList = ((Security)iterator.next()).getRepertoire();
            if (eList == null) continue;
            Iterator iterator2 = eList.iterator();
            while (iterator2.hasNext()) {
                String string;
                sSLConfig = (SSLConfig)iterator2.next();
                if (sSLConfig.getType() == null || !sSLConfig.getType().getName().equals("JSSE") || arrayList.contains(string = sSLConfig.getAlias())) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public Collection getSSSLAlias(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        SSLConfig sSLConfig = null;
        Collection collection = this.getRefObjects(repositoryContext, "security.xml", "Security", true);
        if (collection == null) {
            return arrayList;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            EList eList = ((Security)iterator.next()).getRepertoire();
            if (eList == null) continue;
            Iterator iterator2 = eList.iterator();
            while (iterator2.hasNext()) {
                String string;
                sSLConfig = (SSLConfig)iterator2.next();
                if (sSLConfig.getType() == null || !sSLConfig.getType().getName().equals("SSSL") || arrayList.contains(string = sSLConfig.getAlias())) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public Collection getAuthAlias(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        final RepositoryContext repositoryContext2 = repositoryContext;
        if (repositoryContext.isAvailable("security.xml") && !repositoryContext.isExtracted("security.xml") && SecurityContext.isSecurityEnabled() && !RestrictedAccess.isReadable("security.xml")) {
            try {
                SecurityContext.runAsSystem(new PrivilegedExceptionAction(){

                    public Object run() throws WorkSpaceException {
                        repositoryContext2.extract("security.xml", false);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (WorkSpaceException)privilegedActionException.getException();
            }
        }
        Iterator iterator = this.getRefObjects(repositoryContext, "security.xml", "Security", true).iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((Security)iterator.next()).getAuthDataEntries().iterator();
            while (iterator2.hasNext()) {
                String string = ((JAASAuthData)iterator2.next()).getAlias();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public Collection getMappingConfigAlias(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        final RepositoryContext repositoryContext2 = repositoryContext;
        if (repositoryContext.isAvailable("security.xml") && !repositoryContext.isExtracted("security.xml") && SecurityContext.isSecurityEnabled() && !RestrictedAccess.isReadable("security.xml")) {
            try {
                SecurityContext.runAsSystem(new PrivilegedExceptionAction(){

                    public Object run() throws WorkSpaceException {
                        repositoryContext2.extract("security.xml", false);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (WorkSpaceException)privilegedActionException.getException();
            }
        }
        Iterator iterator = this.getRefObjects(repositoryContext, "security.xml", "Security", true).iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((Security)iterator.next()).getApplicationLoginConfig().getEntries().iterator();
            while (iterator2.hasNext()) {
                String string = ((JAASConfigurationEntry)iterator2.next()).getAlias();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public Collection getLibraryNames(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getRefObjects(repositoryContext, "libraries.xml", "Library", true).iterator();
        while (iterator.hasNext()) {
            String string = ((Library)iterator.next()).getName();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private Collection getServerRefObjects(RepositoryContext repositoryContext, boolean bl) throws WorkSpaceException {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getRefObjects(repositoryContext, "server.xml", "Server", false));
        if (bl) {
            Iterator iterator = repositoryContext.findContext(this.getServerContextType()).iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(this.getServerRefObjects((RepositoryContext)iterator.next(), false));
            }
        }
        return arrayList;
    }

    private Collection getCMPDatasource(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<DataSource> arrayList = new ArrayList<DataSource>();
        Iterator iterator = this.getCMPConnectorFactories(repositoryContext).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((CMPConnectorFactory)iterator.next()).getCmpDatasource());
        }
        return arrayList;
    }

    private Collection getCMPResourceAdapters(RepositoryContext repositoryContext) {
        ArrayList<J2CResourceAdapter> arrayList = new ArrayList<J2CResourceAdapter>();
        Iterator iterator = this.getRefObjects(repositoryContext, "resources.xml", "J2CResourceAdapter", true).iterator();
        while (iterator.hasNext()) {
            J2CResourceAdapter j2CResourceAdapter = (J2CResourceAdapter)iterator.next();
            String string = ((XMLResource)j2CResourceAdapter.eResource()).getID((EObject)j2CResourceAdapter);
            if (!string.equals("builtin_rra")) continue;
            arrayList.add(j2CResourceAdapter);
        }
        return arrayList;
    }

    public Collection getRefObjects(RepositoryContext repositoryContext, String string, String string2, boolean bl) {
        ArrayList<EObject> arrayList = new ArrayList<EObject>();
        Resource resource = this.load(repositoryContext, string);
        if (resource != null) {
            Iterator iterator = resource.getContents().iterator();
            while (iterator.hasNext()) {
                EObject eObject = (EObject)iterator.next();
                String string3 = eObject.eClass().getName();
                if (!string3.equals(string2)) continue;
                arrayList.add(eObject);
            }
            if (bl && repositoryContext.getParent() != null) {
                arrayList.addAll(this.getRefObjects(repositoryContext.getParent(), string, string2, bl));
            }
        }
        return arrayList;
    }

    private Collection getRefObjectMofTypes(RepositoryContext repositoryContext, String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Resource resource = this.load(repositoryContext, string);
        if (resource != null) {
            Iterator iterator = resource.getContents().iterator();
            while (iterator.hasNext()) {
                String string2 = ((EObject)iterator.next()).eClass().getName();
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
            if (bl && repositoryContext.getParent() != null) {
                arrayList.addAll(this.getRefObjectMofTypes(repositoryContext.getParent(), string, bl));
            }
        }
        return arrayList;
    }

    private RefObjectHelper getRefObjectHelper() {
        return RefObjectHelperFactory.getRefObjectHelper();
    }

    public Hashtable getLibraryData(RepositoryContext repositoryContext) throws WorkSpaceException {
        Hashtable<String, EList> hashtable = new Hashtable<String, EList>();
        Iterator iterator = this.getRefObjects(repositoryContext, "libraries.xml", "Library", true).iterator();
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            String string = library.getName();
            EList eList = library.getClassPath();
            hashtable.put(string, eList);
        }
        return hashtable;
    }

    public Collection getResourcePMEJNDINames(RepositoryContext repositoryContext, String string) {
        return this.getResourceJNDINames(this.getResourcePMEFactory(repositoryContext, string));
    }

    private Collection getResourcePMEFactory(RepositoryContext repositoryContext, String string) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getRefObjects(repositoryContext, "resources-pme.xml", string, true).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((J2EEResourceProvider)iterator.next()).getFactories());
        }
        return arrayList;
    }

    public Resource getAppResource(WorkSpace workSpace, EARFile eARFile, String string, String string2, String string3) {
        Resource resource = null;
        String string4 = "com.ibm.ws.management.configarchive.EnhancedEarConfigurator";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(string4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            GenericDeclaration genericDeclaration;
            Object[] objectArray;
            Class<Object> clazz2;
            Constructor<?> constructor = null;
            try {
                clazz2 = Class.forName("java.lang.String");
                objectArray = Class.forName("com.ibm.ws.sm.workspace.WorkSpace");
                genericDeclaration = Class.forName("com.ibm.etools.commonarchive.EARFile");
                Class<Boolean> clazz3 = Boolean.TYPE;
                Class[] classArray = new Class[]{objectArray, genericDeclaration, clazz3, clazz2, clazz2, clazz2};
                constructor = clazz.getConstructor(classArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            clazz2 = null;
            if (constructor != null) {
                objectArray = new Object[]{workSpace, eARFile, Boolean.FALSE, string, string2, string3};
                try {
                    clazz2 = constructor.newInstance(objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
            }
            if (clazz2 != null) {
                objectArray = "getResources";
                try {
                    genericDeclaration = clazz.getMethod((String)objectArray, null);
                    resource = (Resource)((Method)genericDeclaration).invoke(clazz2, null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return resource;
    }
}

