/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.wsaddressing.Constants;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;

public class NamespaceHelper {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(NamespaceHelper.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private static String CLASSNAME = "com.ibm.ws.wsaddressing.NamespaceHelper";

    public boolean isNamespaceSupported(String string) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isNamespaceSupported", string);
        }
        boolean bl = false;
        if (string == null || string.equals("")) {
            return false;
        }
        if (string.equals("http://schemas.xmlsoap.org/ws/2004/08/addressing") || string.equals("http://www.w3.org/2005/08/addressing")) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "isNamespaceSupported", "true");
            }
            return true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isNamespaceSupported", "false");
        }
        return false;
    }

    public String getNamespaceForChildSOAPElement(javax.xml.soap.SOAPElement sOAPElement, String string) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getNamespaceForChildSOAPElement", new Object[]{sOAPElement, string});
        }
        String string2 = null;
        String string3 = "http://www.w3.org/2005/08/addressing";
        SOAPFactory sOAPFactory = null;
        if (sOAPElement instanceof SOAPElement) {
            sOAPFactory = ((SOAPElement)sOAPElement).getSOAPFactory();
        } else {
            try {
                sOAPFactory = SOAPFactory.newInstance();
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException(sOAPException, CLASSNAME, "1:113:1.9");
            }
        }
        Iterator iterator = sOAPElement.getChildElements(NamespaceHelper.createSOAPName(string, sOAPFactory, string3));
        if (iterator.hasNext()) {
            string2 = string3;
        }
        if (string2 == null && (iterator = sOAPElement.getChildElements(NamespaceHelper.createSOAPName(string, sOAPFactory, string3 = "http://schemas.xmlsoap.org/ws/2004/08/addressing"))).hasNext()) {
            string2 = string3;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getNamespaceForChildSOAPElement", string2);
        }
        return string2;
    }

    public String updateInboundWSANamespaceForMessageContext(SOAPHeader sOAPHeader, MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getWSANamespaceFromMessageContext", new Object[]{sOAPHeader, messageContext});
        }
        String string = null;
        string = (String)messageContext.getProperty("com.ibm.ws.wsaddressing.InboundNamespace");
        if (string == null) {
            Object object;
            Object object2;
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = sOAPHeader.getChildElements();
            while (iterator.hasNext()) {
                String string2;
                object2 = iterator.next();
                if (!(object2 instanceof javax.xml.soap.SOAPElement) || (string2 = (object = (javax.xml.soap.SOAPElement)object2).getLocalName()) == null || !string2.equals("Action")) continue;
                arrayList.add(object.getNamespaceURI());
            }
            if (arrayList.contains("http://www.w3.org/2005/08/addressing")) {
                string = "http://www.w3.org/2005/08/addressing";
            } else {
                object2 = arrayList.iterator();
                while (string == null && object2.hasNext()) {
                    object = (String)object2.next();
                    if (!this.isNamespaceSupported((String)object)) continue;
                    string = object;
                }
            }
            if (string == null) {
                string = "http://www.w3.org/2005/08/addressing";
            }
        }
        messageContext.setProperty("com.ibm.ws.wsaddressing.InboundNamespace", (Object)string);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getWSANamespaceFromMessageContext", string);
        }
        return string;
    }

    public String updateOutboundWSANamespaceForMessageContext(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "updateOutboundWSANamespaceForMessageContext", messageContext);
        }
        Object object = messageContext.getProperty("com.ibm.wsspi.wsaddressing.OutboundNamespace");
        Object object2 = messageContext.getProperty("com.ibm.websphere.wsaddressing.destinationEPR");
        String string = "http://www.w3.org/2005/08/addressing";
        if (object instanceof String) {
            EndpointReference endpointReference;
            String string2;
            String string3 = (String)object;
            if (!this.isNamespaceSupported(string3)) {
                String string4 = "The WS-Addressing namespace " + object + " specified by the WSADDRESSING_OUTBOUND_NAMESPACE property is not supported by this implementation";
                Tr.warning(TRACE_COMPONENT, string4);
                throw new JAXRPCException(string4);
            }
            if (object2 instanceof EndpointReference && !(string2 = (endpointReference = (EndpointReference)object2).getNamespace()).equals(string3)) {
                String string5 = "The WS-Addressing namespace " + string3 + " specified by the WSADDRESSING_OUTBOUND_NAMESPACE property conflicts with the namespace of the destination EPR (specified by WSADDRESSING_DESTINATION_EPR property): " + string2;
                Tr.warning(TRACE_COMPONENT, string5);
                throw new JAXRPCException(string5);
            }
            string = string3;
        } else if (object2 instanceof EndpointReference) {
            EndpointReference endpointReference = (EndpointReference)object2;
            string = endpointReference.getNamespace();
        }
        messageContext.setProperty("com.ibm.wsspi.wsaddressing.OutboundNamespace", (Object)string);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "updateOutboundWSANamespaceForMessageContext", string);
        }
        return string;
    }

    private static Name createSOAPName(String string, SOAPFactory sOAPFactory, String string2) {
        Name name2 = null;
        try {
            name2 = sOAPFactory.createName(string, "wsa", string2);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, Constants.class.getName() + ".createSOAPName", "1:298:1.9", string);
        }
        return name2;
    }
}

