/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.webservices.soap.IBMSOAPElement;
import com.ibm.websphere.webservices.soap.IBMSOAPFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.ReferenceParameter;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsrf.WebSphereIOSerializableSOAPElement;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;

public class PersistableSOAPElement
implements Externalizable,
ReferenceParameter,
WebSphereIOSerializableSOAPElement {
    private static final long serialVersionUID = 1399290188997056040L;
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PersistableSOAPElement.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private transient SOAPElement _soapElement = null;
    private String _xmlString = "";

    public PersistableSOAPElement() {
    }

    public PersistableSOAPElement(SOAPElement sOAPElement) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "PersistableSOAPElement", sOAPElement);
        }
        this._soapElement = sOAPElement;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "PersistableSOAPElement");
        }
    }

    public SOAPElement getSOAPElement() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPElement");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPElement", this._soapElement);
        }
        return this._soapElement;
    }

    public void setSOAPElement(SOAPElement sOAPElement) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setSOAPElement", sOAPElement);
        }
        this._soapElement = sOAPElement;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setSOAPElement");
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] objectArray = new Object[]{this._soapElement, this._xmlString, objectOutput};
            Tr.entry(TRACE_COMPONENT, "writeExternal", objectArray);
        }
        this.convertSoapElementToInitialiseXMLString();
        objectOutput.writeObject(this._xmlString);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "writeExternal");
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{this._soapElement, this._xmlString, objectInput};
            Tr.entry(TRACE_COMPONENT, "readExternal", objectArray);
        }
        this._xmlString = (String)objectInput.readObject();
        if (this._xmlString == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                objectArray = new Object[]{this._soapElement, this._xmlString};
                Tr.debug(TRACE_COMPONENT, "readExternal", objectArray);
            }
        } else {
            this.xmlStringToSOAPElement();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{this._soapElement, this._xmlString};
            Tr.exit(TRACE_COMPONENT, "readExternal", objectArray);
        }
    }

    private void xmlStringToSOAPElement() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "xmlStringToSOAPElement");
        }
        try {
            this._soapElement = ((IBMSOAPFactory)SOAPFactory.newInstance()).createElementFromXMLString(this._xmlString);
        }
        catch (SOAPException sOAPException) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Object[] objectArray = new Object[]{this._soapElement, this._xmlString};
                Tr.error(TRACE_COMPONENT, "xmlStringToSOAPElement", objectArray);
            }
            FFDCFilter.processException(sOAPException, PersistableSOAPElement.class.getName() + ".xmlStringToSOAPElement", "1:259:1.17", this, new Object[]{this._soapElement});
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "xmlStringToSOAPElement");
        }
    }

    private void convertSoapElementToInitialiseXMLString() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] objectArray = new Object[]{this._soapElement, this._xmlString};
            Tr.entry(TRACE_COMPONENT, "soapElementToXMLString", objectArray);
        }
        if (this._soapElement != null) {
            this._xmlString = ((IBMSOAPElement)this._soapElement).toXMLString(true);
            if (this._xmlString == null) {
                this._xmlString = "";
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "soapElementToXMLString");
        }
    }

    public String toString() {
        if (this._soapElement != null) {
            this.convertSoapElementToInitialiseXMLString();
        } else {
            this._xmlString = "";
        }
        return this._xmlString;
    }

    public boolean equals(Object object) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] objectArray = new Object[]{this._soapElement, object};
            Tr.entry(TRACE_COMPONENT, "equals", objectArray);
        }
        boolean bl = false;
        if (object instanceof PersistableSOAPElement) {
            PersistableSOAPElement persistableSOAPElement = (PersistableSOAPElement)object;
            bl = this.getSOAPElement() == null ? persistableSOAPElement.getSOAPElement() == null : (this.getSOAPElement().getValue() != null ? (bl = this.getQName().equals(persistableSOAPElement.getQName())) && this.getSOAPElement().getValue().equals(persistableSOAPElement.getSOAPElement().getValue()) : persistableSOAPElement.toString().equals(this.toString()));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            if (bl) {
                Tr.exit(TRACE_COMPONENT, "getQName", "true");
            } else {
                Tr.exit(TRACE_COMPONENT, "getQName", "false");
            }
        }
        return bl;
    }

    public boolean hasSameQName(QName qName) {
        String string;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeReferenceParametersByQName", qName);
        }
        boolean bl = false;
        QName qName2 = this.getQName();
        if (qName2 != null && qName != null) {
            string = qName2.getLocalPart();
            String string2 = qName.getLocalPart();
            if (string2 != null && !string2.equals("")) {
                if (string2.equals(string)) {
                    String string3 = qName2.getNamespaceURI();
                    String string4 = qName.getNamespaceURI();
                    if (string4 != null && !string4.equals("")) {
                        if (string4.equals(string3)) {
                            bl = true;
                        }
                    } else if (string3 == null || string4.equals("")) {
                        bl = true;
                    }
                }
            } else if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.error(TRACE_COMPONENT, "hasSameQName", "Local name was not present in provided QName");
            }
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.error(TRACE_COMPONENT, "hasSameQName", "SOAP element or QName is null");
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            if (bl) {
                string = "The SOAPElement name was the same as the one passed.  localPart is : " + qName2.getLocalPart() + ", prefix is : " + qName2.getPrefix() + ", namespace is : " + qName2.getNamespaceURI();
                Tr.debug(TRACE_COMPONENT, "hasSameName", string);
            } else {
                Tr.debug(TRACE_COMPONENT, "hasSameQName", "Names were not the same");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeReferenceParametersByQName");
        }
        return bl;
    }

    public QName getQName() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getQName");
        }
        QName qName = null;
        if (this.getSOAPElement() != null) {
            String string = this.getSOAPElement().getPrefix();
            String string2 = this.getSOAPElement().getNamespaceURI();
            String string3 = this.getSOAPElement().getLocalName();
            qName = string2 != null && !string2.equals("") ? (string != null && !string.equals("") ? new QName(string2, string3, string) : new QName(string2, string3)) : new QName(string3);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getQName", qName);
            }
        }
        return qName;
    }

    public String getStringValue() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getStringValue");
        }
        String string = null;
        if (this._soapElement != null && this._soapElement.getChildElements() != null) {
            string = this._soapElement.getValue();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getStringValue");
        }
        return string;
    }
}

