/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.wsaddressing.Constants;
import com.ibm.ws.wsaddressing.DestinationUnreachableException;
import com.ibm.ws.wsaddressing.EndpointReferenceImpl;
import com.ibm.ws.wsaddressing.InvalidMultipleElementException;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.handlers.MAPReader;
import com.ibm.ws.wsaddressing.handlers.ReplyHelper;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.webservices.sysapp.SystemEndpointContext;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class InboundWSAProcessor {
    private boolean _wsaPresent = false;
    private boolean _actionPresent = false;
    private boolean _messageIDPresent = false;
    private boolean _relatesToPresent = false;
    private boolean _toPresent = false;
    private boolean _replyToPresent = false;
    private boolean _faultToPresent = false;
    private MAPReader _mapReader;
    private Boolean _validation = null;
    private MessageContext _context = null;
    private static DocumentBuilderFactory _dbf = null;
    private static DocumentBuilder _db = null;
    private QName _faultCode = null;
    private String _faultDetail = null;
    private static final TraceComponent TRACE_COMPONENT = Tr.register(InboundWSAProcessor.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.InboundWSAProcessor";
    private NamespaceData _namespaceData = null;

    public InboundWSAProcessor() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "InboundWSAProcessor");
        }
        this._namespaceData = NamespaceData.getDefaultNamespaceInstance();
        this._mapReader = new MAPReader();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "InboundWSAProcessor");
        }
    }

    private SOAPFaultException setSOAPFaultException(Exception exception, MessageContext messageContext) {
        Throwable throwable;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setSOAPFaultException exception[" + exception + "]");
        }
        this.setFaultCode(this._namespaceData.getInvalidMessageAddressingProperty());
        if (exception instanceof InvalidMultipleElementException) {
            throwable = (InvalidMultipleElementException)exception;
            this.setFaultDetail(((InvalidMultipleElementException)throwable).getProblemHeaderQName().getLocalPart());
        } else if (exception instanceof DestinationUnreachableException) {
            this.setFaultCode(this._namespaceData.getDestinationUnreachable());
        }
        throwable = this.getSoapFaultException();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setSOAPFaultException");
        }
        return throwable;
    }

    public boolean setMessageContext(SOAPMessageContext sOAPMessageContext) throws SOAPFaultException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setMessageContext");
        }
        this._context = sOAPMessageContext;
        try {
            this._wsaPresent = this._mapReader.setMessageContext(sOAPMessageContext);
        }
        catch (InvalidMultipleElementException invalidMultipleElementException) {
            this._mapReader.addPropertiesToContext();
            this._namespaceData = this._mapReader.getNamespaceData();
            sOAPMessageContext.setProperty(Constants.WSA_FOUND_INBOUND, (Object)Boolean.TRUE);
            this.setupRedirectProperties();
            String string = "Check the contents on the SOAPHeader.  An InvalidMultipleElementException was thrown.  This is invalid according to the WS-Addressing Specification." + invalidMultipleElementException.getMessage();
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.warning(TRACE_COMPONENT, string);
            }
            FFDCFilter.processException(invalidMultipleElementException, CLASSNAME, "1:225:1.26.1.1");
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "setMessageContext", sOAPMessageContext);
            }
            SOAPFaultException sOAPFaultException = this.setSOAPFaultException(invalidMultipleElementException, (MessageContext)sOAPMessageContext);
            throw sOAPFaultException;
        }
        catch (DestinationUnreachableException destinationUnreachableException) {
            this._mapReader.addPropertiesToContext();
            this._namespaceData = this._mapReader.getNamespaceData();
            sOAPMessageContext.setProperty(Constants.WSA_FOUND_INBOUND, (Object)Boolean.TRUE);
            String string = "A DestinationUnreachableException was thrown. This occurs when the wsaucf:RoutingInformation relates to a cluster which the processing server is not a memebr of.";
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.warning(TRACE_COMPONENT, string);
            }
            FFDCFilter.processException(destinationUnreachableException, CLASSNAME, "1:248:1.26.1.1");
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "setMessageContext", sOAPMessageContext);
            }
            SOAPFaultException sOAPFaultException = this.setSOAPFaultException(destinationUnreachableException, (MessageContext)sOAPMessageContext);
            throw sOAPFaultException;
        }
        if (!this._wsaPresent) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "setMessageContext", Boolean.FALSE);
            }
            return false;
        }
        this._mapReader.addPropertiesToContext();
        this._namespaceData = this._mapReader.getNamespaceData();
        sOAPMessageContext.setProperty(Constants.WSA_FOUND_INBOUND, (Object)new Boolean(this._wsaPresent));
        this.checkForPresence();
        this.performValidation();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setMessageContext");
        }
        return this._wsaPresent;
    }

    public boolean isWSAPresent() {
        return this._wsaPresent;
    }

    public boolean isAddressingValid() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isValid");
        }
        if (this._validation == null) {
            this.performValidation();
        }
        boolean bl = this._validation;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isValid result[" + bl + "]");
        }
        return bl;
    }

    private void checkForPresence() {
        AttributedURI attributedURI;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "checkForPresence");
        }
        this._actionPresent = (attributedURI = this._mapReader.getActionURI()) != null;
        AttributedURI attributedURI2 = this._mapReader.getMessageIDAURI();
        this._messageIDPresent = attributedURI2 != null;
        EndpointReferenceImpl endpointReferenceImpl = this._mapReader.getFaultToEPR();
        this._faultToPresent = endpointReferenceImpl != null;
        EndpointReferenceImpl endpointReferenceImpl2 = this._mapReader.getReplyToEPR();
        this._replyToPresent = endpointReferenceImpl2 != null;
        AttributedURI attributedURI3 = this._mapReader.getToAddress();
        this._toPresent = attributedURI3 != null;
        Set set = this._mapReader.getRelationshipSet();
        boolean bl = this._relatesToPresent = set != null;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isValid");
        }
    }

    private boolean performValidation() {
        boolean bl;
        block11: {
            boolean bl2;
            Object object;
            block22: {
                block23: {
                    block24: {
                        block16: {
                            block20: {
                                block21: {
                                    Object object2;
                                    block17: {
                                        block18: {
                                            block19: {
                                                block15: {
                                                    block14: {
                                                        AttributedURI attributedURI;
                                                        block13: {
                                                            block12: {
                                                                if (TRACE_COMPONENT.isEntryEnabled()) {
                                                                    Tr.entry(TRACE_COMPONENT, "performValidation");
                                                                }
                                                                bl = true;
                                                                if (!this.isWSAPresent() || !bl) break block11;
                                                                if (this._actionPresent) break block12;
                                                                Tr.debug(TRACE_COMPONENT, "<wsa:Action> field is not present.");
                                                                this.setFaultCode(this._namespaceData.getMessageAddressingPropertyRequired());
                                                                this.setFaultDetail(this._namespaceData.getwsaAction());
                                                                bl = false;
                                                                break block11;
                                                            }
                                                            attributedURI = this._mapReader.getActionURI();
                                                            if (attributedURI != null && attributedURI.getURI() != null) break block13;
                                                            this.setFaultCode(this._namespaceData.getInvalidMessageAddressingProperty());
                                                            this.setFaultDetail(this._namespaceData.getwsaAction());
                                                            bl = false;
                                                            break block11;
                                                        }
                                                        Object object3 = this._context.getProperty("javax.xml.rpc.soap.http.soapaction.use");
                                                        if (object3 != null) {
                                                            Tr.debug(TRACE_COMPONENT, "We have a soapAction field:" + (Boolean)object3);
                                                        }
                                                        if ((object3 = this._context.getProperty("javax.xml.rpc.soap.http.soapaction.uri")) == null) break block14;
                                                        object = (String)object3;
                                                        if (((String)object).equals("")) break block15;
                                                        Tr.debug(TRACE_COMPONENT, "We have a soapActionURI:" + (String)object);
                                                        if (((String)object).equals(attributedURI.getURI().toString())) break block15;
                                                        Tr.debug(TRACE_COMPONENT, "Mismatch SOAPActionURI and wsa:Action");
                                                        this.setFaultCode(this._namespaceData.getActionMismatch());
                                                        this.setFaultDetail(this._namespaceData.getwsaAction());
                                                        bl = false;
                                                        break block11;
                                                    }
                                                    Tr.debug(TRACE_COMPONENT, "SOAPACTION_URI_PROPERTY not present");
                                                }
                                                bl2 = false;
                                                if (!this._replyToPresent && !this._faultToPresent) break block16;
                                                if (!this._replyToPresent || ((EndpointReferenceImpl)(object = this._mapReader.getReplyToEPR())).isAnonymousURI() || ((EndpointReferenceImpl)object).isNoneURI()) break block17;
                                                if (this._messageIDPresent) break block18;
                                                object2 = this._context.getProperty("servletEndpointContext");
                                                if (TRACE_COMPONENT.isDebugEnabled()) {
                                                    Tr.debug(TRACE_COMPONENT, "endpointContext=" + object2);
                                                }
                                                if (!(object2 instanceof SystemEndpointContext)) break block19;
                                                this._context.setProperty("com.ibm.wsspi.wsaddressing.inbound.MessageID", (Object)WSAddressingFactory.createAttributedURI(this._namespaceData.getUnspecifiedMessageURI()));
                                                if (TRACE_COMPONENT.isDebugEnabled()) {
                                                    Tr.debug(TRACE_COMPONENT, "<wsa:MessageID> is not present but in sysapp container so ignoring.");
                                                }
                                                break block17;
                                            }
                                            Tr.debug(TRACE_COMPONENT, "<wsa:MessageID> is not present when protocol expects response");
                                            this.setFaultCode(this._namespaceData.getMessageAddressingPropertyRequired());
                                            this.setFaultDetail(this._namespaceData.getwsaMessageID());
                                            bl = false;
                                            break block11;
                                        }
                                        bl2 = true;
                                    }
                                    if (!this._faultToPresent || ((EndpointReferenceImpl)(object = this._mapReader.getFaultToEPR())).isAnonymousURI() || ((EndpointReferenceImpl)object).isNoneURI()) break block16;
                                    if (this._messageIDPresent) break block20;
                                    object2 = this._context.getProperty("servletEndpointContext");
                                    if (TRACE_COMPONENT.isDebugEnabled()) {
                                        Tr.debug(TRACE_COMPONENT, "endpointContext=" + object2);
                                    }
                                    if (!(object2 instanceof SystemEndpointContext)) break block21;
                                    this._context.setProperty("com.ibm.wsspi.wsaddressing.inbound.MessageID", (Object)WSAddressingFactory.createAttributedURI(this._namespaceData.getUnspecifiedMessageURI()));
                                    if (TRACE_COMPONENT.isDebugEnabled()) {
                                        Tr.debug(TRACE_COMPONENT, "<wsa:MessageID> is not present but in sysapp container so ignoring.");
                                    }
                                    break block16;
                                }
                                Tr.debug(TRACE_COMPONENT, "<wsa:MessageID> is not present when protocol expects response");
                                this.setFaultCode(this._namespaceData.getMessageAddressingPropertyRequired());
                                this.setFaultDetail(this._namespaceData.getwsaMessageID());
                                bl = false;
                                break block11;
                            }
                            bl2 = true;
                        }
                        if (((com.ibm.ws.webservices.engine.MessageContext)this._context).isOneWay()) break block22;
                        if (this._messageIDPresent) break block23;
                        object = this._context.getProperty("servletEndpointContext");
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "endpointContext=" + object);
                        }
                        if (!(object instanceof SystemEndpointContext)) break block24;
                        this._context.setProperty("com.ibm.wsspi.wsaddressing.inbound.MessageID", (Object)WSAddressingFactory.createAttributedURI(this._namespaceData.getUnspecifiedMessageURI()));
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "<wsa:MessageID> is not present but in sysapp container so ignoring.");
                        }
                        break block22;
                    }
                    Tr.debug(TRACE_COMPONENT, "<wsa:MessageID> is not present when protocol expects response");
                    this.setFaultCode(this._namespaceData.getMessageAddressingPropertyRequired());
                    this.setFaultDetail(this._namespaceData.getwsaMessageID());
                    bl = false;
                    break block11;
                }
                bl2 = true;
            }
            if (bl2 && ((object = this._mapReader.getMessageIDAURI()) == null || object.getURI() == null)) {
                Tr.debug(TRACE_COMPONENT, "<wsa:MessageId> is not valid");
                this.setFaultCode(this._namespaceData.getInvalidMessageAddressingProperty());
                this.setFaultDetail(this._namespaceData.getwsaMessageID());
                bl = false;
            } else {
                this.setupRedirectProperties();
            }
        }
        this._validation = new Boolean(bl);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "performValidation result[" + bl + "]");
        }
        return bl;
    }

    private void setupRedirectProperties() {
        if (!((com.ibm.ws.webservices.engine.MessageContext)this._context).isOneWay()) {
            ReplyHelper replyHelper;
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "performValidation", "Operation has return value, so check for redirected replies.");
            }
            EndpointReferenceImpl endpointReferenceImpl = this._mapReader.getReplyToEPR();
            EndpointReferenceImpl endpointReferenceImpl2 = this._mapReader.getFaultToEPR();
            if (endpointReferenceImpl != null && endpointReferenceImpl.isNoneURI()) {
                this._context.setProperty("com.ibm.ws.wsaddressing.NoneResponse", (Object)endpointReferenceImpl);
            }
            if (endpointReferenceImpl2 != null) {
                if (endpointReferenceImpl2.isNoneURI()) {
                    this._context.setProperty("com.ibm.ws.wsaddressing.NoneFault", (Object)endpointReferenceImpl2);
                }
            } else if (endpointReferenceImpl != null && endpointReferenceImpl.isNoneURI()) {
                this._context.setProperty("com.ibm.ws.wsaddressing.NoneFault", (Object)endpointReferenceImpl);
            }
            if ((replyHelper = new ReplyHelper(endpointReferenceImpl, endpointReferenceImpl2, this._namespaceData)).isAsyncReply()) {
                this._context.setProperty("com.ibm.ws.wsaddressing.RedirectRequired", (Object)"true");
                this._context.setProperty("com.ibm.ws.wsaddressing.RedirectResponse", (Object)replyHelper.getAsyncReplyEPR());
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "performValidation", "REDIRECT_RESPONSE is true");
                }
            }
            if (replyHelper.isAsyncFault()) {
                this._context.setProperty("com.ibm.ws.wsaddressing.RedirectRequired", (Object)"true");
                this._context.setProperty("com.ibm.ws.wsaddressing.RedirectFault", (Object)replyHelper.getAsyncFaultEPR());
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "performValidation", "REDIRECT_FAULT is true.");
                }
            }
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "performValidation", "Redirection check complete.");
            }
        }
    }

    public SOAPFault getSoapFault() {
        return this.getSoapFault(this.getFaultCode(), this._faultDetail);
    }

    public SOAPFault getSoapFault(QName qName) {
        return this.getSoapFault(qName, null);
    }

    public SOAPFault getSoapFault(QName qName, String string) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSoapFault faultCode/detail[" + qName + "/" + string + "]");
        }
        String string2 = null;
        String string3 = null;
        if (qName == null) {
            return null;
        }
        if (qName.equals(this._namespaceData.getInvalidMessageAddressingProperty())) {
            string3 = "[Sender]";
            string2 = "A header representing a Message Addressing Property is not valid and the message cannot be processed";
        } else if (qName.equals(this._namespaceData.getMessageAddressingPropertyRequired())) {
            string3 = "[Sender]";
            string2 = "A required header representing a Message Addressing Property is not present";
        } else if (qName.equals(this._namespaceData.getDestinationUnreachable())) {
            string3 = "[Sender]";
            string = string == null ? "[destination]" : string;
            string2 = "No route can be determined to reach " + InboundWSAProcessor.encode(string) + ".";
        } else if (qName.equals(this._namespaceData.getActionNotSupported())) {
            string3 = "S:Sender";
            string = string == null ? "[action]" : string;
            string2 = "The " + InboundWSAProcessor.encode(string) + " cannot be processed at the receiver.";
        } else if (qName.equals(this._namespaceData.getEndpointUnavailable())) {
            string3 = "S:Receiver";
            string2 = "The endpoint is unable to process the message at this time.";
        }
        SOAPFault sOAPFault = null;
        SOAPFactory sOAPFactory = new SOAPFactory();
        try {
            sOAPFault = sOAPFactory.createSOAPFault();
            sOAPFault.setFaultCode(qName.toString());
            sOAPFault.setFaultString(string2);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.wsaddressing.handlers.InboundWSAProcessor.getFaultMsg", "1:833:1.26.1.1", sOAPFactory);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSoapFault result[" + sOAPFault + "]");
        }
        return sOAPFault;
    }

    private static SOAPFault getSOAP1_2FaultMsg(SOAPMessage sOAPMessage, String string, String string2, String string3, String string4) {
        SOAPFault sOAPFault;
        block11: {
            SOAPFactory sOAPFactory = new SOAPFactory();
            if (_dbf == null) {
                try {
                    _dbf = DocumentBuilderFactory.newInstance();
                    _dbf.setNamespaceAware(true);
                    _db = _dbf.newDocumentBuilder();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    FFDCFilter.processException((Throwable)parserConfigurationException, "com.ibm.ws.wsaddressing.handlers.InboundWSAProcessor.getSOAP1_2FaultMsg", "1:892:1.26.1.1", sOAPFactory);
                }
            }
            SOAPBody sOAPBody = null;
            sOAPFault = null;
            try {
                String string5 = "http://schemas.xmlsoap.org/soap/envelope/";
                String string6 = "soapenv";
                if (sOAPMessage != null) {
                    sOAPBody = (SOAPBody)sOAPMessage.getSOAPBody();
                    string5 = sOAPBody.getNamespaceURI();
                    string6 = sOAPBody.getPrefix();
                }
                String string7 = InboundWSAProcessor.getXML_SOAP1_2(string6, string5, string, string2, string3, string4);
                InputSource inputSource = new InputSource(new StringReader(string7));
                Document document = _db.parse(inputSource);
                Element element = document.getDocumentElement();
                sOAPFault = (SOAPFault)sOAPFactory.createElementFromDOMElement(element, SOAPFault.class);
                if (sOAPMessage != null) {
                    sOAPBody.addChildElement(sOAPFault);
                }
            }
            catch (SOAPException sOAPException) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    sOAPException.printStackTrace(printWriter);
                    Tr.debug(TRACE_COMPONENT, "Unexpected Exception " + stringWriter.toString());
                }
            }
            catch (SAXException sAXException) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    sAXException.printStackTrace(printWriter);
                    Tr.debug(TRACE_COMPONENT, "Unexpected Exception " + stringWriter.toString());
                }
            }
            catch (IOException iOException) {
                if (!TRACE_COMPONENT.isDebugEnabled()) break block11;
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                iOException.printStackTrace(printWriter);
                Tr.debug(TRACE_COMPONENT, "Unexpected Exception " + stringWriter.toString());
            }
        }
        return sOAPFault;
    }

    private static SOAPFault getSOAP1_2FaultMsg(SOAPMessage sOAPMessage, Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        Throwable throwable = exception.getCause();
        String string = "";
        if (throwable != null) {
            string = throwable.getMessage();
        }
        return InboundWSAProcessor.getSOAP1_2FaultMsg(sOAPMessage, exception.toString(), exception.getMessage(), string, stringWriter.toString());
    }

    private static String getXML_SOAP1_2(String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\"?>\n");
        stringBuffer.append("<" + string + ":Fault xmlns:" + string + "=\"" + string2 + "\"" + ">\n");
        stringBuffer.append("<" + string + ":Code>\n");
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append("<" + string + ":Value>" + InboundWSAProcessor.encode(string3) + "</" + string + ":Value>\n");
        }
        if (string4 != null && string4.length() > 0) {
            stringBuffer.append("<" + string + ":Subcode>\n");
            stringBuffer.append("<" + string + ":Value>" + InboundWSAProcessor.encode(string4) + "</" + string + ":Value>\n");
            stringBuffer.append("</" + string + ":Subcode>\n");
        }
        stringBuffer.append("</" + string + ":Code>\n");
        if (string5 != null && string5.length() > 0) {
            stringBuffer.append("<" + string + ":Reason>\n");
            stringBuffer.append("<" + string + ":Text xml:lang=\"en\">" + InboundWSAProcessor.encode(string5) + "</" + string + ":Text>\n");
            stringBuffer.append("</" + string + ":Reason>\n");
        }
        if (string6 != null && string6.length() > 0) {
            stringBuffer.append("<" + string + ":Detail>\n" + InboundWSAProcessor.encode(string6) + "</" + string + ":Detail>\n");
        }
        stringBuffer.append("</" + string + ":Fault>");
        return stringBuffer.toString();
    }

    private static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void setFaultCode(QName qName) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setFaultCode faultSubcode[" + qName + "]");
        }
        this._faultCode = qName;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setFaultCode");
        }
    }

    public QName getFaultCode() {
        return this._faultCode;
    }

    public SOAPFaultException getSoapFaultException() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSoapFaultException");
        }
        SOAPFaultException sOAPFaultException = null;
        if (this._faultCode != null) {
            String string = this.getSoapFault().getFaultActor();
            String string2 = this.getSoapFault().getFaultString();
            Detail detail = this.getSoapFault().getDetail();
            QName qName = this.getSoapFault().getFaultCodeAsQName();
            sOAPFaultException = new SOAPFaultException(qName, string2, string, detail);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSoapFaultException result[" + sOAPFaultException + "]");
        }
        return sOAPFaultException;
    }

    private String getFaultDetail() {
        return this._faultDetail;
    }

    private void setFaultDetail(Name name2) {
        this.setFaultDetail(name2.getLocalName());
    }

    private void setFaultDetail(String string) {
        this._context.setProperty("com.ibm.ws.wsaddressing.soapfault.detail", (Object)string);
        this._faultDetail = string;
    }
}

