/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.wsaddressing.EndpointReferenceImpl;
import com.ibm.ws.wsaddressing.ReferenceParameter;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.binders.AttributedURIBinder;
import com.ibm.ws.wsaddressing.binders.EndpointReferenceTypeBinder;
import com.ibm.ws.wsaddressing.binders.RelationshipBinder;
import com.ibm.ws.wsaddressing.handlers.WSAOutboundProperties;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.Relationship;
import java.util.Iterator;
import java.util.Set;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class MAPWriter {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.MAPWriter";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(MAPWriter.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private static AttributedURIBinder _attributedURIBinder = new AttributedURIBinder();
    private static RelationshipBinder _relationshipBinder = new RelationshipBinder();
    private static EndpointReferenceTypeBinder _endpointReferenceTypeBinder = new EndpointReferenceTypeBinder();

    public SOAPHeader getSOAPHeaderFromMessageContext(SOAPMessageContext sOAPMessageContext) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPHeaderFromMessageContext", sOAPMessageContext);
        }
        SOAPHeader sOAPHeader = null;
        SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
        if (sOAPMessage != null && (sOAPHeader = sOAPMessage.getSOAPHeader()) == null) {
            SOAPMessage sOAPMessage2 = sOAPMessageContext.getMessage();
            SOAPPart sOAPPart = sOAPMessage2.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            sOAPHeader = sOAPEnvelope.addHeader();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPHeaderFromMessageContext", sOAPHeader);
        }
        return sOAPHeader;
    }

    public void addPropertiesToSoapHeader(SOAPHeader sOAPHeader, WSAOutboundProperties wSAOutboundProperties) throws JAXRPCException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addPropertiesToSoapHeader", new Object[]{sOAPHeader, wSAOutboundProperties});
        }
        SOAPFactory sOAPFactory = ((SOAPElement)sOAPHeader).getSOAPFactory();
        try {
            Name name2 = null;
            if (wSAOutboundProperties.mustUnderstand()) {
                name2 = sOAPFactory.createName("mustUnderstand", "soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
            }
            this.addAttributedURIToHeader(wSAOutboundProperties.getWsaddressingDestinationURI(), wSAOutboundProperties.getNamespaceData().getwsaTo(), sOAPHeader, sOAPFactory, name2);
            EndpointReferenceImpl endpointReferenceImpl = (EndpointReferenceImpl)wSAOutboundProperties.getWsaddressingDestinationEpr();
            this.addReferenceParametersToSOAPHeader(endpointReferenceImpl, sOAPHeader, wSAOutboundProperties);
            this.addAttributedURIToHeader(wSAOutboundProperties.getWsaddressingAction(), wSAOutboundProperties.getNamespaceData().getwsaAction(), sOAPHeader, sOAPFactory, name2);
            this.addAttributedURIToHeader(wSAOutboundProperties.getWsaddressingMessageId(), wSAOutboundProperties.getNamespaceData().getwsaMessageID(), sOAPHeader, sOAPFactory, name2);
            this.addEPRToHeader(wSAOutboundProperties.getWsaddressingFaultToEpr(), wSAOutboundProperties.getNamespaceData().getwsaFaultTo(), sOAPHeader, sOAPFactory, name2);
            this.addEPRToHeader(wSAOutboundProperties.getWsaddressingFromEpr(), wSAOutboundProperties.getNamespaceData().getwsaFrom(), sOAPHeader, sOAPFactory, name2);
            this.addEPRToHeader(wSAOutboundProperties.getWsaddressingReplyToEpr(), wSAOutboundProperties.getNamespaceData().getwsaReplyTo(), sOAPHeader, sOAPFactory, name2);
            Set set = wSAOutboundProperties.getWsaddressingRelationshipSet();
            if (set != null) {
                Iterator iterator = set.iterator();
                Name name3 = wSAOutboundProperties.getNamespaceData().getwsaRelatesTo();
                while (iterator.hasNext()) {
                    this.addRelationshipToHeader((Relationship)iterator.next(), name3, sOAPHeader, sOAPFactory, wSAOutboundProperties, name2);
                }
            }
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.wsaddressing.handlers.MAPWriter.addPropertiesToSoapHeader", "1:175:1.9", this);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "addPropertiesToSoapHeader");
            }
            throw new JAXRPCException((Throwable)sOAPException);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addPropertiesToSoapHeader");
        }
    }

    private void addReferenceParametersToSOAPHeader(EndpointReferenceImpl endpointReferenceImpl, SOAPHeader sOAPHeader, WSAOutboundProperties wSAOutboundProperties) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addReferenceParametersToSOAPHeader", endpointReferenceImpl);
        }
        if (endpointReferenceImpl != null) {
            Iterator iterator = endpointReferenceImpl.getReferenceParameters();
            while (iterator.hasNext()) {
                ReferenceParameter referenceParameter = (ReferenceParameter)iterator.next();
                this.addReferenceParameterToHeader(referenceParameter, sOAPHeader, wSAOutboundProperties);
            }
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addReferenceParametersToSOAPHeader", "The provided DestinationEPR was null");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addReferenceParametersToSOAPHeader");
        }
    }

    protected void addNamespaceDeclarationToSOAPEnvelope(SOAPMessageContext sOAPMessageContext, NamespaceData namespaceData) throws SOAPException {
        SOAPMessage sOAPMessage;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addNameSpaceDeclarationToSOAPEnvelope", new Object[]{sOAPMessageContext, namespaceData});
        }
        if ((sOAPMessage = sOAPMessageContext.getMessage()) != null && namespaceData != null) {
            SOAPPart sOAPPart;
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "addNameSpaceDeclarationToSOAPEnvelope", "The SOAPMessage was not null. Adding Namespace Declaration");
            }
            if ((sOAPPart = sOAPMessage.getSOAPPart()) != null) {
                SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
                sOAPEnvelope.addNamespaceDeclaration("wsa", namespaceData.getNamespace());
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addNameSpaceDeclarationToSOAPEnvelope");
        }
    }

    private void addEPRToHeader(EndpointReference endpointReference, Name name2, SOAPHeader sOAPHeader, javax.xml.soap.SOAPFactory sOAPFactory, Name name3) throws SOAPException {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{endpointReference, name2, sOAPHeader, sOAPFactory};
            Tr.entry(TRACE_COMPONENT, "addEPRToHeader", objectArray);
        }
        if (endpointReference != null && name2 != null) {
            objectArray = sOAPFactory.createElement(name2);
            if (name3 != null) {
                this.addMustUnderstand((javax.xml.soap.SOAPElement)objectArray, name3);
            }
            javax.xml.soap.SOAPElement sOAPElement = _endpointReferenceTypeBinder.serialize(endpointReference, (javax.xml.soap.SOAPElement)objectArray, null);
            sOAPHeader.addChildElement(sOAPElement);
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addEPRToHeader", "Either epr or name was null so no header added:" + endpointReference + ", " + name2);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addEPRToHeader");
        }
    }

    private void addAttributedURIToHeader(AttributedURI attributedURI, Name name2, SOAPHeader sOAPHeader, javax.xml.soap.SOAPFactory sOAPFactory, Name name3) throws SOAPException {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{attributedURI, name2, sOAPHeader, sOAPFactory};
            Tr.entry(TRACE_COMPONENT, "addAttributedURIToHeader", objectArray);
        }
        if (attributedURI != null && name2 != null) {
            objectArray = sOAPFactory.createElement(name2);
            if (name3 != null) {
                this.addMustUnderstand((javax.xml.soap.SOAPElement)objectArray, name3);
            }
            javax.xml.soap.SOAPElement sOAPElement = _attributedURIBinder.serialize(attributedURI, (javax.xml.soap.SOAPElement)objectArray, null);
            sOAPHeader.addChildElement(sOAPElement);
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addAttributedURIToHeader", "Either auri or name was null so no header added:" + attributedURI + ", " + name2);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addAttributedURIToHeader");
        }
    }

    private void addRelationshipToHeader(Relationship relationship, Name name2, SOAPHeader sOAPHeader, javax.xml.soap.SOAPFactory sOAPFactory, WSAOutboundProperties wSAOutboundProperties, Name name3) throws SOAPException {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{relationship, name2, sOAPHeader, sOAPFactory};
            Tr.entry(TRACE_COMPONENT, "addRelationshipToHeader", objectArray);
        }
        if (relationship != null && name2 != null) {
            objectArray = sOAPFactory.createElement(name2);
            if (name3 != null) {
                this.addMustUnderstand((javax.xml.soap.SOAPElement)objectArray, name3);
            }
            javax.xml.soap.SOAPElement sOAPElement = _relationshipBinder.serialize(relationship, (javax.xml.soap.SOAPElement)objectArray, wSAOutboundProperties.getNamespaceData());
            sOAPHeader.addChildElement(sOAPElement);
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addRelationshipToHeader", "Either auri or name was null so no header added:" + relationship + ", " + name2);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addRelationshipToHeader");
        }
    }

    private void addStringToHeader(String string, Name name2, SOAPHeader sOAPHeader, javax.xml.soap.SOAPFactory sOAPFactory) throws SOAPException {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{string, name2, sOAPHeader, sOAPFactory};
            Tr.entry(TRACE_COMPONENT, "addStringToHeader", objectArray);
        }
        if (string != null && name2 != null) {
            objectArray = sOAPFactory.createElement(name2);
            objectArray.setValue(string);
            sOAPHeader.addChildElement((javax.xml.soap.SOAPElement)objectArray);
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addStringToHeader", "Either auri or name was null so no header added:" + string + ", " + name2);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addStringToHeader");
        }
    }

    private void addReferenceParameterToHeader(ReferenceParameter referenceParameter, SOAPHeader sOAPHeader, WSAOutboundProperties wSAOutboundProperties) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addReferenceParameterToHeader", referenceParameter);
        }
        if (referenceParameter != null) {
            javax.xml.soap.SOAPElement sOAPElement = referenceParameter.getSOAPElement();
            if (sOAPElement != null) {
                try {
                    Name name2 = wSAOutboundProperties.getNamespaceData().getwsaIsReferenceParameter();
                    if (name2 != null) {
                        while (sOAPElement.removeAttribute(name2)) {
                            if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                            Tr.debug(TRACE_COMPONENT, "wsa:IsReferenceParameter attribute removed before serialisation.");
                        }
                        sOAPElement.addAttribute(name2, "true");
                    }
                    sOAPHeader.addChildElement(sOAPElement);
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "addReferenceParameterToHeader", sOAPElement);
                    }
                }
                catch (SOAPException sOAPException) {
                    Object[] objectArray = new Object[]{"Could not add this reference parameter to the SOAPHeader.", sOAPElement};
                    Tr.debug(TRACE_COMPONENT, "addReferenceParameterToHeader", objectArray);
                }
            } else if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "addReferenceParameterToHeader", "SOAPElement was null, not adding a header");
            }
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addReferenceParameterToHeader", "Parameter nextRefParamToSerialize was null, not adding a header");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addReferenceParameterToHeader");
        }
    }

    private void addMustUnderstand(javax.xml.soap.SOAPElement sOAPElement, Name name2) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addMustUnderstand");
        }
        sOAPElement.addAttribute(name2, "1");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addMustUnderstand");
        }
    }
}

