/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.SSLInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.WebContainerInboundChannel;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.proxy.ProxyInboundChannel;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.component.WSAWSComponentImpl;
import com.ibm.ws.wsaddressing.urimap.Prefix;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class MetaDataChannelHelper {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.urimap.MetaDataChannelHelper";
    private static TraceComponent _tc = Tr.register(MetaDataChannelHelper.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    public static final String secure_http_protocol = "https";
    public static final String http_protocol = "http";
    private static List _webContainerPortList;
    private static List _proxyPortList;
    private static boolean _initialized;
    private static boolean _failed;
    private static String _hostName;

    private static synchronized void initialize(RepositoryContext repositoryContext) {
        block3: {
            if (!_initialized && !_failed) {
                try {
                    String string = WSAWSComponentImpl._server.getName();
                    String string2 = WSAWSComponentImpl._server.getNodeName();
                    RepositoryContext repositoryContext2 = repositoryContext.findContext("nodes/" + string2);
                    RepositoryContext repositoryContext3 = repositoryContext2.findContext("servers/" + string);
                    _hostName = MetaDataChannelHelper.resolveHostName(repositoryContext2);
                    _webContainerPortList = MetaDataChannelHelper.loadWebContainerPorts(repositoryContext2, repositoryContext3);
                    _proxyPortList = MetaDataChannelHelper.loadProxyHttpPorts(repositoryContext, repositoryContext2);
                    _initialized = true;
                }
                catch (Exception exception) {
                    _failed = true;
                    FFDCFilter.processException(exception, CLASSNAME, "1:123:1.1");
                    if (!_tc.isDebugEnabled()) break block3;
                    Tr.debug(_tc, "initialize caught exeption ", exception);
                }
            }
        }
    }

    private static Map getEndPointMap(TransportChannelService transportChannelService) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getEndPointMap", new Object[]{transportChannelService});
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        EList eList = transportChannelService.getChains();
        Iterator iterator = eList.iterator();
        for (int i = 0; i < eList.size(); ++i) {
            Chain chain = (Chain)eList.get(i);
            if (!MetaDataChannelHelper.isTCPInbound(chain) || !MetaDataChannelHelper.isWebContainerInbound(chain)) continue;
            if (MetaDataChannelHelper.isSSLInbound(chain)) {
                hashMap.put(MetaDataChannelHelper.getEndPointName(chain), secure_http_protocol);
                continue;
            }
            hashMap.put(MetaDataChannelHelper.getEndPointName(chain), http_protocol);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEndPointMap", new Object[]{hashMap});
        }
        return hashMap;
    }

    private static Map getProxyEndPointMap(TransportChannelService transportChannelService) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getProxyEndPointMap", new Object[]{transportChannelService});
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        EList eList = transportChannelService.getChains();
        Iterator iterator = eList.iterator();
        for (int i = 0; i < eList.size(); ++i) {
            Chain chain = (Chain)eList.get(i);
            if (!MetaDataChannelHelper.isTCPInbound(chain) || !MetaDataChannelHelper.isProxyInbound(chain)) continue;
            if (MetaDataChannelHelper.isSSLInbound(chain)) {
                hashMap.put(MetaDataChannelHelper.getEndPointName(chain), secure_http_protocol);
                continue;
            }
            hashMap.put(MetaDataChannelHelper.getEndPointName(chain), http_protocol);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getProxyEndPointMap", new Object[]{hashMap});
        }
        return hashMap;
    }

    private static TransportChannel getFirstChannel(Chain chain) {
        if (chain == null || chain.getTransportChannels() == null || chain.getTransportChannels().isEmpty()) {
            return null;
        }
        return (TransportChannel)chain.getTransportChannels().get(0);
    }

    private static TransportChannel getLastChannel(Chain chain) {
        if (chain == null || chain.getTransportChannels() == null || chain.getTransportChannels().isEmpty()) {
            return null;
        }
        EList eList = chain.getTransportChannels();
        return (TransportChannel)eList.get(eList.size() - 1);
    }

    private static boolean isTCPInbound(Chain chain) {
        TransportChannel transportChannel = MetaDataChannelHelper.getFirstChannel(chain);
        return transportChannel != null && transportChannel instanceof TCPInboundChannel;
    }

    private static boolean isWebContainerInbound(Chain chain) {
        TransportChannel transportChannel = MetaDataChannelHelper.getLastChannel(chain);
        return transportChannel != null && transportChannel instanceof WebContainerInboundChannel;
    }

    private static boolean isProxyInbound(Chain chain) {
        TransportChannel transportChannel = MetaDataChannelHelper.getLastChannel(chain);
        return transportChannel != null && transportChannel instanceof ProxyInboundChannel;
    }

    private static String getEndPointName(Chain chain) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getEndPointMap");
        }
        String string = "";
        TransportChannel transportChannel = MetaDataChannelHelper.getFirstChannel(chain);
        if (transportChannel != null && transportChannel instanceof TCPInboundChannel) {
            string = ((TCPInboundChannel)transportChannel).getEndPointName();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEndPointMap, endPointName: " + string);
        }
        return string;
    }

    private static boolean isSSLInbound(Chain chain) {
        if (chain == null || chain.getTransportChannels() == null || chain.getTransportChannels().isEmpty()) {
            return false;
        }
        EList eList = chain.getTransportChannels();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            TransportChannel transportChannel = (TransportChannel)iterator.next();
            if (!(transportChannel instanceof SSLInboundChannel)) continue;
            return true;
        }
        return false;
    }

    private static List loadProxyHttpPorts(RepositoryContext repositoryContext, RepositoryContext repositoryContext2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadProxyHttpPorts");
        }
        LinkedList linkedList = new LinkedList();
        MetaDataChannelHelper.loadProxyHttpPortsForLocalNode(repositoryContext2, linkedList);
        if (linkedList.isEmpty()) {
            MetaDataChannelHelper.loadProxyHttpPortsOffNode(repositoryContext, linkedList);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadProxyHttpPorts");
        }
        return linkedList;
    }

    private static void loadProxyHttpPortsOffNode(RepositoryContext repositoryContext, List list) {
        block9: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "loadProxyHttpPortsOffNode");
            }
            try {
                RepositoryContextType repositoryContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("nodes");
                Collection collection = repositoryContext.findContext(repositoryContextType);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
                    ResourceSet resourceSet = repositoryContext2.getResourceSet();
                    Resource resource = resourceSet.getResource(URI.createURI((String)"serverindex.xml"), true);
                    ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                    String string = serverIndex.getHostName();
                    EList eList = serverIndex.getServerEntries();
                    boolean bl = false;
                    ServerEntry serverEntry = null;
                    Iterator iterator2 = eList.iterator();
                    while (iterator2.hasNext()) {
                        serverEntry = (ServerEntry)iterator2.next();
                        String string2 = serverEntry.getServerType();
                        if (string2 == null || !string2.equals("PROXY_SERVER")) continue;
                        String string3 = serverEntry.getServerName();
                        EList eList2 = serverEntry.getSpecialEndpoints();
                        NamedEndPoint namedEndPoint = null;
                        String string4 = null;
                        String string5 = null;
                        int n = 0;
                        EndPoint endPoint = null;
                        Iterator iterator3 = eList2.iterator();
                        while (iterator3.hasNext()) {
                            namedEndPoint = (NamedEndPoint)iterator3.next();
                            endPoint = namedEndPoint.getEndPoint();
                            string4 = namedEndPoint.getEndPointName();
                            string5 = endPoint.getHost();
                            if (string5.equals("*")) {
                                string5 = string;
                            }
                            n = endPoint.getPort();
                            String string6 = new Integer(n).toString();
                            if (string4.equals("PROXY_HTTP_ADDRESS")) {
                                list.add(new Prefix(http_protocol, string5, string6));
                                continue;
                            }
                            if (!string4.equals("PROXY_HTTPS_ADDRESS")) continue;
                            list.add(new Prefix(secure_http_protocol, string5, string6));
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASSNAME, "1:442:1.1");
                if (!_tc.isDebugEnabled()) break block9;
                Tr.debug(_tc, "loadProxyHttpPortsOffNode caught exeption ", exception);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadProxyHttpPortsOffNode");
        }
    }

    private static void loadProxyHttpPortsForLocalNode(RepositoryContext repositoryContext, List list) {
        block5: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "loadProxyHttpPortsForLocalNode");
            }
            try {
                ResourceSet resourceSet = repositoryContext.getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI((String)"serverindex.xml"), true);
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                EList eList = serverIndex.getServerEntries();
                boolean bl = false;
                ServerEntry serverEntry = null;
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    serverEntry = (ServerEntry)iterator.next();
                    String string = serverEntry.getServerType();
                    if (string == null || !string.equals("PROXY_SERVER")) continue;
                    String string2 = serverEntry.getServerName();
                    RepositoryContext repositoryContext2 = repositoryContext.findContext("servers/" + string2);
                    TransportChannelService transportChannelService = MetaDataChannelHelper.findTransportChannelService(repositoryContext2);
                    if (transportChannelService == null) continue;
                    MetaDataChannelHelper.loadHTTPProxyPortsFromV6Template(transportChannelService, serverEntry, list);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASSNAME, "1:495:1.1");
                if (!_tc.isDebugEnabled()) break block5;
                Tr.debug(_tc, "loadProxyHttpPortsForLocalNode caught exeption ", exception);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadProxyHttpPortsForLocalNode");
        }
    }

    private static void loadHTTPProxyPortsFromV6Template(TransportChannelService transportChannelService, ServerEntry serverEntry, List list) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadHTTPProxyPortsFromV6Template");
        }
        Map map = MetaDataChannelHelper.getProxyEndPointMap(transportChannelService);
        MetaDataChannelHelper.mergeV6EndPoints2Ports(map, serverEntry, _hostName, list);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadHTTPProxyPortsFromV6Template");
        }
    }

    private static TransportChannelService findTransportChannelService(RepositoryContext repositoryContext) {
        TransportChannelService transportChannelService;
        block6: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "findTransportChannelService");
            }
            transportChannelService = null;
            try {
                ResourceSet resourceSet = repositoryContext.getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI((String)"server.xml"), true);
                Server server2 = (Server)resource.getContents().get(0);
                String string = server2.getName();
                EList eList = server2.getServices();
                Object var7_8 = null;
                HashMap hashMap = new HashMap();
                boolean bl = false;
                TransportChannelService transportChannelService2 = null;
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    Service service = (Service)iterator.next();
                    if (!(service instanceof TransportChannelService)) continue;
                    transportChannelService2 = (TransportChannelService)service;
                    EList eList2 = transportChannelService2.getTransportChannels();
                    if (!eList2.isEmpty()) {
                        transportChannelService = transportChannelService2;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASSNAME, "1:565:1.1");
                if (!_tc.isDebugEnabled()) break block6;
                Tr.debug(_tc, "findTransportChannelService caught exeption ", exception);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "findTransportChannelService");
        }
        return transportChannelService;
    }

    private static List loadWebContainerPorts(RepositoryContext repositoryContext, RepositoryContext repositoryContext2) {
        LinkedList linkedList;
        block10: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "loadWebContainerPorts");
            }
            linkedList = new LinkedList();
            try {
                ResourceSet resourceSet = repositoryContext2.getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI((String)"server.xml"), true);
                Server server2 = (Server)resource.getContents().get(0);
                String string = server2.getName();
                EList eList = server2.getServices();
                TransportChannelService transportChannelService = null;
                Object var9_10 = null;
                HashMap hashMap = new HashMap();
                transportChannelService = MetaDataChannelHelper.findTransportChannelService(repositoryContext2);
                EList eList2 = server2.getComponents();
                WebContainer webContainer = null;
                boolean bl = false;
                Iterator iterator = eList2.iterator();
                block2: while (iterator.hasNext() && !bl) {
                    Component component2 = (Component)iterator.next();
                    if (!(component2 instanceof ApplicationServer)) continue;
                    ApplicationServer applicationServer = (ApplicationServer)component2;
                    EList eList3 = applicationServer.getComponents();
                    Iterator iterator2 = eList3.iterator();
                    while (iterator2.hasNext()) {
                        Component component3 = (Component)iterator2.next();
                        if (!(component3 instanceof WebContainer)) continue;
                        webContainer = (WebContainer)component3;
                        bl = true;
                        continue block2;
                    }
                }
                if (webContainer != null && bl) {
                    MetaDataChannelHelper.loadHTTPPortsFromV5Template(server2, (List)eList2, webContainer, linkedList);
                }
                if (transportChannelService != null) {
                    MetaDataChannelHelper.loadHTTPPortsFromV6Template(transportChannelService, repositoryContext, server2, string, linkedList);
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "loadWebContainerPorts could not find any http or https ports");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASSNAME, "1:648:1.1");
                if (!_tc.isDebugEnabled()) break block10;
                Tr.debug(_tc, "loadWebContainerPorts caught exeption ", exception);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadWebContainerPorts");
        }
        return linkedList;
    }

    private static void loadHTTPPortsFromV6Template(TransportChannelService transportChannelService, RepositoryContext repositoryContext, Server server2, String string, List list) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadHTTPPortsFromV6Template");
        }
        Map map = MetaDataChannelHelper.getEndPointMap(transportChannelService);
        ServerEntry serverEntry = MetaDataChannelHelper.findServerEntry(repositoryContext, string);
        MetaDataChannelHelper.mergeV6EndPoints2Ports(map, serverEntry, _hostName, list);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadHTTPPortsFromV6Template");
        }
    }

    private static void mergeV6EndPoints2Ports(Map map, ServerEntry serverEntry, String string, List list) {
        block7: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "mergeV6EndPoints2Ports");
            }
            try {
                if (serverEntry != null) {
                    EList eList = serverEntry.getSpecialEndpoints();
                    NamedEndPoint namedEndPoint = null;
                    String string2 = null;
                    Iterator iterator = eList.iterator();
                    while (iterator.hasNext()) {
                        namedEndPoint = (NamedEndPoint)iterator.next();
                        string2 = namedEndPoint.getEndPointName();
                        EndPoint endPoint = null;
                        String string3 = null;
                        String string4 = (String)map.get(string2);
                        String string5 = null;
                        if (string4 == null || string4.length() <= 0) continue;
                        endPoint = namedEndPoint.getEndPoint();
                        string3 = new Integer(endPoint.getPort()).toString();
                        string5 = endPoint.getHost();
                        if (string5.equals("*")) {
                            string5 = string;
                        }
                        list.add(new Prefix(string4, string5, string3));
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASSNAME, "1:716:1.1");
                if (!_tc.isDebugEnabled()) break block7;
                Tr.debug(_tc, "mergeV6EndPoints2Ports caught exeption ", exception);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "mergeV6EndPoints2Ports");
        }
    }

    private static ServerEntry findServerEntry(RepositoryContext repositoryContext, String string) {
        ServerEntry serverEntry;
        block5: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "findServerEntry");
            }
            serverEntry = null;
            try {
                ResourceSet resourceSet = repositoryContext.getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI((String)"serverindex.xml"), true);
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                EList eList = serverIndex.getServerEntries();
                boolean bl = false;
                ServerEntry serverEntry2 = null;
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    serverEntry2 = (ServerEntry)iterator.next();
                    String string2 = serverEntry2.getServerName();
                    if (string2 == null || !(serverEntry2 instanceof ServerEntry) || !string2.equals(string)) continue;
                    serverEntry = serverEntry2;
                    break;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASSNAME, "1:754:1.1");
                if (!_tc.isDebugEnabled()) break block5;
                Tr.debug(_tc, "findServerEntry caught exeption ", exception);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "findServerEntry");
        }
        return serverEntry;
    }

    private static void loadHTTPPortsFromV5Template(Server server2, List list, WebContainer webContainer, List list2) {
        block6: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "loadHTTPPortsFromV5Template");
            }
            try {
                EList eList = webContainer.getTransports();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    HTTPTransport hTTPTransport;
                    EndPoint endPoint;
                    Transport transport2 = (Transport)iterator.next();
                    if (!(transport2 instanceof HTTPTransport) || (endPoint = (hTTPTransport = (HTTPTransport)transport2).getAddress()) == null) continue;
                    String string = new Integer(endPoint.getPort()).toString();
                    String string2 = hTTPTransport.isSslEnabled() ? secure_http_protocol : http_protocol;
                    String string3 = endPoint.getHost();
                    list2.add(new Prefix(string2, string3, string));
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "loadHTTPPortsFromV5Template: for server \"" + server2.getName() + "\" the container is [" + webContainer.toString() + "}");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASSNAME, "1:801:1.1");
                if (!_tc.isDebugEnabled()) break block6;
                Tr.debug(_tc, "loadHTTPPortsFromV5Template caught exeption ", exception);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadHTTPPortsfromV5Template");
        }
    }

    private static String resolveHostName(RepositoryContext repositoryContext) {
        String string = null;
        try {
            ResourceSet resourceSet = repositoryContext.getResourceSet();
            Resource resource = resourceSet.getResource(URI.createURI((String)"serverindex.xml"), true);
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            string = serverIndex.getHostName();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, CLASSNAME, "1:824:1.1");
            Tr.error(_tc, "resolveHostName internal.error", exception);
        }
        return string;
    }

    static List getWebContainerPortList(RepositoryContext repositoryContext) {
        if (!_initialized) {
            MetaDataChannelHelper.initialize(repositoryContext);
        }
        return _webContainerPortList;
    }

    static List getProxyPortList(RepositoryContext repositoryContext) {
        if (!_initialized) {
            MetaDataChannelHelper.initialize(repositoryContext);
        }
        return _proxyPortList;
    }

    static String getHostName(RepositoryContext repositoryContext) {
        if (!_initialized) {
            MetaDataChannelHelper.initialize(repositoryContext);
        }
        return _hostName;
    }

    static {
        _initialized = false;
        _failed = false;
    }
}

