/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.urimap.CFWHelper;
import com.ibm.ws.wsaddressing.urimap.ModuleData;
import com.ibm.ws.wsaddressing.urimap.PortURIManager;
import com.ibm.ws.wsaddressing.urimap.SecurityInfo;
import com.ibm.ws.wsaddressing.urimap.SecurityInfoTable;
import com.ibm.ws.wsaddressing.urimap.URIData;
import com.ibm.ws.wsaddressing.urimap.WebserviceDescriptionInfo;
import com.ibm.ws.wswebcontainer.webapp.WebApp;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import com.ibm.wsspi.wsaddressing.URIGenerationException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.UserDataConstraint;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;

public class PortURIManagerImpl
extends PortURIManager {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.urimap.PortURIManagerImpl";
    private static TraceComponent _tc = Tr.register(PortURIManagerImpl.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private static final HashMap _portURIMap = new HashMap();
    private static final HashMap _applicationPorts = new HashMap();
    private static final HashMap _securityITMap = new HashMap();
    private static final HashMap _moduleMap = new HashMap();

    public void addApplicationPortQName(String string, String string2, QName qName) {
        HashSet<PortKey> hashSet;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addPortQNameURL", new Object[]{string, string2, qName});
        }
        if ((hashSet = (HashSet<PortKey>)_applicationPorts.get(string)) == null) {
            hashSet = new HashSet<PortKey>();
            _applicationPorts.put(string, hashSet);
        }
        PortKey portKey = new PortKey(string2, qName);
        hashSet.add(portKey);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addPortQNameURL");
        }
    }

    protected void removeURIData(String string, PortKey portKey) {
        Set set;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeURIData", new Object[]{string, portKey});
        }
        if ((set = (Set)_portURIMap.get(portKey)) != null) {
            Object[] objectArray = set.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                URIData uRIData = (URIData)objectArray[i];
                if (!uRIData.getApplicationName().equals(string)) continue;
                set.remove(uRIData);
            }
            if (set.size() == 0) {
                _portURIMap.remove(portKey);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeURIData Application");
        }
    }

    public void addPortURIData(String string, QName qName, URIData uRIData) {
        PortKey portKey;
        HashSet<URIData> hashSet;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addPortURIData service ", new Object[]{string, qName, uRIData});
        }
        if ((hashSet = (HashSet<URIData>)_portURIMap.get(portKey = new PortKey(string, qName))) == null) {
            hashSet = new HashSet<URIData>();
            _portURIMap.put(portKey, hashSet);
        }
        hashSet.add(uRIData);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addPortURIData");
        }
    }

    protected void processSecurityData(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processSecurityData", string);
        }
        SecurityInfoTable securityInfoTable = (SecurityInfoTable)_securityITMap.get(string);
        ModuleData moduleData = (ModuleData)_moduleMap.get(string);
        if (moduleData == null) {
            return;
        }
        String string2 = moduleData.getApplicationName();
        if (securityInfoTable != null) {
            Object object;
            Object object2;
            Object object3;
            String string3;
            String string4;
            boolean bl;
            boolean bl2;
            Object object4;
            Object object5;
            block18: {
                object5 = null;
                object4 = null;
                bl2 = false;
                bl = false;
                string4 = moduleData.getDefaultJMSPrefix();
                string3 = this.trimSlash(moduleData.getContextRoot());
                List list = moduleData.getPrefixList();
                list.add(0, moduleData.getDefaultPrefix());
                try {
                    for (int i = 0; i < list.size(); ++i) {
                        object3 = list.get(i).toString();
                        if ("://:".equals(((String)object3).trim())) continue;
                        object2 = URI.create((String)object3);
                        object = ((URI)object2).getScheme();
                        if (((String)object).equals("https")) {
                            if (!bl) {
                                object4 = object3;
                                bl = true;
                            }
                        } else if (((String)object).equals("http") && !bl2) {
                            object5 = object3;
                            bl2 = true;
                        }
                        if (!bl2 || !bl) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, CLASSNAME, "1:333:1.17");
                    if (!_tc.isDebugEnabled()) break block18;
                    Tr.debug(_tc, "processSecurityData", "Exception caught whilst determining http or https prefix.");
                }
            }
            List list = moduleData.getWebservicesDescritions();
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (WebserviceDescriptionInfo)object3.next();
                object = ((WebserviceDescriptionInfo)object2).getQNameToUrlPatternMap();
                Map map = ((WebserviceDescriptionInfo)object2).getQnameToPortComponentNameMap();
                Set set = object.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    QName qName = (QName)iterator.next();
                    String string5 = ((WebserviceDescriptionInfo)object2).getWebserviceDescriptionName();
                    this.addApplicationPortQName(string2, string5, qName);
                    try {
                        URIData uRIData;
                        String string6 = (String)object.get(qName);
                        boolean bl3 = securityInfoTable.isSSLEnabled("/" + string6);
                        if (bl2 && !bl3) {
                            uRIData = new URIData(string2, (String)object5 + "/" + string3 + "/" + string6, moduleData.getVirtualHostName(), moduleData.isIntermediaryPresent());
                            this.addPortURIData(string5, qName, uRIData);
                        }
                        if (bl && bl3) {
                            uRIData = new URIData(string2, (String)object4 + "/" + string3 + "/" + string6, moduleData.getVirtualHostName(), moduleData.isIntermediaryPresent());
                            this.addPortURIData(string5, qName, uRIData);
                        }
                        if (string4 == null || string4.equals("")) continue;
                        uRIData = new URIData(string2, string4 + '&' + "targetService" + '=' + map.get(qName), moduleData.getVirtualHostName(), false);
                        this.addPortURIData(string5, qName, uRIData);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, CLASSNAME, "1:404:1.17");
                        if (!_tc.isDebugEnabled()) continue;
                        Tr.debug(_tc, "processSecurityData", "Exception caught whilst determing prefix of URL pattern");
                    }
                }
            }
            _securityITMap.remove(string);
        }
        _moduleMap.remove(string);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processSecurityData");
        }
    }

    public synchronized void addSysAppPortMappingsImpl(String string, String string2, QName qName, String string3) {
        block6: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "addSysAppPortMappingsImpl service " + string2 + " Port " + qName.toString() + " URLPattern " + string3);
            }
            this.addApplicationPortQName(string, string2, qName);
            try {
                URIData uRIData;
                if (CFWHelper.getHttpFound()) {
                    uRIData = new URIData(string, CFWHelper.getHttpPrefix() + "/_IBMSYSAPP" + "/" + string + "/" + string3, null);
                    this.addPortURIData(string2, qName, uRIData);
                }
                if (CFWHelper.getHttpsFound()) {
                    uRIData = new URIData(string, CFWHelper.getHttpsPrefix() + "/_IBMSYSAPP" + "/" + string + "/" + string3, null);
                    this.addPortURIData(string2, qName, uRIData);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASSNAME, "1:449:1.17");
                if (!_tc.isDebugEnabled()) break block6;
                Tr.debug(_tc, "addSysAppPortMappingsImpl", "Exception caught whilst adding uriData to the URIDataSet.");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addSysAppPortMappingsImpl");
        }
    }

    private String getContextRoot(WebApp webApp) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getContextRoot", webApp);
        }
        WebModuleMetaData webModuleMetaData = webApp.getModuleMetaData();
        WebAppConfig webAppConfig = webModuleMetaData.getConfiguration();
        String string = webAppConfig.getContextRoot();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getContextRoot", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addApplicationSecurityDataImpl(MetaDataEvent metaDataEvent) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addApplicationSecurityDataImpl", metaDataEvent);
        }
        try {
            DeployedModule deployedModule;
            Object object;
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = null;
            WebAppConfig webAppConfig = null;
            MetaData metaData = metaDataEvent.getMetaData();
            if (metaData instanceof WebModuleMetaData && (object = metaDataEvent.getDeployedObject()) instanceof DeployedModule && object.getModuleFile().isWARFile()) {
                deployedModule = (DeployedModule)object;
                webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)deployedModule.getDeploymentDescriptor();
                webAppConfig = ((WebModuleMetaData)metaData).getConfiguration();
            }
            if (webApp == null || webAppConfig == null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "addApplicationSecurityDataImpl", new Object[]{webApp, webAppConfig});
                }
                return;
            }
            object = this.trimSlash(webAppConfig.getContextRoot());
            deployedModule = webApp.getConstraints();
            EList eList = null;
            SecurityInfoTable securityInfoTable = new SecurityInfoTable();
            if (deployedModule != null && SecurityContext.isSecurityEnabled()) {
                if (_tc.isDebugEnabled()) {
                    Tr.warning(_tc, "addApplicationSecurityDataImpl found some Contraints");
                }
                Iterator iterator = deployedModule.iterator();
                while (iterator.hasNext()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.warning(_tc, "addApplicationSecurityDataImpl processing a Contraints");
                    }
                    SecurityConstraint securityConstraint = (SecurityConstraint)iterator.next();
                    UserDataConstraint userDataConstraint = securityConstraint.getUserDataConstraint();
                    int n = 0;
                    if (userDataConstraint != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.warning(_tc, "addApplicationSecurityDataImpl found a UserConstraint");
                        }
                        if (userDataConstraint.isSetTransportGuarantee()) {
                            n = userDataConstraint.getTransportGuarantee().getValue();
                        }
                    }
                    eList = securityConstraint.getWebResourceCollections();
                    Iterator iterator2 = eList.iterator();
                    while (iterator2.hasNext()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.warning(_tc, "addApplicationSecurityDataImpl processing a WebResourceCollection");
                        }
                        WebResourceCollection webResourceCollection = (WebResourceCollection)iterator2.next();
                        EList eList2 = webResourceCollection.getHttpMethod();
                        Iterator iterator3 = eList2.iterator();
                        boolean bl = false;
                        if (eList2.size() == 0) {
                            bl = true;
                        }
                        while (iterator3.hasNext() && !bl) {
                            if (_tc.isDebugEnabled()) {
                                Tr.warning(_tc, "addApplicationSecurityDataImpl processing an HTTPMethod");
                            }
                            if (1 != ((HTTPMethodTypeEnum)iterator3.next()).getValue()) continue;
                            bl = true;
                        }
                        if (!bl) continue;
                        EList eList3 = webResourceCollection.getUrlPattern();
                        SecurityInfo securityInfo = new SecurityInfo((List)eList3, n);
                        securityInfoTable.addSecurityInfo(securityInfo);
                        if (!_tc.isDebugEnabled()) continue;
                        Tr.warning(_tc, "addApplicationSecurityDataImpl found POST - added SInfo to Table");
                    }
                }
            }
            _securityITMap.put(object, securityInfoTable);
            this.processSecurityData((String)object);
        }
        catch (Exception exception) {
            if (_tc.isDebugEnabled()) {
                Tr.warning(_tc, "addApplicationSecurityDataImpl caught Exception " + exception);
            }
            FFDCFilter.processException(exception, CLASSNAME, "1:597:1.17");
        }
        catch (Throwable throwable) {
            if (_tc.isDebugEnabled()) {
                Tr.warning(_tc, "addApplicationSecurityDataImpl caught Throwable " + throwable);
            }
            FFDCFilter.processException(throwable, CLASSNAME, "1:602:1.17");
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "addApplicationSecurityDataImpl");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addApplicationPortMappingsImpl(WebApp webApp, Map map) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addApplicationPortMappingsImpl", new Object[]{webApp, map});
        }
        try {
            Object object;
            Collection collection = map.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (ModuleData)iterator.next();
                String string = this.trimSlash(((ModuleData)object).getContextRoot());
                _moduleMap.put(string, object);
            }
            object = this.trimSlash(this.getContextRoot(webApp));
            this.processSecurityData((String)object);
        }
        catch (Exception exception) {
            if (_tc.isDebugEnabled()) {
                Tr.warning(_tc, "addApplicationPortMappingsImpl caught Exception " + exception);
            }
            FFDCFilter.processException(exception, CLASSNAME, "1:647:1.17");
        }
        catch (Throwable throwable) {
            if (_tc.isDebugEnabled()) {
                Tr.warning(_tc, "addApplicationPortMappingsImpl caught Throwable " + throwable);
            }
            FFDCFilter.processException(throwable, CLASSNAME, "1:652:1.17");
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "addApplicationPortMappingsImpl");
            }
        }
    }

    public synchronized void removeApplicationPortMappingsImpl(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeApplicationPortMappingsImpl", string);
        }
        if (string == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "appName specified is null");
            }
            return;
        }
        Set set = (Set)_applicationPorts.get(string);
        if (set != null) {
            PortKey portKey;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                portKey = (PortKey)iterator.next();
            }
            iterator = set.iterator();
            while (iterator.hasNext()) {
                portKey = (PortKey)iterator.next();
                this.removeURIData(string, portKey);
            }
            _applicationPorts.remove(string);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "removeApplicationPortMappings could not find portKeySet for application " + string);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeApplicationPortMappingsImpl");
        }
    }

    public synchronized URI getSOAPAddressForPortImpl(String string, QName qName) throws URIGenerationException {
        PortKey portKey;
        Set set;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getSOAPAddressForPortImpl", new Object[]{string, qName});
        }
        if ((set = (Set)_portURIMap.get(portKey = new PortKey(string, qName))) == null) {
            return null;
        }
        if (set.size() > 1) {
            if (_tc.isEntryEnabled()) {
                Object[] objectArray = new Object[]{"URIDataSet.size() is > 1 so cannot determine one soap address for this webServiceName and port pair.", string, qName};
                Tr.exit(_tc, "getSOAPAddressForPortImpl", objectArray);
            }
            throw new URIGenerationException("The desired target endpoint has been deployed with multiple addresses.  Unable to determine a unique address URI for EndpointReference creation.");
        }
        Iterator iterator = set.iterator();
        URIData uRIData = (URIData)iterator.next();
        URI uRI = uRIData.getSOAPAddress();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getSOAPAddressForPortImpl", uRI);
        }
        return uRI;
    }

    protected String getVirtualHostForPortImpl(String string, QName qName) throws EndpointReferenceCreationException {
        PortKey portKey;
        Set set;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getVirtualHostForPortImpl", new Object[]{string, qName});
        }
        if ((set = (Set)_portURIMap.get(portKey = new PortKey(string, qName))) == null) {
            return null;
        }
        if (set.size() > 1) {
            if (_tc.isEntryEnabled()) {
                Object[] objectArray = new Object[]{"URIDataSet.size() is > 1 so cannot determine one virtual host for this webServiceName and port pair.", string, qName};
                Tr.exit(_tc, "getVirtualHostForPortImpl", objectArray);
            }
            throw new EndpointReferenceCreationException("The desired target endpoint has been deployed with multiple addresses.  Unable to determine a unique address virtual host for EndpointReference creation.");
        }
        Iterator iterator = set.iterator();
        URIData uRIData = (URIData)iterator.next();
        String string2 = uRIData.getVirtualHost();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getVirtualHostForPortImpl", string2);
        }
        return string2;
    }

    protected String trimSlash(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "trimSlash", string);
        }
        if (string == null) {
            return string;
        }
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "trimSlash", string);
        }
        return string;
    }

    public boolean intermediaryConfiguredImpl(String string, QName qName) throws EndpointReferenceCreationException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "intermediaryConfiguredImpl", new Object[]{string, qName});
        }
        boolean bl = false;
        PortKey portKey = new PortKey(string, qName);
        Set set = (Set)_portURIMap.get(portKey);
        if (set == null) {
            return false;
        }
        if (set.size() > 1) {
            if (_tc.isEntryEnabled()) {
                Object[] objectArray = new Object[]{"URIDataSet.size() is > 1 so cannot determine one virtual host for this webServiceName and port pair.", string, qName};
                Tr.exit(_tc, "intermediaryConfiguredImpl", objectArray);
            }
            throw new EndpointReferenceCreationException("The desired target endpoint has been deployed with multiple addresses.  Unable to determine a unique address virtual host for intermediary check.");
        }
        Iterator iterator = set.iterator();
        URIData uRIData = (URIData)iterator.next();
        bl = uRIData.isInteremdiaryPresent();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "intermediaryConfiguredImpl", bl ? "true" : "false");
        }
        return bl;
    }

    private class PortKey {
        private String webServiceName;
        private QName portQName;

        PortKey(String string, QName qName) {
            this.webServiceName = string;
            this.portQName = qName;
        }

        public String getWebServiceName() {
            return this.webServiceName;
        }

        public QName getPortQName() {
            return this.portQName;
        }

        public int hashCode() {
            return this.webServiceName.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof PortKey)) {
                return false;
            }
            PortKey portKey = (PortKey)object;
            if (this.webServiceName == null ? portKey.getWebServiceName() != null : !this.webServiceName.equals(portKey.getWebServiceName())) {
                return false;
            }
            return !(this.portQName == null ? portKey.getPortQName() != null : !this.portQName.equals(portKey.getPortQName()));
        }
    }
}

