/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsba;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.Work;
import com.ibm.websphere.wsba.BASystemException;
import com.ibm.ws.cscope.CompensationFailedException;
import com.ibm.ws.cscope.RetryCompensatorException;
import com.ibm.ws.wsba.CompensationHandlerWrapper;
import java.io.Serializable;

public class CompensationHandlerWork
implements Work,
Serializable {
    private static final TraceComponent tc = Tr.register(CompensationHandlerWork.class, "WSBA", "com.ibm.ws.wsba.resources.WSBAMessages");
    public static final int CLOSE = 0;
    public static final int COMPENSATE = 1;
    private int _compensationDirection = -1;
    private CompensationHandlerWrapper _compensationHandlerWrapper;
    private Throwable _exceptionThrown = null;
    private static final long serialVersionUID = -3075359013995778912L;

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run", this);
        }
        this.setExceptionThrown(null);
        if (this._compensationHandlerWrapper == null || this._compensationDirection == -1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CompensationHandlerWork object has not been set up correctly.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run", "BASystemException");
            }
            throw new BASystemException();
        }
        switch (this._compensationDirection) {
            case 0: {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Closing the CompensationHandler: ", this._compensationHandlerWrapper);
                    }
                    this._compensationHandlerWrapper.closeCompensationHandler();
                }
                catch (RetryCompensatorException retryCompensatorException) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Caught a RetryCompensatorException in the CompensationHandlerWork class. Marking it to be thrown later.");
                    }
                    this.setExceptionThrown(retryCompensatorException);
                }
                break;
            }
            case 1: {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Compensating the CompensationHandler: ", this._compensationHandlerWrapper);
                    }
                    this._compensationHandlerWrapper.compensateCompensationHandler();
                }
                catch (RetryCompensatorException retryCompensatorException) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Caught a RetryCompensatorException in the CompensationHandlerWork class. Marking it to be thrown later.");
                    }
                    this.setExceptionThrown(retryCompensatorException);
                }
                catch (CompensationFailedException compensationFailedException) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Caught a CompensationFailedException in the CompensationHandlerWork class. Marking it to be thrown later.");
                    }
                    this.setExceptionThrown(compensationFailedException);
                }
                break;
            }
            default: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Completion direction not recognised.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run", "BASystemException");
                }
                throw new BASystemException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    public void setCompensationDirection(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCompensationDirection", new Object[]{new Integer(n), this});
        }
        this._compensationDirection = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCompensationDirection");
        }
    }

    public void setCompensationHandlerWrapper(CompensationHandlerWrapper compensationHandlerWrapper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCompensationHandlerWrapper", new Object[]{compensationHandlerWrapper, this});
        }
        this._compensationHandlerWrapper = compensationHandlerWrapper;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCompensationHandlerWrapper");
        }
    }

    public Throwable getExceptionThrown() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExceptionThrown", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExceptionThrown", this._exceptionThrown);
        }
        return this._exceptionThrown;
    }

    public void setExceptionThrown(Throwable throwable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setExceptionThrown", new Object[]{throwable, this});
        }
        this._exceptionThrown = throwable;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setExceptionThrown");
        }
    }

    public void release() {
    }
}

