/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsba;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.Work;
import com.ibm.websphere.asynchbeans.WorkException;
import com.ibm.websphere.asynchbeans.WorkManager;
import com.ibm.websphere.asynchbeans.WorkWithExecutionContext;
import com.ibm.websphere.wsba.BASystemException;
import com.ibm.websphere.wsba.CompensationHandler;
import com.ibm.websphere.wsba.CompensationHandlerFailedException;
import com.ibm.websphere.wsba.RetryCompensationHandlerException;
import com.ibm.ws.cscope.CScope;
import com.ibm.ws.cscope.CompensationFailedException;
import com.ibm.ws.cscope.Compensator;
import com.ibm.ws.cscope.OrderedCompensator;
import com.ibm.ws.cscope.RetryCompensatorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.wsba.CompensationHandlerWork;
import com.ibm.ws.wsba.WSBAImpl;
import commonj.sdo.DataObject;
import java.util.Date;

public class CompensationHandlerWrapper
implements OrderedCompensator,
Compensator {
    private static final TraceComponent tc = Tr.register(CompensationHandlerWrapper.class, "WSBA", "com.ibm.ws.wsba.resources.WSBAMessages");
    public static WSThreadLocal _compensationHandlerWrapperThreadLocal = new WSThreadLocal();
    public static WSThreadLocal _cscopeThreadLocal = new WSThreadLocal();
    private WorkWithExecutionContext _workWithExecutionContext = null;
    private transient CScope _cscope = null;
    private String _compensationHandlerClass = null;
    private DataObject _compensationData = null;
    private String _creatorBeanName = "";
    private boolean _transactional = false;
    private static final long serialVersionUID = 8501812380437478005L;
    private long _timestamp;
    private long _completionOrder;

    public CompensationHandlerWrapper(WorkWithExecutionContext workWithExecutionContext, String string, DataObject dataObject, String string2, boolean bl, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CompensationHandlerWrapper", new Object[]{workWithExecutionContext, string, dataObject, string2, new Boolean(bl)});
        }
        this._workWithExecutionContext = workWithExecutionContext;
        this._compensationHandlerClass = string;
        this._compensationData = dataObject;
        this._creatorBeanName = string2;
        this._transactional = bl;
        this._timestamp = new Date().getTime();
        this._completionOrder = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CompensationHandlerWrapper", this);
        }
    }

    public void compensate(CScope cScope) throws RetryCompensatorException, CompensationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compensate", new Object[]{cScope, this});
        }
        this._cscope = cScope;
        WorkManager workManager = WSBAImpl.getWorkManager(this);
        try {
            Work work = this._workWithExecutionContext.getWork();
            CompensationHandlerWork compensationHandlerWork = (CompensationHandlerWork)work;
            compensationHandlerWork.setCompensationDirection(1);
            compensationHandlerWork.setCompensationHandlerWrapper(this);
            workManager.doWork(this._workWithExecutionContext);
            Throwable throwable = compensationHandlerWork.getExceptionThrown();
            if (throwable != null) {
                if (throwable instanceof RetryCompensatorException) {
                    RetryCompensatorException retryCompensatorException = (RetryCompensatorException)throwable;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caught a RetryCompensatorException calling compensate. Rethrowing...");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "compensate", retryCompensatorException);
                    }
                    throw retryCompensatorException;
                }
                if (throwable instanceof CompensationFailedException) {
                    CompensationFailedException compensationFailedException = (CompensationFailedException)throwable;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caught a CompensationFailedException calling compensate. Rethrowing...");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "compensate", compensationFailedException);
                    }
                    throw compensationFailedException;
                }
            }
        }
        catch (WorkException workException) {
            FFDCFilter.processException(workException, "com.ibm.ws.wsba.CompensationHandlerWrapper.compensate", "107");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught an WorkException in compensate(), throwing a BASystemException.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "compensate", "BASystemException");
            }
            throw new BASystemException(workException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compensate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compensateCompensationHandler() throws RetryCompensatorException, CompensationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compensateCompensationHandler", this);
        }
        try {
            CompensationHandler compensationHandler = this.createCompensationHandler();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created the user compensation handler in compensateCompensationHandler()");
            }
            try {
                this.prepareThreadForCompetion();
                compensationHandler.compensate(this._compensationData);
            }
            finally {
                this.cleanThread();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Sucessfully invoked the user compensation handler to compensate");
            }
        }
        catch (RetryCompensationHandlerException retryCompensationHandlerException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught a RetryCompensationHandlerException in compensateCompensationHandler(), rethrowing to CScope as a RetryCompensatorException");
            }
            RetryCompensatorException retryCompensatorException = new RetryCompensatorException();
            retryCompensatorException.initCause(retryCompensationHandlerException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "compensateCompensationHandler", "RetryCompensatorException");
            }
            throw retryCompensatorException;
        }
        catch (CompensationHandlerFailedException compensationHandlerFailedException) {
            FFDCFilter.processException(compensationHandlerFailedException, "com.ibm.ws.wsba.CompensationHandlerWrapper.compensateCompensationHandler", "166");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught a CompensationHandlerFailedException in compensateCompensationHandler()");
            }
            Tr.info(tc, "INF_CH_CHFE", new Object[]{this._compensationHandlerClass});
        }
        catch (InstantiationException instantiationException) {
            Tr.error(tc, "ERR_CH_MISSING", new Object[]{this._compensationHandlerClass, instantiationException});
            FFDCFilter.processException(instantiationException, "com.ibm.ws.wsba.CompensationHandlerWrapper.compensateCompensationHandler", "167");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught an InstantiationException in compensateCompensationHandler(), throwing a CompensationFailedException.");
            }
            CompensationFailedException compensationFailedException = new CompensationFailedException();
            compensationFailedException.initCause(instantiationException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "compensateCompensationHandler", "CompensationFailedException");
            }
            throw compensationFailedException;
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException(illegalAccessException, "com.ibm.ws.wsba.CompensationHandlerWrapper.compensateCompensationHandler", "180");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught an IllegalAccessException in compensateCompensationHandler(), throwing a CompensationFailedException.");
            }
            CompensationFailedException compensationFailedException = new CompensationFailedException();
            compensationFailedException.initCause(illegalAccessException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "compensateCompensationHandler", "CompensationFailedException");
            }
            throw compensationFailedException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.error(tc, "ERR_CH_MISSING", new Object[]{this._compensationHandlerClass, classNotFoundException});
            FFDCFilter.processException(classNotFoundException, "com.ibm.ws.wsba.CompensationHandlerWrapper.compensateCompensationHandler", "192");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught an ClassNotFoundException in compensateCompensationHandler(), throwing a CompensationFailedException.");
            }
            CompensationFailedException compensationFailedException = new CompensationFailedException();
            compensationFailedException.initCause(classNotFoundException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "compensateCompensationHandler", "CompensationFailedException");
            }
            throw compensationFailedException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compensateCompensationHandler");
        }
    }

    private void cleanThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanThread", this);
        }
        _compensationHandlerWrapperThreadLocal.remove();
        _cscopeThreadLocal.remove();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanThread");
        }
    }

    private void prepareThreadForCompetion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareThreadForCompetion", this);
        }
        _compensationHandlerWrapperThreadLocal.set(this);
        _cscopeThreadLocal.set(this._cscope);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareThreadForCompetion");
        }
    }

    public void close(CScope cScope) throws RetryCompensatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close", new Object[]{cScope, this});
        }
        this._cscope = cScope;
        WorkManager workManager = WSBAImpl.getWorkManager(this);
        try {
            Work work = this._workWithExecutionContext.getWork();
            CompensationHandlerWork compensationHandlerWork = (CompensationHandlerWork)work;
            compensationHandlerWork.setCompensationDirection(0);
            compensationHandlerWork.setCompensationHandlerWrapper(this);
            workManager.doWork(this._workWithExecutionContext);
            Throwable throwable = compensationHandlerWork.getExceptionThrown();
            if (throwable != null && throwable instanceof RetryCompensatorException) {
                RetryCompensatorException retryCompensatorException = (RetryCompensatorException)throwable;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught a RetryCompensatorException calling close. Rethrowing...");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "close", retryCompensatorException);
                }
                throw retryCompensatorException;
            }
        }
        catch (WorkException workException) {
            FFDCFilter.processException(workException, "com.ibm.ws.wsba.CompensationHandlerWrapper.close", "246");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught an WorkException in close(), throwing a BASystemException.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close", "BASystemException");
            }
            throw new BASystemException(workException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCompensationHandler() throws RetryCompensatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeCompensationHandler", this);
        }
        try {
            CompensationHandler compensationHandler = this.createCompensationHandler();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created the user compensation handler in closeCompensationHandler()");
            }
            try {
                this.prepareThreadForCompetion();
                compensationHandler.close(this._compensationData);
            }
            finally {
                this.cleanThread();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Sucessfully invoked the user compensation handler to close");
            }
        }
        catch (RetryCompensationHandlerException retryCompensationHandlerException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught a RetryCompensationHandlerException in closeCompensationHandler(), rethrowing to CScope as a RetryCompensatorException");
            }
            RetryCompensatorException retryCompensatorException = new RetryCompensatorException();
            retryCompensatorException.initCause(retryCompensationHandlerException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "closeCompensationHandler", "RetryCompensatorException");
            }
            throw retryCompensatorException;
        }
        catch (CompensationHandlerFailedException compensationHandlerFailedException) {
            FFDCFilter.processException(compensationHandlerFailedException, "com.ibm.ws.wsba.CompensationHandlerWrapper.closeCompensationHandler", "306");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught a CompensationHandlerFailedException in closeCompensationHandler()");
            }
            Tr.info(tc, "INF_CH_CHFE", new Object[]{this._compensationHandlerClass});
        }
        catch (InstantiationException instantiationException) {
            Tr.error(tc, "ERR_CH_MISSING", new Object[]{this._compensationHandlerClass, instantiationException});
            FFDCFilter.processException(instantiationException, "com.ibm.ws.wsba.CompensationHandlerWrapper.closeCompensationHandler", "295");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught an InstantiationException in closeCompensationHandler(), throwing a BASystemException.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "closeCompensationHandler", "BASystemException");
            }
            throw new BASystemException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException(illegalAccessException, "com.ibm.ws.wsba.CompensationHandlerWrapper.closeCompensationHandler", "302");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught an IllegalAccessException in closeCompensationHandler(), throwing a BASystemException.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "closeCompensationHandler", "BASystemException");
            }
            throw new BASystemException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.error(tc, "ERR_CH_MISSING", new Object[]{this._compensationHandlerClass, classNotFoundException});
            FFDCFilter.processException(classNotFoundException, "com.ibm.ws.wsba.CompensationHandlerWrapper.closeCompensationHandler", "309");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught an ClassNotFoundException in closeCompensationHandler(), throwing a BASystemException.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "closeCompensationHandler", "BASystemException");
            }
            throw new BASystemException(classNotFoundException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closeCompensationHandler");
        }
    }

    private CompensationHandler createCompensationHandler() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCompensationHandler", this);
        }
        CompensationHandler compensationHandler = (CompensationHandler)Thread.currentThread().getContextClassLoader().loadClass(this._compensationHandlerClass).newInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCompensationHandler", compensationHandler);
        }
        return compensationHandler;
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getName", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getName", this._compensationHandlerClass);
        }
        return this._compensationHandlerClass;
    }

    public String get_creatorBeanName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get_creatorBeanName", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get_creatorBeanName", this._creatorBeanName);
        }
        return this._creatorBeanName;
    }

    public void setCompensationData(DataObject dataObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCompensationData", new Object[]{dataObject, this});
        }
        this._compensationData = dataObject;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCompensationData");
        }
    }

    public boolean isTransactional() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTransactional", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTransactional", new Boolean(this._transactional));
        }
        return this._transactional;
    }

    public void setTransactional(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTransactional", new Object[]{new Boolean(bl), this});
        }
        this._transactional = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTransactional");
        }
    }

    public boolean heuristicEnd(boolean bl, CScope cScope) throws RetryCompensatorException {
        return false;
    }

    public DataObject getCompensationData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompensationData", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompensationData", this._compensationData);
        }
        return this._compensationData;
    }

    public void postFailureCompensate(CScope cScope) throws RetryCompensatorException {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "postFailureCompensate", new Object[]{cScope, this});
            }
            try {
                this.compensate(cScope);
            }
            catch (RetryCompensatorException retryCompensatorException) {
                FFDCFilter.processException(retryCompensatorException, "com.ibm.ws.wsba.CompensationHandlerWrapper.postFailureCompensate", "417");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught a RetryCompensatorException calling compensate(). Rethrowing...");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "compensate", retryCompensatorException);
                }
                throw retryCompensatorException;
            }
            catch (CompensationFailedException compensationFailedException) {
                if (!tc.isEventEnabled()) break block7;
                Tr.event(tc, "CompensationFailedException thrown from compensate(). This should never happen", compensationFailedException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postFailureCompensate");
        }
    }

    public int compareTo(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compareTo", new Object[]{object, this});
        }
        int n = -1;
        if (object != null && object instanceof CompensationHandlerWrapper) {
            CompensationHandlerWrapper compensationHandlerWrapper = (CompensationHandlerWrapper)object;
            long l = compensationHandlerWrapper.getTimestamp();
            if (this._timestamp > l) {
                n = 1;
            } else if (this._timestamp == l && this._completionOrder > compensationHandlerWrapper.getCompletionOrder()) {
                n = 1;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compareTo", new Integer(n));
        }
        return n;
    }

    private long getTimestamp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimestamp", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimestamp", new Long(this._timestamp));
        }
        return this._timestamp;
    }

    private long getCompletionOrder() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompletionOrder", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompletionOrder", new Long(this._completionOrder));
        }
        return this._completionOrder;
    }

    public void setWWEC(WorkWithExecutionContext workWithExecutionContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setWWEC", new Object[]{workWithExecutionContext, this});
        }
        this._workWithExecutionContext = workWithExecutionContext;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setWWEC");
        }
    }
}

