/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsba;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.activity.ActivityContext;
import com.ibm.ws.activity.ContextExtractor;
import com.ibm.ws.cscope.CScopePGMgr;
import com.ibm.ws.cscope.CScopeSystemException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.PropertyGroupContext;
import com.ibm.ws.util.Base64;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.wsba.WSBAConstants;
import com.ibm.ws.wsba.WSBACoordinatorProxy;
import com.ibm.ws.wsba.systemapp.WSBAServiceHelper;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws.wscoor.ServiceHelper;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.EndpointReferenceManager;
import com.ibm.wsspi.wsaddressing.NamespaceNotSupportedException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;

public class WSBAContextExtractor
implements ContextExtractor {
    private static final TraceComponent tc = Tr.register(WSBAContextExtractor.class, "CScope", "com.ibm.ws.cscope.resources.CScopeMessages");
    private static final List EXTENSIBILITY_ELEMENTS_LIST;

    public ActivityContext extractContext(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractContext", new Object[]{messageContext, this});
        }
        MessageContext messageContext2 = messageContext;
        ActivityContext activityContext = null;
        try {
            SOAPMessage sOAPMessage = messageContext2.getMessage();
            SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
            if (sOAPHeader != null) {
                CoordinationContext coordinationContext = CoordinationContext.extractFromSOAPHeader(sOAPHeader, CScopePGMgr.COORDINATION_TYPE.toString(), EXTENSIBILITY_ELEMENTS_LIST);
                activityContext = this.coordinationContextToActivityContext(coordinationContext);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wsba.WSBAContextExtractor.extractContext", "60", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "extractContext", "CScopeSystemException");
            }
            throw new CScopeSystemException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractContext", activityContext);
        }
        return activityContext;
    }

    private ActivityContext coordinationContextToActivityContext(CoordinationContext coordinationContext) throws EndpointReferenceCreationException, NamespaceNotSupportedException, ReferenceParameterCreationException, IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "coordinationContextToActivityContext", new Object[]{coordinationContext, this});
        }
        ActivityContext activityContext = null;
        if (coordinationContext != null) {
            Object object;
            String string = coordinationContext.getIdentifier().getURI().toString();
            EndpointReference endpointReference = EndpointReferenceManager.createEndpointReference(WSBAServiceHelper.getBusinessAgreementWithParticipantCompletionParticipantURI());
            endpointReference.setNamespace("http://schemas.xmlsoap.org/ws/2004/08/addressing");
            ServiceHelper.setAffinity(endpointReference, null);
            String string2 = coordinationContext.getExtensibilityElement(WSBAConstants.UOW_IDENTIFIER_NAME);
            Serializable serializable = null;
            if (string2 != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decode(string2));
                object = new ObjectInputStream(byteArrayInputStream);
                serializable = (Serializable)((ObjectInputStream)object).readObject();
            }
            boolean bl = coordinationContext.getExtensibilityElement(WSBAConstants.TWO_WAY_ENABLED_NAME) != null;
            object = new HashMap();
            ((HashMap)object).put(WSBAConstants.UOW_IDENTIFIER_KEY, serializable);
            ((HashMap)object).put(WSBAConstants.REGISTRATION_SERVICE_KEY, coordinationContext.getRegistrationService());
            WSBACoordinatorProxy wSBACoordinatorProxy = new WSBACoordinatorProxy(endpointReference, WSBAConstants.PARTICIPANT_COMPLETION_PROTOCOL_URI, string, bl);
            activityContext = new ActivityContext(string, "com.ibm.ws.cscope", "com.ibm.ws.cscope", coordinationContext.getExpires(), new PropertyGroupContext("CScope", (Serializable)object), wSBACoordinatorProxy, coordinationContext.getRegistrationService(), wSBACoordinatorProxy, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "coordinationContextToActivityContext", activityContext);
        }
        return activityContext;
    }

    public ActivityContext extractContext(Map map, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractContext", new Object[]{map, string, this});
        }
        ActivityContext activityContext = null;
        try {
            CoordinationContext coordinationContext = CoordinationContext.extractFromSystemContextMap(map, string, CScopePGMgr.COORDINATION_TYPE.toString());
            activityContext = this.coordinationContextToActivityContext(coordinationContext);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wsba.WSBAContextExtractor.extractContext", "161", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "extractContext", "CScopeSystemException");
            }
            throw new CScopeSystemException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractContext", activityContext);
        }
        return activityContext;
    }

    static {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<clinit>");
        }
        EXTENSIBILITY_ELEMENTS_LIST = new ArrayList();
        EXTENSIBILITY_ELEMENTS_LIST.add(WSBAConstants.UOW_IDENTIFIER_NAME);
        EXTENSIBILITY_ELEMENTS_LIST.add(WSBAConstants.TWO_WAY_ENABLED_NAME);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<clinit>");
        }
    }
}

