/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsba;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.activity.Semaphore;
import com.ibm.ws.cscope.CScopeImpl;
import com.ibm.ws.cscope.CScopeServiceManager;
import com.ibm.ws.cscope.util.TraceUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActionErrorException;
import com.ibm.ws.wsba.StatusType;
import com.ibm.ws.wsba.WSBAConstants;
import com.ibm.ws.wsba.WSBAParticipantProxy;
import com.ibm.ws.wsba.systemapp.BusinessAgreementWithCoordinatorCompletionParticipantPortType;
import com.ibm.ws.wsba.systemapp.WSBAServiceHelper;
import com.ibm.ws.wscoor.ProtocolSecurityHelper;
import com.ibm.ws.wscoor.ServiceHelper;
import com.ibm.ws.wscoor.WSCoorConstants;
import com.ibm.ws.wscoor.WSCoorServices;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.EndpointReferenceManager;
import com.ibm.wsspi.wsaddressing.NamespaceNotSupportedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;

public class WSBACoordinatorCompletionParticipantProxy
extends WSBAParticipantProxy {
    private static final long serialVersionUID = -8682572906976484904L;
    private static final TraceComponent tc = Tr.register(WSBACoordinatorCompletionParticipantProxy.class, "CScope", "com.ibm.ws.cscope.resources.CScopeMessages");
    private static final int[][][] _stateChanges = new int[][][]{new int[][]{{11, 5}, {0, 1}, {9, 6}, {0, 1}, {0, 1}, {0, 1}}, new int[0][], new int[][]{{11, 5}, {1, 1}, {9, 6}, {12, 0}, {1, 1}, {1, 1}}, new int[][]{{11, 5}, {5, 7}, {9, 6}, {12, 0}, {1, 1}, {1, 1}}, new int[][]{{11, 5}, {5, 7}, {9, 6}, {4, 1}, {1, 1}, {1, 1}}, new int[][]{{5, 1}, {5, 2}, {5, 1}, {5, 1}, {5, 1}, {5, 1}}, new int[][]{{6, 1}, {6, 3}, {6, 1}, {6, 1}, {12, 0}, {6, 1}}, new int[][]{{7, 1}, {7, 4}, {10, 6}, {7, 1}, {7, 1}, {12, 0}}, new int[0][], new int[][]{{8, 1}, {8, 1}, {8, 2}, {8, 1}, {8, 1}, {8, 1}}, new int[][]{{8, 1}, {8, 2}, {8, 2}, {8, 1}, {8, 1}, {8, 1}}, new int[][]{{11, 2}, {11, 1}, {11, 1}, {11, 1}, {11, 1}, {11, 1}}, new int[][]{{12, 5}, {12, 2}, {12, 6}, {12, 2}, {12, 2}, {12, 2}}};

    public WSBACoordinatorCompletionParticipantProxy(EndpointReference endpointReference, String string, String string2, CScopeImpl cScopeImpl, boolean bl) {
        super(endpointReference, string, string2, cScopeImpl, false);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject", new Object[]{objectInputStream, this});
        }
        objectInputStream.defaultReadObject();
        WSBAServiceHelper.addParticipantProxy(this._participantId, this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject");
        }
    }

    protected boolean readyForCompletion(Semaphore semaphore) throws ActionErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readyForCompletion", new Object[]{semaphore, this});
        }
        boolean bl = false;
        this._semaphore = semaphore;
        if (this._state == 0) {
            boolean bl2 = this.sendProtocolMessageToParticipant(WSBAConstants.COMPLETE_ACTION_URI);
            if (bl2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Participant " + this._participantId + " for context " + this._contextId + " has been sent complete. Waiting for a response.");
                }
                try {
                    this.wait(CScopeServiceManager.ASYNC_RESPONSE_TIMEOUT);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.wsba.WSBACoordinatorCompletionParticipantProxy.readyForCompletion", "128", this);
                    ActionErrorException actionErrorException = new ActionErrorException();
                    actionErrorException.initCause(interruptedException);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "readyForCompletion", actionErrorException);
                    }
                    throw actionErrorException;
                }
                if (this._readyForCompletion) {
                    bl = true;
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Did not send a complete message to the participant as its state is " + TraceUtils.printState(this._state));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readyForCompletion", bl);
        }
        return bl;
    }

    protected boolean sendProtocolMessageToParticipant(AttributedURI attributedURI) throws ActionErrorException {
        block25: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sendProtocolMessageToParticipant", new Object[]{attributedURI, this});
            }
            boolean bl = false;
            try {
                BusinessAgreementWithCoordinatorCompletionParticipantPortType businessAgreementWithCoordinatorCompletionParticipantPortType = this.getParticipant();
                if (attributedURI.equals(WSBAConstants.CLOSE_ACTION_URI)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Sending close message to downstream participant");
                    }
                    this._semaphore.increment();
                    bl = true;
                    this._state = 6;
                    businessAgreementWithCoordinatorCompletionParticipantPortType.closeOperation(null);
                    break block25;
                }
                if (attributedURI.equals(WSBAConstants.COMPENSATE_ACTION_URI)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Sending compensate message to downstream participant");
                    }
                    this._semaphore.increment();
                    bl = true;
                    this._state = 7;
                    businessAgreementWithCoordinatorCompletionParticipantPortType.compensateOperation(null);
                    break block25;
                }
                if (attributedURI.equals(WSBAConstants.CANCEL_ACTION_URI)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Sending cancel message to downstream participant");
                    }
                    this._semaphore.increment();
                    bl = true;
                    this._state = 1;
                    businessAgreementWithCoordinatorCompletionParticipantPortType.cancelOperation(null);
                    break block25;
                }
                if (attributedURI.equals(WSBAConstants.FAULTED_ACTION_URI)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Sending faulted message to downstream participant");
                    }
                    bl = false;
                    this._state = 12;
                    businessAgreementWithCoordinatorCompletionParticipantPortType.faultedOperation(null);
                    break block25;
                }
                if (attributedURI.equals(WSBAConstants.EXITED_ACTION_URI)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Sending exited message to downstream participant");
                    }
                    bl = false;
                    this._state = 12;
                    businessAgreementWithCoordinatorCompletionParticipantPortType.exitedOperation(null);
                    break block25;
                }
                if (attributedURI.equals(WSBAConstants.COMPLETE_ACTION_URI)) {
                    if (this._state == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Sending complete message to downstream participant");
                        }
                        this._semaphore.increment();
                        bl = true;
                        this._state = 4;
                        businessAgreementWithCoordinatorCompletionParticipantPortType.completeOperation(null);
                    } else {
                        bl = false;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Did not send a complete message to the participant as its state is " + TraceUtils.printState(this._state));
                        }
                    }
                    break block25;
                }
                ActionErrorException actionErrorException = new ActionErrorException();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "sendProtocolMessageToParticipant", actionErrorException);
                }
                throw actionErrorException;
            }
            catch (RemoteException remoteException) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.wsba.WSBACoordinatorCompletionParticipantProxy.sendProtocolMessageToParticipant", "258", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RemoteException caught calling downstream participant", remoteException);
                }
                if (this._semaphore != null && bl) {
                    this._semaphore.decrement();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "sendProtocolMessageToParticipant", Boolean.FALSE);
                }
                return false;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wsba.WSBACoordinatorCompletionParticipantProxy.sendProtocolMessageToParticipant", "256", this);
                ActionErrorException actionErrorException = new ActionErrorException();
                actionErrorException.initCause(exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "sendProtocolMessageToParticipant", actionErrorException);
                }
                throw actionErrorException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendProtocolMessageToParticipant", Boolean.TRUE);
        }
        return true;
    }

    protected int[] getStateTransition(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStateTransition", new Object[]{new Integer(n), new Integer(n2), this});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStateTransition");
        }
        return _stateChanges[n][n2];
    }

    public void getStatusMessageReceived() {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getStatusMessageReceived", this);
            }
            BusinessAgreementWithCoordinatorCompletionParticipantPortType businessAgreementWithCoordinatorCompletionParticipantPortType = null;
            try {
                businessAgreementWithCoordinatorCompletionParticipantPortType = this.getParticipant();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wsba.WSBACoordinatorCompletionParticipantProxy.getStatusMessageReceived", "130", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getStatusMessageReceived");
                }
                return;
            }
            try {
                businessAgreementWithCoordinatorCompletionParticipantPortType.statusOperation(StatusType.STATUS_TYPES[this._state]);
            }
            catch (RemoteException remoteException) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.wsba.WSBACoordinatorCompletionParticipantProxy.getStatusMessageReceived", "352", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "RemoteException caught calling downstream participant", remoteException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatusMessageReceived");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getParticipantStatus() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParticipantStatus", this);
        }
        int n = -1;
        try {
            BusinessAgreementWithCoordinatorCompletionParticipantPortType businessAgreementWithCoordinatorCompletionParticipantPortType = this.getParticipant();
            if (this.GET_STATUS_LOCK == null) {
                this.GET_STATUS_LOCK = new Object();
            }
            Object object = this.GET_STATUS_LOCK;
            synchronized (object) {
                this._stateReceivedFromParticipant = -1;
                businessAgreementWithCoordinatorCompletionParticipantPortType.getStatusOperation(null);
                this.GET_STATUS_LOCK.wait(5000L);
                n = this._stateReceivedFromParticipant;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wsba.WSBACoordinatorCompletionParticipantProxy.getParticipantStatus", "429", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParticipantStatus", new Integer(n));
        }
        return n;
    }

    private BusinessAgreementWithCoordinatorCompletionParticipantPortType getParticipant() throws MalformedURLException, EndpointReferenceCreationException, NamespaceNotSupportedException, ServiceException, ReferenceParameterCreationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParticipant", this);
        }
        URL uRL = this._participantProtocolService.getAddress().getURI().toURL();
        BusinessAgreementWithCoordinatorCompletionParticipantPortType businessAgreementWithCoordinatorCompletionParticipantPortType = WSBAServiceHelper.getWSBAService().getBusinessAgreementWithCoordinatorCompletionParticipant(uRL);
        EndpointReference endpointReference = EndpointReferenceManager.createEndpointReference(WSCoorServices.getRegistrationRequesterURI());
        endpointReference.setNamespace("http://schemas.xmlsoap.org/ws/2004/08/addressing");
        ServiceHelper.setAffinity(endpointReference, null);
        endpointReference.setReferenceParameter(WSCoorConstants.CONTEXT_ID_ELEMENT_QNAME, this._contextId);
        endpointReference.setReferenceParameter(WSCoorConstants.INSTANCE_ID_ELEMENT_QNAME, this._participantId);
        ((Stub)businessAgreementWithCoordinatorCompletionParticipantPortType)._setProperty("com.ibm.wsspi.wsaddressing.replyToEPR", (Object)endpointReference);
        EndpointReference endpointReference2 = EndpointReferenceManager.createEndpointReference(WSBAServiceHelper.getFaultURI());
        endpointReference2.setNamespace("http://schemas.xmlsoap.org/ws/2004/08/addressing");
        ServiceHelper.setAffinity(endpointReference2, null);
        endpointReference2.setReferenceParameter(WSCoorConstants.CONTEXT_ID_ELEMENT_QNAME, this._contextId);
        endpointReference2.setReferenceParameter(WSCoorConstants.INSTANCE_ID_ELEMENT_QNAME, this._participantId);
        ProtocolSecurityHelper.makeEPRSecure(uRL.getHost(), endpointReference2);
        ((Stub)businessAgreementWithCoordinatorCompletionParticipantPortType)._setProperty("com.ibm.wsspi.wsaddressing.faultToEPR", (Object)endpointReference2);
        ((Stub)businessAgreementWithCoordinatorCompletionParticipantPortType)._setProperty("com.ibm.websphere.wsaddressing.destinationEPR", (Object)this._participantProtocolService);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParticipant", businessAgreementWithCoordinatorCompletionParticipantPortType);
        }
        return businessAgreementWithCoordinatorCompletionParticipantPortType;
    }
}

