/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsba;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.Semaphore;
import com.ibm.ws.activity.WebSphereActivityCoordinator;
import com.ibm.ws.activity.coordination.WSCoorParticipantProxy;
import com.ibm.ws.cscope.CScopeImpl;
import com.ibm.ws.cscope.CScopeSubordImpl;
import com.ibm.ws.cscope.util.TraceUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActionErrorException;
import com.ibm.ws.javax.activity.Outcome;
import com.ibm.ws.javax.activity.Signal;
import com.ibm.ws.wsba.StatusType;
import com.ibm.ws.wsba.WSBAConstants;
import com.ibm.ws.wsba.systemapp.WSBAServiceHelper;
import com.ibm.ws.wscoor.ServiceHelper;
import com.ibm.ws.wscoor.WSCoorConstants;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.EndpointReferenceManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;

public abstract class WSBAParticipantProxy
implements WSCoorParticipantProxy {
    private static final TraceComponent tc = Tr.register(WSBAParticipantProxy.class, "CScope", "com.ibm.ws.cscope.resources.CScopeMessages");
    protected boolean _exit;
    protected int _state = -1;
    protected String _contextId;
    protected String _participantId;
    protected transient Outcome _outcome;
    protected EndpointReference _participantProtocolService;
    protected transient Semaphore _semaphore;
    protected transient boolean _readyForCompletion;
    protected boolean _promoteCompensators;
    protected transient int _stateReceivedFromParticipant;
    protected transient Object GET_STATUS_LOCK;
    protected transient CScopeImpl _cscope;
    private transient boolean _supportsTwoWay;

    protected WSBAParticipantProxy(EndpointReference endpointReference, String string, String string2, CScopeImpl cScopeImpl, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSBAParticipantProxy", new Object[]{endpointReference, string, string2, cScopeImpl, bl});
        }
        this._contextId = string2;
        this._participantId = string;
        this._participantProtocolService = endpointReference;
        if (cScopeImpl instanceof CScopeSubordImpl) {
            ((CScopeSubordImpl)cScopeImpl).setDownstreamParticipantsRequireCompletionProcessing();
        }
        this._cscope = cScopeImpl;
        this._state = 0;
        this._supportsTwoWay = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSBAParticipantProxy", this);
        }
    }

    protected abstract boolean readyForCompletion(Semaphore var1) throws ActionErrorException;

    protected abstract int[] getStateTransition(int var1, int var2);

    protected abstract boolean sendProtocolMessageToParticipant(AttributedURI var1) throws ActionErrorException;

    public abstract void getStatusMessageReceived();

    public abstract int getParticipantStatus();

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy", this);
        }
        WSBAServiceHelper.removeParticipantProxy(this._participantId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public Outcome getOutcome() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutcome", this);
        }
        Outcome outcome = this._outcome;
        this._outcome = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutcome", outcome);
        }
        return outcome;
    }

    protected void setOutcome(Outcome outcome) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setOutcome", new Object[]{outcome, this});
        }
        this._outcome = outcome;
        this._semaphore.decrement();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setOutcome");
        }
    }

    public String getContextId() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getContextId", this._contextId);
        }
        return this._contextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendProtocolMessageToParticipant(Signal signal, Semaphore semaphore, WebSphereActivityCoordinator webSphereActivityCoordinator) throws ActionErrorException {
        AttributedURI attributedURI;
        block31: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sendProtocolMessageToParticipant", new Object[]{signal, semaphore, webSphereActivityCoordinator, this});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, signal.getName());
            }
            String string = signal.getName();
            attributedURI = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Participant state", TraceUtils.printState(this._state));
            }
            if (string.equals("complete")) {
                WSBAParticipantProxy wSBAParticipantProxy = this;
                synchronized (wSBAParticipantProxy) {
                    if (!this.readyForCompletion(semaphore)) {
                        this._outcome = new Outcome("BeforeCompletionError", (Serializable)null);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "sendProtocolMessageToParticipant", Boolean.TRUE);
                        }
                        return true;
                    }
                }
                this._outcome = new Outcome("BeforeCompletionSuccess", (Serializable)null);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "sendProtocolMessageToParticipant", Boolean.TRUE);
                }
                return true;
            }
            if (this._exit) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subordinate participant has exited");
                }
                this._outcome = new Outcome("CompletionSuccess", (Serializable)null);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "sendProtocolMessageToParticipant", Boolean.TRUE);
                }
                return true;
            }
            if (this._state == -1) {
                this._state = this.getParticipantStatus();
                if (this._state == 11) {
                    this.sendProtocolMessageToParticipant(WSBAConstants.EXITED_ACTION_URI);
                    this._outcome = new Outcome("CompletionSuccess", (Serializable)null);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "sendProtocolMessageToParticipant", Boolean.TRUE);
                    }
                    return true;
                }
            }
            if (string.equals("close")) {
                if (webSphereActivityCoordinator == null) {
                    attributedURI = this._state == 5 || this._state == 6 ? WSBAConstants.CLOSE_ACTION_URI : WSBAConstants.CANCEL_ACTION_URI;
                    break block31;
                } else {
                    this._promoteCompensators = true;
                    this._outcome = WSCoorParticipantProxy.OUTCOME_REQUEST_PROMOTION;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "sendProtocolMessageToParticipant", Boolean.TRUE);
                    }
                    return true;
                }
            }
            if (string.equals("compensate")) {
                if (this._state == 5 || this._state == 7) {
                    attributedURI = WSBAConstants.COMPENSATE_ACTION_URI;
                } else if (this._state == 0) {
                    WSBAParticipantProxy wSBAParticipantProxy = this;
                    synchronized (wSBAParticipantProxy) {
                        attributedURI = !this.readyForCompletion(semaphore) ? WSBAConstants.CANCEL_ACTION_URI : WSBAConstants.COMPENSATE_ACTION_URI;
                    }
                } else if (this._state == 1) {
                    attributedURI = WSBAConstants.CANCEL_ACTION_URI;
                }
            }
        }
        if (attributedURI != null) {
            this._semaphore = semaphore;
            boolean bl = false;
            bl = this.sendProtocolMessageToParticipant(attributedURI);
            if (bl) {
                this._promoteCompensators = false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sendProtocolMessageToParticipant", bl);
            }
            return bl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendProtocolMessageToParticipant", "ActionErrorException");
        }
        throw new ActionErrorException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void protocolMessageReceived(int n, EndpointReference endpointReference) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "protocolMessageReceived", new Object[]{new Integer(n), endpointReference, this});
        }
        int[] nArray = this.getStateTransition(this._state, n);
        this._state = nArray[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New state", new Integer(this._state));
        }
        int n2 = nArray[1];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Action to take", new Integer(n2));
        }
        try {
            switch (n2) {
                case 0: {
                    this.setOutcome(new Outcome("CompletionSuccess", (Serializable)null));
                    this._semaphore.decrement();
                    break;
                }
                case 1: {
                    this.sendInvalidState(endpointReference);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.sendProtocolMessageToParticipant(WSBAConstants.CLOSE_ACTION_URI);
                    break;
                }
                case 4: {
                    this.sendProtocolMessageToParticipant(WSBAConstants.COMPENSATE_ACTION_URI);
                    break;
                }
                case 5: {
                    WSBAParticipantProxy wSBAParticipantProxy = this;
                    synchronized (wSBAParticipantProxy) {
                        this._readyForCompletion = true;
                        this._exit = true;
                        this.notify();
                    }
                    this.sendProtocolMessageToParticipant(WSBAConstants.EXITED_ACTION_URI);
                    break;
                }
                case 6: {
                    if (this._state == 9) {
                        WSBAParticipantProxy wSBAParticipantProxy = this;
                        synchronized (wSBAParticipantProxy) {
                            this._readyForCompletion = true;
                            this._exit = true;
                            this.notify();
                        }
                        this._cscope.faultReceivedWhileActive();
                    }
                    this.sendProtocolMessageToParticipant(WSBAConstants.FAULTED_ACTION_URI);
                    break;
                }
                case 7: {
                    WSBAParticipantProxy wSBAParticipantProxy = this;
                    synchronized (wSBAParticipantProxy) {
                        this._readyForCompletion = true;
                        this.notify();
                        break;
                    }
                }
            }
        }
        catch (ActionErrorException actionErrorException) {
            FFDCFilter.processException((Throwable)actionErrorException, "com.ibm.ws.wsba.WSBAParticipantProxy.protocolMessageReceived", "201", this);
            RemoteException remoteException = new RemoteException();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "protocolMessageReceived", remoteException);
            }
            throw remoteException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "protocolMessageReceived");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statusReceived(QName qName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "statusReceived", new Object[]{qName, this});
        }
        if (this.GET_STATUS_LOCK != null) {
            int n = -1;
            for (int i = 0; i < StatusType.STATUS_TYPES.length; ++i) {
                if (!qName.equals(StatusType.STATUS_TYPES[i].getStatus())) continue;
                n = i;
                break;
            }
            Object object = this.GET_STATUS_LOCK;
            synchronized (object) {
                this._stateReceivedFromParticipant = n;
                this.GET_STATUS_LOCK.notify();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "statusReceived");
        }
    }

    private void sendInvalidState(EndpointReference endpointReference) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sendInvalidState", new Object[]{endpointReference, this});
            }
            try {
                if (endpointReference != null) {
                    EndpointReference endpointReference2 = EndpointReferenceManager.createEndpointReference(WSBAServiceHelper.getBusinessAgreementWithParticipantCompletionCoordinatorURI());
                    endpointReference2.setNamespace("http://schemas.xmlsoap.org/ws/2004/08/addressing");
                    ServiceHelper.setAffinity(endpointReference2, null);
                    endpointReference2.setReferenceParameter(WSCoorConstants.CONTEXT_ID_ELEMENT_QNAME, this._contextId);
                    endpointReference2.setReferenceParameter(WSCoorConstants.INSTANCE_ID_ELEMENT_QNAME, this._participantId);
                    WSBAServiceHelper.sendFault(endpointReference, endpointReference2, WSBAConstants.FAULT_INVALID_STATE_CODE, "The protocol message received was invalid for the current state of the activity.");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.wsba.WSBAParticipantProxy.sendInvalidState", "461");
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Caught an Exception trying to send an wscoor:InvalidState fault to the Coordinator.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendInvalidState");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject", new Object[]{objectInputStream, this});
        }
        objectInputStream.defaultReadObject();
        this._state = -1;
        this.GET_STATUS_LOCK = new Object();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject");
        }
    }

    public boolean supportsTwoWay() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "supportsTwoWay", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "supportsTwoWay", this._supportsTwoWay);
        }
        return this._supportsTwoWay;
    }
}

