/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wscoor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.wsaddressing.AttributedURI;
import com.ibm.ws.wsaddressing.WSAddressingFactory;
import com.ibm.ws.wscoor.AttributedTypeBase;
import com.ibm.ws.wscoor.ServiceHelper;
import com.ibm.ws.wscoor.WSCoorConstants;
import com.ibm.ws.wscoor.WSCoorHelper;
import com.ibm.ws.wscoor.WSCoorServices;
import com.ibm.ws.wscoor.WSCoorSystemException;
import com.ibm.wsspi.exitpoint.systemcontext.SystemContext;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.EndpointReferenceManager;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Node;

public class CoordinationContext
extends AttributedTypeBase
implements Serializable {
    private static final TraceComponent tc = Tr.register(CoordinationContext.class, "WSCoor", null);
    private static final TraceComponent tc2 = Tr.register(CoordinationContext.class, "Transaction", null);
    private static final String COORDINATION_CONTEXT_ELEMENT_STRING = "CoordinationContext";
    private static final String COORDINATION_CONTEXT_IDENTIFIER_STRING = "Identifier";
    private static final String COORDINATION_CONTEXT_EXPIRES_STRING = "Expires";
    private static final String COORDINATION_CONTEXT_REGISTRATION_SERVICE_STRING = "RegistrationService";
    private static final String COORDINATION_CONTEXT_COORDINATION_TYPE_STRING = "CoordinationType";
    private static final transient Name COORDINATION_CONTEXT_ELEMENT_NAME = WSCoorConstants.createSOAPNameForWSCoordinationLocalName("CoordinationContext");
    private static final transient Name COORDINATION_TYPE_ELEMENT_NAME = WSCoorConstants.createSOAPNameForWSCoordinationLocalName("CoordinationType");
    private static final transient Name REGISTRATION_SERVICE_ELEMENT_NAME = WSCoorConstants.createSOAPNameForWSCoordinationLocalName("RegistrationService");
    private static final transient Name EXPIRES_ELEMENT_NAME = WSCoorConstants.createSOAPNameForWSCoordinationLocalName("Expires");
    private static final transient Name IDENTIFIER_ELEMENT_NAME = WSCoorConstants.createSOAPNameForWSCoordinationLocalName("Identifier");
    private static final String REGISTRATION_SERVICE_ADDRESS_STRING = "Address";
    private static final String REGISTRATION_SERVICE_REFERENCE_PROPERTIES_STRING = "ReferenceProperties";
    private static final String REGISTRATION_SERVICE_REFERENCE_PARAMETERS_STRING = "ReferenceParameters";
    private static final String WSA_ROUTING_INFORMATION = "RoutingInformation";
    private static final String WSA_FRAGILE_ROUTING = "Fragile";
    private URI _coordinationType;
    private EndpointReference _registrationService;
    private String _expires;
    private com.ibm.wsspi.wsaddressing.AttributedURI _identifier;
    private Map _extensibilityElements;
    private static final long serialVersionUID = 2461008191555515192L;

    public static CoordinationContext extractFromSOAPHeader(SOAPHeader sOAPHeader, String string) throws SOAPException, EndpointReferenceCreationException {
        return CoordinationContext.extractFromSOAPHeader(sOAPHeader, string, null);
    }

    public static CoordinationContext extractFromSOAPHeader(SOAPHeader sOAPHeader, String string, List list) throws SOAPException, EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "extractFromSOAPHeader", new Object[]{sOAPHeader, string, list});
        }
        CoordinationContext coordinationContext = null;
        Iterator iterator = sOAPHeader.getChildElements(COORDINATION_CONTEXT_ELEMENT_NAME);
        while (iterator.hasNext()) {
            String string2;
            javax.xml.soap.SOAPElement sOAPElement = (javax.xml.soap.SOAPElement)iterator.next();
            Iterator iterator2 = sOAPElement.getChildElements(COORDINATION_TYPE_ELEMENT_NAME);
            if (!iterator2.hasNext() || !(string2 = ((javax.xml.soap.SOAPElement)iterator2.next()).getValue()).equals(string)) continue;
            URI uRI = URI.create(string2);
            Iterator iterator3 = sOAPElement.getChildElements(REGISTRATION_SERVICE_ELEMENT_NAME);
            Iterator iterator4 = sOAPElement.getChildElements(EXPIRES_ELEMENT_NAME);
            Iterator iterator5 = sOAPElement.getChildElements(IDENTIFIER_ELEMENT_NAME);
            AttributedURI attributedURI = null;
            if (iterator5.hasNext()) {
                attributedURI = WSAddressingFactory.createAttributedURI((javax.xml.soap.SOAPElement)iterator5.next());
            }
            EndpointReference endpointReference = null;
            if (iterator3.hasNext()) {
                endpointReference = EndpointReferenceManager.createEndpointReference((javax.xml.soap.SOAPElement)iterator3.next());
            }
            String string3 = null;
            if (iterator4.hasNext()) {
                string3 = ((javax.xml.soap.SOAPElement)iterator4.next()).getValue();
            }
            HashMap<QName, String> hashMap = new HashMap<QName, String>();
            if (list != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Extracting extensibility elements for names", list);
                }
                Iterator iterator6 = list.iterator();
                SOAPFactory sOAPFactory = new SOAPFactory();
                while (iterator6.hasNext()) {
                    QName qName = (QName)iterator6.next();
                    Name name2 = sOAPFactory.createName(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
                    Iterator iterator7 = sOAPElement.getChildElements(name2);
                    String string4 = null;
                    if (iterator7.hasNext()) {
                        string4 = ((javax.xml.soap.SOAPElement)iterator7.next()).getValue();
                    }
                    if (string4 == null) continue;
                    hashMap.put(qName, string4);
                }
            }
            coordinationContext = new CoordinationContext(attributedURI, uRI, endpointReference, string3, hashMap);
            coordinationContext.extractAttributesFromSOAPElement((javax.xml.soap.SOAPElement)sOAPHeader);
            sOAPHeader.removeChild((Node)sOAPElement);
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "extractFromSOAPHeader", coordinationContext);
        }
        return coordinationContext;
    }

    public static CoordinationContext extractFromSDODataGraph(DataGraph dataGraph, String string) throws URISyntaxException, WSCoorSystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "extractFromSDODataGraph", new Object[]{dataGraph, string});
        }
        CoordinationContext coordinationContext = null;
        DataObject dataObject = dataGraph.getRootObject();
        List list = dataObject.getList("/info/headers");
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject2;
            Sequence sequence;
            DataObject dataObject3 = (DataObject)list.get(i);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "object[" + i + "]", dataObject3);
            }
            if (dataObject3 == null) {
                if (!tc2.isDebugEnabled()) continue;
                Tr.debug(tc2, "headerObjectWrapper found to be null, moving on to the next header.");
                continue;
            }
            Sequence sequence2 = dataObject3.getSequence(2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "sequence", sequence2);
            }
            if (sequence2 == null) {
                if (!tc2.isDebugEnabled()) continue;
                Tr.debug(tc2, "headerObjectSequence found to be null, moving on to the next header.");
                continue;
            }
            Property property = sequence2.getProperty(0);
            String string2 = property.getName();
            String string3 = property.getContainingType().getURI();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "uri", string3);
            }
            if (string2 != null && string2.equals(COORDINATION_CONTEXT_ELEMENT_STRING) && string3 != null && string3.equals("http://schemas.xmlsoap.org/ws/2004/10/wscoor") && (coordinationContext = CoordinationContext.createCoordinationContext(sequence = (dataObject2 = (DataObject)sequence2.getValue(0)).getSequence(0), string)) != null) break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "extractFromSDODataGraph", coordinationContext);
        }
        return coordinationContext;
    }

    public static CoordinationContext extractFromSystemContextMap(Map map, String string, String string2) {
        ArrayList arrayList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "extractFromSystemContextMap", new Object[]{map, string, string2});
        }
        CoordinationContext coordinationContext = null;
        if (map != null && (arrayList = (ArrayList)map.get(string)) != null) {
            int n = arrayList.size();
            int n2 = 0;
            if (n > 0) {
                coordinationContext = (CoordinationContext)arrayList.get(n2);
                while (!coordinationContext._coordinationType.toString().equals(string2) && n2 + 1 < n) {
                    coordinationContext = (CoordinationContext)arrayList.get(++n2);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "extractFromSystemContextMap", coordinationContext);
        }
        return coordinationContext;
    }

    public void insertIntoSystemContext(SystemContext systemContext, String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertIntoSystemContext", new Object[]{systemContext, string, this});
        }
        ArrayList<CoordinationContext> arrayList = null;
        try {
            arrayList = (ArrayList<CoordinationContext>)systemContext.getSystemContextItem(string);
            if (arrayList == null) {
                arrayList = new ArrayList<CoordinationContext>();
            }
            arrayList.add(this);
            systemContext.putSystemContextItem(string, arrayList);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.wscoor.CoordinationContext.insertIntoSystemContext", "344", this);
            if (TraceComponent.isAnyTracingEnabled()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught an IOException retrieving the coordination contexts from the SystemContext, rethrowing as a WSCoorSystemException");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "insertIntoSystemContext", "WSCoorSystemException");
                }
            }
            throw new WSCoorSystemException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.wscoor.CoordinationContext.insertIntoSystemContext", "347", this);
            if (TraceComponent.isAnyTracingEnabled()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught an ClassNotFoundException retrieving the coordination contexts from the SystemContext, rethrowing as a WSCoorSystemException");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "insertIntoSystemContext", "WSCoorSystemException");
                }
            }
            throw new WSCoorSystemException(classNotFoundException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertIntoSystemContext");
        }
    }

    private static CoordinationContext createCoordinationContext(Sequence sequence, String string) throws URISyntaxException, WSCoorSystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createCoordinationContext", new Object[]{sequence, string});
        }
        com.ibm.wsspi.wsaddressing.AttributedURI attributedURI = null;
        String string2 = null;
        URI uRI = null;
        EndpointReference endpointReference = null;
        int n = sequence.size();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "coordctx seq size", new Integer(n));
        }
        for (int i = 0; i < n; ++i) {
            String string3;
            DataObject dataObject;
            Property property = sequence.getProperty(i);
            String string4 = property.getName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "coordctx property[" + i + "]", string4);
            }
            if (string4.equals(COORDINATION_CONTEXT_IDENTIFIER_STRING)) {
                dataObject = (DataObject)sequence.getValue(i);
                attributedURI = WSAddressingFactory.createAttributedURI(new URI((String)dataObject.getSequence(0).getValue(0)));
                continue;
            }
            if (string4.equals(COORDINATION_CONTEXT_EXPIRES_STRING)) {
                dataObject = (DataObject)sequence.getValue(i);
                string2 = (String)dataObject.getSequence(0).getValue(0);
                continue;
            }
            if (string4.equals(COORDINATION_CONTEXT_COORDINATION_TYPE_STRING)) {
                dataObject = (DataObject)sequence.getValue(i);
                string3 = (String)dataObject.getSequence(0).getValue(0);
                if (!string3.equals(string)) continue;
                uRI = new URI(string3);
                continue;
            }
            if (string4.equals(COORDINATION_CONTEXT_REGISTRATION_SERVICE_STRING)) {
                String string5;
                DataObject dataObject2;
                String string6;
                Property property2;
                int n2;
                dataObject = (DataObject)sequence.getValue(i);
                string3 = dataObject.getSequence(0);
                int n3 = string3.size();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "regsvce seq size", new Integer(n3));
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    property2 = string3.getProperty(n2);
                    string6 = property2.getName();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "regsvce property[" + n2 + "]", string6);
                    }
                    if (!string6.equals(REGISTRATION_SERVICE_ADDRESS_STRING)) continue;
                    dataObject2 = (DataObject)string3.getValue(n2);
                    string5 = (String)dataObject2.getSequence(0).getValue(0);
                    try {
                        endpointReference = EndpointReferenceManager.createEndpointReference(new URI(string5));
                        break;
                    }
                    catch (EndpointReferenceCreationException endpointReferenceCreationException) {
                        FFDCFilter.processException(endpointReferenceCreationException, "com.ibm.ws.wscoor.CoordinationContext.createCoordinationContext", "340");
                        if (TraceComponent.isAnyTracingEnabled()) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Caught an EndpointReferenceCreationException, rethrowing as a WSCoorSystemException.");
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "createCoordinationContext", "WSCoorSystemException");
                            }
                        }
                        throw new WSCoorSystemException(endpointReferenceCreationException);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        FFDCFilter.processException(uRISyntaxException, "com.ibm.ws.wscoor.CoordinationContext.createCoordinationContext", "344");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "createCoordinationContext", uRISyntaxException);
                        }
                        throw uRISyntaxException;
                    }
                }
                if (endpointReference == null) continue;
                for (n2 = 0; n2 < n3; ++n2) {
                    property2 = string3.getProperty(n2);
                    string6 = property2.getName();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "regsvce property[" + n2 + "]", string6);
                    }
                    if (!string6.equals(REGISTRATION_SERVICE_REFERENCE_PROPERTIES_STRING) && !string6.equals(REGISTRATION_SERVICE_REFERENCE_PARAMETERS_STRING)) continue;
                    dataObject2 = (DataObject)string3.getValue(n2);
                    string5 = dataObject2.getSequence(0);
                    int n4 = string5.size();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "refprop seq size", new Integer(n4));
                    }
                    for (int j = 0; j < n4; ++j) {
                        Object object;
                        Property property3 = string5.getProperty(j);
                        String string7 = property3.getName();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "reference property[" + j + "]", string7);
                        }
                        String string8 = property3.getContainingType().getURI();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "property uri", string8);
                        }
                        DataObject dataObject3 = (DataObject)string5.getValue(j);
                        if (string7.equals(WSA_ROUTING_INFORMATION)) {
                            object = dataObject3.getSequence(0);
                            int n5 = object.size();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "routing seq size", new Integer(n5));
                            }
                            for (int k = 0; k < n5; ++k) {
                                Property property4 = object.getProperty(k);
                                String string9 = property4.getName();
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "routing property name", string9);
                                }
                                String string10 = property4.getContainingType().getURI();
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "routing property uri", string10);
                                }
                                DataObject dataObject4 = (DataObject)object.getValue(k);
                                String string11 = (String)dataObject4.getSequence(0).getValue(0);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "routing value", string11);
                                }
                                if (!string11.equals(WSA_FRAGILE_ROUTING) || !TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                                Tr.event(tc, "Fragile routed registration service.");
                            }
                            continue;
                        }
                        try {
                            object = (String)dataObject3.getSequence(0).getValue(0);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "refprop value", object);
                            }
                            QName qName = new QName(string8, string7);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "refprop qname", qName);
                            }
                            endpointReference.setReferenceParameter(qName, (String)object);
                            continue;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.wscoor.CoordinationContext.createCoordinationContext", "524");
                            if (TraceComponent.isAnyTracingEnabled()) {
                                if (tc.isEventEnabled()) {
                                    Tr.event(tc, "Caught a Throwable, rethrowing as a WSCoorSystemException.", throwable);
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "createCoordinationContext", "WSCoorSystemException");
                                }
                            }
                            throw new WSCoorSystemException(throwable);
                        }
                    }
                }
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not parse the CoordinationContext. Element not understood: " + string4);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createCoordinationContext", "WSCoorSystemException");
                }
            }
            throw new WSCoorSystemException();
        }
        CoordinationContext coordinationContext = null;
        if (uRI != null) {
            if (attributedURI != null && endpointReference != null) {
                coordinationContext = new CoordinationContext(attributedURI, uRI, endpointReference, string2, null);
            } else {
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not parse the CoordinationContext. Not all mandatory information was present. Identifier: " + attributedURI + " Registration Service: " + endpointReference);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "createCoordinationContext", "WSCoorSystemException");
                    }
                }
                throw new WSCoorSystemException();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createCoordinationContext", coordinationContext);
        }
        return coordinationContext;
    }

    public CoordinationContext(com.ibm.wsspi.wsaddressing.AttributedURI attributedURI, URI uRI, EndpointReference endpointReference, String string, Map map) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, COORDINATION_CONTEXT_ELEMENT_STRING, new Object[]{attributedURI, uRI, endpointReference, string, map});
        }
        this._identifier = attributedURI;
        this._coordinationType = uRI;
        this._registrationService = endpointReference;
        this._expires = string;
        this._extensibilityElements = map;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, COORDINATION_CONTEXT_ELEMENT_STRING, this);
        }
    }

    public CoordinationContext(com.ibm.wsspi.wsaddressing.AttributedURI attributedURI, URI uRI, String string) throws WSCoorSystemException {
        this(attributedURI, uRI, CoordinationContext.createRegistrationServiceEPR(attributedURI.getURI().toString()), string, null);
    }

    public CoordinationContext(com.ibm.wsspi.wsaddressing.AttributedURI attributedURI, URI uRI, String string, Map map) throws WSCoorSystemException {
        this(attributedURI, uRI, CoordinationContext.createRegistrationServiceEPR(attributedURI.getURI().toString()), string, new HashMap(map));
    }

    private static EndpointReference createRegistrationServiceEPR(String string) throws WSCoorSystemException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createRegistrationServiceEPR", string);
        }
        EndpointReference endpointReference = null;
        try {
            endpointReference = WSCoorHelper.createEPR(WSCoorServices.getRegistrationCoordinatorURI());
            ServiceHelper.setAffinity(endpointReference, null);
            endpointReference.setReferenceParameter(WSCoorConstants.CONTEXT_ID_ELEMENT_QNAME, string);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.wscoor.CoordinationContext.createRegistrationServiceEPR", "112");
            WSCoorSystemException wSCoorSystemException = new WSCoorSystemException(exception);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createRegistrationServiceEPR", wSCoorSystemException);
            }
            throw wSCoorSystemException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createRegistrationServiceEPR", endpointReference);
        }
        return endpointReference;
    }

    public URI getCoordinationType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getCoordinationType", this._coordinationType);
        }
        return this._coordinationType;
    }

    public EndpointReference getRegistrationService() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRegistrationService", this._registrationService);
        }
        return this._registrationService;
    }

    public String getExpires() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getExpires", this._expires);
        }
        return this._expires;
    }

    public com.ibm.wsspi.wsaddressing.AttributedURI getIdentifier() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getIdentifier", this._identifier);
        }
        return this._identifier;
    }

    public void insertIntoSOAPHeader(SOAPMessageContext sOAPMessageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertIntoSOAPHeader", new Object[]{sOAPMessageContext, this});
        }
        try {
            SOAPMessage sOAPMessage;
            SOAPPart sOAPPart;
            SOAPEnvelope sOAPEnvelope;
            SOAPHeader sOAPHeader;
            String string = this._identifier.toString();
            String string2 = this._coordinationType.toString();
            String string3 = this._registrationService.getAddress().toString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Identifier - " + string);
                Tr.debug(tc, "CoordinationType - " + string2);
                Tr.debug(tc, "RegistrationService Address - " + string3);
                Tr.debug(tc, "Expires - " + this._expires);
            }
            if ((sOAPHeader = (sOAPEnvelope = (sOAPPart = (sOAPMessage = sOAPMessageContext.getMessage()).getSOAPPart()).getEnvelope()).getHeader()) == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "SOAP header does not exist");
                }
                sOAPHeader = sOAPEnvelope.addHeader();
            }
            SOAPHeaderElement sOAPHeaderElement = sOAPHeader.addHeaderElement(COORDINATION_CONTEXT_ELEMENT_NAME);
            this.insertIntoSOAPHeader(sOAPHeaderElement);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.wscoor.CoordinationContext.insertIntoSOAPHeader", "211", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "insertIntoSOAPHeader", "JAXRPCException");
            }
            throw new JAXRPCException((Throwable)sOAPException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertIntoSOAPHeader");
        }
    }

    private void insertIntoSOAPHeader(SOAPHeaderElement sOAPHeaderElement) throws SOAPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertIntoSOAPHeader", new Object[]{sOAPHeaderElement, this});
        }
        sOAPHeaderElement.setMustUnderstand(true);
        this.insertIntoSOAPElement((javax.xml.soap.SOAPElement)sOAPHeaderElement);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertIntoSOAPHeader", sOAPHeaderElement);
        }
    }

    public void insertIntoSOAPElement(javax.xml.soap.SOAPElement sOAPElement) throws SOAPException {
        Object object;
        SOAPFactory sOAPFactory = ((SOAPElement)sOAPElement).getSOAPFactory();
        if (this._identifier != null) {
            object = sOAPFactory.createElement(IDENTIFIER_ELEMENT_NAME);
            sOAPElement.addChildElement(((AttributedURI)this._identifier).getSOAPElement((javax.xml.soap.SOAPElement)object));
        }
        if (this._expires != null) {
            object = sOAPFactory.createElement(EXPIRES_ELEMENT_NAME);
            object.addTextNode(this._expires);
            sOAPElement.addChildElement((javax.xml.soap.SOAPElement)object);
        }
        if (this._coordinationType != null) {
            object = sOAPFactory.createElement(COORDINATION_TYPE_ELEMENT_NAME);
            object.addTextNode(this._coordinationType.toString());
            sOAPElement.addChildElement((javax.xml.soap.SOAPElement)object);
        }
        if (this._registrationService != null) {
            object = sOAPFactory.createElement(REGISTRATION_SERVICE_ELEMENT_NAME);
            sOAPElement.addChildElement(this._registrationService.getSOAPElement((javax.xml.soap.SOAPElement)object));
        }
        this.addAttributesToSOAPElement(sOAPElement);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating SOAP elements for extensibility elements", this._extensibilityElements);
        }
        if (this._extensibilityElements != null) {
            object = this._extensibilityElements.keySet().iterator();
            while (object.hasNext()) {
                QName qName = (QName)object.next();
                javax.xml.soap.SOAPElement sOAPElement2 = sOAPFactory.createElement(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
                String string = (String)this._extensibilityElements.get(qName);
                sOAPElement2.addTextNode(string);
                sOAPElement.addChildElement(sOAPElement2);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" ");
        stringBuffer.append(this._coordinationType);
        stringBuffer.append(" ");
        stringBuffer.append(this._registrationService);
        return stringBuffer.toString();
    }

    public String getExtensibilityElement(QName qName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getExtensibilityElement", new Object[]{qName, this});
        }
        if (this._extensibilityElements != null) {
            String string = (String)this._extensibilityElements.get(qName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getExtensibilityElement", string);
            }
            return string;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getExtensibilityElement", null);
        }
        return null;
    }
}

