/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wscoor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.TransactionService;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextException;
import com.ibm.websphere.security.auth.WSSecurityContextResult;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorNullImpl;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.util.Base64;
import com.ibm.ws.wscoor.ServiceHelper;
import com.ibm.ws.wscoor.WSCoorConstants;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.rmi.RemoteException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.omg.CORBA.NO_PERMISSION;

public final class ProtocolSecurityHelper
implements SecurityServiceListener {
    private static final TraceComponent tc = Tr.register(ProtocolSecurityHelper.class, "WSCoor", null);
    private static final TraceComponent tc1 = Tr.register(ServiceHelper.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static ProtocolSecurityHelper _instance;
    private static RoleBasedAuthorizer _roleBasedAuthorizer;
    private static SecurityService _securityService;
    private static WSSecurityContext _securityContext;
    private static String _defaultRealm;
    private static boolean _disableProtocolSecurity;
    private static final int DEFAULT_AUTH_FAILURE_MESSAGE_INTERVAL = 10;
    public static final String AUTH_FAILURE_MESSAGE_INTERVAL = "AUTH_FAILURE_MESSAGE_INTERVAL";
    private static int _authFailureMessageInterval;
    private static int _authFailureCount;

    public static void initialize(TransactionService transactionService) {
        if (tc1.isEntryEnabled()) {
            Tr.entry(tc1, "initialize", transactionService);
        }
        if (_instance == null) {
            _instance = new ProtocolSecurityHelper(transactionService);
        }
        if (tc1.isEntryEnabled()) {
            Tr.exit(tc1, "initialize");
        }
    }

    private ProtocolSecurityHelper(TransactionService transactionService) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ProtocolSecurityHelper", transactionService);
        }
        try {
            EList eList;
            _disableProtocolSecurity = !transactionService.isEnableProtocolSecurity();
            try {
                _roleBasedAuthorizer = new RoleBasedConfiguratorNullImpl().getRoleBasedAuthorizer(null, null);
            }
            catch (RoleBasedAppException roleBasedAppException) {
                FFDCFilter.processException((Throwable)roleBasedAppException, "com.ibm.ws.wscoor.ProtocolSecurityHelper.ProtocolSecurityHelper", "102", this);
            }
            _securityService = (SecurityService)WsServiceRegistry.getService((Object)this, (Class)SecurityService.class);
            if (!_disableProtocolSecurity) {
                _securityService.addListener(this);
            }
            if ((eList = transactionService.getProperties()) != null && !eList.isEmpty()) {
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    Property property = (Property)iterator.next();
                    if (property == null) continue;
                    String string = property.getName();
                    String string2 = property.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Property name is " + string);
                        Tr.debug(tc, "Property value is " + string2);
                    }
                    if (!AUTH_FAILURE_MESSAGE_INTERVAL.equalsIgnoreCase(string)) continue;
                    _authFailureMessageInterval = Integer.parseInt(string2);
                }
            }
            if (_authFailureMessageInterval < 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resetting AUTH_FAILURE_MESSAGE_INTERVAL to 10");
                }
                _authFailureMessageInterval = 10;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wscoor.ProtocolSecurityHelper.ProtocolSecurityHelper", "54", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ProtocolSecurityHelper", this);
        }
    }

    public void stateChanged(SecurityServiceEvent securityServiceEvent) {
        block9: {
            if (tc1.isEntryEnabled()) {
                Tr.entry(tc1, "stateChanged", new Object[]{securityServiceEvent, this});
            }
            if (securityServiceEvent.getState() == 1) {
                _securityContext = _securityService.getWSSecurityContext();
                _defaultRealm = ContextManagerFactory.getInstance().getDefaultRealm();
                try {
                    RoleBasedConfigurator roleBasedConfigurator = _securityService.getConfigurator();
                    _roleBasedAuthorizer = roleBasedConfigurator.getRoleBasedAuthorizer("admin-authz", null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Proper RoleBasedAuthorizer now in use", _roleBasedAuthorizer);
                    }
                }
                catch (RoleBasedAppException roleBasedAppException) {
                    FFDCFilter.processException((Throwable)roleBasedAppException, "com.ibm.ws.wscoor.ProtocolSecurityHelper.stateChanged", "85", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "stateChanged", roleBasedAppException);
                    }
                    try {
                        _roleBasedAuthorizer = new RoleBasedConfiguratorNullImpl().getRoleBasedAuthorizer(null, null);
                    }
                    catch (RoleBasedAppException roleBasedAppException2) {
                        FFDCFilter.processException((Throwable)roleBasedAppException2, "com.ibm.ws.wscoor.ProtocolSecurityHelper.stateChanged", "94", this);
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug(tc, "stateChanged", roleBasedAppException2);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged");
        }
    }

    public static void checkAuthorization() throws NO_PERMISSION {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAuthorization");
        }
        if (!ProtocolSecurityHelper.authorized()) {
            ProtocolSecurityHelper.reportAuthFailure();
            NO_PERMISSION nO_PERMISSION = new NO_PERMISSION();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAuthorization", (Object)nO_PERMISSION);
            }
            throw nO_PERMISSION;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAuthorization");
        }
    }

    private static boolean authorized() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authorized");
        }
        boolean bl = _roleBasedAuthorizer.isCallerInRole("administrator");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authorized", bl);
        }
        return bl;
    }

    public static WSSecurityContext getSecurityContext() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSecurityContext", _securityContext);
        }
        return _securityContext;
    }

    public static String getDefaultRealm() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDefaultRealm", _defaultRealm);
        }
        return _defaultRealm;
    }

    public static boolean isEnforceProtocolSecurity() {
        boolean bl;
        boolean bl2 = bl = WSSecurityHelper.isGlobalSecurityEnabled() && !_disableProtocolSecurity;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isEnforceProtocolSecurity", bl);
        }
        return bl;
    }

    public static void checkAuthorization(EndpointReference endpointReference) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAuthorization", endpointReference);
        }
        if (!ProtocolSecurityHelper.authorized(endpointReference)) {
            ProtocolSecurityHelper.reportAuthFailure();
            RemoteException remoteException = new RemoteException("unauthorized");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAuthorization", remoteException);
            }
            throw remoteException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAuthorization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean authorized(EndpointReference endpointReference) {
        WSSecurityContext wSSecurityContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authorized", endpointReference);
        }
        if ((wSSecurityContext = ProtocolSecurityHelper.getSecurityContext()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "authorized", Boolean.TRUE);
            }
            return true;
        }
        if (endpointReference != null) {
            String string = endpointReference.getReferenceParameter(WSCoorConstants.SECURITY_ELEMENT_QNAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityToken", string);
            }
            if (string != null) {
                byte[] byArray = Base64.decode(string);
                try {
                    wSSecurityContext.acceptSecContext(byArray);
                    WSSecurityContextResult wSSecurityContextResult = wSSecurityContext.acceptSecContext(byArray);
                    if (wSSecurityContextResult != null) {
                        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                            public Object run() {
                                return ProtocolSecurityHelper.authorized();
                            }
                        };
                        Boolean bl = (Boolean)ContextManagerFactory.getInstance().runAsSpecified(wSSecurityContextResult.getSubject(), privilegedExceptionAction);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "authorized", bl);
                        }
                        boolean bl2 = bl;
                        return bl2;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.wscoor.ProtocolSecurityHelper.authorized", "251");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "authorized", exception);
                    }
                }
                finally {
                    try {
                        wSSecurityContext.dispose();
                    }
                    catch (WSSecurityContextException wSSecurityContextException) {
                        FFDCFilter.processException(wSSecurityContextException, "com.ibm.ws.wscoor.ProtocolSecurityHelper.authorized", "262");
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "authorized", Boolean.FALSE);
                        }
                        return false;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authorized", Boolean.FALSE);
        }
        return false;
    }

    public static void makeEPRSecure(String string, EndpointReference endpointReference) throws ReferenceParameterCreationException {
        String string2;
        if (tc1.isEntryEnabled()) {
            Tr.entry(tc1, "makeEPRSecure", new Object[]{string, endpointReference});
        }
        if ((string2 = ProtocolSecurityHelper.getSecurityToken(string)) != null) {
            endpointReference.setReferenceParameter(WSCoorConstants.SECURITY_ELEMENT_QNAME, string2);
        }
        if (tc1.isEntryEnabled()) {
            Tr.exit(tc1, "makeEPRSecure");
        }
    }

    private static String getSecurityToken(String string) {
        byte[] byArray;
        WSSecurityContext wSSecurityContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityToken", string);
        }
        if ((wSSecurityContext = ProtocolSecurityHelper.getSecurityContext()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityToken", null);
            }
            return null;
        }
        try {
            byArray = wSSecurityContext.initSecContext(ContextManagerFactory.getInstance().getServerSubject(), string, ProtocolSecurityHelper.getDefaultRealm());
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException(wSSecurityException, "com.ibm.ws.wscoor.ProtocolSecurityHelper.getSecurityToken", "363");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityToken", wSSecurityException);
            }
            return null;
        }
        String string2 = Base64.encode(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityToken", string2);
        }
        return string2;
    }

    public static void reportAuthFailure() {
        if (_authFailureCount++ % _authFailureMessageInterval == 0) {
            Tr.warning(tc, "WTRN0107_GENERIC_WARNING", "Number of protocol messages failing authorization: " + _authFailureCount);
        }
    }

    static {
        _authFailureMessageInterval = 10;
    }
}

