/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wscoor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.Alias;
import com.ibm.ws.http.VirtualHost;
import com.ibm.ws.runtime.service.VirtualHostMgr;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.webcontainer.channel.WCChannelFactory;
import com.ibm.ws.webservices.engine.types.URI;
import com.ibm.ws.wsaddressing.EndpointReference;
import com.ibm.ws.wsaddressing.HAResource;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelFactoryException;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.transaction.SystemException;

public final class ServiceHelper {
    private static final TraceComponent tc = Tr.register(ServiceHelper.class, "WSCoor", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static String _secureTransportChain;
    private static int _port;
    private static String _host;
    private static boolean _initFailed;
    private static byte[] _SRPortData;
    private static boolean _portAndHostInitialized;
    private static String _httpProxyPrefix;
    private static String _httpsProxyPrefix;
    private static String _virtualHostName;
    public static final int PORT_DATA_ERROR = 0;
    public static final int PORT_DATA_VERSION1 = 1;
    private static boolean _useUnsecuredProtocol;
    static /* synthetic */ Class class$com$ibm$ws$tcp$channel$impl$WSTCPChannelFactory;
    static /* synthetic */ Class class$com$ibm$ws$ssl$channel$impl$WSSSLChannelFactory;

    public ServiceHelper() {
        Tr.register(ServiceHelper.class, "Transaction", null);
    }

    public static void setSRPortData(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setSRPortData", byArray == null ? "null" : new ByteArray(byArray).toString());
        }
        _SRPortData = byArray;
    }

    private static boolean initializePortAndHostFromProxySettings() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initializePortAndHostFromProxySettings");
        }
        boolean bl = false;
        if (WSSecurityHelper.isServerSecurityEnabled()) {
            bl = ServiceHelper.processProxyPrefix(_httpsProxyPrefix);
        }
        if (!bl && (bl = ServiceHelper.processProxyPrefix(_httpProxyPrefix))) {
            _useUnsecuredProtocol = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initializePortAndHostFromProxySettings", bl);
        }
        return bl;
    }

    private static boolean processProxyPrefix(String string) {
        boolean bl;
        block5: {
            bl = false;
            URI uRI = null;
            if (string != null && !string.equals("")) {
                try {
                    uRI = new URI(string);
                    String string2 = uRI.getHost();
                    int n = uRI.getPort();
                    if (string2 != null && n != -1) {
                        ServiceHelper.setPortAndHost(n, string2);
                        bl = true;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "WS-Transaction Host and Port obtained from WCCM. Host " + string2 + " Port " + n);
                        }
                    }
                }
                catch (URI.MalformedURIException malformedURIException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "processProxyPrefix", malformedURIException);
                }
            }
        }
        return bl;
    }

    public static void setHttpProxyPrefix(String string) throws ConfigurationError {
        _httpProxyPrefix = ServiceHelper.validateProxyPrefix(string, "http");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHttpProxyPrefix", string);
        }
    }

    public static void setHttpsProxyPrefix(String string) throws ConfigurationError {
        _httpsProxyPrefix = ServiceHelper.validateProxyPrefix(string, "https");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHttpsProxyPrefix", string);
        }
    }

    private static String validateProxyPrefix(String string, String string2) throws ConfigurationError {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateProxyPrefix", new Object[]{string, string2});
        }
        String string3 = null;
        if (string != null && !string.equals("")) {
            try {
                URI uRI = new URI(string);
                if (uRI.getScheme().equals(string2)) {
                    String string4 = uRI.getPath();
                    String string5 = uRI.getQueryString();
                    String string6 = uRI.getFragment();
                    if (string4 != null && !string4.equals("") && !string4.equals("/") || string5 != null && !string5.equals("") || string6 != null && !string6.equals("")) {
                        throw new URI.MalformedURIException("Invalid URI specification for proxy prefix.");
                    }
                } else {
                    throw new URI.MalformedURIException("Bad scheme in proxy prefix.");
                }
                string3 = string;
            }
            catch (URI.MalformedURIException malformedURIException) {
                FFDCFilter.processException(malformedURIException, "com.ibm.ws.wscoor.ServiceHelper.validateProxyPrefix", "198");
                Tr.error(tc, "WTRN0100_GENERIC_ERROR", "Invalid " + string2 + " proxy prefix configuration: " + string);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateProxyPrefix", malformedURIException);
                }
                throw new ConfigurationError(malformedURIException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateProxyPrefix", string3);
        }
        return string3;
    }

    private static void setPortAndHost(int n, String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setPortAndHost", new Object[]{new Integer(n), string});
        }
        _host = string;
        _port = n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setPortAndHost");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.net.URI getAddressedURI(String string) throws SystemException {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAddressedURI", string);
        }
        if (_initFailed) {
            SystemException systemException = new SystemException("Cannot retrieve host and port from ChannelFramework.");
            FFDCFilter.processException(systemException, "com.ibm.ws.wscoor.ServiceHelper.getAddressedURI", "354");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getAddressedURI", (Object)systemException);
            }
            throw systemException;
        }
        URI uRI = null;
        try {
            uRI = new URI(string);
            if (!_portAndHostInitialized) {
                object = ServiceHelper.class;
                synchronized (object) {
                    if (!_portAndHostInitialized) {
                        ServiceHelper.initializePortAndHost();
                    }
                }
            }
            if (WSSecurityHelper.isGlobalSecurityEnabled() && !_useUnsecuredProtocol) {
                uRI.setScheme("https");
            } else {
                uRI.setScheme("http");
            }
            uRI.setHost(_host);
            uRI.setPort(_port);
        }
        catch (URI.MalformedURIException malformedURIException) {
            FFDCFilter.processException(malformedURIException, "com.ibm.ws.wscoor.ServiceHelper.getAddressedURI", "204");
            Throwable throwable = new SystemException().initCause((Throwable)malformedURIException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getAddressedURI", throwable);
            }
            throw (SystemException)throwable;
        }
        if (uRI == null) {
            object = new SystemException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getAddressedURI", object);
            }
            throw object;
        }
        object = java.net.URI.create(uRI.toString());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAddressedURI", object);
        }
        return object;
    }

    private static void initializePortAndHost() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initializePortAndHost");
        }
        if (!ServiceHelper.initializePortAndHostFromProxySettings()) {
            if (PlatformHelperFactory.getPlatformHelper().isServantJvm()) {
                ServiceHelper.demarshalPortData(_SRPortData);
            } else {
                ServiceHelper.initializePortAndHostFromCFS();
            }
        }
        if (_virtualHostName == null || _virtualHostName.length() == 0) {
            ServiceHelper.setVirtualHostName(_port);
        }
        _portAndHostInitialized = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initializePortAndHost");
        }
    }

    private static void setVirtualHostName(int n) {
        block13: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "setVirtualHostName", new Integer(n));
            }
            try {
                _virtualHostName = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() {
                        return System.getProperty("com.ibm.ws.wscoor.VirtualHost");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException(privilegedActionException, "com.ibm.ws.wscoor.ServiceHelper.setVirtualHostName", "335");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "setVirtualHostName", privilegedActionException);
            }
        }
        String string = null;
        if (_virtualHostName == null) {
            try {
                VirtualHost[] virtualHostArray;
                VirtualHostMgr virtualHostMgr = (VirtualHostMgr)WsServiceRegistry.getService((Object)tc, (Class)VirtualHostMgr.class);
                if (virtualHostMgr != null && (virtualHostArray = virtualHostMgr.getVirtualHosts()) != null) {
                    for (int i = 0; i < virtualHostArray.length && _virtualHostName == null; ++i) {
                        Alias[] aliasArray = virtualHostArray[i].getAliases();
                        if (aliasArray == null) continue;
                        for (int j = 0; j < aliasArray.length && _virtualHostName == null; ++j) {
                            if (Integer.parseInt(aliasArray[j].getPort()) == n) {
                                _virtualHostName = virtualHostArray[i].getName();
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Found Virtual Host Name", _virtualHostName);
                                continue;
                            }
                            if (!"*".equals(aliasArray[j].getPort())) continue;
                            string = virtualHostArray[i].getName();
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Found Wild Card Virtual Host Name", string);
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.wscoor.ServiceHelper.setVirtualHostName", "346");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setVirtualHostName", exception);
                }
                _initFailed = true;
            }
            if (_virtualHostName == null) {
                _virtualHostName = string == null ? "default_host" : string;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setVirtualHostName", _virtualHostName);
        }
    }

    public static String getVirtualHostName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getVirtualHostName", _virtualHostName);
        }
        return _virtualHostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] marshalPortData() {
        Object object;
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "marshalPortData");
            }
            if (!_portAndHostInitialized) {
                object = ServiceHelper.class;
                synchronized (object) {
                    if (!_portAndHostInitialized) {
                        ServiceHelper.initializePortAndHost();
                    }
                }
            }
            object = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                if (!_initFailed) {
                    dataOutputStream.writeByte(1);
                    dataOutputStream.writeInt(_port);
                    dataOutputStream.writeUTF(_host);
                    dataOutputStream.writeBoolean(_useUnsecuredProtocol);
                    dataOutputStream.flush();
                    dataOutputStream.close();
                    object = byteArrayOutputStream.toByteArray();
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.wscoor.ServiceHelper.marshalPortData", "277");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block10;
                Tr.event(tc, "IOException caught marshalling port data", iOException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshalPortData", object == null ? "null" : new ByteArray((byte[])object).toString());
        }
        return object;
    }

    public static void demarshalPortData(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "demarshalPortData", byArray == null ? "null" : new ByteArray(byArray).toString());
        }
        if (byArray == null) {
            _initFailed = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "demarshalPortData", "port and host unset");
            }
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream.read();
        byteArrayInputStream.read();
        byteArrayInputStream.read();
        byteArrayInputStream.read();
        int n = byteArrayInputStream.read();
        if (n == 1) {
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            try {
                int n2 = dataInputStream.readInt();
                String string = dataInputStream.readUTF();
                ServiceHelper.setPortAndHost(n2, string);
                _useUnsecuredProtocol = dataInputStream.readBoolean();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "data from CR ", new Object[]{new Integer(n2), string, _useUnsecuredProtocol});
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.wscoor.ServiceHelper.demarshalPortData", "313");
            }
        } else {
            _initFailed = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "demarshalPortData", new Object[]{new Integer(_port), _host});
        }
    }

    private static void initializePortAndHostFromCFS() {
        block31: {
            CFEndPoint cFEndPoint;
            boolean bl;
            block30: {
                ChainData[] chainDataArray;
                ChannelFrameworkService channelFrameworkService;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "initializePortAndHostFromCFS");
                }
                if ((channelFrameworkService = ServiceHelper.getChannelFrameworkService()) == null) {
                    _initFailed = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "initializePortAndHostFromCFS", "No ChannelFrameworkService");
                    }
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "ChannelFrameworkService obtained", channelFrameworkService);
                }
                try {
                    chainDataArray = channelFrameworkService.getAllChains(WCChannelFactory.class);
                }
                catch (InvalidChannelFactoryException invalidChannelFactoryException) {
                    FFDCFilter.processException(invalidChannelFactoryException, "com.ibm.ws.wscoor.ServiceHelper.initializePortAndHostFromCFS", "359");
                    _initFailed = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "initializePortAndHostFromCFS", (Object)invalidChannelFactoryException);
                    }
                    return;
                }
                bl = WSSecurityHelper.isGlobalSecurityEnabled();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "ChainDataArray size is " + chainDataArray.length);
                    int n = chainDataArray.length;
                    while (--n >= 0) {
                        Tr.debug(tc, "Chain [" + n + "] Name is " + chainDataArray[n].getName());
                        ChannelData[] channelDataArray = chainDataArray[n].getChannelList();
                        for (int i = 0; i < channelDataArray.length; ++i) {
                            Tr.debug(tc, "Channel [" + i + "] Factory is " + channelDataArray[i].getFactoryType());
                        }
                    }
                }
                cFEndPoint = null;
                try {
                    if (bl && _secureTransportChain != null) {
                        cFEndPoint = channelFrameworkService.getEndPoint(_secureTransportChain);
                        boolean bl2 = _useUnsecuredProtocol = !cFEndPoint.isSSLEnabled();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, " chain explicitly configured " + _secureTransportChain + ", useUnsecuredProtocol: " + _useUnsecuredProtocol);
                        }
                        break block30;
                    }
                    int n = chainDataArray.length;
                    while (--n >= 0) {
                        ChainData chainData = chainDataArray[n];
                        String string = chainData.getName();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking chain " + string);
                        }
                        if (string.startsWith("WCInboundAdmin") || string.startsWith("SOAPMonitorChain")) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, string + " excluded by name");
                            continue;
                        }
                        ChannelData[] channelDataArray = chainData.getChannelList();
                        if (channelDataArray == null || channelDataArray.length < 2) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, string + " has less than 2 channels");
                            continue;
                        }
                        Class clazz = channelDataArray[0].getFactoryType();
                        if (!clazz.equals(class$com$ibm$ws$tcp$channel$impl$WSTCPChannelFactory == null ? ServiceHelper.class$("com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory") : class$com$ibm$ws$tcp$channel$impl$WSTCPChannelFactory) && !clazz.getSuperclass().equals(class$com$ibm$ws$tcp$channel$impl$WSTCPChannelFactory == null ? ServiceHelper.class$("com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory") : class$com$ibm$ws$tcp$channel$impl$WSTCPChannelFactory)) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, string + " has no TCP channel");
                            continue;
                        }
                        clazz = channelDataArray[1].getFactoryType();
                        if (bl ^ clazz.equals(class$com$ibm$ws$ssl$channel$impl$WSSSLChannelFactory == null ? ServiceHelper.class$("com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory") : class$com$ibm$ws$ssl$channel$impl$WSSSLChannelFactory)) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, string + " has wrong SSL enablement");
                            continue;
                        }
                        cFEndPoint = channelFrameworkService.getEndPoint(string);
                        break;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.wscoor.ServiceHelper.initializePortAndHostFromCFS", "611");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block30;
                    Tr.debug(tc, "initializePortAndHostFromCFS", exception);
                }
            }
            if (cFEndPoint == null) {
                _initFailed = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "initializePortAndHostFromCFS", "Cannot find WebContainerChannel");
                }
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found CFEndPoint", cFEndPoint);
            }
            String string = cFEndPoint.getAddress().getHostName();
            _port = cFEndPoint.getPort();
            _virtualHostName = cFEndPoint.getVhost();
            if (string != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found host " + string);
                }
                try {
                    _host = "localhost".equals(string) || "*".equals(string) ? InetAddress.getLocalHost().getHostAddress() : (!bl || _secureTransportChain == null || _useUnsecuredProtocol ? InetAddress.getByName(string).getHostAddress() : string);
                }
                catch (UnknownHostException unknownHostException) {
                    FFDCFilter.processException(unknownHostException, "com.ibm.ws.wscoor.ServiceHelper.initializePortAndHostFromCFS", "449");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block31;
                    Tr.debug(tc, "initializePortAndHostFromCFS", unknownHostException);
                }
            }
        }
        if (_host == null) {
            _initFailed = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initializePortAndHostFromCFS", "Can't get host name");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initializePortAndHostFromCFS", new Object[]{new Integer(_port), _host, _virtualHostName});
        }
    }

    private static ChannelFrameworkService getChannelFrameworkService() {
        ChannelFrameworkService channelFrameworkService;
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getChannelFrameworkService");
            }
            channelFrameworkService = null;
            try {
                channelFrameworkService = (ChannelFrameworkService)WsServiceRegistry.getService((Object)tc, (Class)ChannelFrameworkService.class);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.Transaction.wstx.WSATServices.getChannelFrameworkService", "649");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block4;
                Tr.exit(tc, "getChannelFrameworkService", channelFrameworkService);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getChannelFrameworkService", channelFrameworkService);
        }
        return channelFrameworkService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getInitFailed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInitFailed");
        }
        if (!_portAndHostInitialized) {
            Class clazz = ServiceHelper.class;
            synchronized (clazz) {
                if (!_portAndHostInitialized) {
                    ServiceHelper.initializePortAndHost();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInitFailed", _initFailed);
        }
        return _initFailed;
    }

    public static void setSecureTransportChain(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setSecureTransportChain", string);
        }
        _secureTransportChain = string;
    }

    public static boolean setAffinity(com.ibm.wsspi.wsaddressing.EndpointReference endpointReference, HAResource hAResource) {
        ((EndpointReference)endpointReference).setVirtualHostName(ServiceHelper.getVirtualHostName());
        return ((EndpointReference)endpointReference).setAffinity(hAResource);
    }

    static {
        _useUnsecuredProtocol = false;
    }
}

