/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.wsgroup.WsGroupListener;
import com.ibm.ws.wsgroup.WsGroupManager;
import com.ibm.ws.wsgroup.WsGroupMember;
import com.ibm.ws.wsgroup.WsMessage;
import com.ibm.ws.wsgroup.WsMessageEnvelope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class WsGroup {
    public static final String ODC_NO_BCAST = "ODC_NO_BCAST";
    protected static final TraceComponent tc = TrUtil.register(WsGroup.class);
    public static final WsGroupMember[] NO_MEMBERS = new WsGroupMember[0];
    public static final WsGroupListener[] NO_LISTENERS = new WsGroupListener[0];
    protected final String name;
    protected final boolean global;
    protected final WsGroupManager manager;
    protected final List listenerList = new ArrayList();
    protected WsGroupListener[] listeners = NO_LISTENERS;
    protected WsGroupMember self = null;
    protected Map memberMap = Collections.synchronizedMap(new HashMap());
    protected Map memberJoinTimeMap = Collections.synchronizedMap(new HashMap());
    protected boolean started = false;
    protected boolean ready = false;

    public WsGroup(String string, boolean bl, WsGroupManager wsGroupManager) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "creating wsgroup " + string);
        }
        this.name = string;
        this.global = bl;
        this.manager = wsGroupManager;
    }

    public void start() throws Exception {
        if (!this.started) {
            this.memberMap.put(this.getSelf().getName(), this.getSelf());
            this.providerStart();
            this.started = true;
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean bl) {
        boolean bl2 = this.ready;
        this.ready = bl;
        if (bl != bl2 && bl) {
            this.receiveMessage(this.getSelf(), new WsMessageEnvelope(this.getSelf(), this.getSelf(), this, WsMessage.GROUP_IS_READY), 0);
        }
    }

    public void stop() throws Exception {
        if (this.started) {
            this.providerStop();
            this.started = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public WsGroupManager getManager() {
        return this.manager;
    }

    public synchronized long getMemberJoinTime(String string) {
        Long l = (Long)this.memberJoinTimeMap.get(string);
        if (l != null) {
            return l;
        }
        return -1L;
    }

    public synchronized WsGroupMember getMember(String string) {
        return (WsGroupMember)this.memberMap.get(string);
    }

    public synchronized WsGroupMember getMember(String string, Object object) {
        WsGroupMember wsGroupMember = this.getMember(string);
        if (wsGroupMember == null) {
            try {
                wsGroupMember = this.createMember(string, object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return wsGroupMember;
    }

    public synchronized WsGroupMember[] addListener(WsGroupListener wsGroupListener) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addListener entry " + wsGroupListener);
        }
        this.listenerList.add(wsGroupListener);
        this.listeners = this.listenerList.toArray(NO_LISTENERS);
        WsGroupMember[] wsGroupMemberArray = this.getMembers();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addListener exit " + wsGroupMemberArray);
        }
        return wsGroupMemberArray;
    }

    public synchronized void removeListener(WsGroupListener wsGroupListener) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeListener " + wsGroupListener);
        }
        this.listenerList.remove(wsGroupListener);
        this.listeners = this.listenerList.toArray(NO_LISTENERS);
    }

    public WsGroupMember[] getMembers() {
        return this.memberMap.values().toArray(NO_MEMBERS);
    }

    public void broadcastMessage(Object object) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "broadcastMessage to group " + this.name);
        }
        WsMessageEnvelope wsMessageEnvelope = new WsMessageEnvelope(this.getSelf(), this, object);
        WsGroupMember[] wsGroupMemberArray = this.getMembers();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < wsGroupMemberArray.length; ++i) {
            try {
                if (wsGroupMemberArray[i].equals(this.getSelf()) || wsGroupMemberArray[i].isODCPublisherOnly()) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, wsGroupMemberArray[i] + " skipped for bcast");
                    continue;
                }
                int n3 = wsGroupMemberArray[i].sendMessageEnvelope(wsMessageEnvelope);
                ++n2;
                if (n3 <= 0) continue;
                n = n3;
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.out);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSG: broadcastMessage of size " + n + ": " + object);
        }
    }

    public void memberJoined(WsGroupMember wsGroupMember) throws Exception {
        this.memberMap.put(wsGroupMember.getName(), wsGroupMember);
        this.memberJoinTimeMap.put(wsGroupMember.getName(), new Long(System.currentTimeMillis()));
        this.receiveMessage(wsGroupMember, new WsMessageEnvelope(wsGroupMember, this.getSelf(), this, WsMessage.JOINED_GROUP), 0);
    }

    public void memberLeft(WsGroupMember wsGroupMember) throws Exception {
        wsGroupMember.close();
        this.memberMap.remove(wsGroupMember.getName());
        this.memberJoinTimeMap.remove(wsGroupMember.getName());
        this.receiveMessage(wsGroupMember, new WsMessageEnvelope(wsGroupMember, this.getSelf(), this, WsMessage.LEFT_GROUP), 0);
    }

    public void receiveMessages(WsGroupMember wsGroupMember, WsMessageEnvelope[] wsMessageEnvelopeArray, int n) {
        if (wsMessageEnvelopeArray.length == 1) {
            this.receiveMessage(wsGroupMember, wsMessageEnvelopeArray[0], n);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSG: receiveMessages from " + wsGroupMember + ", count = " + wsMessageEnvelopeArray.length + ", total size = " + n);
            }
            for (int i = 0; i < wsMessageEnvelopeArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSG: (" + (i + 1) + ") " + wsMessageEnvelopeArray[i].getMessage());
                }
                this.deliverMessage(wsGroupMember, wsMessageEnvelopeArray[i]);
            }
        }
    }

    public void receiveMessage(WsGroupMember wsGroupMember, WsMessageEnvelope wsMessageEnvelope, int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSG: receiveMessage from " + wsGroupMember + (n > 0 ? " of size " + n : "") + ": " + wsMessageEnvelope.getMessage());
        }
        this.deliverMessage(wsGroupMember, wsMessageEnvelope);
    }

    public void deliverMessage(WsGroupMember wsGroupMember, WsMessageEnvelope wsMessageEnvelope) {
        WsGroupListener[] wsGroupListenerArray = this.listeners;
        for (int i = 0; i < wsGroupListenerArray.length; ++i) {
            try {
                wsGroupListenerArray[i].onMessage(wsMessageEnvelope);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.out);
            }
        }
    }

    public void updateMemberShip() throws Exception {
    }

    public String toString() {
        return this.name;
    }

    protected abstract void providerStart() throws Exception;

    protected abstract void providerStop() throws Exception;

    protected abstract WsGroupMember createMember(String var1, Object[] var2) throws Exception;

    protected abstract WsGroupMember createMember(String var1, Object var2) throws Exception;

    protected abstract Object getMyContext();

    public abstract WsGroupMember getSelf();
}

