/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.wsgroup.WsGroup;
import com.ibm.ws.wsgroup.WsMessageEnvelope;
import java.util.HashMap;
import java.util.Map;

public abstract class WsGroupMember {
    protected static final TraceComponent tc = TrUtil.register(WsGroup.class);
    public static final String ODC_PUBLISHER_ONLY = "ODC_PUBLISHER_ONLY";
    public static final String COREGROUP_NAME = "COREGROUP_NAME";
    public static final String CONTRIBUTORS = "CONTRIBUTORS";
    protected String name;
    protected String groupName;
    protected boolean isSelf;
    protected WsGroup group;
    protected Map map = new HashMap();
    protected boolean isODCPublisherOnly = true;

    public WsGroupMember(String string, String string2, boolean bl, WsGroup wsGroup) {
        this.name = string;
        this.groupName = string2;
        this.isSelf = bl;
        this.group = wsGroup;
    }

    public WsGroupMember() {
    }

    public String getName() {
        return this.name;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    public WsGroup getGroup() {
        return this.group;
    }

    public boolean isODCPublisherOnly() {
        return this.isODCPublisherOnly;
    }

    public void setODCPublisherOnly(boolean bl) {
        this.isODCPublisherOnly = bl;
    }

    public boolean isInMyCoreGroup() {
        return true;
    }

    public String getCoreGroupName() {
        return this.getProperty(COREGROUP_NAME, "");
    }

    public String[] getContributors() {
        String string = (String)this.map.get(CONTRIBUTORS);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "contributors from " + this + ": " + string);
        }
        if (string == null) {
            return new String[]{this.name};
        }
        return string.split(",");
    }

    public int sendMessage(Object object) throws Exception {
        if (this.isSelf) {
            return 0;
        }
        int n = this.providerSendMessage(new WsMessageEnvelope(this.group.getSelf(), this, this.group, object));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSG: sendMessage of size " + n + " to " + this.name + ": " + object);
        }
        return n;
    }

    public int sendMessageEnvelope(WsMessageEnvelope wsMessageEnvelope) throws Exception {
        if (this.isSelf) {
            return 0;
        }
        return this.providerSendMessage(wsMessageEnvelope);
    }

    public void close() throws Exception {
        this.providerClose();
    }

    public abstract int providerSendMessage(WsMessageEnvelope var1) throws Exception;

    public abstract void providerClose() throws Exception;

    public boolean equals(Object object) {
        return this.name.equals(((WsGroupMember)object).name);
    }

    public String toString() {
        return this.name;
    }

    public synchronized void setProperty(String string, String string2) {
        this.map.put(string, string2);
    }

    public synchronized String getProperty(String string) {
        return (String)this.map.get(string);
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public void updateMap(Map map) {
        this.map.putAll(map);
        boolean bl = new Boolean((String)this.map.get(ODC_PUBLISHER_ONLY));
        if (bl != this.isODCPublisherOnly()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updateMap: " + this.name + " Changing " + ODC_PUBLISHER_ONLY + " :" + bl);
            }
            this.setODCPublisherOnly(bl);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "memberContributors: member=" + this + ", contributors=" + this.map.get(CONTRIBUTORS));
        }
    }

    public Map getMap() {
        return this.map;
    }
}

