/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup;

import com.ibm.ws.wsgroup.WsGroup;
import com.ibm.ws.wsgroup.WsGroupManagerFactory;
import com.ibm.ws.wsgroup.WsGroupMember;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class WsMessageEnvelope
implements Externalizable {
    static final long serialVersionUID = 1L;
    protected WsGroupMember sender = null;
    protected WsGroupMember receiver = null;
    protected WsGroup group = null;
    protected String senderName;
    protected String receiverName;
    protected String groupName;
    protected Object message;
    protected Object messageContext = null;
    protected boolean receiverInitialized;
    protected final long creationTime = System.currentTimeMillis();

    public WsMessageEnvelope(WsGroupMember wsGroupMember, WsGroupMember wsGroupMember2, WsGroup wsGroup, Object object) {
        this.sender = wsGroupMember;
        this.senderName = wsGroupMember.getName();
        this.receiver = wsGroupMember2;
        this.receiverName = wsGroupMember2 != null ? wsGroupMember2.getName() : null;
        this.group = wsGroup;
        this.groupName = wsGroup.getName();
        this.message = object;
        this.receiverInitialized = true;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public WsMessageEnvelope(WsGroupMember wsGroupMember, WsGroup wsGroup, Object object) {
        this(wsGroupMember, null, wsGroup, object);
    }

    public WsMessageEnvelope() {
        this.receiverInitialized = false;
    }

    public void setSender(WsGroupMember wsGroupMember) {
        this.sender = wsGroupMember;
        if (wsGroupMember != null) {
            this.senderName = wsGroupMember.getName();
            this.setGroup(wsGroupMember.getGroup());
        }
    }

    public void setGroup(WsGroup wsGroup) {
        this.group = wsGroup;
        if (wsGroup != null) {
            this.groupName = wsGroup.getName();
        }
    }

    public WsGroupMember getSender() {
        if (this.sender == null) {
            this.sender = this.group.getMember(this.senderName, this.messageContext);
        }
        return this.sender;
    }

    public WsGroupMember getReceiver() {
        if (!this.receiverInitialized) {
            this.receiver = this.receiverName != null ? this.group.getMember(this.receiverName, this.messageContext) : null;
            this.receiverInitialized = true;
        }
        return this.receiver;
    }

    public Object getMessage() {
        return this.message;
    }

    public Object getMessageContext() {
        return this.messageContext;
    }

    public void setMessageContext(Object object) {
        this.messageContext = object;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeObject(this.sender.getName());
        objectOutput.writeObject(this.receiver != null ? this.receiver.getName() : null);
        objectOutput.writeObject(this.group.getName());
        objectOutput.writeObject(this.message);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        this.senderName = (String)objectInput.readObject();
        this.receiverName = (String)objectInput.readObject();
        String string = (String)objectInput.readObject();
        this.message = objectInput.readObject();
        try {
            this.group = WsGroupManagerFactory.getManager().getGroup(string);
            if (this.group == null) {
                throw new IOException("group '" + string + "' not found");
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public String toString() {
        return "Envelope { sender: " + this.senderName + ", receiver: " + (this.receiverName == null ? "broadcast" : this.receiverName) + ", creation time: " + this.getCreationTime() + ", message: " + this.message + " }";
    }
}

