/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup.bb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.hamanagerservice.HAManagerService;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.util.Util;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.wsgroup.WsGroup;
import com.ibm.ws.wsgroup.WsGroupManager;
import com.ibm.ws.wsgroup.WsGroupMember;
import com.ibm.ws.wsgroup.WsGroupUtil;
import com.ibm.ws.wsgroup.WsLocalProcessProperties;
import com.ibm.ws.wsgroup.WsMessageEnvelope;
import com.ibm.ws.wsgroup.bb.BBGroupMember;
import com.ibm.ws.wsgroup.bb.CoreGroup;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardFactory;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScopes;
import com.ibm.wsspi.hamanager.corestack.CoreStack;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;

public class BBGroup
extends WsGroup {
    protected static final TraceComponent tc = TrUtil.register(BBGroup.class);
    protected static final CoreGroup[] NO_CORE_GROUPS = new CoreGroup[0];
    protected static final BBGroupMember[] NO_BBMEMBERS = new BBGroupMember[0];
    protected BulletinBoard bb = null;
    protected CoreGroup myCoreGroup = null;
    protected String myCoreGroupName = null;
    protected CoreGroup[] remoteCoreGroups = null;
    protected CoreGroup[] allCoreGroups = null;
    protected long prevSmallestAck = -1L;
    protected boolean started;

    public BBGroup(String string, boolean bl, WsGroupManager wsGroupManager) throws Exception {
        super(string, bl, wsGroupManager);
        WsLocalProcessProperties.getPropertiesMap().put("COREGROUP_NAME", this.getMyCoreGroupName());
        this.initBB();
        this.initCoreGroups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsGroupMember getSelf() {
        if (this.self == null) {
            BBGroup bBGroup = this;
            synchronized (bBGroup) {
                if (this.self == null) {
                    try {
                        this.self = this.createMember(WsGroupUtil.getMyName(), this.allCoreGroups);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            }
        }
        return this.self;
    }

    public BulletinBoard getBB() {
        return this.bb;
    }

    public synchronized BBGroupMember[] getBBMembers() {
        return this.memberMap.values().toArray(NO_BBMEMBERS);
    }

    public void broadcastMessage(Object object) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "broadcastMessage " + object);
        }
        WsMessageEnvelope wsMessageEnvelope = new WsMessageEnvelope(this.getSelf(), this, object);
        int n = (Integer)WsLocalProcessProperties.getPropertiesMap().get("GROUP_VERSION");
        if (n > 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using real broadcast topic");
            }
            int n2 = this.myCoreGroup.broadcast(wsMessageEnvelope);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSG: broadcastMessage of size " + n2 + ": " + object);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using iterative broadcast");
            }
            super.broadcastMessage(object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSG: iterative broadcastMessage:" + object);
            }
        }
    }

    public void processBroadcastAcks() throws Exception {
        long l = this.getSmallestAck();
        if (l > this.prevSmallestAck) {
            this.prevSmallestAck = l;
            for (int i = 0; i < this.allCoreGroups.length; ++i) {
                this.allCoreGroups[i].processBroadcastAck(l);
            }
        }
    }

    public long getSmallestAck() throws Exception {
        long l = Long.MAX_VALUE;
        BBGroupMember[] bBGroupMemberArray = this.getBBMembers();
        for (int i = 0; i < bBGroupMemberArray.length; ++i) {
            long l2;
            if (bBGroupMemberArray[i].isSelf() || (l2 = bBGroupMemberArray[i].getLastBroadcastSequenceNumber()) >= l) continue;
            l = l2;
        }
        return l;
    }

    public void updateMemberShip() throws Exception {
        Map map = WsLocalProcessProperties.getPropertiesMap();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Posting Membership: " + map);
        }
        for (int i = 0; i < this.allCoreGroups.length; ++i) {
            this.allCoreGroups[i].post(map, true);
        }
    }

    public void providerStart() throws Exception {
        if (this.started) {
            return;
        }
        if (Util.isProxy()) {
            WsLocalProcessProperties.getPropertiesMap().put("ODC_PUBLISHER_ONLY", "false");
        } else {
            WsLocalProcessProperties.getPropertiesMap().put("ODC_PUBLISHER_ONLY", "true");
        }
        for (int i = 0; i < this.allCoreGroups.length; ++i) {
            this.allCoreGroups[i].start();
        }
        this.started = true;
    }

    public void providerStop() throws Exception {
        if (!this.started) {
            return;
        }
        for (int i = 0; i < this.allCoreGroups.length; ++i) {
            this.allCoreGroups[i].stop();
        }
        this.started = false;
    }

    protected void initBB() {
        try {
            CoreStack coreStack = (CoreStack)WsServiceRegistry.getService((Object)this, CoreStack.class);
            if (coreStack == null) {
                throw new RuntimeException("Failed to find CoreStack");
            }
            BulletinBoardFactory bulletinBoardFactory = coreStack.getBulletinboardFactory();
            if (bulletinBoardFactory == null) {
                throw new RuntimeException("Failed to find bulletin board factory");
            }
            this.bb = bulletinBoardFactory.findBulletinBoard("WsGroup." + this.name);
            if (this.bb == null) {
                throw new RuntimeException("Failed to find WsGroup bulletin board");
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void initCoreGroups() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initCoreGroups");
        }
        try {
            BulletinBoardScopes bulletinBoardScopes;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initialize public scope");
            }
            if ((bulletinBoardScopes = (BulletinBoardScopes)WsServiceRegistry.getService((Object)this, BulletinBoardScopes.class)) == null) {
                throw new RuntimeException("Failed to find bulletin BulletinBoardScopes");
            }
            this.myCoreGroup = new CoreGroup(this.bb, bulletinBoardScopes.getPublicScope(), "local", this, true);
            Map map = bulletinBoardScopes.getPeerAccessPointsMap();
            Iterator iterator = map.keySet().iterator();
            ArrayList<CoreGroup> arrayList = new ArrayList<CoreGroup>();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found scope " + string);
                }
                BulletinBoardScope bulletinBoardScope = null;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("peerName", string);
                bulletinBoardScope = bulletinBoardScopes.getRemoteScope(hashMap);
                arrayList.add(new CoreGroup(this.bb, bulletinBoardScope, string, this, false));
            }
            this.remoteCoreGroups = arrayList.toArray(NO_CORE_GROUPS);
            arrayList.add(this.myCoreGroup);
            this.allCoreGroups = arrayList.toArray(NO_CORE_GROUPS);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initCoreGroups");
        }
    }

    public void receiveMessages(WsGroupMember wsGroupMember, WsMessageEnvelope[] wsMessageEnvelopeArray, byte[] byArray) {
        super.receiveMessages(wsGroupMember, wsMessageEnvelopeArray, byArray.length);
    }

    protected WsGroupMember createMember(String string, Object object) throws Exception {
        return this.createMember(string, new Object[]{object});
    }

    protected WsGroupMember createMember(String string, Object[] objectArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMember", "memberName=" + string + " memberContext=" + objectArray);
        }
        if (objectArray == null || objectArray.length == 1 && objectArray[0] == null) {
            objectArray = new Object[]{this.myCoreGroup};
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createMember", "Number of contexts: " + objectArray.length);
        }
        CoreGroup coreGroup = (CoreGroup)objectArray[0];
        BBGroupMember bBGroupMember = new BBGroupMember(string, this.getName(), string.equals(WsGroupUtil.getMyName()), coreGroup.getBBGroup());
        for (int i = 0; i < objectArray.length; ++i) {
            coreGroup = (CoreGroup)objectArray[i];
            bBGroupMember.addCoreGroup(coreGroup);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMember", "member=" + bBGroupMember);
        }
        return bBGroupMember;
    }

    public Object getMyContext() {
        return this.myCoreGroup;
    }

    public void memberLeft(WsGroupMember wsGroupMember) throws Exception {
        super.memberLeft(wsGroupMember);
        this.processBroadcastAcks();
    }

    public String getMyCoreGroupName() {
        if (this.myCoreGroupName == null) {
            try {
                Resource resource;
                Repository repository2;
                String string = "";
                String string2 = System.getProperty("file.separator");
                StringBuffer stringBuffer = new StringBuffer("nodes" + string2 + WsGroupUtil.getMyNodeName() + string2 + "servers" + string2 + WsGroupUtil.getMyProcessName() + string2 + "hamanagerservice.xml");
                try {
                    repository2 = (Repository)WsServiceRegistry.getService((Object)this, Repository.class);
                    if (repository2 == null) {
                        throw new RuntimeException("Repository service unavailable");
                    }
                    resource = repository2.getConfigRoot().getResource(0, stringBuffer.toString());
                }
                catch (Exception exception) {
                    throw new ConfigurationWarning("Unable to getResource at [" + stringBuffer.toString() + "] exception=" + exception);
                }
                repository2 = (HAManagerService)resource.getContents().get(0);
                string = repository2.getCoreGroupName();
                this.myCoreGroupName = WsGroupUtil.getMyCellName() + "\\" + string;
            }
            catch (ConfigurationWarning configurationWarning) {
                TrUtil.error(configurationWarning, this, "getMyCoreGroupName", tc);
            }
        }
        return this.myCoreGroupName;
    }
}

