/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup.bb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.wsgroup.WsGroupMember;
import com.ibm.ws.wsgroup.WsGroupUtil;
import com.ibm.ws.wsgroup.WsMessageEnvelope;
import com.ibm.ws.wsgroup.bb.BBGroup;
import com.ibm.ws.wsgroup.bb.BBPostingAck;
import com.ibm.ws.wsgroup.bb.BBPostingMsg;
import com.ibm.ws.wsgroup.bb.BBTopic;
import com.ibm.ws.wsgroup.bb.BBWatchDog;
import com.ibm.ws.wsgroup.bb.CoreGroup;
import com.ibm.ws.wsgroup.bb.Trace;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import java.util.ArrayList;

public class BBGroupMember
extends WsGroupMember {
    protected static final TraceComponent tc = TrUtil.register(BBGroupMember.class);
    protected static final byte[] EMPTY_BUF = new byte[0];
    protected final BBGroup bbGroup;
    protected ArrayList coreGroup = new ArrayList();
    protected ArrayList msgTopic = new ArrayList();
    protected ArrayList ackTopic = new ArrayList();
    protected long lastSequenceNumber = -1L;
    protected long lastBroadcastSequenceNumber = -1L;

    public BBGroupMember(String string, String string2, boolean bl, BBGroup bBGroup) throws Exception {
        super(string, string2, bl, bBGroup);
        this.bbGroup = bBGroup;
    }

    public boolean isInMyCoreGroup() {
        String string = this.bbGroup.getMyCoreGroupName();
        if (string == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isInMyCoreGroup " + this.name + "; don't know my core group");
            }
            return true;
        }
        String string2 = this.getCoreGroupName();
        boolean bl = string.equals(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isInMyCoreGroup " + this.name + "; myCoreGroup=" + string + ", memberCoreGroup=" + string2 + ", answer=" + bl);
        }
        return bl;
    }

    public void addCoreGroup(CoreGroup coreGroup) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Adding coregoup " + coreGroup + " to " + this);
        }
        this.coreGroup.add(coreGroup);
        this.msgTopic.add(new MsgTopic(this.name, coreGroup.getBB(), coreGroup.getScope(), coreGroup.getScopeName(), this.msgTopic.size()));
        this.ackTopic.add(new AckTopic(this.name, coreGroup.getBB(), coreGroup.getScope(), coreGroup.getScopeName(), this.ackTopic.size()));
    }

    public int providerSendMessage(WsMessageEnvelope wsMessageEnvelope) throws Exception {
        int n = 0;
        for (int i = 0; i < this.msgTopic.size(); ++i) {
            MsgTopic msgTopic = (MsgTopic)this.msgTopic.get(i);
            n = msgTopic.sendMessage(wsMessageEnvelope);
        }
        return n;
    }

    public void providerClose() throws Exception {
        BBTopic bBTopic;
        int n;
        for (n = 0; n < this.msgTopic.size(); ++n) {
            bBTopic = (MsgTopic)this.msgTopic.get(n);
            ((MsgTopic)bBTopic).close();
        }
        for (n = 0; n < this.ackTopic.size(); ++n) {
            bBTopic = (AckTopic)this.ackTopic.get(n);
            bBTopic.close();
        }
    }

    public void handleAck(BBPostingAck bBPostingAck) throws Exception {
        if (bBPostingAck.isBroadcast()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BCAST: received ACK from " + this + ": " + bBPostingAck);
            }
            this.lastBroadcastSequenceNumber = bBPostingAck.getSequenceNumber();
            this.bbGroup.processBroadcastAcks();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "received ACK for point-to-point from " + this + ": " + bBPostingAck);
            }
            this.lastSequenceNumber = bBPostingAck.getSequenceNumber();
            MsgTopic msgTopic = (MsgTopic)this.msgTopic.get(0);
            msgTopic.receivedAck(this.lastSequenceNumber);
        }
    }

    public long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public long getLastBroadcastSequenceNumber() {
        return this.lastBroadcastSequenceNumber;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof BBGroupMember)) {
            return false;
        }
        return this.name.equals(((BBGroupMember)object).name);
    }

    public String toString() {
        return this.name;
    }

    protected class AckTopic
    extends BBTopic {
        protected final BBPostingAck posting;
        protected final BBPostingAck bcastPosting;
        protected int index;

        public AckTopic(String string, BulletinBoard bulletinBoard, BulletinBoardScope bulletinBoardScope, String string2, int n) throws Exception {
            super("ACK-" + string, bulletinBoard, bulletinBoardScope, string2);
            this.posting = new BBPostingAck();
            this.bcastPosting = new BBPostingAck(true);
            this.index = n;
            if (BBGroupMember.this.isSelf) {
                this.listen();
            }
        }

        public long sendAck(long l) throws Exception {
            long l2 = this.posting.setSequenceNumber(l);
            this.post(this.posting, false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sendAck (seqNo=" + l + ") to " + BBGroupMember.this.name);
            }
            return l2;
        }

        public long sendBroadcastAck(long l) throws Exception {
            long l2 = this.bcastPosting.setSequenceNumber(l);
            this.post(this.bcastPosting, false);
            return l2;
        }

        protected void markReady() {
        }

        protected void postingAdded(String string, byte[] byArray) throws Exception {
            this.handleAck(string, byArray);
        }

        protected void postingChanged(String string, byte[] byArray) throws Exception {
            this.handleAck(string, byArray);
        }

        protected void postingRemoved(String string) throws Exception {
        }

        protected void handleAck(String string, byte[] byArray) throws Exception {
            BBGroupMember bBGroupMember = (BBGroupMember)BBGroupMember.this.group.getMember(string, BBGroupMember.this.coreGroup.get(this.index));
            BBPostingAck bBPostingAck = (BBPostingAck)WsGroupUtil.byteArrayToObject(byArray);
            bBGroupMember.handleAck(bBPostingAck);
        }
    }

    protected class MsgTopic
    extends BBTopic {
        protected final BBPostingMsg posting;
        int index;
        BBWatchDog watchDog;

        public MsgTopic(String string, BulletinBoard bulletinBoard, BulletinBoardScope bulletinBoardScope, String string2, int n) throws Exception {
            super("MSG-" + string, bulletinBoard, bulletinBoardScope, string2);
            this.watchDog = null;
            this.posting = new BBPostingMsg(string);
            this.index = n;
            if (BBGroupMember.this.isSelf) {
                this.listen();
            }
        }

        public synchronized void cleanup() throws Exception {
            this.posting.cleanup();
            this.postBuf(EMPTY_BUF);
        }

        public synchronized int sendMessage(WsMessageEnvelope[] wsMessageEnvelopeArray) throws Exception {
            int n;
            if (this.watchDog == null) {
                this.watchDog = new BBWatchDog(this, this.posting);
                this.watchDog.scheduleAlarm();
            }
            long l = 0L;
            for (n = 0; n < wsMessageEnvelopeArray.length; ++n) {
                l = this.addMessage(wsMessageEnvelopeArray[n]);
            }
            n = this.post(this.posting, true);
            if (Trace.tc.isDebugEnabled()) {
                Tr.debug(Trace.tc, "BBMSG: sendMsg to " + BBGroupMember.this.name + ", seqno=" + l + ", size " + n + (wsMessageEnvelopeArray.length == 1 ? "" : ", count=" + wsMessageEnvelopeArray.length));
            }
            return n;
        }

        public synchronized int sendMessage(WsMessageEnvelope wsMessageEnvelope) throws Exception {
            if (this.watchDog == null) {
                this.watchDog = new BBWatchDog(this, this.posting);
                this.watchDog.scheduleAlarm();
            }
            long l = this.addMessage(wsMessageEnvelope);
            int n = this.post(this.posting, true);
            if (Trace.tc.isDebugEnabled()) {
                Tr.debug(Trace.tc, "BBMSG: sendMsg to " + BBGroupMember.this.name + ", seqno=" + l + ", size " + n);
            }
            return n;
        }

        private long addMessage(WsMessageEnvelope wsMessageEnvelope) {
            long l = this.posting.addMessage(wsMessageEnvelope);
            return l;
        }

        public void receivedAck(long l) throws Exception {
            if (Trace.tc.isDebugEnabled()) {
                Tr.debug(Trace.tc, "BBMSG: receivedAck from " + BBGroupMember.this.name + ", seqno=" + l);
            }
            if (this.posting.receivedAck(l)) {
                this.postBuf(EMPTY_BUF);
            }
        }

        protected void markReady() {
        }

        protected void postingAdded(String string, byte[] byArray) throws Exception {
            this.handleMessage(string, byArray);
        }

        protected void postingChanged(String string, byte[] byArray) throws Exception {
            this.handleMessage(string, byArray);
        }

        protected void postingRemoved(String string) throws Exception {
        }

        public void close() throws Exception {
            if (this.watchDog != null) {
                this.watchDog.cancel();
            }
            super.close();
        }

        protected void handleMessage(String string, byte[] byArray) throws Exception {
            if (byArray.length == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "empty message from " + string);
                }
                return;
            }
            BBGroupMember bBGroupMember = (BBGroupMember)BBGroupMember.this.group.getMember(string, BBGroupMember.this.coreGroup.get(this.index));
            BBPostingMsg bBPostingMsg = (BBPostingMsg)WsGroupUtil.byteArrayToObject(byArray);
            AckTopic ackTopic = (AckTopic)bBGroupMember.ackTopic.get(0);
            long l = ackTopic.sendAck(bBPostingMsg.getSequenceNumber());
            WsMessageEnvelope[] wsMessageEnvelopeArray = bBPostingMsg.getMessages(l, BBGroupMember.this.coreGroup.get(this.index));
            ((BBGroup)BBGroupMember.this.group).receiveMessages((WsGroupMember)bBGroupMember, wsMessageEnvelopeArray, byArray);
        }
    }
}

