/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup.bb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScopes;
import com.ibm.wsspi.hamanager.bboard.DuplicatePostException;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.bboard.SubjectPost;
import com.ibm.wsspi.hamanager.bboard.SubjectPostClosedException;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class BBPostCache {
    protected static final TraceComponent tc = TrUtil.register(BBPostCache.class);
    private static BBPostCache _cache = new BBPostCache();
    protected Hashtable postsTable = new Hashtable();
    protected BulletinBoardScopes bbs = null;

    protected BBPostCache() {
        try {
            this.bbs = (BulletinBoardScopes)WsServiceRegistry.getService((Object)this, BulletinBoardScopes.class);
        }
        catch (Exception exception) {
            RuntimeException runtimeException = new RuntimeException("BulletinBoardScopes service unavailable");
            runtimeException.initCause(exception);
            throw runtimeException;
        }
    }

    public static BBPostCache getInstance() {
        return _cache;
    }

    public synchronized SubjectPost getPost(String string, BulletinBoard bulletinBoard) throws HAParameterRejectedException, DuplicatePostException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPost", "Looking up post for: " + string);
        }
        PostsTableEntry postsTableEntry = (PostsTableEntry)this.postsTable.get(string);
        SubjectPost subjectPost = null;
        if (postsTableEntry == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getPost", "Creating post for " + string);
            }
            object = bulletinBoard.createSubject(this.bbs.getPublicScope(), string);
            subjectPost = bulletinBoard.createPost((SubjectInfo)object);
            this.postsTable.put(string, new PostsTableEntry(subjectPost, System.currentTimeMillis()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getPost", "Added <<" + string + ", " + subjectPost + ">> to cache");
            }
        } else {
            subjectPost = postsTableEntry.post;
            postsTableEntry.lastAccessTime = System.currentTimeMillis();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getPost", "Found " + string + " :: " + subjectPost);
            }
        }
        if (tc.isDebugEnabled()) {
            object = new StringBuffer();
            Enumeration enumeration = this.postsTable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                ((StringBuffer)object).append(string2 + "::" + this.postsTable.get(string2) + "\n");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getPost", "Cache:\n" + object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPost", string + " :: " + subjectPost);
        }
        return subjectPost;
    }

    public synchronized boolean closePost(String string) throws SubjectPostClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closePost", "Looking up post for: " + string);
        }
        boolean bl = true;
        PostsTableEntry postsTableEntry = (PostsTableEntry)this.postsTable.remove(string);
        SubjectPost subjectPost = null;
        if (postsTableEntry != null) {
            subjectPost = postsTableEntry.post;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "closePost", "closing " + string + " :: " + subjectPost);
            }
            subjectPost.close();
            bl = true;
        } else {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closePost", "Closed post for: " + string);
        }
        return bl;
    }

    class PostsTableEntry {
        public SubjectPost post;
        public long lastAccessTime;

        public PostsTableEntry(SubjectPost subjectPost, long l) {
            this.post = subjectPost;
            this.lastAccessTime = l;
        }

        public String toString() {
            return this.post + ":" + new Date(this.lastAccessTime);
        }
    }
}

