/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup.bb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.wsgroup.WsMessageEnvelope;
import com.ibm.ws.wsgroup.bb.Trace;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class BBPostingMsg
implements Externalizable {
    protected static final TraceComponent tc = TrUtil.register(BBPostingMsg.class);
    private static final int ACK_TIMEOUT = Integer.parseInt(System.getProperty("ODCAckTimeout", "60000"));
    private static final int CLEAR_MESSAGE_AGE = Integer.parseInt(System.getProperty("ODCClearMessageAge", "300000"));
    static final long serialVersionUID = 1L;
    protected String name = "inbound message";
    protected long sequenceNumber = -1L;
    protected List messages = new ArrayList();

    public BBPostingMsg() {
    }

    public BBPostingMsg(String string) {
        this.name = string;
    }

    public synchronized long addMessage(WsMessageEnvelope wsMessageEnvelope) {
        this.messages.add(wsMessageEnvelope);
        ++this.sequenceNumber;
        if (Trace.tc.isDebugEnabled()) {
            Tr.debug(Trace.tc, "BBMSG: posting " + wsMessageEnvelope.getClass().getName() + ", seqno=" + this.sequenceNumber + ", count=" + this.messages.size() + ", name=" + this.name + ", hc=" + this.hashCode());
        }
        if (Trace.tc.isDebugEnabled()) {
            Tr.debug(Trace.tc, "BBMSG: adding message: " + wsMessageEnvelope);
        }
        if (this.messages.size() > 1) {
            WsMessageEnvelope wsMessageEnvelope2 = (WsMessageEnvelope)this.messages.get(0);
            long l = System.currentTimeMillis() - wsMessageEnvelope2.getCreationTime();
            if (Trace.tc.isDebugEnabled()) {
                Tr.debug(Trace.tc, "BBMSG: age of oldest non-ACKed message is " + l + " message=" + wsMessageEnvelope2);
            }
            if (l > 360000L) {
                Exception exception = new Exception("BBMSG: (this message can be ignored unless you are experiencing other issues) age of oldest non-ACKed message is " + l + " message=" + wsMessageEnvelope2);
                FFDCFilter.processException(exception, "com.ibm.ws.wsgroup.bb.BBPostingMsg", "65");
            }
        }
        return this.sequenceNumber;
    }

    public synchronized boolean clearOldMessages() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearOldMessages (total=" + this.messages.size() + " for posting " + this.name);
        }
        boolean bl = false;
        while (this.messages.size() > 0) {
            WsMessageEnvelope wsMessageEnvelope = (WsMessageEnvelope)this.messages.get(0);
            long l = System.currentTimeMillis() - wsMessageEnvelope.getCreationTime();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "message age=" + l);
            }
            if (l <= (long)CLEAR_MESSAGE_AGE) break;
            Exception exception = new Exception("BBMSG: (this message can be ignored unless you are experiencing other issues) age of oldest non-ACKed message is " + l + " message=" + wsMessageEnvelope);
            FFDCFilter.processException(exception, "com.ibm.ws.wsgroup.bb.BBPostingMsg", "65");
            bl = true;
            this.messages.remove(0);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearOldMessages for posting " + this.name + " cleared=" + bl);
        }
        return bl;
    }

    public synchronized void cleanup() {
        Exception exception = new Exception("Dropping messages because no ACKs have been received recently from " + this.name + ", seqno=" + this.sequenceNumber + ", hc=" + this.hashCode() + ": " + this.messages);
        TrUtil.warning(exception, this, "BBPostingMsg.cleanup", tc);
        this.messages.clear();
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public synchronized WsMessageEnvelope[] getMessages(long l, Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getMessages: prevSeqNo=" + l + ", seqNo=" + this.sequenceNumber + ", size=" + this.messages.size());
        }
        long l2 = this.sequenceNumber - (long)this.messages.size();
        if (l >= this.sequenceNumber) {
            l = l2;
        }
        if (l < l2 && l != -1L) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getMessages: previous sequence number is too small; ignore");
            }
            return new WsMessageEnvelope[0];
        }
        int n = l != -1L ? (int)(this.sequenceNumber - l) : this.messages.size();
        int n2 = this.messages.size();
        WsMessageEnvelope[] wsMessageEnvelopeArray = new WsMessageEnvelope[n];
        while (n > 0) {
            WsMessageEnvelope wsMessageEnvelope = (WsMessageEnvelope)this.messages.get(--n2);
            wsMessageEnvelope.setMessageContext(object);
            wsMessageEnvelopeArray[--n] = wsMessageEnvelope;
        }
        return wsMessageEnvelopeArray;
    }

    public synchronized boolean receivedAck(long l) {
        if (Trace.tc.isDebugEnabled()) {
            Tr.debug(Trace.tc, "BBMSG: receivedAck, seqno=" + this.sequenceNumber + ", count=" + this.messages.size() + ", name=" + this.name + ", hc=" + this.hashCode());
        }
        if (l == this.sequenceNumber) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "receivedAck of " + l + "; clearing messages");
            }
            this.messages.clear();
            return true;
        }
        if (l < this.sequenceNumber) {
            int n = (int)(this.sequenceNumber - l);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "receivedAck of " + l + "; leaving " + n);
            }
            while (this.messages.size() > n) {
                this.messages.remove(0);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "receivedAck of " + l + "; spurious ack");
        }
        return false;
    }

    public synchronized void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeLong(this.sequenceNumber);
        objectOutput.writeObject(this.messages);
    }

    public synchronized void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readInt();
        this.sequenceNumber = objectInput.readLong();
        this.messages = (List)objectInput.readObject();
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.messages.size() == 1) {
            stringBuffer.append("message number ").append(this.sequenceNumber);
            stringBuffer.append(": ").append(this.messages.get(0));
        } else {
            stringBuffer.append("message bundle:");
            int n = (int)(this.sequenceNumber - (long)this.messages.size() + 1L);
            int n2 = 0;
            while (n2 < this.messages.size()) {
                stringBuffer.append("\n\t(").append(n).append(") ").append(this.messages.get(n2));
                ++n2;
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

