/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup.bb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.wsgroup.WsGroupUtil;
import com.ibm.ws.wsgroup.WsMessageEnvelope;
import com.ibm.ws.wsgroup.bb.BBPostCache;
import com.ibm.ws.wsgroup.bb.BBPostingMsg;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.DuplicatePostException;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.bboard.SubjectPost;
import com.ibm.wsspi.hamanager.bboard.SubjectPostClosedException;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionEvents;
import com.ibm.wsspi.hamanager.bboard.SubjectValue;
import java.util.HashMap;
import java.util.Map;

public abstract class BBTopic
implements SubjectSubscriptionEvents {
    protected static final TraceComponent tc = TrUtil.register(BBTopic.class);
    private static final int BBMSG_BUFFER_WARNING_SIZE = Integer.parseInt(System.getProperty("BBMSG_BUFFER_WARNING_SIZE", "1000"));
    protected final String name;
    protected final BulletinBoard bb;
    protected final BulletinBoardScope scope;
    protected final String scopeName;
    protected final SubjectInfo subject;
    protected SubjectSubscription subscription = null;
    protected HashMap versionMap = new HashMap();
    protected boolean ready = false;

    public BBTopic(String string, BulletinBoard bulletinBoard, BulletinBoardScope bulletinBoardScope, String string2) throws Exception {
        this.name = string;
        this.bb = bulletinBoard;
        this.scope = bulletinBoardScope;
        this.scopeName = string2;
        this.subject = bulletinBoard.createSubject(bulletinBoardScope, string);
    }

    public String getName() {
        return this.name;
    }

    public BulletinBoard getBB() {
        return this.bb;
    }

    public BulletinBoardScope getScope() {
        return this.scope;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public SubjectInfo getSubject() {
        return this.subject;
    }

    public SubjectSubscription getSubscription() {
        return this.subscription;
    }

    public boolean isReady() {
        return this.ready;
    }

    public String toString() {
        return "BBTopic@" + this.hashCode() + " [" + this.name + "] ";
    }

    public void listen() throws Exception {
        if (this.subscription == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this + "subscribing to topic " + this.name + " in scope " + this.scopeName);
            }
            this.subscription = this.bb.subscribe(this.subject, this);
        }
    }

    public synchronized int post(Object object, boolean bl) throws Exception {
        byte[] byArray = WsGroupUtil.objectToByteArray(object, bl);
        this.postBuf(byArray);
        return byArray.length;
    }

    public synchronized void postBuf(byte[] byArray) throws Exception {
        Object object;
        SubjectPost subjectPost = this.getPost();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "postBuf", this + " posting " + subjectPost + " to " + this.name + " in public scope(always) of size " + byArray.length);
        }
        if (byArray.length > BBMSG_BUFFER_WARNING_SIZE * 1024 && (object = WsGroupUtil.byteArrayToObject(byArray)) instanceof BBPostingMsg) {
            BBPostingMsg bBPostingMsg = (BBPostingMsg)object;
            Tr.warning(tc, "BB Message buffer warning size of " + BBMSG_BUFFER_WARNING_SIZE + " exceeded, current buffer is: " + byArray.length);
            Tr.warning(tc, this + " posting " + subjectPost + " to " + this.name + " in public scope(always) of size " + byArray.length);
            WsMessageEnvelope[] wsMessageEnvelopeArray = bBPostingMsg.getMessages(-1L, null);
            Tr.warning(tc, "Number of messages: " + wsMessageEnvelopeArray.length);
            long l = System.currentTimeMillis();
            for (int i = 0; i < wsMessageEnvelopeArray.length; ++i) {
                Tr.warning(tc, "Message age=" + (l - wsMessageEnvelopeArray[i].getCreationTime()) + " content=" + wsMessageEnvelopeArray[i]);
            }
        }
        subjectPost.updatePost(byArray);
    }

    public void close() throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this + "closing topic " + this.name + " in scope " + this.scopeName);
        }
        if (this.subscription != null) {
            this.subscription.close();
            this.subscription = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this + "closing post name:" + this.name);
        }
        this.closePost();
    }

    public void updated(SubjectSubscription subjectSubscription, SubjectValue[] subjectValueArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this + "updated topic " + this.name + " in scope " + this.scopeName);
        }
        Map map = (Map)this.versionMap.clone();
        for (int i = 0; i < subjectValueArray.length; ++i) {
            Object object = subjectValueArray[i];
            String string = object.getServerName();
            if (string.equals(WsGroupUtil.getMyName())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this + "server " + string);
            }
            Long l = (Long)map.remove(string);
            Long l2 = new Long(object.getVersion());
            this.versionMap.put(string, l2);
            if (l == null) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, this + "topic change to " + this.name + " in scope " + this.scopeName + ": new poster " + string);
                    }
                    this.postingAdded(string, object.getValues());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.out);
                }
                continue;
            }
            if (l.equals(l2)) continue;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this + "topic change to " + this.name + " in scope " + this.scopeName + ": mod poster " + string);
                }
                if (string.equals(WsGroupUtil.getMyName())) continue;
                this.postingChanged(string, object.getValues());
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.out);
            }
        }
        for (Object object : map.keySet()) {
            try {
                this.versionMap.remove(object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this + "topic change to " + this.name + " in scope " + this.scopeName + ": del poster " + (String)object);
                }
                this.postingRemoved((String)object);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.out);
            }
        }
        if (!this.ready) {
            this.ready = true;
            this.markReady();
        }
    }

    public SubjectPost getPost() throws HAParameterRejectedException, DuplicatePostException {
        return BBPostCache.getInstance().getPost(this.name, this.bb);
    }

    public boolean closePost() throws SubjectPostClosedException {
        return BBPostCache.getInstance().closePost(this.name);
    }

    protected abstract void markReady();

    protected abstract void postingAdded(String var1, byte[] var2) throws Exception;

    protected abstract void postingChanged(String var1, byte[] var2) throws Exception;

    protected abstract void postingRemoved(String var1) throws Exception;
}

