/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup.bb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.wsgroup.bb.BBPostingMsg;
import com.ibm.ws.wsgroup.bb.BBTopic;

public class BBWatchDog
implements AlarmListener {
    protected static final TraceComponent tc = TrUtil.register(BBWatchDog.class);
    private final int MSG_CLEAR_WATCHDOG_INTERVAL = Integer.parseInt(System.getProperty("ODCMsgClearInterval", "150000"));
    BBTopic topic;
    BBPostingMsg posting;
    Alarm alarm;

    public BBWatchDog(BBTopic bBTopic, BBPostingMsg bBPostingMsg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "BBWatchDog", bBTopic.getName());
        }
        this.topic = bBTopic;
        this.posting = bBPostingMsg;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "BBWatchDog");
        }
    }

    public void scheduleAlarm() {
        this.alarm = AlarmManager.createNonDeferrable(this.MSG_CLEAR_WATCHDOG_INTERVAL, this);
    }

    public synchronized void alarm(Object object) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "watchdog woken for topic: " + this.topic.getName());
        }
        if (bl = this.posting.clearOldMessages()) {
            try {
                int n = this.topic.post(this.posting, false);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "BCAST: reposted after clearing messages, new size=" + n);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        this.scheduleAlarm();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    public synchronized void cancel() {
        if (this.alarm != null) {
            this.alarm.cancel();
        }
    }
}

