/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup.bb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.wsgroup.WsGroupMember;
import com.ibm.ws.wsgroup.WsGroupUtil;
import com.ibm.ws.wsgroup.WsLocalProcessProperties;
import com.ibm.ws.wsgroup.WsMessageEnvelope;
import com.ibm.ws.wsgroup.bb.BBGroup;
import com.ibm.ws.wsgroup.bb.BBGroupMember;
import com.ibm.ws.wsgroup.bb.BBPostingMsg;
import com.ibm.ws.wsgroup.bb.BBTopic;
import com.ibm.ws.wsgroup.bb.BBWatchDog;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import java.util.HashMap;
import java.util.Map;

public class CoreGroup
extends BBTopic {
    public static final String WSGROUP_CURRENT_VERSION = "WSGROUP_CURRENT_VERSION";
    public static final String WSGROUP_MAX_VERSION = "WSGROUP_MAX_VERSION";
    public static final byte current_version = 1;
    public static final byte max_version = 1;
    protected static final TraceComponent tc = TrUtil.register(CoreGroup.class);
    public static byte[] myMembershipPosting = new byte[]{1, 1};
    protected static final byte[] EMPTY_BUF = new byte[0];
    protected final BBGroup bbGroup;
    protected final HashMap membershipMap = new HashMap();
    protected final boolean local;
    protected final BroadcastTopic bcastTopic;

    public CoreGroup(BulletinBoard bulletinBoard, BulletinBoardScope bulletinBoardScope, String string, BBGroup bBGroup, boolean bl) throws Exception {
        super("MEMBER", bulletinBoard, bulletinBoardScope, string);
        this.bbGroup = bBGroup;
        this.local = bl;
        this.bcastTopic = new BroadcastTopic(bulletinBoard, bulletinBoardScope, string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "created coregroup for scope " + string);
        }
    }

    public boolean isLocal() {
        return this.local;
    }

    public BBGroup getBBGroup() {
        return this.bbGroup;
    }

    public void start() throws Exception {
        WsLocalProcessProperties.getPropertiesMap().put(WSGROUP_CURRENT_VERSION, new Integer(1));
        WsLocalProcessProperties.getPropertiesMap().put(WSGROUP_MAX_VERSION, new Integer(1));
        if (this.local) {
            this.post(WsLocalProcessProperties.getPropertiesMap(), true);
        }
        this.listen();
        this.bcastTopic.start();
    }

    public void stop() throws Exception {
        this.close();
        this.bcastTopic.stop();
    }

    protected void postingAdded(String string, byte[] byArray) throws Exception {
        Object object;
        BBGroupMember bBGroupMember = (BBGroupMember)this.bbGroup.getMember(string, this);
        if (byArray != null && byArray.length > 0) {
            object = WsGroupUtil.byteArrayToObject(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "postingAdded " + bBGroupMember + " post:" + object);
            }
            if (object instanceof Map) {
                bBGroupMember.getMap().putAll((Map)object);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Member is not posting a Map");
            }
        }
        if (bBGroupMember.getMap().get(WSGROUP_MAX_VERSION) == null) {
            bBGroupMember.getMap().put(WSGROUP_MAX_VERSION, new Integer(0));
        }
        if (bBGroupMember.getMap().get(WSGROUP_CURRENT_VERSION) == null) {
            bBGroupMember.getMap().put(WSGROUP_CURRENT_VERSION, new Integer(0));
        }
        this.membershipMap.put(string, bBGroupMember);
        object = WsGroupUtil.byteArrayToObject(byArray);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "postingAdded " + bBGroupMember + " post:" + object);
        }
        if (object instanceof Map) {
            bBGroupMember.updateMap((Map)object);
        }
        this.bbGroup.memberJoined(bBGroupMember);
    }

    protected void postingChanged(String string, byte[] byArray) throws Exception {
        BBGroupMember bBGroupMember = (BBGroupMember)this.bbGroup.getMember(string);
        if (bBGroupMember != null) {
            Object object = WsGroupUtil.byteArrayToObject(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "postingAdded " + bBGroupMember + " post:" + object);
            }
            if (object instanceof Map) {
                bBGroupMember.updateMap((Map)object);
            }
        }
    }

    protected void postingRemoved(String string) throws Exception {
        BBGroupMember bBGroupMember = (BBGroupMember)this.membershipMap.remove(string);
        if (bBGroupMember != null) {
            this.bbGroup.memberLeft(bBGroupMember);
        }
    }

    protected void markReady() {
        this.bbGroup.setReady(true);
    }

    public int broadcast(WsMessageEnvelope wsMessageEnvelope) throws Exception {
        return this.bcastTopic.broadcast(wsMessageEnvelope);
    }

    public void processBroadcastAck(long l) throws Exception {
        this.bcastTopic.receivedAck(l);
    }

    public String toString() {
        return super.toString() + " core group " + this.scopeName;
    }

    private class BroadcastTopic
    extends BBTopic {
        protected final BBPostingMsg posting;
        BBWatchDog watchDog;

        public BroadcastTopic(BulletinBoard bulletinBoard, BulletinBoardScope bulletinBoardScope, String string) throws Exception {
            super("BROADCAST", bulletinBoard, bulletinBoardScope, string);
            this.posting = new BBPostingMsg("broadcast");
            this.watchDog = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "created broadcast for " + string);
            }
        }

        public void start() throws Exception {
            this.listen();
        }

        public void stop() throws Exception {
            this.close();
        }

        public void close() throws Exception {
            if (this.watchDog != null) {
                this.watchDog.cancel();
            }
            super.close();
        }

        public synchronized int broadcast(WsMessageEnvelope wsMessageEnvelope) throws Exception {
            if (this.watchDog == null) {
                this.watchDog = new BBWatchDog(this, this.posting);
                this.watchDog.scheduleAlarm();
            }
            long l = this.posting.addMessage(wsMessageEnvelope);
            int n = this.post(this.posting, false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BCAST: sent seqno " + l + ", size=" + n);
            }
            return n;
        }

        public void receivedAck(long l) throws Exception {
            if (this.posting.receivedAck(l)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "BCAST: receivedAck of seqno " + l + "; removing post");
                }
                this.postBuf(EMPTY_BUF);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BCAST: receivedAck of seqno " + l);
            }
        }

        protected void postingAdded(String string, byte[] byArray) throws Exception {
            this.handleMessage(string, byArray);
        }

        protected void postingChanged(String string, byte[] byArray) throws Exception {
            this.handleMessage(string, byArray);
        }

        protected void handleMessage(String string, byte[] byArray) throws Exception {
            if (byArray.length == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "empty broadcast message from " + string);
                }
                return;
            }
            BBGroupMember bBGroupMember = (BBGroupMember)CoreGroup.this.bbGroup.getMember(string, CoreGroup.this);
            BBPostingMsg bBPostingMsg = (BBPostingMsg)WsGroupUtil.byteArrayToObject(byArray);
            long l = bBPostingMsg.getSequenceNumber();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BCAST: received broadcast from " + string + "; seqNo=" + l + ", size=" + byArray.length);
            }
            BBGroupMember.AckTopic ackTopic = (BBGroupMember.AckTopic)bBGroupMember.ackTopic.get(0);
            long l2 = ackTopic.sendBroadcastAck(l);
            WsMessageEnvelope[] wsMessageEnvelopeArray = bBPostingMsg.getMessages(l2, CoreGroup.this);
            CoreGroup.this.bbGroup.receiveMessages((WsGroupMember)bBGroupMember, wsMessageEnvelopeArray, byArray);
        }

        protected void postingRemoved(String string) throws Exception {
        }

        protected void markReady() {
        }

        public String toString() {
            return super.toString() + " broadcast topic " + this.scopeName;
        }
    }
}

