/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup.bb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.util.ServiceHandle;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.wsgroup.WsGroupManager;
import com.ibm.ws.wsgroup.WsGroupMember;
import com.ibm.ws.wsgroup.WsGroupUtil;
import com.ibm.ws.wsgroup.WsLocalProcessProperties;
import com.ibm.ws.wsgroup.WsMessageEnvelope;
import com.ibm.ws.wsgroup.bb.BBGroup;
import com.ibm.ws.wsgroup.bb.BBPostingMsg;
import com.ibm.ws.wsgroup.bb.CoreGroup;
import com.ibm.ws.wsgroup.bb.HBGroupMember;
import com.ibm.wsspi.hamanager.AsynchOperationComplete;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAGroup;
import com.ibm.wsspi.hamanager.HAGroupCallback;
import com.ibm.wsspi.hamanager.corestack.CoreStack;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HBGroup
extends BBGroup
implements HAGroupCallback {
    protected static final TraceComponent tc = TrUtil.register(HBGroup.class);
    public static final String HB_GROUP_ENABLED = "HB_GROUP_ENABLED";
    protected HAGroup haGroup = null;
    protected String coreGroup = null;
    public static final String MESSAGETYPE = "MESSAGETYPE";
    public static final String MESSAGETYPE_BCAST = "MESSAGETYPE_BCAST";
    protected final HashMap coregroupMap = new HashMap();

    public HAGroup getHaGroup() {
        return this.haGroup;
    }

    public HBGroup(String string, boolean bl, WsGroupManager wsGroupManager) throws Exception {
        super(string, bl, wsGroupManager);
        this.initHA();
    }

    protected void initHA() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initHA");
        }
        try {
            ServiceHandle serviceHandle = ServiceHandle.obtain(CoreStack.class);
            if (serviceHandle == null) {
                throw new RuntimeException("CoreStack service unavailable");
            }
            CoreStack coreStack = (CoreStack)serviceHandle.getService();
            if (coreStack == null) {
                throw new RuntimeException("Failed to find CoreStack");
            }
            GroupManager groupManager = coreStack.getGroupManager();
            ((HBGroupMember)this.getSelf()).setCoreGroup(this.getMyCoreGroupName());
            this.getSelf().setProperty("COREGROUP_NAME", ((HBGroupMember)this.getSelf()).getCoreGroup());
            GroupName groupName = groupManager.createGroupName(this.getSelf().getMap());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "groupName=" + groupName);
            }
            this.haGroup = groupManager.joinGroup(groupName, new HashMap(), this);
        }
        catch (Exception exception) {
            TrUtil.error(exception, this, "initHA", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initHA", "haGroup=" + this.haGroup);
        }
    }

    public void receiveMessages(WsGroupMember wsGroupMember, WsMessageEnvelope[] wsMessageEnvelopeArray, byte[] byArray) {
        WsMessageEnvelope[] wsMessageEnvelopeArray2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveMessages", wsGroupMember);
        }
        if ((wsMessageEnvelopeArray2 = this.extractFromBcastMessage(wsMessageEnvelopeArray, wsGroupMember)) != null && wsMessageEnvelopeArray2.length != wsMessageEnvelopeArray.length) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Relaying BCAST msg from " + wsGroupMember + "[" + wsGroupMember.getGroupName() + "] locally");
            }
            this.broadcastLocal(byArray);
        }
        super.receiveMessages(wsGroupMember, wsMessageEnvelopeArray2, byArray.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveMessages", wsGroupMember);
        }
    }

    public WsMessageEnvelope[] extractFromBcastMessage(WsMessageEnvelope[] wsMessageEnvelopeArray, WsGroupMember wsGroupMember) {
        HashMap hashMap;
        Object v;
        WsMessageEnvelope wsMessageEnvelope;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractFromBcastMessage", "incoming:" + wsMessageEnvelopeArray.length);
        }
        WsMessageEnvelope[] wsMessageEnvelopeArray2 = wsMessageEnvelopeArray;
        if (wsMessageEnvelopeArray != null && wsMessageEnvelopeArray.length > 1 && (object = (wsMessageEnvelope = wsMessageEnvelopeArray[0]).getMessage()) != null && object instanceof HashMap && (v = (hashMap = (HashMap)object).get(MESSAGETYPE)) != null && v.equals(MESSAGETYPE_BCAST)) {
            wsMessageEnvelopeArray2 = new WsMessageEnvelope[wsMessageEnvelopeArray.length - 1];
            for (int i = 0; i < wsMessageEnvelopeArray2.length; ++i) {
                wsMessageEnvelopeArray2[i] = wsMessageEnvelopeArray[i + 1];
                wsMessageEnvelopeArray2[i].setSender(wsGroupMember);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractFromBcastMessage", wsMessageEnvelopeArray2.length + "");
        }
        return wsMessageEnvelopeArray2;
    }

    public WsMessageEnvelope[] convertToBcastMessage(WsMessageEnvelope[] wsMessageEnvelopeArray) {
        if (wsMessageEnvelopeArray == null) {
            wsMessageEnvelopeArray = new WsMessageEnvelope[]{};
        }
        int n = wsMessageEnvelopeArray.length + 1;
        WsMessageEnvelope[] wsMessageEnvelopeArray2 = new WsMessageEnvelope[n];
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(MESSAGETYPE, MESSAGETYPE_BCAST);
        wsMessageEnvelopeArray2[0] = new WsMessageEnvelope(this.getSelf(), this, hashMap);
        for (int i = 0; i < wsMessageEnvelopeArray.length; ++i) {
            wsMessageEnvelopeArray2[i + 1] = wsMessageEnvelopeArray[i];
        }
        return wsMessageEnvelopeArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsGroupMember getSelf() {
        if (this.self == null) {
            HBGroup hBGroup = this;
            synchronized (hBGroup) {
                if (this.self == null) {
                    try {
                        this.self = this.createMember(WsGroupUtil.getMyName(), this.allCoreGroups);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            }
        }
        return (HBGroupMember)this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberLeft(WsGroupMember wsGroupMember) throws Exception {
        WsGroupMember wsGroupMember2 = wsGroupMember;
        synchronized (wsGroupMember2) {
            HBGroupMember hBGroupMember = (HBGroupMember)wsGroupMember;
            hBGroupMember.setHasLeft(true);
            wsGroupMember.notifyAll();
            List list = (List)this.getCoregroupMap().get(hBGroupMember.getCoreGroup());
            if (list != null) {
                list.remove(hBGroupMember);
            }
        }
        super.memberLeft(wsGroupMember);
    }

    public void broadcastLocal(byte[] byArray) {
        HBGroupMember[] hBGroupMemberArray = (HBGroupMember[])this.getMembers();
        ArrayList<GroupMemberId> arrayList = new ArrayList<GroupMemberId>();
        for (int i = 0; i < hBGroupMemberArray.length; ++i) {
            HBGroupMember hBGroupMember = hBGroupMemberArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "broadcastLocal: considering --> " + hBGroupMember);
            }
            if (hBGroupMember.isLocal() && !hBGroupMember.isSelf()) {
                if (hBGroupMember.isODCPublisherOnly()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, hBGroupMember + " does not accept broadcasts");
                    }
                } else {
                    arrayList.add(hBGroupMember.getGroupMemberId());
                }
            }
            if (hBGroupMember.isLocal() || hBGroupMember.isSelf() || hBGroupMember.isODCPublisherOnly() || !hBGroupMember.getCoreGroup().equalsIgnoreCase(((HBGroupMember)this.getSelf()).getCoreGroup())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, hBGroupMember + " Not joined HAGroup");
            }
            if (!hBGroupMember.waitToJoinHAGroup()) continue;
            arrayList.add(hBGroupMember.getGroupMemberId());
        }
        if (arrayList.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Bcast local to " + arrayList.size() + " members");
            }
            try {
                this.getHaGroup().sendMessage(MsgQoS.NORMAL, arrayList.toArray(new GroupMemberId[0]), byArray);
            }
            catch (HAException hAException) {
                TrUtil.error(hAException, this, "broadcastLocal", tc);
            }
        }
    }

    public WsGroupMember[] getMembers() {
        return this.memberMap.values().toArray(new HBGroupMember[0]);
    }

    public void broadcastMessage(Object object) throws Exception {
        Object object2;
        Object object32;
        WsMessageEnvelope wsMessageEnvelope = new WsMessageEnvelope(this.getSelf(), this, object);
        this.broadcastLocal(WsGroupUtil.objectToByteArray(wsMessageEnvelope, true));
        WsMessageEnvelope[] wsMessageEnvelopeArray = this.convertToBcastMessage(new WsMessageEnvelope[]{wsMessageEnvelope});
        for (Object object32 : this.getCoregroupMap().keySet()) {
            List list = (List)this.getCoregroupMap().get(object32);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "broadcastMessage: considering CG: " + (String)object32 + " members#:" + list.size());
            }
            if (((String)object32).equalsIgnoreCase(this.getMyCoreGroupName()) || ((String)object32).equals("COMPAT_COREGROUP") || ((String)object32).equals("UNINITIALIZED_COREGROUP")) {
                Tr.debug(tc, "broadcastMessage: NO Relay BCAST TO CG: " + (String)object32);
                continue;
            }
            if (list.size() > 0) {
                HBGroupMember hBGroupMember;
                int n;
                object2 = new ArrayList();
                for (n = 0; n < list.size(); ++n) {
                    hBGroupMember = (HBGroupMember)list.get(n);
                    if (hBGroupMember.isODCPublisherOnly()) continue;
                    ((ArrayList)object2).add(hBGroupMember);
                }
                if (((ArrayList)object2).size() > 0) {
                    n = (int)(System.currentTimeMillis() % (long)((ArrayList)object2).size());
                    hBGroupMember = (HBGroupMember)((ArrayList)object2).get(n);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, hBGroupMember + " relaying BCAST for CG: " + (String)object32);
                    }
                    hBGroupMember.providerSendMessages(wsMessageEnvelopeArray);
                    continue;
                }
                Tr.debug(tc, "broadcastMessage: CG: " + (String)object32 + " has no members accepting bcasts");
                continue;
            }
            Tr.debug(tc, "broadcastMessage: CG: " + (String)object32 + " has no members");
        }
        object32 = (List)this.getCoregroupMap().get("COMPAT_COREGROUP");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "#COMPAT Members: " + (object32 == null ? 0 : object32.size()));
        }
        if (object32 != null) {
            for (int i = 0; i < object32.size(); ++i) {
                object2 = (HBGroupMember)object32.get(i);
                if (((HBGroupMember)object2).isHBGroup()) continue;
                ((HBGroupMember)object2).providerSendMessage(wsMessageEnvelope);
            }
        }
    }

    public void memberJoined(WsGroupMember wsGroupMember) throws Exception {
        HBGroupMember hBGroupMember = (HBGroupMember)wsGroupMember;
        if (hBGroupMember.getCoreGroup().equalsIgnoreCase(this.getMyCoreGroupName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberJoined in my coreGroup :" + hBGroupMember);
            }
            if (hBGroupMember.callJoinGroupWhenHAJoins()) {
                super.memberJoined(hBGroupMember);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberJoined not in my HAGroup yet...");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberJoined in coreGroup:" + hBGroupMember.getCoreGroup());
            }
            super.memberJoined(hBGroupMember);
        }
        ArrayList<HBGroupMember> arrayList = (ArrayList<HBGroupMember>)this.getCoregroupMap().get(hBGroupMember.getCoreGroup());
        if (arrayList == null) {
            arrayList = new ArrayList<HBGroupMember>();
            this.getCoregroupMap().put(hBGroupMember.getCoreGroup(), arrayList);
        }
        arrayList.add(hBGroupMember);
    }

    protected WsGroupMember createMember(String string, Object[] objectArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMember", "memberName=" + string + " memberContext=" + objectArray);
        }
        if (objectArray == null || objectArray.length == 1 && objectArray[0] == null) {
            objectArray = new Object[]{this.myCoreGroup};
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createMember", "Number of contexts: " + objectArray.length);
        }
        CoreGroup coreGroup = (CoreGroup)objectArray[0];
        HBGroupMember hBGroupMember = new HBGroupMember(string, this.getName(), string.equals(WsGroupUtil.getMyName()), this, null);
        this.memberMap.put(string, hBGroupMember);
        for (int i = 0; i < objectArray.length; ++i) {
            coreGroup = (CoreGroup)objectArray[i];
            hBGroupMember.addCoreGroup(coreGroup);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMember", "member=" + hBGroupMember);
        }
        return hBGroupMember;
    }

    public boolean isAlive(GroupName groupName) {
        return true;
    }

    protected static Set getKeySet(Map map) {
        HashSet hashSet = new HashSet();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    public void membershipChanged(GroupName groupName, GroupMemberId[] groupMemberIdArray) {
        HBGroupMember hBGroupMember;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "membershipChanged " + groupMemberIdArray.length);
        }
        int n = 0;
        int n2 = 0;
        Set set = HBGroup.getKeySet(this.memberMap);
        for (int i = 0; i < groupMemberIdArray.length; ++i) {
            String string = groupMemberIdArray[i].getServerName();
            set.remove(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "membershipChanged", string);
            }
            if ((hBGroupMember = (HBGroupMember)this.getMember(string)) == null) {
                try {
                    hBGroupMember = (HBGroupMember)this.createMember(string, null);
                }
                catch (Exception exception) {
                    TrUtil.error(exception, this, "membershipChanged", tc);
                }
            }
            if (hBGroupMember.getGroupMemberId() != null) continue;
            ++n;
            hBGroupMember.setGroupMemberId(groupMemberIdArray[i]);
        }
        for (String string : set) {
            hBGroupMember = (HBGroupMember)this.getMember(string);
            hBGroupMember.setGroupMemberId(null);
            ++n2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "membershipChanged added:" + n + " removed:" + n2 + "  total:" + this.memberMap.size());
        }
    }

    public void onMessage(GroupMemberId groupMemberId, byte[] byArray) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onMessage: " + groupMemberId + " msg:" + byArray.length);
        }
        Object object2 = WsGroupUtil.byteArrayToObject(byArray);
        WsMessageEnvelope[] wsMessageEnvelopeArray = null;
        if (object2 instanceof WsMessageEnvelope[]) {
            wsMessageEnvelopeArray = (WsMessageEnvelope[])object2;
        } else if (object2 instanceof WsMessageEnvelope) {
            wsMessageEnvelopeArray = new WsMessageEnvelope[]{(WsMessageEnvelope)object2};
        } else if (object2 instanceof BBPostingMsg) {
            object = ((BBPostingMsg)object2).messages;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, object2.getClass() + " has " + object.size() + " elements");
            }
            if (object != null) {
                wsMessageEnvelopeArray = object.toArray(new WsMessageEnvelope[0]);
            }
        }
        if (wsMessageEnvelopeArray != null && wsMessageEnvelopeArray.length > 0) {
            object = (HBGroupMember)wsMessageEnvelopeArray[0].getSender();
            if (((HBGroupMember)object).getCoreGroup().equalsIgnoreCase("UNINITIALIZED_COREGROUP")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, object + " not initialized");
                }
            } else {
                WsMessageEnvelope[] wsMessageEnvelopeArray2 = this.extractFromBcastMessage(wsMessageEnvelopeArray, (WsGroupMember)object);
                if (!groupMemberId.getServerName().equalsIgnoreCase(((WsGroupMember)object).getName()) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "sender: " + ((WsGroupMember)object).getName() + ", relay by:" + groupMemberId.getServerName());
                }
                super.receiveMessages((WsGroupMember)object, wsMessageEnvelopeArray2, byArray.length);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onMessage: IGNORED class:" + object2.getClass());
            Tr.debug(tc, "onMessage: IGNORED " + object2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onMessage: ", groupMemberId);
        }
    }

    public void memberMayActivate(GroupName groupName) {
    }

    public void memberMayActivateCancelled(GroupName groupName) {
    }

    public void memberIsActivated(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
    }

    public void memberDeactivate(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
    }

    public HashMap getCoregroupMap() {
        return this.coregroupMap;
    }

    static {
        WsLocalProcessProperties.getPropertiesMap().put(HB_GROUP_ENABLED, "true");
    }
}

