/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup.bb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.wsgroup.WsGroupUtil;
import com.ibm.ws.wsgroup.WsMessageEnvelope;
import com.ibm.ws.wsgroup.bb.BBGroupMember;
import com.ibm.ws.wsgroup.bb.HBGroup;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;
import java.util.Map;

public class HBGroupMember
extends BBGroupMember {
    protected static final TraceComponent tc = TrUtil.register(HBGroupMember.class);
    protected GroupMemberId groupMemberId;
    protected HBGroup hbGroup;
    public static final String COMPAT_COREGROUP = "COMPAT_COREGROUP";
    public static final String UNINITIALIZED_COREGROUP = "UNINITIALIZED_COREGROUP";
    protected String coreGroup = "UNINITIALIZED_COREGROUP";
    protected boolean isLocal = false;
    protected boolean waitingForHA = false;
    protected boolean hasLeft = false;
    protected boolean isHBGroup = false;
    protected byte[] dataToSend = null;
    protected boolean callJoinGroupWhenHAJoins = false;

    public HBGroupMember(String string, String string2, boolean bl, HBGroup hBGroup, GroupMemberId groupMemberId) throws Exception {
        super(string, string2, bl, hBGroup);
        this.groupMemberId = groupMemberId;
        this.hbGroup = hBGroup;
    }

    public int providerSendMessage(WsMessageEnvelope wsMessageEnvelope) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "providerSendMessage", wsMessageEnvelope);
        }
        int n = 0;
        boolean bl = this.isLocal();
        if (!this.isLocal() && this.getCoreGroup().equalsIgnoreCase(this.getHbGroup().getMyCoreGroupName())) {
            bl = this.waitToJoinHAGroup();
        }
        if (bl) {
            byte[] byArray = WsGroupUtil.objectToByteArray(wsMessageEnvelope, true);
            this.hbGroup.getHaGroup().sendMessage(MsgQoS.NORMAL_NOSELF, this.groupMemberId, byArray);
            n = byArray.length;
        } else {
            n = super.providerSendMessage(wsMessageEnvelope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "providerSendMessage - size=" + n);
        }
        return n;
    }

    public int providerSendMessages(WsMessageEnvelope[] wsMessageEnvelopeArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "providerSendMessage", wsMessageEnvelopeArray);
        }
        int n = 0;
        if (this.isLocal()) {
            byte[] byArray = WsGroupUtil.objectToByteArray(wsMessageEnvelopeArray, true);
            this.hbGroup.getHaGroup().sendMessage(MsgQoS.NORMAL_NOSELF, this.groupMemberId, byArray);
            n = byArray.length;
        } else {
            for (int i = 0; i < this.msgTopic.size(); ++i) {
                BBGroupMember.MsgTopic msgTopic = (BBGroupMember.MsgTopic)this.msgTopic.get(i);
                n = msgTopic.sendMessage(wsMessageEnvelopeArray);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "providerSendMessage - len=" + n);
        }
        return n;
    }

    public GroupMemberId getGroupMemberId() {
        return this.groupMemberId;
    }

    public String getCoreGroup() {
        return this.coreGroup;
    }

    public void setCoreGroup(String string) {
        this.coreGroup = string;
    }

    public HBGroup getHbGroup() {
        return this.hbGroup;
    }

    public void updateMap(Map map) {
        String string = (String)map.get("COREGROUP_NAME");
        if (string != null) {
            if (!string.equalsIgnoreCase(this.getCoreGroup())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateMap: Changing COREGROUP_NAME to:<" + string + "> from: <" + this.getCoreGroup() + ">");
                }
                this.setCoreGroup(string);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updateMap: Changing COREGROUP_NAME to:<COMPAT_COREGROUP> from: <" + this.getCoreGroup() + ">");
            }
            this.setCoreGroup(COMPAT_COREGROUP);
        }
        this.isHBGroup = new Boolean((String)map.get("HB_GROUP_ENABLED"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this + " isHBGroup=" + this.isHBGroup);
        }
        super.updateMap(map);
    }

    public synchronized void setGroupMemberId(GroupMemberId groupMemberId) {
        this.groupMemberId = groupMemberId;
        if (groupMemberId != null) {
            this.setLocal(true);
            if (this.isWaitingForHA()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Someone is waiting for " + this + " notifying...");
                }
                this.notifyAll();
                this.setWaitingForHA(false);
            }
            if (this.isCallJoinGroupWhenHAJoins()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Waiting for " + this + " to join fully");
                }
                try {
                    this.getHbGroup().memberJoined(this);
                }
                catch (Exception exception) {
                    TrUtil.error(exception, this, "setGroupMemberId:memberJoined", tc);
                }
                this.setCallJoinGroupWhenHAJoins(false);
            }
        } else {
            this.setLocal(false);
        }
    }

    public synchronized boolean isLocal() {
        return this.isLocal;
    }

    public synchronized void setLocal(boolean bl) {
        this.isLocal = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" cg:<" + this.getCoreGroup() + "> groupMemberID:<" + this.getGroupMemberId() + "> local:<" + this.isLocal + ">");
        return stringBuffer.toString();
    }

    public synchronized boolean isWaitingForHA() {
        return this.waitingForHA;
    }

    public synchronized void setWaitingForHA(boolean bl) {
        this.waitingForHA = bl;
    }

    public synchronized boolean isHasLeft() {
        return this.hasLeft;
    }

    public synchronized void setHasLeft(boolean bl) {
        this.hasLeft = bl;
    }

    public synchronized boolean callJoinGroupWhenHAJoins() {
        boolean bl = false;
        if (!this.isLocal()) {
            this.setCallJoinGroupWhenHAJoins(true);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public synchronized boolean waitToJoinHAGroup() {
        boolean bl = false;
        this.setWaitingForHA(true);
        while (!this.isLocal() && !this.isHasLeft()) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Waiting for: " + this);
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                TrUtil.ffdc(interruptedException, this, "waitToJoinHAGroup:" + this, tc);
            }
        }
        this.setWaitingForHA(false);
        if (this.isHasLeft()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this + " left while waiting");
            }
            bl = false;
        } else if (this.isLocal()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this + " has joined HAGroup");
            }
            bl = true;
        }
        return bl;
    }

    public synchronized boolean isCallJoinGroupWhenHAJoins() {
        return this.callJoinGroupWhenHAJoins;
    }

    public synchronized void setCallJoinGroupWhenHAJoins(boolean bl) {
        this.callJoinGroupWhenHAJoins = bl;
    }

    public boolean isHBGroup() {
        return this.isHBGroup;
    }
}

