/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCTreeImpl;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.util.Util;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.wsgroup.WsGroup;
import com.ibm.ws.wsgroup.WsGroupListener;
import com.ibm.ws.wsgroup.WsGroupManagerFactory;
import com.ibm.ws.wsgroup.WsGroupMember;
import com.ibm.ws.wsgroup.WsGroupUtil;
import com.ibm.ws.wsgroup.WsLocalProcessProperties;
import com.ibm.ws.wsgroup.WsMessageEnvelope;
import com.ibm.ws.wsgroup.WsMessageGroupIsReady;
import com.ibm.ws.wsgroup.WsMessageJoinedGroup;
import com.ibm.ws.wsgroup.WsMessageLeftGroup;
import com.ibm.ws.wsgroup.odc.ODCGroupMember;
import com.ibm.ws.wsgroup.odc.ODCMessage;
import com.ibm.ws.wsgroup.odc.ODCMessageGetTreeRequest;
import com.ibm.ws.wsgroup.odc.ODCMessageGetTreeResponse;
import com.ibm.ws.wsgroup.odc.ODCMessageTreeChange;
import com.ibm.wsspi.odc.ODCEvent;
import com.ibm.wsspi.odc.ODCEventType;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCPropertyValueWrapper;
import com.ibm.wsspi.odc.ODCTransactionListener;
import com.ibm.wsspi.odc.ODCTree;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.GZIPInputStream;

public class ODCGroup
implements ODCTransactionListener,
WsGroupListener {
    protected static final TraceComponent tc = TrUtil.register(ODCGroup.class);
    protected static final Object DOWN_WEIGHT = new ODCPropertyValueWrapper(new Integer(0), 1);
    protected static final Object STOPPED_STATE = new ODCPropertyValueWrapper("STOPPED", 1);
    protected static final Timer timer = new Timer(true);
    protected static final int STARTUP_PERIOD = Integer.parseInt(System.getProperty("ODCStartupPeriod", "300000"));
    protected static final int NEW_MEMBER_REQUEST_DELAY = Integer.parseInt(System.getProperty("ODCNewMemberRequestDelay", "30000"));
    protected static final int INITIAL_DELAY_FACTOR = Integer.parseInt(System.getProperty("ODCInitialDelayFactor", "2000"));
    protected static final int INITIAL_DELAY_MAX = Integer.parseInt(System.getProperty("ODCInitialDelayMax", "1"));
    protected static final int GET_TREE_REQUEST_DELAY_MAX = Integer.parseInt(System.getProperty("ODCGetTreeRequestDelayMax", "1"));
    protected static final long GET_TREE_RESPONSE_TIMEOUT = Long.parseLong(System.getProperty("ODCResponseTimeout", "60000"));
    protected static final long GET_TREE_RESPONSE_DELAY = Long.parseLong(System.getProperty("ODCGetTreeResponseDelay", "10000"));
    public static final long LEFT_GROUP_DELAY = Long.parseLong(System.getProperty("ODCLeftGroupDelay", "165000"));
    public static final long TREE_REQUEST_RESEND_DELAY = Long.parseLong(System.getProperty("ODCTreeRequestResendDelay", "30000"));
    protected final ODCTreeImpl tree;
    protected WsGroup group = null;
    protected ODCGroupMember self = null;
    protected final ODCHelper odc;
    protected boolean getTreeRequestIsScheduled = false;
    protected boolean processingGetTreeResponse = false;
    protected boolean started = false;
    protected boolean initialized = false;
    protected boolean consumer = Util.isProxy();
    private boolean perhapsSendGetTreeRequestScheduled = false;
    private WsGroupMember getTreeRequestOutstandingTo = null;
    private GetTreeResponseTimeoutTask getTreeRequestOutstandingTimeoutTask = null;
    private Object treeResponseTimeoutLock = new Object();
    private final Random random = new Random();
    private boolean ready;
    private final Set nonResponsiveMembers = Collections.synchronizedSet(new HashSet());
    private final Map leftGroupTimerMap = Collections.synchronizedMap(new HashMap());
    private final Map needTreeResponse = Collections.synchronizedMap(new HashMap());
    private final Map suspectedMembers = Collections.synchronizedMap(new HashMap());
    private long startupTime;
    private boolean sentInitialBroadcast = false;
    private List queuedPreInitialBroadcastMessages = new LinkedList();
    protected WsGroupMember lastTreeRequestMember = null;
    protected static String odcGroupClass = null;
    protected static ODCGroup _odcGroup = null;
    public static int groupVersion = 4;
    public static final int memberVersion = 4;

    public static ODCGroup getInstance(ODCTree oDCTree) {
        try {
            if (_odcGroup == null) {
                block8: {
                    if (odcGroupClass != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Loading " + odcGroupClass);
                        }
                        try {
                            Class<?> clazz = Class.forName(odcGroupClass);
                            Constructor<?> constructor = clazz.getConstructor(ODCTree.class);
                            _odcGroup = (ODCGroup)constructor.newInstance(oDCTree);
                        }
                        catch (Throwable throwable) {
                            if (!tc.isDebugEnabled()) break block8;
                            TrUtil.warning(throwable, oDCTree + "", "getInstance", tc);
                        }
                    }
                }
                if (_odcGroup == null) {
                    _odcGroup = new ODCGroup(oDCTree);
                }
            }
            return _odcGroup;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected ODCGroup(ODCTree oDCTree) throws Exception {
        WsLocalProcessProperties.getPropertiesMap().put("MEMBER_VERSION", "4");
        WsLocalProcessProperties.getPropertiesMap().put("MEMBER_STARTUP_TIME", System.currentTimeMillis() + "");
        this.tree = (ODCTreeImpl)oDCTree;
        this.odc = ODCHelper.getInstance();
        this.ready = !this.isEnabled();
    }

    public boolean isEnabled() {
        boolean bl;
        String string;
        boolean bl2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEnabled");
        }
        if (bl2 = Boolean.valueOf(string = System.getProperty("ODCGroup.disabled", "false")).booleanValue()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ODCGroup disabled by 'ODCGroup.disabled=true' system property");
            }
            return false;
        }
        string = System.getProperty("ODC.BBEnabled", "true");
        boolean bl3 = Boolean.valueOf(string);
        if (!bl3) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ODCGroup disabled by 'ODC.BBEnabled' system property, value=" + string);
            }
            return false;
        }
        String string2 = System.getProperty("com.ibm.ws.xd.dmgr.standby", "false");
        if (string2.equalsIgnoreCase("true")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ODCGroup disabled by 'com.ibm.ws.xd.dmgr.standby=true' system property");
            }
            return false;
        }
        if (Util.isStandAlone()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ODCGroup disabled in standalone");
            }
            return false;
        }
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        boolean bl4 = bl = platformHelper.isZOS() && (platformHelper.isServantJvm() || platformHelper.isCRAJvm());
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ODCGroup disabled in ZOS servant and CRA");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEnabled - true");
        }
        return true;
    }

    public String getName() {
        return this.tree.getName();
    }

    public ODCTree getTree() {
        return this.tree;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void start() throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "starting ODCGroup for " + this.tree.getName());
        }
        if (!this.isEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ODCGroup is disabled");
            }
            return;
        }
        if (this.started) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "already started ODCGroup for " + this.tree.getName());
            }
            return;
        }
        this.startupTime = System.currentTimeMillis();
        this.started = true;
        WsLocalProcessProperties.getPropertiesMap().put("ODC_PUBLISHER_ONLY", "" + this.consumer);
        WsLocalProcessProperties.getPropertiesMap().put("GROUP_VERSION", new Integer(groupVersion));
        this.group = WsGroupManagerFactory.getManager().getGroup("odc." + this.tree.getName());
        this.self = new ODCGroupMember(this.group.getSelf().getName(), 0L, this.getName());
        WsLocalProcessProperties.getPropertiesMap().put("CONTRIBUTORS", this.self.getName());
        this.tree.addContributor(this.self);
        this.group.addListener(this);
        this.group.start();
        this.updateMembership();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "started ODCGroup for " + this.tree.getName());
        }
    }

    public void stop() throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stopping ODCGroup for " + this.tree.getName());
        }
        if (!this.isEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ODCGroup is disabled");
            }
            return;
        }
        if (!this.started) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "already stopped ODCGroup for " + this.tree.getName());
            }
            return;
        }
        if (this.initialized) {
            this.tree.removeListener(this);
        }
        if (this.group != null) {
            this.group.removeListener(this);
        }
        this.tree.clearContributors();
        this.started = false;
        timer.cancel();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stopped ODCGroup for " + this.tree.getName());
        }
    }

    protected void handleGroupIsReadyMessage() throws Exception {
        this.scheduleInitialContribution();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleGroupIsReadyMessage - initialized=" + this.initialized);
        }
    }

    public boolean isConsumer() {
        return this.consumer;
    }

    public void setConsumer(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConsumer - " + bl);
        }
        if (!this.isEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setConsumer - not enabled");
            }
            return;
        }
        if (this.consumer == bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setConsumer - no change");
            }
            return;
        }
        this.consumer = bl;
        this.updateMembership();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConsumer - changed");
        }
    }

    private boolean updateMembership() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateMembership");
        }
        boolean bl = this.consumer;
        try {
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateMembership: start consuming");
                }
                WsLocalProcessProperties.getPropertiesMap().put("ODC_PUBLISHER_ONLY", "false");
                WsLocalProcessProperties.getPropertiesMap().put("GROUP_VERSION", new Integer(groupVersion));
                if (this.group != null) {
                    this.group.updateMemberShip();
                    this.perhapsSendGetTreeRequest(false);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateMembership: stop consuming");
                }
                WsLocalProcessProperties.getPropertiesMap().put("ODC_PUBLISHER_ONLY", "true");
                WsLocalProcessProperties.getPropertiesMap().put("GROUP_VERSION", new Integer(groupVersion));
                if (this.group != null) {
                    this.group.updateMemberShip();
                }
            }
        }
        catch (Exception exception) {
            TrUtil.error(exception, this, "updateMembership", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateMembership - consumer=" + bl);
        }
        return bl;
    }

    public ODCEventType[] interestEventTypes() {
        return null;
    }

    public void handleEvents(ODCEvent[] oDCEventArray) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "handleEvents");
        }
        if (oDCEventArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "handleEvents - none");
            }
            return;
        }
        String string = this.tree.getLocalTransactionName();
        if (string == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "handleEvents - ignore");
            }
            return;
        }
        this.broadcastTreeChangeMessage(oDCEventArray);
    }

    public void handleEvent(ODCEvent oDCEvent) throws Exception {
        this.handleEvents(new ODCEvent[]{oDCEvent});
    }

    public void consumerOnMessage(WsMessageEnvelope wsMessageEnvelope) throws Exception {
        Object object = wsMessageEnvelope.getMessage();
        WsGroupMember wsGroupMember = wsMessageEnvelope.getSender();
        boolean bl = this.nonResponsiveMembers.remove(wsGroupMember.getName());
        if (bl && tc.isDebugEnabled()) {
            Tr.debug(tc, wsGroupMember + " is no longer marked non-responsive");
        }
        if (object instanceof ODCMessageTreeChange) {
            this.handleTreeChangeMessage(wsMessageEnvelope);
        } else if (object instanceof ODCMessageGetTreeRequest) {
            this.handleGetTreeRequest(wsMessageEnvelope);
        } else if (object instanceof ODCMessageGetTreeResponse) {
            this.handleGetTreeResponse(wsMessageEnvelope);
        } else if (object instanceof WsMessageGroupIsReady) {
            this.handleGroupIsReadyMessage();
        } else if (object instanceof WsMessageJoinedGroup) {
            HandleLeftGroupTask handleLeftGroupTask = (HandleLeftGroupTask)this.leftGroupTimerMap.remove(wsMessageEnvelope.getSender().getName());
            if (handleLeftGroupTask != null) {
                handleLeftGroupTask.cancel();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "canceled LeftGroupTask for " + wsMessageEnvelope.getSender());
                }
                String string = (String)wsMessageEnvelope.getSender().getMap().get("MEMBER_STARTUP_TIME");
                Long l = null;
                if (string != null) {
                    l = new Long(string);
                }
                Long l2 = handleLeftGroupTask.getMemberStartTime();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Old start time=" + l2 + ", new start time=" + l);
                }
                if (l2 != null && l != null && !l.equals(l2)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Treating member as though it restarted - marking down and requesting new tree");
                    }
                    this.handleLeftGroupMessage(wsMessageEnvelope);
                    this.handleJoinedGroupMessage(wsMessageEnvelope);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Treating member as though it left/returned due to network glitch, taking no action");
                }
            } else {
                this.handleJoinedGroupMessage(wsMessageEnvelope);
            }
        } else if (object instanceof WsMessageLeftGroup) {
            if (this.isMemberStopping(wsMessageEnvelope.getSender())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Member is stopping already, so removing from group immediately");
                }
                this.handleLeftGroupMessage(wsMessageEnvelope);
            } else if (!this.leftGroupTimerMap.containsKey(wsMessageEnvelope.getSender().getName())) {
                Long l = null;
                String string = (String)wsMessageEnvelope.getSender().getMap().get("MEMBER_STARTUP_TIME");
                if (string != null) {
                    l = new Long(string);
                }
                HandleLeftGroupTask handleLeftGroupTask = new HandleLeftGroupTask(wsMessageEnvelope, l);
                this.leftGroupTimerMap.put(wsMessageEnvelope.getSender().getName(), handleLeftGroupTask);
                timer.schedule((TimerTask)handleLeftGroupTask, LEFT_GROUP_DELAY);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scheduled LeftGroupTask for " + wsMessageEnvelope.getSender() + " for " + LEFT_GROUP_DELAY + " in future");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "LeftGroupTask already scheduled for " + wsMessageEnvelope.getSender());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WARNING: ignoring unknown message type: " + object.getClass().getName());
        }
    }

    public void producerOnMessage(WsMessageEnvelope wsMessageEnvelope) throws Exception {
        Object object = wsMessageEnvelope.getMessage();
        WsGroupMember wsGroupMember = wsMessageEnvelope.getSender();
        boolean bl = this.nonResponsiveMembers.remove(wsGroupMember.getName());
        if (bl && tc.isDebugEnabled()) {
            Tr.debug(tc, wsGroupMember + " is no longer marked non-responsive");
        }
        if (object instanceof ODCMessageTreeChange) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IGNORE: " + object + " from: " + wsGroupMember);
            }
        } else if (object instanceof ODCMessageGetTreeRequest) {
            this.handleGetTreeRequest(wsMessageEnvelope);
        } else if (object instanceof ODCMessageGetTreeResponse) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IGNORE: " + object + " from: " + wsGroupMember);
            }
        } else if (object instanceof WsMessageGroupIsReady) {
            this.handleGroupIsReadyMessage();
        } else if (object instanceof WsMessageJoinedGroup) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IGNORE: " + object + " from: " + wsGroupMember);
            }
            this.setGroupVersion();
        } else if (object instanceof WsMessageLeftGroup) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IGNORE: " + object + " from: " + wsGroupMember);
            }
            this.setGroupVersion();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WARNING: ignoring unknown message type: " + object.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(WsMessageEnvelope wsMessageEnvelope) throws Exception {
        List list = this.queuedPreInitialBroadcastMessages;
        synchronized (list) {
            if (this.sentInitialBroadcast) {
                this.processMessage(wsMessageEnvelope);
            } else if (wsMessageEnvelope.getMessage() instanceof WsMessageGroupIsReady) {
                this.processMessage(wsMessageEnvelope);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "haven't bcast initial tree yet, queuing incoming message " + wsMessageEnvelope);
                }
                this.queuedPreInitialBroadcastMessages.add(wsMessageEnvelope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processQueuedMessages() throws Exception {
        List list = this.queuedPreInitialBroadcastMessages;
        synchronized (list) {
            if (this.queuedPreInitialBroadcastMessages.size() > 0) {
                Iterator iterator = this.queuedPreInitialBroadcastMessages.iterator();
                while (iterator.hasNext()) {
                    WsMessageEnvelope wsMessageEnvelope = (WsMessageEnvelope)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processing queued message: " + wsMessageEnvelope);
                    }
                    this.onMessage(wsMessageEnvelope);
                    iterator.remove();
                }
            }
        }
    }

    protected void processMessage(WsMessageEnvelope wsMessageEnvelope) throws Exception {
        if (this.isConsumer()) {
            this.consumerOnMessage(wsMessageEnvelope);
        } else {
            this.producerOnMessage(wsMessageEnvelope);
        }
    }

    protected void broadcastTreeChangeMessage(byte[] byArray) throws Exception {
        if (this.group != null) {
            this.group.broadcastMessage(new ODCMessageTreeChange(this.getTranactionName(), this.tree.getGenerationNumber(), byArray, false));
        }
    }

    protected synchronized void broadcastTreeChangeMessage(ODCEvent[] oDCEventArray) throws Exception {
        if (this.group != null) {
            this.group.broadcastMessage(new ODCMessageTreeChange(this.getTranactionName(), this.self.incrementGenerationNumber(), oDCEventArray, false));
        }
    }

    private String getTranactionName() {
        return this.tree.getLocalTransactionName() + " from " + WsGroupUtil.getMyName();
    }

    public Set getMemberNames() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.group != null) {
            WsGroupMember[] wsGroupMemberArray = this.group.getMembers();
            for (int i = 0; i < wsGroupMemberArray.length; ++i) {
                hashSet.add(wsGroupMemberArray[i].getName());
            }
        }
        return hashSet;
    }

    public long getMemberJoinTime(String string) {
        if (this.group != null) {
            return this.group.getMemberJoinTime(string);
        }
        return -1L;
    }

    protected WsGroupMember findPreferredNonContributingMember(Set set) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findPreferredNonContributingMember");
        }
        if (this.group == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findPreferredNonContributingMember - WsGroup disabled");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "my current contributor list: " + this.tree.getMyContributorList());
        }
        ArrayList<WsGroupMember> arrayList = new ArrayList<WsGroupMember>();
        String string = WsGroupUtil.getMyName();
        int n = 1;
        WsGroupMember[] wsGroupMemberArray = this.group.getMembers();
        for (int i = 0; i < wsGroupMemberArray.length; ++i) {
            WsGroupMember wsGroupMember = wsGroupMemberArray[i];
            String string2 = wsGroupMember.getName();
            if (string2.equals(string)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "skipping self: " + string2);
                continue;
            }
            if (set.contains(wsGroupMember)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "skipping already tried member: " + wsGroupMember);
                continue;
            }
            if (this.nonResponsiveMembers.contains(string2)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "skipping non-responsive member: " + string2);
                continue;
            }
            int n2 = this.tree.getNumberOfNewContributors(wsGroupMember);
            if (n2 < n) continue;
            if (n2 > n) {
                n = n2;
                arrayList.clear();
            }
            arrayList.add(wsGroupMember);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "preferredMember count: " + arrayList.size());
        }
        WsGroupMember wsGroupMember = null;
        if (arrayList.size() > 0) {
            int n3 = (int)(Math.random() * (double)arrayList.size());
            wsGroupMember = (WsGroupMember)arrayList.get(n3);
            set.add(wsGroupMember);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findPreferredNonContributingMember - " + wsGroupMember + "; new contributors=" + n);
        }
        return wsGroupMember;
    }

    protected void handleJoinedGroupMessage(WsMessageEnvelope wsMessageEnvelope) throws Exception {
        this.setGroupVersion();
        if (this.isCurrentlyContributing(wsMessageEnvelope.getSender())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, wsMessageEnvelope.getSender() + " is already a contributor; ignore join");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, wsMessageEnvelope.getSender() + " is not yet a contributor: ready=" + this.ready);
            }
            this.suspectedMembers.remove(wsMessageEnvelope.getSender());
            if (this.ready) {
                this.perhapsSendGetTreeRequest(true);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void setGroupVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setGroupVersion");
        }
        int n = Integer.MAX_VALUE;
        WsGroupMember[] wsGroupMemberArray = this.group.getMembers();
        for (int i = 0; i < wsGroupMemberArray.length; ++i) {
            int n2;
            block15: {
                if (wsGroupMemberArray[i].getName().equals(this.self.getName())) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Member: " + wsGroupMemberArray[i].getName() + " skipped, self");
                    continue;
                }
                Object v = wsGroupMemberArray[i].getMap().get("MEMBER_VERSION");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Member: " + wsGroupMemberArray[i].getName() + " version object=" + v);
                }
                if (v == null) {
                    Object v2 = wsGroupMemberArray[i].getMap().get("ODC_PUBLISHER_ONLY");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Member: " + wsGroupMemberArray[i].getName() + " publisher object=" + v2);
                    }
                    if (v2 == null) {
                        n2 = 0;
                        break block15;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting ODCGroup Version to: 2");
                        }
                        groupVersion = 2;
                        WsLocalProcessProperties.getPropertiesMap().put("GROUP_VERSION", new Integer(2));
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "setGroupVersion: " + groupVersion);
                        }
                        return;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found remote version object=" + v);
                }
                n2 = Integer.valueOf((String)v);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using remote version value=" + n2);
                }
            }
            if (n2 < n) {
                n = n2;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Member : " + wsGroupMemberArray[i].getName() + " version=" + n2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting ODCGroup Version to: " + n);
        }
        groupVersion = n;
        WsLocalProcessProperties.getPropertiesMap().put("GROUP_VERSION", new Integer(n));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setGroupVersion: " + groupVersion);
        }
    }

    protected void scheduleInitialContribution() {
        if (this.group == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scheduleInitialContribution: WsGroup disabled");
            }
            return;
        }
        try {
            int n = Math.min(this.group.getMembers().length * INITIAL_DELAY_FACTOR, INITIAL_DELAY_MAX);
            long l = this.random.nextInt(n);
            timer.schedule((TimerTask)new InitialContributionTask(), l);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scheduled initial contribution broadcast for " + l + " ms in future");
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "scheduleInitialContribution", tc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean perhapsSendGetTreeRequest(boolean bl) {
        ODCTreeImpl oDCTreeImpl = this.tree;
        synchronized (oDCTreeImpl) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "perhapsSendGetTreeRequest - new member=" + bl);
            }
            if (!this.isEnabled()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "perhapsSendGetTreeRequest - not enabled");
                }
                return false;
            }
            if (!this.ready) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "perhapsSendGetTreeRequest - not ready");
                }
                return false;
            }
            if (!this.consumer) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "perhapsSendGetTreeRequest - not a consumer");
                }
                return false;
            }
            if (this.tree.haveContributionsFromEveryone() && !this.needTreeResponse()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "perhapsSendGetTreeRequest - have contributions from everyone");
                }
                return false;
            }
            if (this.perhapsSendGetTreeRequestScheduled) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "perhapsSendGetTreeRequest - already scheduled");
                }
                return true;
            }
            if (this.getTreeRequestOutstandingTo != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "perhapsSendGetTreeRequest - outstanding to " + this.getTreeRequestOutstandingTo);
                }
                return true;
            }
            try {
                long l = INITIAL_DELAY_MAX + this.random.nextInt(GET_TREE_REQUEST_DELAY_MAX);
                if (bl && System.currentTimeMillis() - this.startupTime > (long)STARTUP_PERIOD) {
                    l += (long)NEW_MEMBER_REQUEST_DELAY;
                }
                timer.schedule((TimerTask)new GetTreeRequestTask(), l);
                this.perhapsSendGetTreeRequestScheduled = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scheduled GetTreeRequest for " + l + " ms in future; initialized=" + this.initialized);
                }
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "perhapsSendGetTreeRequestFailure", tc);
                this.tree.isInitializationCompleteAndNotify(true);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "perhapsSendGetTreeRequest - scheduled for future execution");
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean perhapsSendGetTreeRequestNow() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "perhapsSendGetTreeRequestNow");
        }
        HashSet hashSet = new HashSet();
        ODCTreeImpl oDCTreeImpl = this.tree;
        synchronized (oDCTreeImpl) {
            while (true) {
                WsGroupMember wsGroupMember;
                block29: {
                    if (this.getTreeRequestOutstandingTo != null) {
                        this.perhapsSendGetTreeRequestScheduled = false;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "perhapsSendGetTreeRequestNow - outstanding to " + this.getTreeRequestOutstandingTo);
                        }
                        return true;
                    }
                    if (this.tree.haveContributionsFromEveryone() && !this.needTreeResponse()) {
                        this.perhapsSendGetTreeRequestScheduled = false;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "perhapsSendGetTreeRequestNow - have contributions from everyone");
                        }
                        return false;
                    }
                    wsGroupMember = this.findPreferredNonContributingMember(hashSet);
                    if (wsGroupMember == null && !this.needTreeResponse()) {
                        this.tree.isInitializationCompleteAndNotify(true);
                        this.perhapsSendGetTreeRequestScheduled = false;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "perhapsSendGetTreeRequestNow - all members are contributing");
                        }
                        return false;
                    }
                    if (wsGroupMember != null) break block29;
                    for (String string : this.needTreeResponse.keySet()) {
                        if (this.group != null) {
                            wsGroupMember = this.group.getMember(string);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "need a tree response from: " + string + " member object=" + wsGroupMember);
                        }
                        if (wsGroupMember == null) {
                            if (!tc.isEntryEnabled()) continue;
                            Tr.exit(tc, "perhapsSendGetTreeRequestNow - couldn't find member object, ignoring");
                            continue;
                        }
                        if (wsGroupMember.isSelf()) continue;
                        break;
                    }
                    if (wsGroupMember != null) break block29;
                    this.tree.isInitializationCompleteAndNotify(true);
                    this.perhapsSendGetTreeRequestScheduled = false;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "perhapsSendGetTreeRequestNow - all members are contributing");
                    }
                    return false;
                    {
                        catch (Throwable throwable) {
                            TrUtil.warning(throwable, this, "perhapsSendGetTreeRequestNow", tc);
                            this.tree.isInitializationCompleteAndNotify(true);
                            this.perhapsSendGetTreeRequestScheduled = false;
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "perhapsSendGetTreeRequestNow - failed");
                            }
                            return false;
                        }
                    }
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "sendGetTreeRequest to " + wsGroupMember);
                    }
                    wsGroupMember.sendMessage(ODCMessage.GET_TREE_REQUEST);
                    this.getTreeRequestOutstandingTo = wsGroupMember;
                    this.perhapsSendGetTreeRequestScheduled = false;
                    long l = 0L;
                    if (this.lastTreeRequestMember != null && wsGroupMember.getName().equals(this.lastTreeRequestMember.getName())) {
                        l = TREE_REQUEST_RESEND_DELAY;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "treeRequest recipient same as last iteration, delaying send by " + l / 1000L + " seconds.");
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "waiting " + GET_TREE_RESPONSE_TIMEOUT + l + " ms for a getTreeResponse from " + wsGroupMember);
                    }
                    this.getTreeRequestOutstandingTimeoutTask = new GetTreeResponseTimeoutTask(wsGroupMember);
                    this.lastTreeRequestMember = wsGroupMember;
                    timer.schedule((TimerTask)this.getTreeRequestOutstandingTimeoutTask, GET_TREE_RESPONSE_TIMEOUT + l);
                    if (l == 0L) {
                        wsGroupMember.sendMessage(ODCMessage.GET_TREE_REQUEST);
                    } else {
                        timer.schedule((TimerTask)new ActualSendTreeRequestTask(wsGroupMember), l);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "perhapsSendGetTreeRequestNow - sent");
                    }
                    return true;
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "GetTreeRequestFailure", tc);
                    this.perhapsSendGetTreeRequestScheduled = false;
                    this.tree.isInitializationCompleteAndNotify(true);
                    continue;
                }
                break;
            }
        }
    }

    protected void handleLeftGroupMessage(WsMessageEnvelope wsMessageEnvelope) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleLeftGroupMessage " + wsMessageEnvelope);
        }
        WsGroupMember wsGroupMember = wsMessageEnvelope.getSender();
        this.markServerDown(wsGroupMember);
        this.removeCurrentContributor(wsGroupMember.getName());
        this.tree.isInitializationCompleteAndNotify(true);
        this.setGroupVersion();
        this.finishGetTreeResponse(wsGroupMember);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleLeftGroupMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleGetTreeRequest(WsMessageEnvelope wsMessageEnvelope) throws Exception {
        WsGroupMember wsGroupMember = wsMessageEnvelope.getSender();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleGetTreeRequest - from " + wsGroupMember);
        }
        Object object = this.leftGroupTimerMap;
        synchronized (object) {
            Object[] objectArray = this.leftGroupTimerMap.values().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((HandleLeftGroupTask)objectArray[i]).run();
            }
        }
        object = (ODCMessageGetTreeRequest)wsMessageEnvelope.getMessage();
        this.sendGetTreeResponse((ODCMessageGetTreeRequest)object, wsGroupMember);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleGetTreeRequest - from " + wsGroupMember);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendGetTreeResponse(ODCMessageGetTreeRequest oDCMessageGetTreeRequest, WsGroupMember wsGroupMember) throws Exception {
        ODCMessageGetTreeResponse oDCMessageGetTreeResponse;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendGetTreeResponse - to " + wsGroupMember);
        }
        ODCTreeImpl oDCTreeImpl = this.tree;
        synchronized (oDCTreeImpl) {
            oDCMessageGetTreeResponse = oDCMessageGetTreeRequest.respondWithXml() ? new ODCMessageGetTreeResponse(this.tree.getCurrentContributorMap(), this.tree.getGenerationNumber(), this.tree.getCompressedXml()) : new ODCMessageGetTreeResponse(this.tree.getCurrentContributorMap(), this.tree.getGenerationNumber(), this.tree.getEvents(false));
        }
        wsGroupMember.sendMessage(oDCMessageGetTreeResponse);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendGetTreeResponse - to " + wsGroupMember);
        }
    }

    protected InputStream getXmlInputStream(byte[] byArray) throws Exception {
        FilterInputStream filterInputStream = null;
        int n = groupVersion;
        if (byArray != null) {
            try {
                if (n < 4) {
                    String string = (String)WsGroupUtil.byteArrayToObject(byArray);
                    filterInputStream = new BufferedInputStream(new ByteArrayInputStream(string.getBytes("UTF-8")));
                } else {
                    filterInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
                }
            }
            catch (RuntimeException runtimeException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught runtime exception deserializing");
                }
                if (runtimeException.getCause() instanceof StreamCorruptedException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "is a stream corrupted exception, reprocessing");
                    }
                    if (n < 4) {
                        filterInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
                    } else {
                        String string = (String)WsGroupUtil.byteArrayToObject(byArray);
                        filterInputStream = new BufferedInputStream(new ByteArrayInputStream(string.getBytes("UTF-8")));
                    }
                }
                throw runtimeException;
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught IOException deserializing (not gzipped), reprocessing");
                }
                if (n < 4) {
                    filterInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
                }
                String string = (String)WsGroupUtil.byteArrayToObject(byArray);
                filterInputStream = new BufferedInputStream(new ByteArrayInputStream(string.getBytes("UTF-8")));
            }
        }
        return filterInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleGetTreeResponse(WsMessageEnvelope wsMessageEnvelope) throws Exception {
        WsGroupMember wsGroupMember = wsMessageEnvelope.getSender();
        this.processingGetTreeResponse = true;
        try {
            ODCMessageGetTreeResponse oDCMessageGetTreeResponse = (ODCMessageGetTreeResponse)wsMessageEnvelope.getMessage();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleGetTreeResponse - sender=" + wsGroupMember + ", contributors=" + this.tree.getContributorInfoList(oDCMessageGetTreeResponse.getContributorInfo()));
            }
            ODCTreeImpl oDCTreeImpl = this.tree;
            synchronized (oDCTreeImpl) {
                Object object;
                boolean bl = false;
                for (Object object2 : oDCMessageGetTreeResponse.getContributorInfo().values()) {
                    if (((ODCGroupMember)object2).getName().equals(this.self.getName())) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "CONTRIB: skipping self: " + object2);
                        continue;
                    }
                    object = this.tree.getContributor(((ODCGroupMember)object2).getName());
                    ODCGroupMember oDCGroupMember = (ODCGroupMember)this.suspectedMembers.get(((ODCGroupMember)object2).getName());
                    if (oDCGroupMember != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Tree contains info for suspected member " + oDCGroupMember.getName() + " with suspected generation " + oDCGroupMember.getGenerationNumber());
                        }
                        if (oDCGroupMember.getGenerationNumber() > ((ODCGroupMember)object2).getGenerationNumber()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Suspected generation(" + oDCGroupMember.getGenerationNumber() + ") is greater than contributing generation(" + ((ODCGroupMember)object2).getGenerationNumber() + "), discarding tree response.");
                            }
                            bl = true;
                        }
                    }
                    if (object == null || ((ODCGroupMember)object).getGenerationNumber() <= ((ODCGroupMember)object2).getGenerationNumber()) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Tree contains info for member " + ((ODCGroupMember)object2).getName() + " at generation " + ((ODCGroupMember)object2).getGenerationNumber() + " which is older than existing generation " + ((ODCGroupMember)object).getGenerationNumber() + " - ignore");
                    }
                    bl = true;
                }
                if (!bl) {
                    Object object2;
                    this.needTreeResponse.remove(wsGroupMember.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "needTreeResponse removed: " + wsGroupMember.getName() + ", remaining: ", this.needTreeResponse);
                    }
                    if ((object = this.getXmlInputStream((byte[])(object2 = (Object)oDCMessageGetTreeResponse.getCompressedXml()))) == null) {
                        this.performEvents("getTreeResponse from " + wsGroupMember, oDCMessageGetTreeResponse.getEvents(), wsGroupMember);
                    } else {
                        this.performEvents("getTreeResponse from " + wsGroupMember, (InputStream)object, (byte[])object2, wsGroupMember, true);
                    }
                    for (ODCGroupMember oDCGroupMember : oDCMessageGetTreeResponse.getContributorInfo().values()) {
                        if (oDCGroupMember.getName().equals(this.self.getName())) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "CONTRIB: skipping self: " + oDCGroupMember);
                            continue;
                        }
                        ODCGroupMember oDCGroupMember2 = this.tree.getContributor(oDCGroupMember.getName());
                        if (oDCGroupMember2 != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "CONTRIB: existing=" + oDCGroupMember2 + ", incoming=" + oDCGroupMember);
                            }
                            if (oDCGroupMember2.getGenerationNumber() >= oDCGroupMember.getGenerationNumber()) continue;
                            oDCGroupMember2.setGenerationNumber(oDCGroupMember.getGenerationNumber());
                            continue;
                        }
                        String[] stringArray = oDCGroupMember.getName().split("\\\\");
                        String string = stringArray[0];
                        if (Util.connectedToCell(string)) {
                            this.tree.addContributor(oDCGroupMember);
                            this.suspectedMembers.remove(oDCGroupMember.getName());
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "CONTRIB: new " + oDCGroupMember);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "CONTRIB: ignoring (not cellConnected): " + oDCGroupMember);
                    }
                    this.tree.isInitializationCompleteAndNotify(true);
                    this.publishMyContributorList();
                    this.tree.flushToFile();
                }
            }
        }
        finally {
            this.processingGetTreeResponse = false;
            this.finishGetTreeResponse(wsGroupMember);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleGetTreeResponse - from " + wsGroupMember);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastInitialContribution() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "broadcastInitialContribution");
        }
        if (this.group == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "broadcastInitialContribution - WsGroup disabled");
            }
            return;
        }
        try {
            ODCTreeImpl oDCTreeImpl = this.tree;
            synchronized (oDCTreeImpl) {
                ODCMessageTreeChange oDCMessageTreeChange = groupVersion >= 2 ? new ODCMessageTreeChange("initial contribution from " + this.self.getName(), this.self.incrementGenerationNumber(), this.tree.getCompressedXml(), true) : new ODCMessageTreeChange("initial contribution from " + this.self.getName(), this.self.incrementGenerationNumber(), this.tree.getEvents(false), true);
                Properties properties = new Properties();
                properties.setProperty("consumer", this.isConsumer() ? "true" : "false");
                this.tree.addListener(this, properties);
                this.group.broadcastMessage(oDCMessageTreeChange);
                this.ready = true;
                List list = this.queuedPreInitialBroadcastMessages;
                synchronized (list) {
                    this.sentInitialBroadcast = true;
                    this.processQueuedMessages();
                }
            }
            this.perhapsSendGetTreeRequest(false);
        }
        catch (Exception exception) {
            TrUtil.warning(exception, this, "InitialContribution", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "broadcastInitialContribution");
        }
    }

    protected void publishMyContributorList() throws Exception {
        if (this.group == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "publishMyContributorList - WsGroup disabled");
            }
            return;
        }
        String string = this.tree.getMyContributorList();
        WsLocalProcessProperties.getPropertiesMap().put("CONTRIBUTORS", string);
        this.group.updateMemberShip();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "publishMyContributorList: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishGetTreeResponse(WsGroupMember wsGroupMember) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "finishGetTreeResponse - " + wsGroupMember);
        }
        Object object = this.treeResponseTimeoutLock;
        synchronized (object) {
            if (this.getTreeRequestOutstandingTo != null && wsGroupMember.equals(this.getTreeRequestOutstandingTo)) {
                this.getTreeRequestOutstandingTo = null;
                if (this.getTreeRequestOutstandingTimeoutTask != null) {
                    this.getTreeRequestOutstandingTimeoutTask.cancel();
                    this.getTreeRequestOutstandingTimeoutTask = null;
                }
            }
        }
        this.perhapsSendGetTreeRequest(false);
    }

    public int getCurrentMemberCount() {
        if (this.group == null) {
            return 1;
        }
        return this.group.getMembers().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTreeChangeMessage(WsMessageEnvelope wsMessageEnvelope) {
        try {
            WsGroupMember wsGroupMember = wsMessageEnvelope.getSender();
            ODCMessageTreeChange oDCMessageTreeChange = (ODCMessageTreeChange)wsMessageEnvelope.getMessage();
            ODCGroupMember oDCGroupMember = null;
            boolean bl = false;
            boolean bl2 = false;
            long l = oDCMessageTreeChange.getGenerationNumber();
            boolean bl3 = oDCMessageTreeChange.isInitialContribution();
            ODCTreeImpl oDCTreeImpl = this.tree;
            synchronized (oDCTreeImpl) {
                String string = wsGroupMember.getName();
                oDCGroupMember = this.tree.getContributor(string);
                if (oDCGroupMember == null) {
                    if (!bl3) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "handleTreeChange: adding suspect " + wsGroupMember + " at generation " + l);
                        }
                        ODCGroupMember oDCGroupMember2 = new ODCGroupMember(wsGroupMember, l, this);
                        this.suspectedMembers.put(oDCGroupMember2.getName(), oDCGroupMember2);
                        return;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "handleTreeChange: new contributor: name=" + string + ", generation=" + l);
                    }
                    oDCGroupMember = new ODCGroupMember(wsGroupMember, -1L, this);
                    bl = true;
                }
                if (oDCGroupMember != null) {
                    long l2 = oDCGroupMember.getGenerationNumber();
                    long l3 = oDCMessageTreeChange.getGenerationNumber();
                    if (bl3 || l3 == l2 + 1L) {
                        byte[] byArray;
                        InputStream inputStream;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "handleTreeChange: sender=" + wsGroupMember + ", newGeneration=" + l3 + ", initial=" + bl3);
                        }
                        if ((inputStream = this.getXmlInputStream(byArray = oDCMessageTreeChange.getCompressedXml())) == null) {
                            this.performEvents(oDCMessageTreeChange.getTransactionName() + " from " + wsGroupMember, oDCMessageTreeChange.getEvents(), wsGroupMember);
                        } else {
                            this.performEvents(oDCMessageTreeChange.getTransactionName() + " from " + wsGroupMember, inputStream, byArray, wsGroupMember, bl3);
                        }
                        oDCGroupMember.setGenerationNumber(l3);
                    } else if (l3 <= l2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "handleTreeChange: dropping from " + wsGroupMember + ": cur=" + l2 + ", new=" + l3);
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.warning(tc, "handleTreeChange: missed change from " + wsGroupMember + ": cur=" + l2 + ", new=" + l3);
                        }
                        bl2 = true;
                        bl = false;
                    }
                }
            }
            if (bl2) {
                this.removeCurrentContributor(oDCGroupMember.getName());
                this.perhapsSendGetTreeRequest(false);
            } else if (bl) {
                this.tree.addContributor(oDCGroupMember);
                this.tree.isInitializationCompleteAndNotify(true);
            }
        }
        catch (Throwable throwable) {
            TrUtil.error(throwable, this, "failed to apply change: " + wsMessageEnvelope, tc);
        }
    }

    protected void performEvents(String string, ODCEvent[] oDCEventArray, WsGroupMember wsGroupMember) throws Exception {
        this.tree.performEvents(string + " from " + wsGroupMember, oDCEventArray, false);
    }

    protected void performEvents(String string, String string2, WsGroupMember wsGroupMember, boolean bl) throws Exception {
        this.tree.performEvents(string + " from " + wsGroupMember, string2, false, bl, wsGroupMember.getName());
    }

    protected void performEvents(String string, InputStream inputStream, byte[] byArray, WsGroupMember wsGroupMember, boolean bl) throws Exception {
        this.tree.performEvents(string + " from " + wsGroupMember, inputStream, byArray, false, bl, wsGroupMember.getName());
    }

    protected boolean isCurrentlyContributing(WsGroupMember wsGroupMember) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCurrentlyContributing", wsGroupMember);
        }
        boolean bl2 = false;
        boolean bl3 = this.tree.getContributor(wsGroupMember.getName()) != null;
        boolean bl4 = bl = this.needTreeResponse.get(wsGroupMember.getName()) == null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "contributing=" + bl3 + " doNotNeedResponse=" + bl);
        }
        boolean bl5 = bl2 = bl3 && bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCurrentlyContributing - " + bl2);
        }
        return bl2;
    }

    protected ODCGroupMember removeCurrentContributor(String string) throws Exception {
        ODCGroupMember oDCGroupMember;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeCurrentContributor - " + string);
        }
        if ((oDCGroupMember = this.tree.removeContributor(string)) != null) {
            this.publishMyContributorList();
        }
        return oDCGroupMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isMemberStopping(WsGroupMember wsGroupMember) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMemberStopping " + wsGroupMember);
        }
        String string = wsGroupMember.getName();
        String[] stringArray = string.split("\\\\");
        ODCTreeImpl oDCTreeImpl = this.tree;
        synchronized (oDCTreeImpl) {
            ODCNode oDCNode = this.tree.getRoot().getNode(this.odc.cell, stringArray[0]);
            if (oDCNode == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell '" + stringArray[0] + "' not found");
                }
                return false;
            }
            ODCNode oDCNode2 = oDCNode.getNode(this.odc.node, stringArray[1]);
            if (oDCNode2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node '" + stringArray[1] + "' not found");
                }
                return false;
            }
            ODCNode oDCNode3 = oDCNode2.getNode(this.odc.server, stringArray[2]);
            if (oDCNode3 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server '" + stringArray[2] + "' not found");
                }
                return false;
            }
            String string2 = (String)oDCNode3.getProperty(this.odc.serverState);
            if ("STOPPING".equalsIgnoreCase(string2) || "STOPPED".equalsIgnoreCase(string2)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isMemberStopping - true");
                }
                return true;
            }
        }
        return false;
    }

    public void markServerForTreeRequest(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markServerForTreeRequest - " + string);
        }
        this.needTreeResponse.put(string, "true");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "needTreeResponse size=" + this.needTreeResponse.size(), this.needTreeResponse);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markServerForTreeRequest - " + string);
        }
    }

    public boolean needTreeResponse() {
        return this.needTreeResponse.containsValue("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markServerDown(WsGroupMember wsGroupMember) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markServerDown " + wsGroupMember);
        }
        String string = wsGroupMember.getName();
        String[] stringArray = string.split("\\\\");
        ODCTreeImpl oDCTreeImpl = this.tree;
        synchronized (oDCTreeImpl) {
            ODCNode oDCNode = this.tree.getRoot().getNode(this.odc.cell, stringArray[0]);
            if (oDCNode == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell '" + stringArray[0] + "' not found");
                }
                return;
            }
            ODCNode oDCNode2 = oDCNode.getNode(this.odc.node, stringArray[1]);
            if (oDCNode2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node '" + stringArray[1] + "' not found");
                }
                return;
            }
            ODCNode oDCNode3 = oDCNode2.getNode(this.odc.server, stringArray[2]);
            if (oDCNode3 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server '" + stringArray[2] + "' not found");
                }
                return;
            }
            this.tree.beginTransaction("markServerDown: " + string, false);
            try {
                ODCGroup.markServerDown(oDCNode3, this.odc);
                this.tree.commitTransaction();
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    throwable.printStackTrace(System.out);
                }
                this.tree.rollbackTransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markServerDown " + wsGroupMember);
        }
    }

    public static void markServerDown(ODCNode oDCNode, ODCHelper oDCHelper) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markServerDown - " + oDCNode);
        }
        if (oDCNode != null) {
            oDCNode.setProperty(oDCHelper.serverWeight, DOWN_WEIGHT);
            oDCNode.setProperty(oDCHelper.serverState, STOPPED_STATE);
            String string = (String)oDCNode.getProperty(oDCHelper.serverType);
            if (string.equals("APPLICATION_SERVER") || string.equals("DEPLOYMENT_MANAGER")) {
                ODCNode[] oDCNodeArray = oDCNode.getChildren(oDCHelper.transport);
                for (int i = 0; i < oDCNodeArray.length; ++i) {
                    oDCNodeArray[i].setProperty(oDCHelper.transportIsActive, (Object)new ODCPropertyValueWrapper(false, 1));
                    ODCNode[] oDCNodeArray2 = oDCNodeArray[i].getChildren(oDCHelper.channelChain);
                    for (int j = 0; j < oDCNodeArray2.length; ++j) {
                        oDCNodeArray2[j].setProperty(oDCHelper.channelChainCFEndpoint, (Object)new ODCPropertyValueWrapper(null, 1));
                    }
                }
            }
            ODCGroup.removeNodes(oDCNode, oDCHelper.serverApplication);
            ODCGroup.removeNodes(oDCNode, oDCHelper.webModule);
            ODCGroup.removeNodes(oDCNode, oDCHelper.ejbModule);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markServerDown - " + oDCNode);
        }
    }

    protected static void removeNodes(ODCNode oDCNode, ODCNodeType oDCNodeType) throws ODCException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removing " + oDCNodeType + " nodes for server " + oDCNode);
        }
        ODCNode[] oDCNodeArray = oDCNode.getNodes(oDCNodeType);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            oDCNode.removeNode(oDCNodeArray[i]);
        }
    }

    public static void setOdcGroupClass(String string) {
        odcGroupClass = string;
    }

    protected class HandleLeftGroupTask
    extends TimerTask {
        private final WsMessageEnvelope envelope;
        private final Long startTime;

        public HandleLeftGroupTask(WsMessageEnvelope wsMessageEnvelope, Long l) {
            this.envelope = wsMessageEnvelope;
            this.startTime = l;
        }

        public void run() {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "running HandleLeftGroupTask for " + this.envelope.getSender());
                }
                if (ODCGroup.this.leftGroupTimerMap.remove(this.envelope.getSender().getName()) == this) {
                    ODCGroup.this.handleLeftGroupMessage(this.envelope);
                }
            }
            catch (Exception exception) {
                TrUtil.warning(exception, this, "HandleLeftGroupTask", tc);
            }
        }

        public Long getMemberStartTime() {
            return this.startTime;
        }
    }

    protected class GetTreeResponseTimeoutTask
    extends TimerTask {
        private final WsGroupMember member;

        public GetTreeResponseTimeoutTask(WsGroupMember wsGroupMember) {
            this.member = wsGroupMember;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = ODCGroup.this.treeResponseTimeoutLock;
            synchronized (object) {
                if (ODCGroup.this.getTreeRequestOutstandingTo != null && ODCGroup.this.getTreeRequestOutstandingTo.getName().equals(this.member.getName())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "GetTreeResponseTimeoutTask: never heard from " + this.member);
                    }
                    ODCGroup.this.getTreeRequestOutstandingTo = null;
                    ODCGroup.this.getTreeRequestOutstandingTimeoutTask = null;
                    ODCGroup.this.nonResponsiveMembers.add(this.member.getName());
                    ODCGroup.this.perhapsSendGetTreeRequest(false);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "GetTreeResponseTimeoutTask: response previously received from " + this.member);
                }
            }
        }
    }

    protected class GetTreeRequestTask
    extends TimerTask {
        public void run() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "running GetTreeRequestTask.run");
            }
            while (ODCGroup.this.processingGetTreeResponse) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing getTreeResponse");
                }
                try {
                    Thread.sleep(GET_TREE_RESPONSE_DELAY);
                }
                catch (InterruptedException interruptedException) {}
            }
            ODCGroup.this.perhapsSendGetTreeRequestNow();
        }
    }

    protected class InitialContributionTask
    extends TimerTask {
        public void run() {
            ODCGroup.this.broadcastInitialContribution();
        }
    }

    protected class ActualSendTreeRequestTask
    extends TimerTask {
        WsGroupMember member;

        public ActualSendTreeRequestTask(WsGroupMember wsGroupMember) {
            this.member = wsGroupMember;
        }

        public void run() {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "ActualSendTreeRequestTask.run() for member " + this.member.getName());
                }
                this.member.sendMessage(ODCMessage.GET_TREE_REQUEST);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "ActualSendTreeRequestTask.run() for member " + this.member.getName());
                }
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "SendGetTreeRequestFailure", tc);
            }
        }
    }
}

