/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup.odc;

import com.ibm.ws.wsgroup.WsGroupMember;
import com.ibm.ws.wsgroup.odc.ODCGroup;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ODCGroupMember
implements Externalizable {
    static final long serialVersionUID = 1L;
    protected String groupName;
    protected String memberName;
    protected String memberPath;
    protected long generationNumber;

    public ODCGroupMember(WsGroupMember wsGroupMember, long l, ODCGroup oDCGroup) {
        this.generationNumber = l;
        this.groupName = oDCGroup.getName();
        this.setMemberName(wsGroupMember.getName());
    }

    public ODCGroupMember(String string, long l, String string2) {
        this.generationNumber = l;
        this.groupName = string2;
        this.setMemberName(string);
    }

    private void setMemberName(String string) {
        this.memberName = string;
        String[] stringArray = string.split("\\\\");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/cell/").append(stringArray[0]);
        stringBuffer.append("/node/").append(stringArray[1]);
        stringBuffer.append("/server/").append(stringArray[2]).append("/");
        this.memberPath = stringBuffer.toString();
    }

    public ODCGroupMember() {
    }

    public String getName() {
        return this.memberName;
    }

    public long getGenerationNumber() {
        return this.generationNumber;
    }

    public synchronized long incrementGenerationNumber() {
        return ++this.generationNumber;
    }

    public void setGenerationNumber(long l) {
        this.generationNumber = l;
    }

    public String getMemberPath() {
        return this.memberPath;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeObject(this.groupName);
        objectOutput.writeObject(this.memberName);
        objectOutput.writeLong(this.generationNumber);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readInt();
        this.groupName = (String)objectInput.readObject();
        this.setMemberName((String)objectInput.readObject());
        this.generationNumber = objectInput.readLong();
    }

    public String toString() {
        return this.memberName + "." + this.generationNumber;
    }
}

