/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup.odc;

import com.ibm.ws.wsgroup.odc.ODCMessage;
import com.ibm.wsspi.odc.ODCEvent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Map;

public class ODCMessageGetTreeResponse
extends ODCMessage {
    static final long serialVersionUID = 1L;
    protected int version;
    protected Map contributorInfo;
    protected long generationNumber;
    protected ODCEvent[] events;
    protected byte[] compressedXml;

    public ODCMessageGetTreeResponse(Map map, long l, ODCEvent[] oDCEventArray) throws Exception {
        this.version = 0;
        this.contributorInfo = map;
        this.generationNumber = l;
        this.events = oDCEventArray;
        this.compressedXml = null;
    }

    public ODCMessageGetTreeResponse(Map map, long l, byte[] byArray) throws Exception {
        this.version = 1;
        this.contributorInfo = map;
        this.generationNumber = l;
        this.events = null;
        this.compressedXml = byArray;
    }

    public ODCMessageGetTreeResponse() {
    }

    public Map getContributorInfo() {
        return this.contributorInfo;
    }

    public long getGenerationNumber() {
        return this.generationNumber;
    }

    public ODCEvent[] getEvents() {
        return this.events;
    }

    public byte[] getCompressedXml() {
        return this.compressedXml;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.version);
        objectOutput.writeObject(this.contributorInfo);
        objectOutput.writeLong(this.generationNumber);
        objectOutput.writeObject(this.events);
        if (this.version > 0) {
            objectOutput.writeObject(this.compressedXml);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.version = objectInput.readInt();
        this.contributorInfo = (Map)objectInput.readObject();
        this.generationNumber = objectInput.readLong();
        this.events = (ODCEvent[])objectInput.readObject();
        this.compressedXml = (byte[])(this.version > 0 ? (byte[])objectInput.readObject() : null);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GetTreeResponse");
        stringBuffer.append("\n\tContributors: ");
        Iterator iterator = this.contributorInfo.values().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(iterator.next());
            bl = false;
        }
        if (this.version == 0) {
            stringBuffer.append("\n\tEvents={");
            if (this.events != null) {
                for (int i = 0; i < this.events.length; ++i) {
                    stringBuffer.append("\n\t\t(").append(i).append(") ").append(this.events[i]);
                }
            }
        } else if (this.compressedXml != null) {
            stringBuffer.append("\n\tcompressedXml size: ").append(this.compressedXml.length);
        }
        return stringBuffer.toString();
    }
}

