/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsgroup.odc;

import com.ibm.ws.wsgroup.odc.ODCMessage;
import com.ibm.wsspi.odc.ODCEvent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ODCMessageTreeChange
extends ODCMessage {
    static final long serialVersionUID = 1L;
    protected String transactionName;
    protected long generationNumber;
    protected ODCEvent[] events;
    protected boolean initialContribution;
    protected byte[] compressedXml = null;

    public ODCMessageTreeChange(String string, long l, ODCEvent[] oDCEventArray) {
        this(string, l, oDCEventArray, l <= 1L);
    }

    public ODCMessageTreeChange(String string, long l, ODCEvent[] oDCEventArray, boolean bl) {
        this.transactionName = string;
        this.generationNumber = l;
        this.events = oDCEventArray;
        this.initialContribution = bl;
    }

    public ODCMessageTreeChange(String string, long l, byte[] byArray, boolean bl) {
        this.transactionName = string;
        this.generationNumber = l;
        this.events = null;
        this.initialContribution = bl;
        this.compressedXml = byArray;
    }

    public ODCMessageTreeChange() {
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public long getGenerationNumber() {
        return this.generationNumber;
    }

    public ODCEvent[] getEvents() {
        return this.events;
    }

    public boolean isInitialContribution() {
        return this.initialContribution;
    }

    public byte[] getCompressedXml() {
        return this.compressedXml;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(2);
        objectOutput.writeObject(this.transactionName);
        objectOutput.writeLong(this.generationNumber);
        objectOutput.writeObject(this.events);
        objectOutput.writeBoolean(this.initialContribution);
        objectOutput.writeObject(this.compressedXml);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        this.transactionName = (String)objectInput.readObject();
        this.generationNumber = objectInput.readLong();
        this.events = (ODCEvent[])objectInput.readObject();
        this.compressedXml = null;
        if (n >= 1) {
            this.initialContribution = objectInput.readBoolean();
            if (n >= 2) {
                this.compressedXml = (byte[])objectInput.readObject();
            }
        } else {
            this.initialContribution = this.generationNumber <= 1L;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TreeChange caused by ").append(this.transactionName);
        stringBuffer.append("\n\tGenerationNumber=").append(this.generationNumber);
        if (this.events != null) {
            stringBuffer.append("\n\tEvents:");
            for (int i = 0; i < this.events.length; ++i) {
                stringBuffer.append("\n\t\t").append(this.events[i]);
            }
        }
        if (this.compressedXml != null) {
            stringBuffer.append("\n\tcompressedXml size:").append(this.compressedXml.length);
        }
        return stringBuffer.toString();
    }
}

